<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Theme Made By www.w3schools.com - No Copyright -->
  <title>My Profile - Taxi Nearby</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
      .card {
        border: 1px solid;
        border-radius: 10px;
        padding: 10px 0px;
      }
      .driver_div {
          margin-bottom: 10px;
      }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-center">
  <h3>View Taxi</h3>
  <p><em></em></p>
  <div class="row">
     <div class="col-sm-12 driver_div">
      <div class="card">
          <div class="card-body">
          <img class="card-img-top" src="{{ $driver->vehicle_type=='Auto'?url('images/auto.png'):url('images/car.png')}}" alt="{{ $driver->vehicle_type }}" width="300px">
          </div>
        </div>
      </div> 
     <div class="col-sm-6 driver_div">
             <a class="btn btn-xl btn-warning form-control" href="tel:{{ $driver->mobile }}">Call</a>
     </div> 
     <div class="col-sm-6 driver_div">
             <a class="btn btn-xl btn-success form-control" href="https://api.whatsapp.com/send?phone=91{{ substr($driver->mobile,-10) }}">Whatsapp</a>
     </div> 
     <div class="col-sm-12 driver_div">
      <div class="card">
          <div class="card-body text-left" style="padding-left:20px;">
              <p>
                <label for="name">Type</label> {{ $driver->vehicle_type }}  
              </p>
              <p>
                <label for="name">Taxi Name</label> {{ $driver->vehicle_name }}
              </p>
              <p>
                <label for="name">Model</label> {{ $driver->vehicle_model }}  
              </p>
              <p>
                <label for="name">Taxi Number</label> {{ $driver->vehicle_number }}  
              </p>
              <p>
                <label for="name">Driver Name</label> {{ $driver->name }}  
              </p>
            
          </div>
        </div>
      </div> 
  </div>
  
</div>


<!-- Image of location/map -->

@php
$disclaimer = true;
@endphp
<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
</body>
</html>
