@php
function slugify($urlString)
{
  $search = ['Ș', 'Ț', 'ş', 'ţ', 'Ş', 'Ţ', 'ș', '', 'î', 'â', 'ă', 'Î', ' ', 'Ă', 'ë', 'Ë'];
  $replace = ['s', 't', 's', 't', 's', 't', 's', 't', 'i', 'a', 'a', 'i', '-', 'a', 'e', 'E'];
  $str = str_ireplace($search, $replace, strtolower(trim($urlString)));
  $str = preg_replace('/[^\w\d\-\ ]/', '-', $str);
  $str = str_replace(' ', '-', $str);
  return preg_replace('/\-{2,}/', '-', $str);
}
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <title>{{ config('app.name') }}</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content=""/>
  
  @include('layouts.style')
  <style>
      .card {
        border: 1px solid;
        border-radius: 10px;
        padding: 0px 0px 10px 0px;
        overflow: hidden;
      }
      .driver_div {
        margin-bottom: 10px;
      }
      .card-img-top {
        width: 100%;
        overflow: hidden;
      }
      .btn {
        display: inline-block;
        margin-bottom: 10px;
      }
      .item {
          height: 100vh;
          width: 100%;
      }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')


<div class="container common_main_div">
@if(Auth()->user())
	<a class="btn btn-primary" href="{{ route('files') }}">My Files</a>
@else
	<a class="btn btn-primary" href="{{ route('login') }}">Login</a>&nbsp;
	<a class="btn btn-primary" href="{{ route('register') }}">Register</a>
@endif
</div>

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    function send_mail() {
        $('.mail_response').html('sending...');
        var name = $('#name').val();
        var email = $('#email').val();
        var message = $('#message').val();
        if(name.trim()!="" && email.trim()!="" && message.trim()!=""){
            var _token= "{{ csrf_token() }}";
            const xhttp=new XMLHttpRequest();
            xhttp.onload = function() {
                var chatData = JSON.parse(xhttp.responseText);
                $('.mail_response').html('<div class="alert alert-success">Message sent successfullly</div>');
                $('#name').val('');
                $('#email').val('');
                $('#message').val('');
            }
            xhttp.open("POST", "{{route('send_mail')}}");
            xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            xhttp.send("_token="+_token+"&name="+name+"&email="+email+"&message="+message);
        } else {
            $('.mail_response').html('<div class="alert alert-danger">Please enter all fields</div>');
        }
    }
</script>
</body>
</html>
