<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\FileList;
use App\Models\Log;
use App\Models\WordLog;
use App\Models\UserPackage;
use App\Models\UserQuestion;
use App\Models\Genie;
use App\Models\AllowedFolder;
use App\Models\Package;


use App\Models\UsersJob;
use App\Models\ChatMember;
use App\Models\ChatGroupAllAnswer;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Exception;
use DB;
use Mail;
use Hash;
use File;
use Response;
use Storage;
use Session;
use App\Http\Controllers\PDF2TextController;
use Webklex\PDFMerger\Facades\PDFMergerFacade as PDFMerger;

use Spatie\PdfToImage\Pdf;

//use Spatie\PdfToText\Pdf;
use Smalot\PdfParser\Parser;

use Ilovepdf\Ilovepdf;

class ApiController extends Controller
{
    public function register_from_aceit(Request $request)
    {
        
        $otp = rand(100000,999999);
        $user = new User();
		$user->name = $request->name;
		$user->email = $request->email;
		$user->password = bcrypt($request->password);
		$user->mobile = $request->mobile;
		$user->level = $request->level;
		$user->status = $request->level==7?1:0;
		$user->referral = $request->referral?$request->referral:'';
		
		$user->otp = $otp;
		$user->save();
		
		$this->generate_referrer_id($user->id); 
        
        $uj = new UsersJob();
        $uj->user_id = $user->id;
        $uj->password = $request->password;
        $uj->status = 0;
        $uj->save();
        
        return response()->json(['status' => 'success', 'result' => $user->id]);
        
    }
    
    public function generate_referrer_id($id){
        $my_referrer_id = strtoupper(substr(md5(microtime()),rand(0,26),3).$id.substr(md5(microtime()),rand(0,26),3));
        $exist = User::where('my_referrer_id',$my_referrer_id)->first();
        if($exist){
            $this->generate_referrer_id($id);
        } else {
            $user = User::where('id',$id)->first();
            $user->my_referrer_id = $my_referrer_id;
            $user->save();
        }
    } 
    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email'    => 'required|email',
        ]);

        if ($validator->fails()) return sendError('Validation Error.', $validator->errors(), 422);

        //$credentials = $request->only('email', 'password');
        $user = User::where('email', $request->email)->first();
        if ($user){
            Auth::loginUsingId($user->id);
            $user             = Auth::user();
            $success['token'] = $user->createToken('accessToken')->accessToken;
            return response()->json(['status' => 'success', 'result' => $success]);
            
        } else {
            return response()->json(['status' => 'failed', 'result' => 'Invalid User']);
        }
    }
    public function file_list(Request $request) {
        
        
        $orderby = $request->orderby?$request->orderby:'filename';
        $sort = $request->sort?$request->sort:'ASC';
        
      	
        $user = auth()->user();
        if(!$user){
            return response()->json(['status' => 'failed', 'result' => 'Invalid User']);
        } else {
            if(!$request->parent || $request->parent=="0" || $request->parent==""){   
                $request->parent = 726;
                $request->parent = 3631;
            }
            if($user->level==5){
    	        $file_level = 4;
    	    } else {
    	       $file_level = $user->level;
    	    }
    	    $file_level = 4;
            $admins = User::where('level','1')->pluck('id');
            
            $files = FileList::where('file_level',$file_level)->with(['child'])->where('parent',$request->parent)->orderBy('type')->orderBy($orderby,$sort)->get();
            
            // $files = FileList::where(function($qry) use ($admins,$file_level,$user){
            //             $qry->where('user_id',$user->id)->orWhere(function($q) use ($admins,$file_level){
            //                 if($file_level==7){
            //                     $q->whereIn('file_level',[4,7])->whereIn('user_id',$admins);
            //                 } else {
            //                     $q->where('file_level',$file_level)->whereIn('user_id',$admins);
            //                 }
            //             });
            //         })->with(['child'])->where(function($qq) use ($request) { 
            //             if($request->parent=="1379"){
            //                 $qq->where('parent',$request->parent)->orWhere('id',1955);
            //             } else {
            //                 $qq->where('parent',$request->parent);
            //             }
            //         })->orderBy('type')->orderBy('filename')->get();
            return response()->json(['status' => 'success', 'result' => $files]);
        }
    }
    public function ask(Request $request){      
      	$query = $request->question;  
      	$store_name = $request->store_name;
      	$qlimit = false;
      	
        $user = auth()->user();
        if(!$user){
            return response()->json(['status' => 'failed', 'result' => 'Invalid user']);
        } else {
      	    
          	$qlimit = $this->admin_questions_count($store_name,$user); 
          	if($qlimit){
          	    $mesg =  "The i-Life Genie question limit exceeds. Please upgrade";
          	    return response()->json(['status' => 'failed', 'result' => $mesg]);
          	    exit;
          	}
      	
      	
          	$update_word_count = false;
          	if($user && $user->chat_model=="2"){
          	    $model = "gpt-4o";
          	    $update_word_count = true;
          	    $date = date('m-Y');
                $words = WordLog::where('user_id',$user->id)->where('month',$date)->first();
                if($words && $words->total_count>=500000){
                    $model = "gpt-4o";
                    $update_word_count = false;
                }
          	} else {
          	    $model = "gpt-4o";
          	    
          	}
            $postParameter = array(
                'store_name' => $store_name,
                'query' => $query,
                'model' => $model
            );
            $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/ask_api');  //https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
            curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
            curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
    
            $response = curl_exec($curlHandle);
          	$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
            curl_close($curlHandle);
          	$log = new Log();
    		$log->log = "Asked question -".$request->question." to txt_file - ".$store_name;
    		$log->user_id = Auth::user()?Auth::user()->id:0;
    		$log->save();
          	if(trim($httpcode)!="200"){
              //self::ask($request);
              $mesg =  "i-Life Genie wasn't able to find reliable information for your question. You could try again";
              return response()->json(['status' => 'failed', 'result' => $mesg]);
            } else {
              if(trim($response)=="I don't know." || trim($response)=="I'm sorry, I don't know." || trim($response)=="I do not know."){
                $mesg =  "i-Life Genie wasn't able to find reliable information for your question. You could try rephrasing your question or ask a different question.";
                return response()->json(['status' => 'failed', 'result' => $mesg]);
              } else {
                if($update_word_count){
                    if($user && ($user->level=="3" || $user->level=="4" || $user->level=="5")){
                        
                        $total_words = str_word_count($query)+str_word_count($response);
                        $old_words = 0;
                        if($words){
                            $old_words = $words->total_count;
                        } else {
                           $words = new  WordLog();
                           $words->user_id = $user->id;
                           $words->month = $date;
                        }
                        $words->total_count = $old_words+$total_words;
                        $words->save();
                    }
                    
                    
                }
                $qa_id = 0;
                
               $qa = new UserQuestion();
               $qa->user_id = $user?$user->id:0;
               $qa->file_id = $store_name;
               $qa->question = $request->question;
               $qa->answer = "<md-block>".($response)."</md-block>";
               $qa->save();
               $qa_id = $qa->id;
               
               if($user){
                    $groups = ChatMember::where('user_id',$user->id)->with('group')->get();
                    foreach($groups as $mygrp){
                        if($mygrp->group){
                            if($mygrp->group->save_all=="1"){
                                $ans = new ChatGroupAllAnswer();
                                $ans->answer_id	= $qa_id;
                                $ans->user_id = $user->id;
                                $ans->group_id = $mygrp->group_id;
                                $ans->save();
                            }
                        }
                    }
               }
                $response = str_replace('```json','',$response);
                 
                return response()->json(['status' => 'success', 'result' => $response]);
              }
            }
      	}
	}
	
	
  	public static function full_path($id, $path=""){
      	$fileData = FileList::where('id',$id)->first();
      	if($user->level==7 && ($fileData->id==726 || $fileData->id==1020)){
      	    $fileData = FileList::where('id',1379)->first();
      	    $path = "<a href='".route('files',['parent'=>$fileData->id])."' class='breadcrumb_".$fileData->id."'><span class='glyphicon glyphicon-home'></span></a>";
      	} else {
          	if($fileData->parent!="0"){
              if($path==""){
              	$path = $fileData->filename;
              } else {
                $path = "<a href='".route('files',['parent'=>$fileData->id])."' class='breadcrumb_".$fileData->id."'>".$fileData->filename."</a>";
              }
              $path = self::full_path($fileData->parent, $path).' / '.$path;
            } else {
              $path = "<a href='".route('files')."' class='breadcrumb_".$fileData->id."'><span class='glyphicon glyphicon-home'></span></a>
              / <a href='".route('files',['parent'=>$fileData->id])."' class='breadcrumb_".$fileData->id."'>".$fileData->filename."</a>";
            }
  	    }
      	return $path;
    }
    
    
	
    
	public function admin_questions_count($store_name,$user){
	    $file = FileList::where('txt_file',$store_name)->with('user')->first();
	    $mypackage = UserPackage::where('user_id',($user->parent>0?$user->parent:$user->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();    
      	if($mypackage){
      	    $question_limit = UserPackage::where('user_id',($user->parent>0?$user->parent:$user->id))->where('end_date','>=',date("Y-m-d"))->sum('question_limit');
      	} else {
      	    $question_limit = 100;
      	}
        if($user->parent>0){
	        $qcount = UserQuestion::whereRaw('user_id IN (SELECT id FROM users WHERE parent="'.$user->parent.'")')->count();
	    } else {
	        $qcount = UserQuestion::where('user_id',$user->id)->count();
	    }
	    if($user->level=="1"){
	       return false;
	    }
      	if($qcount>$question_limit){
      	    return true;
      	} else {
      	    return false;
      	}
	}
	
  	public static function special_full_path($id, $path="",$route="special_files"){
      	$fileData = FileList::where('id',$id)->where('file_level','>','2')->first();
      	if($fileData){
          	if($fileData->parent!="0"){ 
              if($path==""){
              	$path = $fileData->filename;
              } else {
                $path = "<a href='".route($route,['parent'=>$fileData->id])."'>".$fileData->filename."</a>";
              }
              $path = self::special_full_path($fileData->parent, $path,$route).' / '.$path;
            } else {
              $path = "<a href='".route($route,['parent'=>$fileData->id])."'>".$fileData->filename."</a>";
            }
      	}
      	return $path;
    }
    public function allowed_folders(Request $request){
        $folders = FileList::where('type','D')->with(['child_folders'])->where('parent','1020')->get();
        $allowed_folders = AllowedFolder::where('user_id',$user->id)->get();
        return view('allowed_folders',compact('allowed_folders','folders'));
    }
    public function my_folder_name($id){
        echo $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($id,'ilife-genie'));
    }
    
}
