<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\FileList;
use App\Models\Log;
use App\Models\WordLog;
use App\Models\UserPackage;
use App\Models\UserQuestion;
use App\Models\Genie;
use App\Models\AllowedFolder;
use App\Models\Package;


use App\Models\UsersJob;
use App\Models\ChatMember;
use App\Models\ChatGroupAllAnswer;

use App\Models\HomeChat;

use App\Models\CustomToggle;
use App\Models\Order;
use App\Models\Invoice;
use App\Models\CouponCode;
use App\Models\StoryBook;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Exception;
use DB;
use Mail;
use Hash;
use File;
use Response;
use Storage;
use Session;
use App\Http\Controllers\PDF2TextController;
use Webklex\PDFMerger\Facades\PDFMergerFacade as PDFMerger;

//use Spatie\PdfToImage\Pdf;

//use Spatie\PdfToText\Pdf;
use Smalot\PdfParser\Parser;

use Ilovepdf\Ilovepdf;

use PDF;

class ApiLMSController extends Controller
{
    public function register_from_aceit(Request $request)
    {
        
        $otp = rand(100000,999999);
        $user = new User();
		$user->name = $request->name;
		$user->email = $request->email;
		$user->password = bcrypt($request->password);
		$user->mobile = $request->mobile;
		$user->level = $request->level;
		$user->status = $request->level==7?1:0;
		$user->referral = $request->referral?$request->referral:'';
		
		$user->otp = $otp;
		$user->save();
		
		$this->generate_referrer_id($user->id); 
        
        $uj = new UsersJob();
        $uj->user_id = $user->id;
        $uj->password = $request->password;
        $uj->status = 0;
        $uj->save();
        
        return response()->json(['status' => 'success', 'result' => $user->id]);
        
    }
    
    public function generate_referrer_id($id){
        $my_referrer_id = strtoupper(substr(md5(microtime()),rand(0,26),3).$id.substr(md5(microtime()),rand(0,26),3));
        $exist = User::where('my_referrer_id',$my_referrer_id)->first();
        if($exist){
            $this->generate_referrer_id($id);
        } else {
            $user = User::where('id',$id)->first();
            $user->my_referrer_id = $my_referrer_id;
            $user->save();
        }
    } 
    public function login_genie(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email'    => 'required',
            'password'    => 'required',
        ]);

        if ($validator->fails()) return sendError('Validation Error.', $validator->errors(), 422);

        $credentials = $request->only('email', 'password');
        if (Auth::attempt($credentials)) {
            $user             = Auth::user();
            $tokenResult = $user->createToken('accessToken');
            //return response()->json(['status' => 'success', 'result' => $success]);
            return response()->json([
                'status' => 'success',
                'name' => Auth::user()->name,
                'access_token' => $tokenResult->accessToken,
                'token_type' => 'Bearer',
                'expires_at' => $tokenResult->token->expires_at
            ]);
            
        } else {
            return response()->json(['status' => 'failed', 'result' => 'Invalid User']);
        }
    }
    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email'    => 'required',
        ]);

        if ($validator->fails()) return sendError('Validation Error.', $validator->errors(), 422);

        //$credentials = $request->only('email', 'password');
        $user = User::where('email', $request->email)->first();
        if ($user){
            Auth::loginUsingId($user->id);
            $user             = Auth::user();
            $tokenResult = $user->createToken('accessToken');
            //return response()->json(['status' => 'success', 'result' => $success]);
            return response()->json([
                'status' => 'success',
                'name' => Auth::user()->name,
                'access_token' => $tokenResult->accessToken,
                'token_type' => 'Bearer',
                'expires_at' => $tokenResult->token->expires_at
            ]);
            
        } else {
            return response()->json(['status' => 'failed', 'result' => 'Invalid User']);
        }
    }
    public function file_list(Request $request) {
        
        
        $orderby = $request->orderby?$request->orderby:'filename';
        $sort = $request->sort?$request->sort:'ASC';
        
        $user = auth()->user();
        if(!$user) {
            return response()->json(['status' => 'failed', 'result' => 'Invalid User']);
        } else {
                
            if(auth()->user()->status!="1") {
	            return response()->json(['status' => 'failed', 'result' => 'Not verified']);
	        }
      	    if(auth()->user()->level=="0") {
    	        return response()->json(['status' => 'failed', 'result' => 'User type not set']);
    	    }
    	    
    	    if(auth()->user()->level!="1") {
        	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
                if(!$mypackage) {
                    return response()->json(['status' => 'failed', 'result' => 'No package added']);
                }
    	    }
            if($user->level==5) {
    	        $file_level = 4;
    	    } else {
    	       $file_level = $user->level;
    	    }
            if(!$request->parent || $request->parent=="0" || $request->parent==""){   
                //$request->parent = 1020;
                if($file_level==4){
                    $request->parent = 1020;
                } 
            }
    	    
            $admins = User::where('level','1')->pluck('id');
            
            
            $files = FileList::where(function($qry) use ($admins,$file_level){
                        $qry->where('user_id',auth()->user()->id)->orWhere(function($q) use ($admins,$file_level){
                            if($file_level==7){
                                $q->whereIn('file_level',[4,7])->whereIn('user_id',$admins);
                            } else {
                                $q->where('file_level',$file_level)->whereIn('user_id',$admins);
                            }
                        });
                    })->with(['child'])->where(function($qq) use ($request) { 
                        if($request->parent=="1379"){
                            $qq->where('parent',$request->parent)->orWhere('id',1955);
                        } elseif($request->parent!=""){
                            $qq->where('parent',$request->parent);
                        }
                    });
            if($request->parent=="7226"){
                $files = $files->orderByRaw('FIELD(id, "7233") DESC')->get();  
            } else {
                $files = $files->orderByRaw('type, CAST(filename AS UNSIGNED)')->get();
            }
            //$files = FileList::where('file_level',$file_level)->with(['child'])->where('parent',$request->parent)->orderBy('type')->orderBy($orderby,$sort)->get();
            
            return response()->json(['status' => 'success', 'result' => $files]);
        }
    }
    public function like_message(Request $request){
        $answer = UserQuestion::where('id',$request->id)->first();
        $answer->liked = $request->liked;
        $answer->save();
        return response()->json(['status' => 'success', 'result' => 'Updated Successfully']);
    }
    public function save_message(Request $request){
        $answer = UserQuestion::where('id',$request->id)->first();
        $answer->saved = $request->saved;
        $answer->save();
        return response()->json(['status' => 'success', 'result' => 'Updated Successfully']);
    }
    public function chat_history(Request $request){
        $custom_toggles = CustomToggle::where('user_id',auth()->user()->id)->get();
        $userquestions = UserQuestion::where('user_id',auth()->user()->id)->where('file_id',$request->txt_file)->orderBy('created_at','DESC')->limit(3)->get();
        //$userquestions = $userquestions->reverse();
        $toggles = array();
        
        $toggles[] = array(
            "value"=>"and Explain this in story mode",
            "name"=>"Story Mode"
            );
                			
        $toggles[] = array("value"=>"and Provide real life examples",
        "name"=>"Real Life Examples");
                			
        $toggles[] = array("value"=>"Also generate 20 questions and their respective answers based on this topic",
        "name"=>"Generate Questions");
                			
        $toggles[] = array("value"=>"Suggest an activity based learning exercise on this topic.",
        "name"=>"Practical Activity");
                			
        $toggles[] = array("value"=>"Explain this in an easy to understand manner.",
        "name"=>"Ezy Explain");
                                    		
        $toggles[] = array("value"=>"Am I right or wrong?",
        "name"=>"Validate Answer");
                                    
                        			
        $toggles[] = array("value"=>"Check the above text for plagiarism across all possible sources on the internet",
        "name"=>"Plagiarism Check");
                                    
                        			
        if(auth()->user() && auth()->user()->level=="5"){
            $toggles[] = array("value"=>"Create a detailed lesson plan on this.",
                    "name"=>"Lesson Plan");
        }
                
        foreach($custom_toggles as $ct){
        	$toggles[] = array("value"=>$ct->value,
            "name"=>$ct->name);
        }
        return response()->json(['status' => 'success', 'result' => $userquestions, 'toggles' => $toggles]);
    }
    public function ask(Request $request){      
      	$query = $request->question;  
      	$store_name = $request->store_name;
      	$qlimit = false;
      	
        $user = auth()->user();
        if(!$user){
            return response()->json(['status' => 'failed', 'result' => 'Invalid user']);
        } else {
      	    
          	$qlimit = $this->admin_questions_count($store_name,$user); 
          	if($qlimit){
          	    $mesg =  "The i-Life Genie question limit exceeds. Please upgrade";
          	    return response()->json(['status' => 'failed', 'result' => $mesg]);
          	    exit;
          	}
      	
      	
          	$update_word_count = false;
          	if($user && $user->chat_model=="2"){
          	    $model = "gpt-4o";
          	    $update_word_count = true;
          	    $date = date('m-Y');
                $words = WordLog::where('user_id',$user->id)->where('month',$date)->first();
                if($words && $words->total_count>=500000){
                    $model = "gpt-4o";
                    $update_word_count = false;
                }
          	} else {
          	    $model = "gpt-4o";
          	    
          	}
            $postParameter = array(
                'store_name' => $store_name,
                'query' => $query,
                'model' => $model
            );
            $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/ask_api');  //https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
            curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
            curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
    
            $response = curl_exec($curlHandle);
          	$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
            curl_close($curlHandle);
          	$log = new Log();
    		$log->log = "Asked question -".$request->question." to txt_file - ".$store_name;
    		$log->user_id = Auth::user()?Auth::user()->id:0;
    		$log->save();
          	if(trim($httpcode)!="200"){
              //self::ask($request);
              $mesg =  "i-Life Genie wasn't able to find reliable information for your question. You could try again";
              return response()->json(['status' => 'failed', 'result' => $mesg]);
            } else {
              if(trim($response)=="I don't know." || trim($response)=="I'm sorry, I don't know." || trim($response)=="I do not know."){
                $mesg =  "i-Life Genie wasn't able to find reliable information for your question. You could try rephrasing your question or ask a different question.";
                return response()->json(['status' => 'failed', 'result' => $mesg]);
              } else {
                if($update_word_count){
                    if($user && ($user->level=="3" || $user->level=="4" || $user->level=="5")){
                        
                        $total_words = str_word_count($query)+str_word_count($response);
                        $old_words = 0;
                        if($words){
                            $old_words = $words->total_count;
                        } else {
                           $words = new  WordLog();
                           $words->user_id = $user->id;
                           $words->month = $date;
                        }
                        $words->total_count = $old_words+$total_words;
                        $words->save();
                    }
                    
                    
                }
                $qa_id = 0;
                
               $qa = new UserQuestion();
               $qa->user_id = $user?$user->id:0;
               $qa->file_id = $store_name;
               $qa->question = $request->question;
               $qa->answer = "<md-block>".($response)."</md-block>";
               $qa->save();
               $qa_id = $qa->id;
               
               if($user){
                    $groups = ChatMember::where('user_id',$user->id)->with('group')->get();
                    foreach($groups as $mygrp){
                        if($mygrp->group){
                            if($mygrp->group->save_all=="1"){
                                $ans = new ChatGroupAllAnswer();
                                $ans->answer_id	= $qa_id;
                                $ans->user_id = $user->id;
                                $ans->group_id = $mygrp->group_id;
                                $ans->save();
                            }
                        }
                    }
               }
                $response = str_replace('```json','',$response);
                 $result = array('answer'=>$response, 'id'=>$qa_id);
                return response()->json(['status' => 'success', 'result' => $result]);
              }
            }
      	}
	}
	
	
  	public static function full_path($id, $path=""){
      	$fileData = FileList::where('id',$id)->first();
      	if($user->level==7 && ($fileData->id==726 || $fileData->id==1020)){
      	    $fileData = FileList::where('id',1379)->first();
      	    $path = "<a href='".route('files',['parent'=>$fileData->id])."' class='breadcrumb_".$fileData->id."'><span class='glyphicon glyphicon-home'></span></a>";
      	} else {
          	if($fileData->parent!="0"){
              if($path==""){
              	$path = $fileData->filename;
              } else {
                $path = "<a href='".route('files',['parent'=>$fileData->id])."' class='breadcrumb_".$fileData->id."'>".$fileData->filename."</a>";
              }
              $path = self::full_path($fileData->parent, $path).' / '.$path;
            } else {
              $path = "<a href='".route('files')."' class='breadcrumb_".$fileData->id."'><span class='glyphicon glyphicon-home'></span></a>
              / <a href='".route('files',['parent'=>$fileData->id])."' class='breadcrumb_".$fileData->id."'>".$fileData->filename."</a>";
            }
  	    }
      	return $path;
    }
    
    
	
    
	public function admin_questions_count($store_name,$user){
	    $file = FileList::where('txt_file',$store_name)->with('user')->first();
	    $mypackage = UserPackage::where('user_id',($user->parent>0?$user->parent:$user->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();    
      	if($mypackage){
      	    $question_limit = UserPackage::where('user_id',($user->parent>0?$user->parent:$user->id))->where('end_date','>=',date("Y-m-d"))->sum('question_limit');
      	} else {
      	    $question_limit = 100;
      	}
        if($user->parent>0){
	        $qcount = UserQuestion::whereRaw('user_id IN (SELECT id FROM users WHERE parent="'.$user->parent.'")')->count();
	    } else {
	        $qcount = UserQuestion::where('user_id',$user->id)->count();
	    }
	    if($user->level=="1"){
	       return false;
	    }
      	if($qcount>$question_limit){
      	    return true;
      	} else {
      	    return false;
      	}
	}
	
  	public static function special_full_path($id, $path="",$route="special_files"){
      	$fileData = FileList::where('id',$id)->where('file_level','>','2')->first();
      	if($fileData){
          	if($fileData->parent!="0"){ 
              if($path==""){
              	$path = $fileData->filename;
              } else {
                $path = "<a href='".route($route,['parent'=>$fileData->id])."'>".$fileData->filename."</a>";
              }
              $path = self::special_full_path($fileData->parent, $path,$route).' / '.$path;
            } else {
              $path = "<a href='".route($route,['parent'=>$fileData->id])."'>".$fileData->filename."</a>";
            }
      	}
      	return $path;
    }
    public function allowed_folders(Request $request){
        $folders = FileList::where('type','D')->with(['child_folders'])->where('parent','1020')->get();
        $allowed_folders = AllowedFolder::where('user_id',$user->id)->get();
        return view('allowed_folders',compact('allowed_folders','folders'));
    }
    public function my_folder_name($id){
        echo $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($id,'ilife-genie'));
    }
    
    public function speechtotext(Request $request){
        
        //return 'ssssssssss';
        $vfile = $request->file('voice');
        $voicefile = rand(100,999).date('YmdHis').rand(100,999).".mp3";
        
        $vfile->move(public_path('voices'), $voicefile);
        
        $cFile = curl_file_create(public_path('voices/'.$voicefile), $voicefile);
        $postParameter = array(
            'file' => $cFile,
            'model' => 'whisper-1'
        );
        //print_r($postParameter);
		$header = array(
		    'Authorization: Bearer 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'
		);
        
        $curlHandle = curl_init('https://api.openai.com/v1/audio/translations');
	    
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
		curl_close($curlHandle);
		unlink(public_path('voices/'.$voicefile));
		//echo public_path('voices/'.$voicefile);
		return $response;
		
    }
    
    public function translate_text(Request $request){
        
        $answer = UserQuestion::where('id',$request->id)->first();
        $qstn = 'Translate '.($answer->answer).' from English to '.$request->language;
        $header = array(
		    'Content-Type: application/json',
		    'Authorization: Bearer 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'
		);
		$postParameter = array(
            'model' => 'gpt-3.5-turbo',
            'messages' => array(
                array('role' => 'user',
                'content' => $qstn
                ))
        );
        
        $curlHandle = curl_init('https://api.openai.com/v1/chat/completions');
	    
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		
		$responses =  $result['choices'][0]['message']['content'];
		
		$qa_id = 0;
        
       $qa = new UserQuestion();
       $qa->user_id = auth()->user()?auth()->user()->id:0;
       $qa->file_id = $answer->file_id;
       $qa->question = 'Translate '.($answer->question).' answer from English to '.$request->language;;
       $qa->answer = "<md-block>".($responses)."</md-block>";
       $qa->save();
       $qa_id = $qa->id;
       
        $response = str_replace('```json','',$responses);
        $result = array('answer'=>$response, 'id'=>$qa_id);
        return response()->json(['status' => 'success', 'result' => $result]);
        
      	//return "<md-block data-id='".$qa_id."'>".($responses)."</md-block>";
    }
    
  	public function add_folder(Request $request){
  	    $validator = Validator::make($request->all(), [
			'filename'     => 'required',
		]);
		
		if ($validator->fails()) return response($validator->messages(), 200);
		
		$request->parent = isset($request->parent)?$request->parent:726;
		$request->parent = $request->parent!="0"?$request->parent:726;
		$folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt(Auth::user()->id,'ilife-genie'));
		$path = public_path().'/files/pdf-files/'.$folder1;
		if(!File::exists($path)) {
			File::makeDirectory($path, $mode = 0777, true, true);
		}
		
		$file_level = 2;
		if($request->parent!=0){
			$parentFolder = FileList::where('id',$request->parent)->first();
			$file_level = $parentFolder->file_level;
		}
		if(Auth::user()->level>2){
		    $file_level = Auth::user()->level;
		    if(Auth::user()->level==5){
		        $file_level = 4;
		    }
		}
		$file = FileList::where('user_id',Auth::user()->id)->where('parent',$request->parent)->where('filename',$request->filename)->first();
  	
  	    if(!$file) {
			$file = new FileList();
			$file->filename = $request->filename;
			$file->txt_file = '';
			$file->type = "D";
			$file->user_id = Auth::user()->id;
			$file->parent = $request->parent;
            $file->file_level = $file_level;
			$file->save();
          
          	$log = new Log();
            $log->log = "Added folder -".$request->filename." - ID:".$file->id;
            $log->user_id = Auth::user()?Auth::user()->id:0;
            $log->save();
          
		}
		$randStr = substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"),-3);
		$txt_file = date('YmdHis').preg_replace('/[^A-Za-z0-9]/', 'D', crypt($file->id,'ilife-genie')).$randStr;
		$file->txt_file = $txt_file;
		$file->save();
		return response()->json(['status' => 'success', 'result' => 'Folder Created SuccessFully']);
  	}
  	public function add_file(Request $request){
          $validator = Validator::make($request->all(), [
              'filename'     => 'required',
              'filename.*' => 'mimes:pdf,docx'
          ]);
          if ($validator->fails()) return response($validator->messages(), 200);
        
        
        $mypackage = UserPackage::where('user_id',Auth::user()->id)->where('end_date','>=',date("Y-m-d"))->orderBy('end_date','desc')->first();
        if($mypackage){
            if(date('Y-m-d')>=date('Y-m-d',strtotime($mypackage->start_date)) && date('Y-m-d')<=date('Y-m-d',strtotime($mypackage->end_date))){
                $maxpages = $mypackage->page_limit;
            } else {
                $maxpages = 100; 
            }
        } else {
            $maxpages = 100;
        }
        
		$uploaded_ids = '';
		$request->parent = isset($request->parent)?$request->parent:726;
		$request->parent = $request->parent!="0"?$request->parent:726;
		
    	$folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt(Auth::user()->id,'ilife-genie'));
		
    	$path = public_path().'/files/pdf-files/'.$folder1;
    	
    	//if(Auth::user()->id==3){
		    
    	//}
		if(!File::exists($path)) {
			File::makeDirectory($path, $mode = 0777, true, true);
		}
		$file_level = 2;
		if($request->parent!=0){
			$path = $path."/".$request->parent;
			$folder1 = $folder1."/".$request->parent;
			if(!File::exists($path)) {
				File::makeDirectory($path, $mode = 0777, true, true);
			}
			$parentFolder = FileList::where('id',$request->parent)->first();
			$file_level = $parentFolder->file_level;
		}
		

		
		
		if(Auth::user()->level>2){
		    $file_level = Auth::user()->level;
		    if(Auth::user()->level==5){
		        $file_level = 4;
		    }
		}
		$resultmsg = 'Uploaded, Processing...';
		
      $mypages = FileList::where('user_id',Auth::user()->id)->where('type','F')->sum('page_nos');
      
      $pdfile = $request->file('filename');
      $pdffile = $pdfile->getClientOriginalName();
      
      $file_ext = explode('.',$pdffile);
      $extension = strtoupper(end($file_ext));
      $allowed_exts = array('DOC', 'DOCX', 'PPT', 'PPTX', 'XLS', 'XLSX', 'ODT', 'ODP', 'ODS');
      if(in_array($extension,$allowed_exts)){
          $doc_filename = rand(100,999).date('YmdHis').auth()->user()->id.rand(1000,9999).".docx";
          $pdfile->move(public_path('other-files/'), $doc_filename);
          
          $doc_file_path = public_path('other-files/'.$doc_filename);
          
          $pdf_filename = substr($pdffile, 0, -5).".pdf";
          $pdf_file_path = public_path('files/pdf-files/'.$folder1.'/'.$pdf_filename);
          
          $doc_file2 = 'public/other-files/'.$doc_filename;
          $pdf_file2 = 'public/files/pdf-files/'.$folder1.'/'.$pdf_filename;
          $pdf_file3 = 'files/pdf-files/'.$folder1.'/'.$pdf_filename;
          
        try { 
            $ilovepdf = new Ilovepdf('project_public_8d43a6f826b46e30edc4a15016c9d2df_AbEHWdd3e0e1456c64a865698adef2d9eab43','secret_key_ad61cc9ca86185823a73bb2221905681_ITAFwfccf722a6d9f42680408805f66a6d967');
            $myTask = $ilovepdf->newTask('officepdf');
            $file1 = $myTask->addFile(public_path('other-files/'.$doc_filename));
            $myTask->setOutputFilename($pdf_file3);
            $myTask->execute();
            $myTask->download('files/pdf-files/'.$folder1);
          
        } catch (\Ilovepdf\Exceptions\StartException $e) {
            $resultmsg = "An error occured on start: " . $e->getMessage() . " ";
            // Authentication errors
        } catch (\Ilovepdf\Exceptions\AuthException $e) {
            $resultmsg = "An error occured on auth: " . $e->getMessage() . " ";
            //echo implode(', ', $e->getErrors());
            // Uploading files errors
        } catch (\Ilovepdf\Exceptions\UploadException $e) {
            $resultmsg = "An error occured on upload: " . $e->getMessage() . " ";
            //echo implode(', ', $e->getErrors());
            // Processing files errors
        } catch (\Ilovepdf\Exceptions\ProcessException $e) {
            $resultmsg = "An error occured on process - " . $e->getMessage() . " ";
            //echo implode(', ', $e->getErrors());
            // Downloading files errors
        } catch (\Ilovepdf\Exceptions\DownloadException $e) {
            $resultmsg = "An error occured on process : " . $e->getMessage() . " ";
            //echo implode(', ', $e->getErrors());
            // Other errors (as connexion errors and other)
        } catch (\Exception $e) {
            
            try {
                $ilovepdf = new Ilovepdf('project_public_8d43a6f826b46e30edc4a15016c9d2df_AbEHWdd3e0e1456c64a865698adef2d9eab43','secret_key_ad61cc9ca86185823a73bb2221905681_ITAFwfccf722a6d9f42680408805f66a6d967');
                $myTask = $ilovepdf->newTask('officepdf');
                $file1 = $myTask->addFile(public_path('other-files/'.$doc_filename));
                $myTask->setOutputFilename($pdf_file3);
                $myTask->execute();
                $myTask->download('files/pdf-files/'.$folder1);
            } catch (\Exception $e) {
                $resultmsg = "An error occurred- " . $e->getMessage();
            }
        }
          
    //       $postParameter = array(
    //             'doc_file' => $doc_file2,
    //             'pdf_file' => $pdf_file2,
    //             'project' => 'genieweb'
    //         );
    //         $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/convert_file');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
    	    
    // 		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
    // 		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
    // 		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
    
    // 		$response = curl_exec($curlHandle);
    // 		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
    // 		curl_close($curlHandle);
    		
    		if(file_exists($pdf_file_path)){
    		    $pdf = file_get_contents($pdf_file_path);
    		    $number = preg_match_all("/\/Page\W/", $pdf, $dummy);
                  if($number>1000){
                      $resultmsg = 'Max page limit: 1000';
                     // continue;
                  }
                  if(Auth::user()->level==2 && ($mypages+$number)>$maxpages){
                      $resultmsg = 'Your subscription plan page limit exceeds';
                      //continue;
                  }
                  
                  $pdfFilePath = public_path('files/pdf-files/'.$folder1).'/'.$pdf_filename;
                  
                  $file = FileList::where('user_id',Auth::user()->id)->where('parent',$request->parent)->where('filename',$pdf_filename)->first();
    
                  $totalPages = 0;
                  if(file_exists($pdfFilePath)){
                    $pdf = file_get_contents($pdfFilePath); 
                    $totalPages = preg_match_all("/\/Page\W/", $pdf, $dummy);
                  }
            		
                  $newfile = false;
                  if(!$file) {
                      $file = new FileList();
                      $file->filename = $pdf_filename;
                      $file->txt_file = '';
                      $file->type = "F";
                      $file->user_id = Auth::user()->id;
                      $file->parent = $request->parent;
                      $file->file_level = $file_level;
                      $file->trial = ($request->trial&&$request->trial==1)?1:0;
                      $file->generate = 1;
                      $file->page_nos = $totalPages;
                      $file->save();
                      $newfile= true;
                      
                      $log = new Log();
                      $log->log = "Added File -".$pdffile." - ID:".$file->id;
                      $log->user_id = Auth::user()?Auth::user()->id:0;
                      $log->save();
                      
                  }
                  $randStr = substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"),-3);
                  $txt_file = date('YmdHis').preg_replace('/[^A-Za-z0-9]/', 'F', crypt($file->id,'ilife-genie')).$randStr;
                  if($uploaded_ids!=""){
                      $uploaded_ids = $uploaded_ids.",";
                  }
                  $uploaded_ids = $uploaded_ids.$file->id;
                  if($newfile) {
                      $file->txt_file = $txt_file;
                      $file->save();
                  }
    		}
          
      } else {
          
          $pdf = file_get_contents($pdfile);
          
          $number = preg_match_all("/\/Page\W/", $pdf, $dummy);
          if($number>1000){
              $resultmsg = 'Max page limit: 1000';
              //continue;
          }
          if(Auth::user()->level==2 && ($mypages+$number)>$maxpages){
              $resultmsg = 'Your subscription plan page limit exceeds';
              //continue;
          }
          
          $pdfFilePath = public_path('files/pdf-files/'.$folder1).'/'.$pdffile;
          
          $file = FileList::where('user_id',Auth::user()->id)->where('parent',$request->parent)->where('filename',$pdffile)->first();
          
          $move = $pdfile->move(public_path('files/pdf-files/'.$folder1), $pdffile);
          
          $totalPages = 0;
          if(file_exists($pdfFilePath)){
            $pdf = file_get_contents($pdfFilePath); 
            $totalPages = preg_match_all("/\/Page\W/", $pdf, $dummy);
            
        	  if(Auth::user()->id=="3"){
                  $resultmsg .=   'filepath = '.url('files/pdf-files/'.$folder1).'/'.$pdffile; 
              }	 
          }
    	  
          $newfile = false;
          if(!$file) {
              $file = new FileList();
              $file->filename = $pdffile;
              $file->txt_file = '';
              $file->type = "F";
              $file->user_id = Auth::user()->id;
              $file->parent = $request->parent;
              $file->file_level = $file_level;
              $file->trial = ($request->trial&&$request->trial==1)?1:0;
              $file->generate = 1;
              $file->page_nos = $totalPages;
              $file->save();
              $newfile= true;
              
              $log = new Log();
              $log->log = "Added File -".$pdffile." - ID:".$file->id;
              $log->user_id = Auth::user()?Auth::user()->id:0;
              $log->save();
              
          }
          $randStr = substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"),-3);
          $txt_file = date('YmdHis').preg_replace('/[^A-Za-z0-9]/', 'F', crypt($file->id,'ilife-genie')).$randStr;
          if($uploaded_ids!=""){
              $uploaded_ids = $uploaded_ids.",";
          }
          $uploaded_ids = $uploaded_ids.$file->id;
          if($newfile) {
              $file->txt_file = $txt_file;
              $file->save();
          }
      }
	
		$files = $file;
		$id = $files->id;
      	$parent = $files->parent;
		$whole_text = "";
		
		$pdfs = array();
		$pknames = array();
		$folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($files->user_id,'ilife-genie'));
		$whole_text = $files->txt_file;
      	$type = $files->type;
		if($files->type=="D"){
			$path = '/files/pdf-files/'.$folder1.'/'.$id;
			$pknames = array();
			$pdfs = array();
			$kids = FileList::where('parent',$id)->where('generate','!=','3')->where('type','F')->get();
			foreach($kids as $kid){
			    $pdfs[] = $path.'/'.$kid->filename;
			    $pknames[] = $kid->txt_file;
			}
			
            $postParameter = array(
                'filepath' => $path,
                'store_name' => $whole_text,
                'type' => $type,
                'summary' => 'yes',
                'questions' => 'yes',
                'pdfs' => json_encode($pdfs),
                'pknames' => json_encode($pknames),
                'project' => 'genieweb'
            );
		} else {
			$path = '/files/pdf-files/'.$folder1;
			if($files->parent!=0){
				$path = $path."/".$files->parent;
			}
			$path = $path.'/'.$files->filename;
			
            $postParameter = array(
                'filepath' => $path,
                'store_name' => $whole_text,
                'type' => $type,
                'summary' => 'yes',
                'questions' => 'yes',
                'project' => 'genieweb'
            );
		}
          
		
		if($files->type=="D"){
	        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/chatfolder');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
	    } else {
	        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/chatfile');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
	    }
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
		curl_close($curlHandle); 
		
		
		$log = new Log();
		$log->log = "Create chat of file/folder id-".$id;
		$log->user_id = Auth::user()?Auth::user()->id:0;
		$log->save();
		if(trim($httpcode)!="200"){
			//self::create_chat($request);
			return response()->json(['status' => 'failed', 'result' => 'Something went wrong. Please try again.']);
		} elseif($response!="") {
			$respArr =  explode('-eeddjustinddee-',$response);
			if(trim($respArr[0])!="I don't know." && trim($respArr[0])!=""){
				$files->summary = nl2br($respArr[0]);
			}
			if(trim($respArr[1])!="I don't know." && trim($respArr[1])!=""){
				$files->sample_questions = nl2br($respArr[1]);
			}
			$files->embed = 1;
			$files->save();
			
		}
      	return response()->json(['status' => 'success', 'result' => 'Chat Generated Successfully']);
		
		
// 		$files->generate = 1;
// 		$files->save();
//       	$parent = $files->parent;
// 		$whole_text = "";
		
// 		$pdfs = array();
// 		$pknames = array();
// 		$folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($files->user_id,'ilife-genie'));
// 		$whole_text = $files->txt_file;
      	
// 		$path = 'files/pdf-files/'.$folder1;
// 		if($files->parent!=0){
// 			$path = $path."/".$files->parent;
// 		}
// 		$path = $path.'/'.$files->filename;
		
//         $postParameter = array(
//             'filepath' => $path,
//             'store_name' => $whole_text,
//             'project' => 'genieweb'
//         );
// 		if(auth()->user()->id=="3"){
		    

		    
// 		    if(File::exists(public_path($path))) {
// 		        $response = $path;
// 		    } else {
// 		        $response =  "file not exist";
// 		    }
// 		    //return response()->json(['status' => 'success', 'result' => $response]);
// 		}
//         $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/newfile');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
	    
// 		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
// 		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
// 		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);

// 		$response = curl_exec($curlHandle);
// 		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
// 		curl_close($curlHandle); 
		
// 		//if(auth()->user()->id=="3"){
// 		//    return $response;
// 		//}
		
// 		if($response=="success"){
// 		    $files->generate = 2;
// 		    $files->embed = 1;
		    
// 		    $files->save();
// 		} else {
// 		    $response = "Invalid file format or a PDF with only scanned pages detected. Please upload a PDF with text content.";
// 		    $files->generate = 3;
// 		    $files->save();
// 		}
// 		return response()->json(['status' => 'success', 'result' => $response]);
	}
  	public function add_files(Request $request){
		for($i=0;$i<$request->files_count;$i++){
          $validator = Validator::make($request->all(), [
              'filename_'.$i     => 'required',
              'filename_'.$i.'.*' => 'mimes:pdf,docx'
          ]);
          if ($validator->fails()) return response($validator->messages(), 200);
        }
        
        $mypackage = UserPackage::where('user_id',Auth::user()->id)->where('end_date','>=',date("Y-m-d"))->orderBy('end_date','desc')->first();
        if($mypackage){
            if(date('Y-m-d')>=date('Y-m-d',strtotime($mypackage->start_date)) && date('Y-m-d')<=date('Y-m-d',strtotime($mypackage->end_date))){
                $maxpages = $mypackage->page_limit;
            } else {
                $maxpages = 100; 
            }
        } else {
            $maxpages = 100;
        }
        
		$uploaded_ids = '';
		$request->parent = isset($request->parent)?$request->parent:0;
		
    	$folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt(Auth::user()->id,'ilife-genie'));
		
    	$path = public_path().'/files/pdf-files/'.$folder1;
    	
    	//if(Auth::user()->id==3){
		    
    	//}
		if(!File::exists($path)) {
			File::makeDirectory($path, $mode = 0777, true, true);
		}
		$file_level = 2;
		if($request->parent!=0){
			$path = $path."/".$request->parent;
			$folder1 = $folder1."/".$request->parent;
			if(!File::exists($path)) {
				File::makeDirectory($path, $mode = 0777, true, true);
			}
			$parentFolder = FileList::where('id',$request->parent)->first();
			$file_level = $parentFolder->file_level;
		}
		

		
		
		if(Auth::user()->level>2){
		    $file_level = Auth::user()->level;
		    if(Auth::user()->level==5){
		        $file_level = 4;
		    }
		}
		$resultmsg = 'Uploaded, Processing...';
    	for($i=0;$i<$request->files_count;$i++){
    	      $mypages = FileList::where('user_id',Auth::user()->id)->where('type','F')->sum('page_nos');
    	      
              $pdfile = $request->file('filename_'.$i);
              $pdffile = $pdfile->getClientOriginalName();
              
              $file_ext = explode('.',$pdffile);
              $extension = strtoupper(end($file_ext));
              $allowed_exts = array('DOC', 'DOCX', 'PPT', 'PPTX', 'XLS', 'XLSX', 'ODT', 'ODP', 'ODS');
              if(in_array($extension,$allowed_exts)){
                  $doc_filename = rand(100,999).date('YmdHis').auth()->user()->id.rand(1000,9999).".docx";
                  $pdfile->move(public_path('other-files/'), $doc_filename);
                  
                  $doc_file_path = public_path('other-files/'.$doc_filename);
                  
                  $pdf_filename = substr($pdffile, 0, -5).".pdf";
                  $pdf_file_path = public_path('files/pdf-files/'.$folder1.'/'.$pdf_filename);
                  
                  $doc_file2 = 'public/other-files/'.$doc_filename;
                  $pdf_file2 = 'public/files/pdf-files/'.$folder1.'/'.$pdf_filename;
                  $pdf_file3 = 'files/pdf-files/'.$folder1.'/'.$pdf_filename;
                  
                try { 
                    $ilovepdf = new Ilovepdf('project_public_8d43a6f826b46e30edc4a15016c9d2df_AbEHWdd3e0e1456c64a865698adef2d9eab43','secret_key_ad61cc9ca86185823a73bb2221905681_ITAFwfccf722a6d9f42680408805f66a6d967');
                    $myTask = $ilovepdf->newTask('officepdf');
                    $file1 = $myTask->addFile(public_path('other-files/'.$doc_filename));
                    $myTask->setOutputFilename($pdf_file3);
                    $myTask->execute();
                    $myTask->download('files/pdf-files/'.$folder1);
                  
                } catch (\Ilovepdf\Exceptions\StartException $e) {
                    $resultmsg = "An error occured on start: " . $e->getMessage() . " ";
                    // Authentication errors
                } catch (\Ilovepdf\Exceptions\AuthException $e) {
                    $resultmsg = "An error occured on auth: " . $e->getMessage() . " ";
                    //echo implode(', ', $e->getErrors());
                    // Uploading files errors
                } catch (\Ilovepdf\Exceptions\UploadException $e) {
                    $resultmsg = "An error occured on upload: " . $e->getMessage() . " ";
                    //echo implode(', ', $e->getErrors());
                    // Processing files errors
                } catch (\Ilovepdf\Exceptions\ProcessException $e) {
                    $resultmsg = "An error occured on process - " . $e->getMessage() . " ";
                    //echo implode(', ', $e->getErrors());
                    // Downloading files errors
                } catch (\Ilovepdf\Exceptions\DownloadException $e) {
                    $resultmsg = "An error occured on process : " . $e->getMessage() . " ";
                    //echo implode(', ', $e->getErrors());
                    // Other errors (as connexion errors and other)
                } catch (\Exception $e) {
                    
                    try {
                        $ilovepdf = new Ilovepdf('project_public_8d43a6f826b46e30edc4a15016c9d2df_AbEHWdd3e0e1456c64a865698adef2d9eab43','secret_key_ad61cc9ca86185823a73bb2221905681_ITAFwfccf722a6d9f42680408805f66a6d967');
                        $myTask = $ilovepdf->newTask('officepdf');
                        $file1 = $myTask->addFile(public_path('other-files/'.$doc_filename));
                        $myTask->setOutputFilename($pdf_file3);
                        $myTask->execute();
                        $myTask->download('files/pdf-files/'.$folder1);
                    } catch (\Exception $e) {
                        $resultmsg = "An error occurred- " . $e->getMessage();
                    }
                }
                  
            //       $postParameter = array(
            //             'doc_file' => $doc_file2,
            //             'pdf_file' => $pdf_file2,
            //             'project' => 'genieweb'
            //         );
            //         $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/convert_file');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
            	    
            // 		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
            // 		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
            // 		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
            
            // 		$response = curl_exec($curlHandle);
            // 		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
            // 		curl_close($curlHandle);
            		
            		if(file_exists($pdf_file_path)){
            		    $pdf = file_get_contents($pdf_file_path);
            		    $number = preg_match_all("/\/Page\W/", $pdf, $dummy);
                          if($number>1000){
                              $resultmsg = 'Max page limit: 1000';
                              continue;
                          }
                          if(Auth::user()->level==2 && ($mypages+$number)>$maxpages){
                              $resultmsg = 'Your subscription plan page limit exceeds';
                              continue;
                          }
                          
                          $pdfFilePath = public_path('files/pdf-files/'.$folder1).'/'.$pdf_filename;
                          
                          $file = FileList::where('user_id',Auth::user()->id)->where('parent',$request->parent)->where('filename',$pdf_filename)->first();
            
                          $totalPages = 0;
                          if(file_exists($pdfFilePath)){
                            $pdf = file_get_contents($pdfFilePath); 
                            $totalPages = preg_match_all("/\/Page\W/", $pdf, $dummy);
                          }
                    		
                          $newfile = false;
                          if(!$file) {
                              $file = new FileList();
                              $file->filename = $pdf_filename;
                              $file->txt_file = '';
                              $file->type = "F";
                              $file->user_id = Auth::user()->id;
                              $file->parent = $request->parent;
                              $file->file_level = $file_level;
                              $file->trial = ($request->trial&&$request->trial==1)?1:0;
                              $file->generate = 1;
                              $file->page_nos = $totalPages;
                              $file->save();
                              $newfile= true;
                              
                              $log = new Log();
                              $log->log = "Added File -".$pdffile." - ID:".$file->id;
                              $log->user_id = Auth::user()?Auth::user()->id:0;
                              $log->save();
                              
                          }
                          $randStr = substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"),-3);
                          $txt_file = date('YmdHis').preg_replace('/[^A-Za-z0-9]/', 'F', crypt($file->id,'ilife-genie')).$randStr;
                          if($uploaded_ids!=""){
                              $uploaded_ids = $uploaded_ids.",";
                          }
                          $uploaded_ids = $uploaded_ids.$file->id;
                          if($newfile) {
                              $file->txt_file = $txt_file;
                              $file->save();
                          }
            		}
                  
              } else {
                  
                  $pdf = file_get_contents($pdfile);
                  
                  $number = preg_match_all("/\/Page\W/", $pdf, $dummy);
                  if($number>1000){
                      $resultmsg = 'Max page limit: 1000';
                      continue;
                  }
                  if(Auth::user()->level==2 && ($mypages+$number)>$maxpages){
                      $resultmsg = 'Your subscription plan page limit exceeds';
                      continue;
                  }
                  
                  $pdfFilePath = public_path('files/pdf-files/'.$folder1).'/'.$pdffile;
                  
                  $file = FileList::where('user_id',Auth::user()->id)->where('parent',$request->parent)->where('filename',$pdffile)->first();
                  
                  $move = $pdfile->move(public_path('files/pdf-files/'.$folder1), $pdffile);
                  
                  $totalPages = 0;
                  if(file_exists($pdfFilePath)){
                    $pdf = file_get_contents($pdfFilePath); 
                    $totalPages = preg_match_all("/\/Page\W/", $pdf, $dummy);
                    
                	  if(Auth::user()->id=="3"){
                          $resultmsg .=   'filepath = '.url('files/pdf-files/'.$folder1).'/'.$pdffile; 
                      }	 
                    
                  }
            	  
                  $newfile = false;
                  if(!$file) {
                      $file = new FileList();
                      $file->filename = $pdffile;
                      $file->txt_file = '';
                      $file->type = "F";
                      $file->user_id = Auth::user()->id;
                      $file->parent = $request->parent;
                      $file->file_level = $file_level;
                      $file->trial = ($request->trial&&$request->trial==1)?1:0;
                      $file->generate = 1;
                      $file->page_nos = $totalPages;
                      $file->save();
                      $newfile= true;
                      
                      $log = new Log();
                      $log->log = "Added File -".$pdffile." - ID:".$file->id;
                      $log->user_id = Auth::user()?Auth::user()->id:0;
                      $log->save();
                      
                  }
                  $randStr = substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"),-3);
                  $txt_file = date('YmdHis').preg_replace('/[^A-Za-z0-9]/', 'F', crypt($file->id,'ilife-genie')).$randStr;
                  if($uploaded_ids!=""){
                      $uploaded_ids = $uploaded_ids.",";
                  }
                  $uploaded_ids = $uploaded_ids.$file->id;
                  if($newfile) {
                      $file->txt_file = $txt_file;
                      $file->save();
                  }
              }
              
              
        
		}
        
		return response()->json(['status' => 'success', 'result' => $resultmsg, 'files'=>$uploaded_ids]);
    }
	
	public function profile(Request $request){
	    if(auth()->user()->status!="1"){
            return response()->json(['status' => 'failed', 'result' => 'Not verified']);
        }
  	    if(auth()->user()->level=="0"){
	        return response()->json(['status' => 'failed', 'result' => 'User type not set']);
	    }
	    
	    if(auth()->user()->level!="1"){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return response()->json(['status' => 'failed', 'result' => 'No package added']);
            }
	    }
	    $up = UserPackage::where('user_id',auth()->user()->id)->with('package')->orderBy('end_date','desc')->orderBy('package_id','desc')->first();
        
        $total_limit = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->sum('question_limit');
        
        if(auth()->user()->parent>0){
	        $used_limit = UserQuestion::whereRaw('user_id IN (SELECT id FROM users WHERE parent="'.auth()->user()->parent.'")')->count();
	        $today_used_limit = UserQuestion::whereRaw('user_id IN (SELECT id FROM users WHERE parent="'.auth()->user()->parent.'")')->where('created_at',date("Y-m-d"))->count();
	        $monthly_used_limit = UserQuestion::whereRaw('user_id IN (SELECT id FROM users WHERE parent="'.auth()->user()->parent.'")')->where('created_at','LIKE','%'.date("Y-m-").'%')->count();
	        
	    } else {
	        $used_limit = UserQuestion::where('user_id',auth()->user()->id)->count();
	        $today_used_limit = UserQuestion::where('user_id',auth()->user()->id)->where('created_at',date("Y-m-d"))->count();
	        $monthly_used_limit = UserQuestion::where('user_id',auth()->user()->id)->where('created_at','LIKE','%'.date("Y-m-").'%')->count();
	    }
	    
	    $rc = User::where('referral',auth()->user()->my_referrer_id)->count();
	    
	    return response()->json(['status' => 'success', 'result' => auth()->user(), 
	                                'total_limit'=>$total_limit,
	                                'package'=>$up, 
	                                'referral_count'=>$rc, 
	                                'used_limit'=>$used_limit, 
	                                'today_used_limit'=>$today_used_limit, 
	                                'monthly_used_limit'=>$monthly_used_limit]);
	}
	
    public function register(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name'     => 'required',
            'level'     => 'required',
            'email'    => 'required|email|unique:users',
            'mobile' => 'required|min:10',
            'password' => 'required|min:5'
        ]);
        
        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'result' => $validator->messages()]);
        }
        //return response($validator->messages(), 200);
        
        $otp = rand(100000,999999);
        $user = new User();
		$user->name = $request->name;
		$user->email = $request->email;
		$user->password = bcrypt($request->password);
		$user->mobile = $request->mobile;
		$user->level = $request->level;
		$user->status = $request->level==7?1:0;
		$user->referral = $request->referral?$request->referral:'';
		
		$user->otp = $otp;
		$user->save();
		
		$this->generate_referrer_id($user->id); 
		$request->subscription_type = 1;
		
        $uj = new UsersJob();
        $uj->user_id = $user->id;
        $uj->password = $request->password;
        $uj->status = 0;
        $uj->save();
        
        $credentials = $request->only('email', 'password');

        if (Auth::attempt($credentials)) {
            $user             = Auth::user();
            $tokenResult = $user->createToken('accessToken');
            //return response()->json(['status' => 'success', 'result' => $success]);
            return response()->json([
                'status' => 'success',
                'name' => Auth::user()->name,
                'access_token' => $tokenResult->accessToken,
                'token_type' => 'Bearer',
                'expires_at' => $tokenResult->token->expires_at
            ]);
        }
        
    }
    
    public function resend_otp(Request $request){
      $id = auth()->user()->id;
      $otp = rand(100000,999999);
      $user = User::where('id',$id)->first();
      $user->otp = $otp;
      $user->save();
      
      $user->message = $otp." is the OTP for your email verification";  
      
        Mail::to($user->email)->send(new \App\Mail\AskPDFMailOTP($user));
      
      return response()->json(['status' => 'success', 'result' =>'OTP has been sent to your mail!']);
      
    }
  	public function verify_otp(Request $request){
      $otp = auth()->user()->otp;
      if($request->otp==$otp){
        $user = User::where('id',auth()->user()->id)->first();
        if($user){
          $user->status=1;
          $user->save();
        
        }
        return response()->json(['status' => 'success', 'result' =>'Verified SuccessFully']);
      }
      return response()->json(['status' => 'failed', 'result' =>'Incorrect OTP']);
    }
  	public function user_status(Request $request){
      $user = auth()->user();
      return response()->json(['status' => 'success', 'result' =>$user->status]);
    }
    public function update_user_type(Request $request){
	    $id = auth()->user()->id;
        $user = User::where('id',$id)->first();
        $user->level = $request->level;
        if($request->level==7){
            $user->status = 1; 
        }
        $user->save();
        return response()->json(['status' => 'success', 'result' =>'Updated SuccessFully']);
    }
    
  	public function pricings(Request $request){
      $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
	  $all_packages = Package::where('status',1)->where('level',auth()->user()->level==1?2:auth()->user()->level)->orderby('price','asc')->get();
	  $ip = $_SERVER['REMOTE_ADDR'];
        $details = json_decode(file_get_contents("http://ipinfo.io/{$ip}/json"));
        $mycountry = $details->country; 
      return response()->json(['status' => 'success', 'result' =>$all_packages, 'my_package'=>$mypackage, 'my_country'=>$mycountry]);
    }
    
    
    public function home_ask(Request $request){
        if(auth()->user()){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return response()->json(['status' => 'failed', 'result' => 'No package added']);
            }
	    } else {
	        $asked = HomeChat::where('device_id',$request->device_id)->where('created_at','>=',date('Y-m-d').' 00:00:00')->where('created_at','<=',date('Y-m-d').' 23:59:59')->count();
	        if($asked>=5){
	            return response()->json(['status' => 'failed', 'result' => 'Limit Exceeds']);
	        }
	    }
        $qstn = $request->question;
        $header = array(
		    'Content-Type: application/json',
		    'Authorization: Bearer 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'
		);
		$postParameter = array(
            'model' => 'gpt-3.5-turbo',
            'messages' => array(
                array('role' => 'user',
                'content' => $qstn
                ))
        );
        
        $curlHandle = curl_init('https://api.openai.com/v1/chat/completions');
	    
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		
		$responses =  $result['choices'][0]['message']['content'];
		
		$qa_id = 0;
        
        $hmchat = new HomeChat();
        $hmchat->device_id = $request->device_id;
        $hmchat->user_id = auth()->user()?auth()->user()->id:'0';
        $hmchat->question = $request->question;
        $hmchat->answer = $responses;
        $hmchat->save();
        
        return response()->json(['status' => 'success', 'result' =>$responses]);
      	//return "<md-block data-id='".$qa_id."'>".($responses)."</md-block>";
    }
    
    
   
  	public function apply_coupon(Request $request){
  	    
  	    
        $amount = $price = $request->amount/100;
    	
    	$applied_coupon = $request->applied_coupon;
		$coupon = CouponCode::where('code',$applied_coupon)->where('status',1)->first();
		$msg = "Invalid Coupon";
        if($coupon){
            $price = (($price)-(($price)*($coupon->off_percent/100)));
            $msg = $applied_coupon." applied successfully!";
        }
		
        return response()->json(['status' => 'success', 'result' =>$price, 'msg'=>$msg]);
    }
  	public function payment(Request $request){
  	    
  	    
        $amount = $price = $request->amount>0?$request->amount/100:0;
    	
    	$applied_coupon = $request->applied_coupon?$request->applied_coupon:'';
		$coupon = CouponCode::where('code',$applied_coupon)->where('status',1)->first();
        if($coupon){
            $price = (($price)-(($price)*($coupon->off_percent/100)));
        }
        
		$package_id = $request->id;
		
        $order = new Order();
        $order->user_id = auth()->user()->id;
        $order->amount = $price;
        $order->package = $package_id;
        $order->billing_address = $request->address?$request->address:'';
        $order->response = $request->payment;
        $order->status = 0;
        $order->coupon = $applied_coupon;
        $order->save();
    			
		
		$package = Package::where('id',$package_id)->first();
		
		$order_id	= $order->id;
		
		$userpackage = new UserPackage();
		$userpackage->user_id = auth()->user()->id;
        $userpackage->package_id = $package_id;
        $userpackage->start_date = date('Y-m-d H:i:s');
        $userpackage->end_date	= date('Y-m-d', strtotime('+'.$package->period));
        $userpackage->status = 1;	
        
        $userpackage->order_id	= $order_id;
        $userpackage->page_limit = $package->page_limit;
        $userpackage->user_limit = $package->user_limit;
        $userpackage->question_limit = $package->question_limit;
        
        $userpackage->save();
		
		$invoice = new Invoice();
		$invoice->order_id = $order_id;
		$invoice->amount = $amount;
		$invoice->save(); 
		
      return response()->json(['status' => 'success', 'result' =>'Payment Successful']);
    }
    
	public function create_chat(Request $request){
		$id = $request->id;
		$files = FileList::where('id',$id)->first();
      	$parent = $files->parent;
		$whole_text = "";
		
		$pdfs = array();
		$pknames = array();
		$folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($files->user_id,'ilife-genie'));
		$whole_text = $files->txt_file;
      	$type = $files->type;
		if($files->type=="D"){
			$path = '/files/pdf-files/'.$folder1.'/'.$id;
			$pknames = array();
			$pdfs = array();
			$kids = FileList::where('parent',$id)->where('generate','!=','3')->where('type','F')->get();
			foreach($kids as $kid){
			    $pdfs[] = $path.'/'.$kid->filename;
			    $pknames[] = $kid->txt_file;
			}
			
            $postParameter = array(
                'filepath' => $path,
                'store_name' => $whole_text,
                'type' => $type,
                'summary' => 'yes',
                'questions' => 'yes',
                'pdfs' => json_encode($pdfs),
                'pknames' => json_encode($pknames),
                'project' => 'genieweb'
            );
		} else {
			$path = '/files/pdf-files/'.$folder1;
			if($files->parent!=0){
				$path = $path."/".$files->parent;
			}
			$path = $path.'/'.$files->filename;
			
            $postParameter = array(
                'filepath' => $path,
                'store_name' => $whole_text,
                'type' => $type,
                'summary' => 'yes',
                'questions' => 'yes',
                'project' => 'genieweb'
            );
		}
          
		if(auth()->user()->id=="3"){
		    if($files->type=="D"){
		        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/chatfolder');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
		    } else {
		        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/chatfile');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
		    }
    		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
    		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
    		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
    
    		$response = curl_exec($curlHandle);
    		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
    		curl_close($curlHandle); 
    		//print_r($postParameter);
    		//echo $response; exit();
		} else {
    		if($files->type=="D"){
		        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/chatfolder');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
		    } else {
		        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/chatfile');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
		    }
    		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
    		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
    		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
    
    		$response = curl_exec($curlHandle);
    		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
    		curl_close($curlHandle); 
		}
		
		$log = new Log();
		$log->log = "Create chat of file/folder id-".$id;
		$log->user_id = Auth::user()?Auth::user()->id:0;
		$log->save();
		if(trim($httpcode)!="200"){
			//self::create_chat($request);
			return response()->json(['status' => 'failed', 'result' => 'Something went wrong. Please try again.']);
		} elseif($response!="") {
			$respArr =  explode('-eeddjustinddee-',$response);
			if(trim($respArr[0])!="I don't know." && trim($respArr[0])!=""){
				$files->summary = nl2br($respArr[0]);
			}
			if(trim($respArr[1])!="I don't know." && trim($respArr[1])!=""){
				$files->sample_questions = nl2br($respArr[1]);
			}
			$files->embed = 1;
			$files->save();
			
      	    return response()->json(['status' => 'success', 'result' => 'Chat Generated Successfully','file'=>$files]);
		}
	} 
	
    
	public function pdfslist(Request $request){
	    $id = $request->id;
	    $file = FileList::where('id',$id)->first();
	    $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($file->user_id,'ilife-genie'));
	    $pdfs = array();
	    if($file->type=="D"){
	        $path = '/files/pdf-files/'.$folder1.'/'.$id;
	        $kids = FileList::where('parent',$id)->where('generate','!=','3')->where('type','F')->get();
			foreach($kids as $kid){
			    $pdfs[] = $path.'/'.$kid->filename;
			}
	    } else{
	        $path = '/files/pdf-files/'.$folder1;
			if($file->parent!=0){
				$path = $path."/".$file->parent;
			}
			$path = $path.'/'.$file->filename;
	        $pdfs[] = $path;
	    }
	    return response()->json(['status' => 'success', 'result' =>$pdfs]);
	}
	
	
    public function storybook($data){
        return view('storybook', compact('data'));
    }
    public function story_chat_history(Request $request){
        $userquestions = StoryBook::where('user_id',auth()->user()->id)->orderBy('created_at','DESC')->limit(3)->get();
        $toggles = array();
        $toggles[] = array("value"=>"",
                    "name"=>"Test");
        return response()->json(['status' => 'success', 'result' => $userquestions, 'toggles' => $toggles]);
    }
    public function generate_story_book(Request $request){
        if(auth()->user()){
    	    //$mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            //if(!$mypackage){
            //    return response()->json(['status' => 'failed', 'result' => 'No package added']);
            //}
	    } else {
	       return response()->json(['status' => 'failed', 'result' => 'Invalid User ']);
	    }
        $qstn = $request->question;
        $question = "Create a story for the topic '".$qstn."'. The story needs 20 paragraphs. Each paragraphs needs 100 words limit. Make the main character name of story as ".auth()->user()->name;
        
        
        //$cover_image = $this->generate_image("Cover image for a story book about ".$qstn.". The image should not have any text or writings in it","820x1060",1,"imagine");//, "820x1060"
        
        
        //return response()->json(['status' => 'success', 'result' =>$cover_image]);
        
        
        
        $header = array(
		    'Content-Type: application/json',
		    'Authorization: Bearer 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'
		);
		$postParameter = array(
            'model' => 'gpt-3.5-turbo',
            'messages' => array(
                array('role' => 'user',
                'content' => $question
                ))
        );
        
        $curlHandle = curl_init('https://api.openai.com/v1/chat/completions');
	    
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		
		$responses =  $result['choices'][0]['message']['content']; 
		
// 		$responses =  "Justin was a passionate environmentalist who had always been concerned about the impact of global warming on the planet. He had spent years studying the issue and advocating for change, but it often felt like his efforts were falling on deaf ears. Despite the overwhelming evidence of climate change, many people still refused to take action.\n\n
// 		One day, Justin decided to take matters into his own hands. He organized a community meeting to discuss the effects of global warming and what they could do to combat it. Surprisingly, the turnout was better than he had expected. People from all walks of life came together to share their concerns and ideas.\n\n
// 		Inspired by the support he received, Justin decided to launch a campaign to raise awareness about the importance of taking action on climate change. He used social media to spread the word, reaching thousands of people with his message. The response was overwhelmingly positive, and soon Justin found himself at the forefront of a growing movement to address global warming.\n\n
// 		As the campaign gained momentum, Justin and his fellow activists began to see real change happening. Companies started to adopt more sustainable practices, governments passed legislation to reduce greenhouse gas emissions, and individuals made small changes in their daily lives to reduce their carbon footprints.\n\n
// 		But despite the progress that was being made, Justin knew that there was still so much more to be done. The effects of global warming were becoming increasingly evident, with more frequent natural disasters, rising sea levels, and dwindling wildlife populations. The urgency of the situation weighed heavily on his mind.\n\n
// 		Determined to make a difference, Justin decided to take his campaign to the next level. He organized a series of protests and demonstrations to demand action on climate change from world leaders. The events drew huge crowds and garnered international attention, putting even more pressure on governments to take meaningful steps to address the crisis.\n\n
// 		But as the years went by, Justin began to grow frustrated with the slow pace of progress. Despite all their efforts, global temperatures continued to rise, and the impacts of climate change became more severe. It seemed like they were fighting an uphill battle against powerful interests that were resistant to change.\n\n
// 		But Justin refused to give up. He believed that every small action had the potential to create a ripple effect that could lead to real change. He continued to speak out, educate others, and advocate for policies that would help mitigate the effects of global warming. And slowly but surely, his persistence began to pay off.\n\n
// 		One day, Justin received a phone call from a government official who had been inspired by his activism. The official wanted to meet with Justin to discuss ways they could work together to address climate change at a higher level. Justin was thrilled by the opportunity and eagerly accepted the invitation.\n\n
// 		The meeting was a turning point in Justin's campaign. With the support of the government, he was able to make even greater strides in the fight against global warming. New policies were introduced, renewable energy sources were expanded, and emissions targets were set that would help reduce the impact of climate change on the planet.\n\n
// 		As the years passed, Justin watched with pride as the world began to shift towards a more sustainable future. The effects of global warming were still present, but they were no longer as catastrophic as they had once been. It was a testament to the power of individuals coming together to make a difference.\n\n
// 		Justin knew that the fight against climate change was far from over, but he was filled with hope for the future. He had seen firsthand the impact that collective action could have, and he was certain that if people continued to work together, they could create a world that was safe, healthy, and sustainable for generations to come. And with that belief in his heart, Justin continued to advocate for change, knowing that every step forward was a step towards a better tomorrow.";
		
		
		$data = array();
        $data['title'] = $qstn;
        
        $data['author'] = auth()->user()->name;
        
        $data['paragraph'] = explode("\n\n", $responses);
        
        $n = ceil(count($data['paragraph'])/2);
        
        //$data['page_image'] = $this->generate_multiple_images("Generate comic book like illustration for ".$responses.". The image should not have any text or writings in it","1024x1024",$n);
        
        
        $cover_image = $this->generate_image("Cover image for a story book about ".$qstn.". The image should not have any text or writings in it","820x1060",1,"openai");//, "820x1060"
        
        $data['cover_image'] = $cover_image; 
        
        //return response()->json(['status' => 'success', 'result' =>$cover_image]);
         
        //$data['page_image']  
         
		for($i=0;$i<count($data['paragraph']);$i++){
		    $prompt = $data['paragraph'][$i]." ".(isset($data['paragraph'][$i+1])?$data['paragraph'][$i+1]:'');
		    $image = $this->generate_image("Generate comic book like illustration for ".$prompt.". The image should not have any text or writings in it","820x1060",1,"openai");
		    $data['page_image'][] = $image;
		    $i = $i+1;
		}
		
		
		$qa_id = 0;
        
        $filename = "story_book_".date('YmdHis').".pdf";
        $path = public_path().'/storybook/'.auth()->user()->id;
		if(!File::exists($path)) {
			File::makeDirectory($path, $mode = 0777, true, true);
		}
		
        $pdf = \PDF::loadView('storybook', compact('data'))->setPaper('letter', 'portrait');

        $pdf->save($path.'/'.$filename);
        
        $hmchat = new StoryBook();
        $hmchat->user_id = auth()->user()?auth()->user()->id:'0';
        $hmchat->topic = $qstn;
        $hmchat->file = $filename;
        $hmchat->save();
         
        return response()->json(['status' => 'success', 'result' =>$hmchat]);
      	//return "<md-block data-id='".$qa_id."'>".($responses)."</md-block>";
    }
    public function storybookpdf(Request $request){
        $book = StoryBook::where('id',$request->id)->first();
        $pdf = "/storybook/".auth()->user()->id."/".$book->file;
        return response()->json(['status' => 'success', 'result' =>$pdf]);
    }
    
    public function generate_each_image(Request $request){
        $type = $request->type;
        $prompt = $request->prompt;
        $imgdata = $this->generate_image("Cover image for a story book about ".$prompt.". The image should not have any text or writings in it", "1024x1024", 1, "openai");
        return response()->json(['status' => 'success', 'result' =>$imgdata]);
    }
    
    
    
    public function generate_image($prompt, $size="1024x1024", $n=1, $type="openai"){
        if($type=="openai"){
            $header = array(
    		    'Content-Type: application/json',
    		    'Authorization: Bearer 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'
    		);
    		
            $postParameter = array(
                "model" => "dall-e-2",
                "prompt"=> $prompt,
                "n"=> (int)$n,
                "size"=> $size,
                "response_format"=> "b64_json"
            ); 
             
            $curlHandle = curl_init('https://api.openai.com/v1/images/generations');
        } elseif($type=="imagine"){
            
            $header = array(
    		    'Content-Type: application/json',
    		    'Authorization: Bearer vk-fT6Q3ywMjE3L2DMYtkuEtXeSLvBQLmafXJcosjDbF8mKBY'
    		    
    		);
    		
            $postParameter = array(
                "prompt"=> $prompt,
                "style"=> "imagine-turbo",
                "aspect_ratio"=> "3:4"
            ); 
            $curlHandle = curl_init('https://api.vyro.ai/v2/image/generations');
        } else {
            $prompt2 = $prompt.". Make the image size ".$size."px";
            $header = array(
    		    'Content-Type: application/json',
    		    'api-key: 354d1a40-3628-479e-96fb-1f0f794f24a2'
    		);
    		
            $postParameter = array(
                "text"=> $prompt2
            ); 
             
            $curlHandle = curl_init('https://api.deepai.org/api/text2img');
        }
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);  
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header); 
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);   
  
		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
	    if($type=="openai"){
    		if(isset($result['data'])){
                return "data:image/png;base64,".$result['data'][0]['b64_json'];
    		} else {
    		    return $this->generate_image($prompt, $size, $n, $type);
    		}
		} elseif($type=="imagine"){
		    return $result; 
		    if(isset($result['result'])){
                return $result['result']['output_url'];
    		} else {
    		    return $this->generate_image($prompt, $size, $n, $type);
    		}
		    
		} else {
		    if(isset($result['result'])){
                return $result['result']['output_url'];
    		} else {
    		    return $this->generate_image($prompt, $size, $n, $type);
    		}
		    
		}
    } 
    
    public function generate_multiple_images($prompt, $size="1024x1024", $n=1){
        $header = array(
		    'Content-Type: application/json',
		    'Authorization: Bearer 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'
		);
		$postParameter = array(
            "model" => "dall-e-2",
            "prompt"=> $prompt,
            "n"=> (int)$n,
            "size"=> $size,
            "response_format"=> "b64_json"
        ); 
         
        $curlHandle = curl_init('https://api.openai.com/v1/images/generations');
	     
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header); 
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);
  
		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
	 
        return response()->json(['status' => 'success', 'result' =>$result]);
         
		if(isset($result['result']['data'])){
            return $result['result']['data'];
		} else {
		    return $this->generate_multiple_images($prompt, $size, $n);
		}
    } 
       
    public function generate_image_demo(Request $request){
        
        $size="1024x1024";
        $prompt = $request->question;
        $n = $request->n?$request->n:5;
        
        $header = array(
		    'Content-Type: application/json',
		    'Authorization: Bearer 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'
		);
		$postParameter = array(
            "model" => "dall-e-2",
            "prompt"=> $prompt,
            "n"=> (int)$n,
            "size"=> $size,
            "response_format"=> "b64_json"
        ); 
          
          
             
             
           
           
          
        $curlHandle = curl_init('https://api.openai.com/v1/images/generations');
	    
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		
		
		return response()->json(['status' => 'success', 'result'=>$result]);
		
		
    }
    
    public function storybook_demo(){
        $filename = "story_book_20250204105258.pdf";//"story_book_".date('YmdHis').".pdf";
        $path = public_path().'/storybook/'.auth()->user()->id;
		if(!File::exists($path)) {
			File::makeDirectory($path, $mode = 0777, true, true);
		}
		
        $pdf = \PDF::loadView('storybook2')->setPaper('letter', 'portrait');

        $pdf->save($path.'/'.$filename);
        return response()->json(['status' => 'success']);
    }
    
    
    public function generate_text(Request $request) {
        $type = $request->type;
        $qstn = $request->question;
        $question = "Create a story for the topic '".$qstn."'. The story needs 20 paragraphs. Each paragraphs needs 100 words limit. Make the main character name of story as Justin";
            
        if($type=="openai"){
            $header = array(
    		    'Content-Type: application/json',
    		    'Authorization: Bearer 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'
    		);
    		$postParameter = array(
                'model' => 'gpt-3.5-turbo',
                'messages' => array(
                    array('role' => 'user',
                    'content' => $question
                    ))
            );
        } else {
            $header = array(
    		    'Content-Type: application/json',
    		    'api-key: 354d1a40-3628-479e-96fb-1f0f794f24a2'
    		);
    		
            $postParameter = array(
                "text"=> $question
            ); 
             
            $curlHandle = curl_init('https://api.deepai.org/api/text-generator');
        }
        //curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header); 
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);
  
		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		return response()->json(['status' => 'success', 'result' =>$result]);
    }
}
