<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\CareerPlanning;
use App\Models\CpAnswer;
use App\Models\CpQuestion;
use App\Models\CpSkill;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Exception;
use DB;
use Mail;
use Hash;
use File;
use Response;
use Storage;

class CPController extends Controller
{
    
    public function index($step=""){
		$exist = CareerPlanning::where('status','0')->where('user_id',auth()->user()->id)->with('gradedata')->first();
		$question = [];
		$skills = [];
		$all_questions = false;
		$active_qns = array();
		$prev = false;
		$final_result = "";
		$selected_ans = array();
		$manual = false;
		if($exist){
		   
    	    $question = CpQuestion::whereRaw('id NOT IN (SELECT DISTINCT question_id FROM cp_answers WHERE user_id='.auth()->user()->id.' AND cp_id='.$exist->id.')')->first();
    	    if($question) {
    	        $all_questions = CpQuestion::get();
    	        $active_qstns = CpAnswer::where('user_id',auth()->user()->id)->where('cp_id',$exist->id)->groupBy('cp_id')->selectRaw('GROUP_CONCAT(DISTINCT question_id) as ids')->first();
    	        if($active_qstns){
    	            $active_qns = explode(",",$active_qstns->ids);
    	            if(in_array($step,$active_qns)){
    	                $question = CpQuestion::where('id',$step)->first();
    	                $selected_ansrs = CpAnswer::where('user_id',auth()->user()->id)->where('cp_id',$exist->id)->groupBy('cp_id')->selectRaw('GROUP_CONCAT(DISTINCT answer_id) as ids')->first();
    	                $selected_ans = explode(",",$selected_ansrs->ids);
    	                $manual = true;
    	            }
    	        }
    	        if($manual){
    	            $skills = CpSkill::whereRaw('(id NOT IN (SELECT DISTINCT answer_id FROM cp_answers WHERE user_id='.auth()->user()->id.' AND cp_id='.$exist->id.') AND type='.$question->type.') OR (id IN (SELECT DISTINCT answer_id FROM cp_answers WHERE user_id='.auth()->user()->id.' AND cp_id='.$exist->id.' AND question_id ='.$question->id.') AND type='.$question->type.')')->where(function($q){
    	                $q->where('added_by','0')->orWhere('added_by',auth()->user()->id);
    	           })->get();
    	        } else {
    	            $skills = CpSkill::whereRaw('id NOT IN (SELECT DISTINCT answer_id FROM cp_answers WHERE user_id='.auth()->user()->id.' AND cp_id='.$exist->id.') AND type='.$question->type)->where(function($q){
    	                $q->where('added_by','0')->orWhere('added_by',auth()->user()->id);
    	           })->get();
    	        }
    	        
    	    } else {
    	        $final_result = $exist->result;
    	        if($final_result==""){
                    $chatquestion = "My name is ".$exist->name." and my educational qualification is ".$exist->gradedata->name;
                    
                    $askedquestions = CpQuestion::where(function($q) use($exist){
                        $q->where('grade',0)->orWhere('grade',$exist->grade);
                    })->get();
                    foreach($askedquestions as $askQn){
                        $chatquestion .= ". ".$askQn->ask." ";
                        $toldans = "";
                        
                        $ansCp = CpAnswer::where('cp_id',$exist->id)->where('user_id',auth()->user()->id)->where('question_id',$askQn->id)->with('skilldata')->get();
                        foreach($ansCp as $ansQn){
                            if($toldans!=""){
                                $toldans = $toldans.", ";
                            }
                            $toldans = $toldans.$ansQn->skilldata->name;
                        }
                        $chatquestion .= $toldans;
                    }
                    
                    $chatquestion .= ". Based on the given data about my work values and skills, suggest top 3 career paths that I can pursue. Also tell me how to go about acquiring the work values and skills that I wish I had.";
                    
                    
                    $header = array(
            		    'Content-Type: application/json',
            		    'Authorization: Bearer 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'
            		);
                    $postParameter = array(
                        'messages'=>array(array("role"=>"user", "content"=>$chatquestion)),
                        'model' => "gpt-3.5-turbo"
                    );
                    
                    $curlHandle = curl_init('https://api.openai.com/v1/chat/completions');  //https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
                    curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
                    curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
                    curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
            
                    $response = curl_exec($curlHandle);
                  	$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
                    curl_close($curlHandle);
                     
                    $output = json_decode($response,true);
                    $final_result = $output['choices'][0]['message']['content'];
                     
        	        $exist->result = $final_result;
        	        $exist->status = 1;
        	        $exist->save();
    	        }
    	    }
		} else {
		    $prev = CareerPlanning::where('status','1')->where('user_id',auth()->user()->id)->get();
		}
		return view('career_planning',compact('exist','question','skills','final_result','prev','all_questions','active_qns','selected_ans'));
	}   
	
	public function career_planning_history($id){
	    $exist = CareerPlanning::where('status','1')->where('user_id',auth()->user()->id)->where('id',$id)->with('gradedata','answers')->first();
	    
	    return view('career_planning_history',compact('exist'));
	}
	public function save_answer(Request $request){
		$exist = CareerPlanning::where('status','0')->where('user_id',auth()->user()->id)->first();
		if($exist){
    		$answers = $request->answers;
    		CpAnswer::where('question_id',$request->question_id)->delete();
    		foreach($answers as $key => $answer){
    		    $cp = new CpAnswer();
        	    $cp->user_id = auth()->user()->id;
        	    $cp->question_id = $request->question_id;
        	    $cp->answer_id = $answer;
        	    $cp->cp_id = $exist->id;
        	    $cp->save();
    		}
    		if(isset($request->extra_skills) && $request->extra_skills!=""){
    		    $question = CpQuestion::where('id',$request->question_id)->first();
    		    $extras = explode(',',$request->extra_skills);
    		    for($i=0;$i<count($extras);$i++) {
    		        $skill = CpSkill::where('name',trim($extras[$i]))->where('type',$question->type)->first();
    		        if($skill){
    		            $cp = new CpAnswer();
                	    $cp->user_id = auth()->user()->id;
                	    $cp->question_id = $request->question_id;
                	    $cp->answer_id = $skill->id;
                	    $cp->cp_id = $exist->id;
                	    $cp->save();
    		        } else {
    		            $nsk = new CpSkill();
    		            $nsk->name = trim($extras[$i]);
    		            $nsk->description = '';
    		            $nsk->type = $question->type;
    		            $nsk->grade = 0;
    		            $nsk->added_by= auth()->user()->id;
    		            $nsk->save();
    		            
    		            $cp = new CpAnswer();
                	    $cp->user_id = auth()->user()->id;
                	    $cp->question_id = $request->question_id;
                	    $cp->answer_id = $nsk->id;
                	    $cp->cp_id = $exist->id;
                	    $cp->save();
    		            
    		        }
    		    }
    		}
		    return redirect('career_planning/'.$cp->question_id+1);
		} else {
		    $cp = new CareerPlanning();
    	    $cp->user_id = auth()->user()->id;
    	    $cp->name = $request->name;
    	    $cp->grade = $request->grade;
    	    $cp->save();
		    return redirect('career_planning');
		}
	} 
}
