<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\FileList;
use App\Models\Log;
use App\Models\WordLog;
use App\Models\UserPackage;
use App\Models\UserQuestion;
use App\Models\Genie;
use App\Models\AllowedFolder;
use App\Models\Package;

use App\Models\ChatMember;
use App\Models\ChatGroupAllAnswer;
use App\Models\CustomToggle;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Exception;
use DB;
use Mail;
use Hash;
use File;
use Response;
use Storage;
use Session;
use App\Http\Controllers\PDF2TextController;
use Webklex\PDFMerger\Facades\PDFMergerFacade as PDFMerger;

use Spatie\PdfToImage\Pdf;

//use Spatie\PdfToText\Pdf;
use Smalot\PdfParser\Parser;

use Ilovepdf\Ilovepdf;

use Illuminate\Support\Str;

use App\Models\HomeChat;

class FileListController extends Controller
{
    /**
     * User login API method
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
    */
    
	//useful
    public function chat($id,$embedded=false){
        
	    if(auth()->user() && auth()->user()->level!="1"){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return redirect('pricings')->withWarning('Please choose a plan to continue');
            }
	    }
	    $userquestions = [];
		$files = FileList::where('txt_file',$id)->where('embed',1)->first();
		if($files && $files->file_level!="2"){
		    if(!auth()->user()){
		        //abort(404);
		    }
		    if(auth()->user() && auth()->user()->level=="2"){
		        //abort(404);
		    }
		}
        
      	$parent = $files->parent;
		$whole_text = "";
		$pdfs = array();
		$folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($files->user_id,'ilife-genie'));
		$whole_text = $files->txt_file;
      	$type = $files->type;
		if($files->type=="D"){
			$id = $files->id;
			$nfiles = FileList::where('parent',$id)->where('type','F')->get();
			$path = '/files/pdf-files/'.$folder1.'/'.$id;
			foreach($nfiles as $nfile){ 
			  //if(!file_exists(public_path($path.'/'.$nfile->filename))){
			  //    $path = '/files/pdf-files/'.$folder1.'/2611';
			  //}
              //$filepdf = fopen(public_path().$path.'/'.$nfile->filename,"r");
			  //if ($filepdf) {
				$pdfs[] = url('/').$path.'/'.$nfile->filename;
                //fclose($filepdf);
              //}
			}
			$txt_file = $files->txt_file;
		} else {
			$path = '/files/pdf-files/'.$folder1;
			if($files->parent!=0){
				$path = $path."/".$files->parent;
			}
			$pdfs[] = url('/').$path.'/'.$files->filename;
		}
        $response = '';
        $groups = [];
        $custom_toggles = [];
        if(auth()->user()){
            $groups = ChatMember::where('user_id',auth()->user()->id)->with('group')->get();
            $custom_toggles = CustomToggle::where('user_id',auth()->user()->id)->get();
            $userquestions = UserQuestion::where('user_id',auth()->user()->id)->where('file_id',$files->txt_file)->orderBy('created_at','DESC')->limit(3)->get();
            $userquestions = $userquestions->reverse();
            // $chathistory = array();
            // $i=0;
            // foreach($userquestions as $uqns){
            //   $chathistory[$i]['id'] = $uqns->id;
            //   $chathistory[$i]['question'] = $uqns->question;
            //   $chathistory[$i]['liked'] = $uqns->liked;
            //   $chathistory[$i]['saved'] = $uqns->saved;
            //   $answer = $uqns->answer;
            //   $answer = str_replace('<md-block>','',$answer);
            //   $answer = str_replace('</md-block>','',$answer);
            //   $chathistory[$i]['answer'] = '<md-block>'.Str::markdown($answer).'</md-block>';
            //   $i++; 
            // }
            
        }
        
		return view('chat',compact('pdfs','whole_text','parent','embedded','type','folder1','id','files','groups','custom_toggles','userquestions'));
	}   
	public function view_pdf_file($id){
	    $files = FileList::where('txt_file',$id)->first();
	    if($files){
	        $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($files->user_id,'ilife-genie'));
	        $path = '/files/pdf-files/'.$folder1;
			if($files->parent!=0){
				$path = $path."/".$files->parent;
			}
	        
	        $pdf = url('/').$path.'/'.$files->filename;
	        return view('view_file',compact('pdf'));
	    } else {
	        abort(404);
	    }
	    
	    
	}
	public function load_chat_history(Request $request){
	    $last_id = $request->last_id;
	    $id = $request->file_id;
	    if($last_id>0){
	        $userquestions = UserQuestion::where('user_id',auth()->user()->id)->where('file_id',$id)->where('id','<',$last_id)->orderBy('created_at','DESC')->limit(3)->get();
	    } else {
	        $userquestions = UserQuestion::where('user_id',auth()->user()->id)->where('file_id',$id)->orderBy('created_at','DESC')->limit(3)->get();
	    }
        $userquestions = $userquestions->reverse();
        $ans = array();
        $i=0;
        foreach($userquestions as $qns){
            $ans[$i]['question'] = $qns->question;
            $ans[$i]['answer'] = $html = Str::markdown($qns->answer);
            $i++;
        }
        $result = json_encode($ans);
	    return response()->json(['status' => 'success', 'result' => $result]);
	}
	public function convert_markdown(Request $request){
	    return Str::markdown($request->answer);
	}
	public function create_law_chat(Request $request){
	    $id = 499;
	    $files = FileList::where('file_level',3)->where('generate',2)->where('type','F')->get();
	    $store_name = "20240125060648ilR8y2ircCZjMQun_all";
	    
	    foreach($files as $kid){
	        $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($kid->user_id,'ilife-genie'));
	        $path = '/files/pdf-files/'.$folder1.'/'.$kid->parent;
		    $pdfs[] = $path.'/'.$kid->filename;
		    $pknames[] = $kid->txt_file;
		}
		$postParameter = array(
            'filepath' => $path,
            'store_name' => $store_name,
            'type' => "D",
            'summary' => 'yes',
            'questions' => 'yes',
            'pdfs' => json_encode($pdfs),
            'pknames' => json_encode($pknames),
            'project' => 'genieweb'
        );
        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/chatfolder');
        curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
		curl_close($curlHandle); 
		return $response;
	}
	public function create_chat(Request $request){
		$id = $request->id;
		$files = FileList::where('id',$id)->first();
      	$parent = $files->parent;
		$whole_text = "";
		
		$pdfs = array();
		$pknames = array();
		$folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($files->user_id,'ilife-genie'));
		$whole_text = $files->txt_file;
      	$type = $files->type;
		if($files->type=="D"){
			$path = '/files/pdf-files/'.$folder1.'/'.$id;
			$pknames = array();
			$pdfs = array();
			$kids = FileList::where('parent',$id)->where('generate','!=','3')->where('type','F')->get();
			foreach($kids as $kid){
			    $pdfs[] = $path.'/'.$kid->filename;
			    $pknames[] = $kid->txt_file;
			}
			
            $postParameter = array(
                'filepath' => $path,
                'store_name' => $whole_text,
                'type' => $type,
                'summary' => 'yes',
                'questions' => 'yes',
                'pdfs' => json_encode($pdfs),
                'pknames' => json_encode($pknames),
                'project' => 'genieweb'
            );
		} else {
			$path = '/files/pdf-files/'.$folder1;
			if($files->parent!=0){
				$path = $path."/".$files->parent;
			}
			$path = $path.'/'.$files->filename;
			
            $postParameter = array(
                'filepath' => $path,
                'store_name' => $whole_text,
                'type' => $type,
                'summary' => 'yes',
                'questions' => 'yes',
                'project' => 'genieweb'
            );
		}
          
		if(auth()->user()->id=="3"){
		    if($files->type=="D"){
		        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/chatfolder');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
		    } else {
		        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/chatfile');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
		    }
    		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
    		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
    		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
    
    		$response = curl_exec($curlHandle);
    		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
    		curl_close($curlHandle); 
    		//print_r($postParameter);
    		//echo $response; exit();
		} else {
    		if($files->type=="D"){
		        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/chatfolder');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
		    } else {
		        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/chatfile');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
		    }
    		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
    		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
    		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
    
    		$response = curl_exec($curlHandle);
    		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
    		curl_close($curlHandle); 
		}
		
		$log = new Log();
		$log->log = "Create chat of file/folder id-".$id;
		$log->user_id = Auth::user()?Auth::user()->id:0;
		$log->save();
		if(trim($httpcode)!="200"){
			//self::create_chat($request);
			return response()->json(['status' => 'failed', 'result' => 'Something went wrong. Please try again.']);
		} elseif($response!="") {
			$respArr =  explode('-eeddjustinddee-',$response);
			if(trim($respArr[0])!="I don't know." && trim($respArr[0])!=""){
				$files->summary = nl2br($respArr[0]);
			}
			if(trim($respArr[1])!="I don't know." && trim($respArr[1])!=""){
				$files->sample_questions = nl2br($respArr[1]);
			}
			$files->embed = 1;
			$files->save();
			
		}
      	return response()->json(['status' => 'success', 'result' => 'Chat Generated Successfully']);
	} 
	
	public function merge_pdfs($postParameter){
	    $postParameter['project'] = "genieweb";
	    $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/mergeall');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
		curl_close($curlHandle); 
		return $response;
	}
	
	public function admin_questions_count($store_name){
	    $file = FileList::where('txt_file',$store_name)->with('user')->first();
	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();    
      	if($mypackage){
      	    $question_limit = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->sum('question_limit');
      	} else {
      	    $question_limit = 100;
      	}
      	/*
	    if($file && $file->user){
	        if($file->user->level=="1"){
	            return false;
	        }
	        if($file->user->parent>0){
	            //$qcount = DB::table('user_questions')->whereRaw('file_id IN (SELECT txt_file FROM file_lists WHERE user_id IN (SELECT id FROM users WHERE parent="'.$file->user->parent.'"))')->count();
	            //UserQuestion::
	            
	        } else {
	            $qcount = DB::table('user_questions')->whereRaw('file_id IN (SELECT txt_file FROM file_lists WHERE user_id="'.$file->user->id.'")')->count();
	            //UserQuestion::
	        }
	        
	    }
	    */
	    
        if(auth()->user()->parent>0){
	        $qcount = UserQuestion::whereRaw('user_id IN (SELECT id FROM users WHERE parent="'.auth()->user()->parent.'")')->count();
	    } else {
	        $qcount = UserQuestion::where('user_id',auth()->user()->id)->count();
	    }
	    if(auth()->user()->level=="1"){
	       return false;
	    }
      	if($qcount>$question_limit){
      	    return true;
      	} else {
      	    return false;
      	}
	}
	
    public function ask(Request $request){      
      	$query = $request->question;//.". Format everything in markdown.";  
      	$store_name = $request->store_name;
      	$wholelaw = $request->wholelaw;
      	//
      	$qlimit = false;
      	if(auth()->user()){
          	$qlimit = $this->admin_questions_count($store_name); 
          	if($qlimit){
          	    return "The i-Life Genie question limit exceeds. Please upgrade";
          	    exit;
          	}
      	}
      	//$file = FileList::where('txt_file',$store_name)->first();
      	//$user = User::where('id',$file->user_id)->first();
      	$update_word_count = false;
      	if(auth()->user() && auth()->user()->chat_model=="2"){
      	    $model = "gpt-4o";
      	    $update_word_count = true;
      	    $date = date('m-Y');
            $words = WordLog::where('user_id',auth()->user()->id)->where('month',$date)->first();
            if($words && $words->total_count>=500000){
                $model = "gpt-4o";
                $update_word_count = false;
            }
      	} else {
      	    $model = "gpt-4o";
      	    
      	}
      	//if(auth()->user() && auth()->user()->id=="22"){
      	    //echo $model;
      	//} 
        $postParameter = array(
            'store_name' => $store_name.($wholelaw=="yes"?"_all":""),
            'query' => $query,
            'model' => $model
        );
        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/ask');  //https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
        curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
        curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($curlHandle);
      	$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
        curl_close($curlHandle);
      	$log = new Log();
		$log->log = "Asked question -".$request->question." to txt_file - ".$store_name;
		$log->user_id = Auth::user()?Auth::user()->id:0;
		$log->save();
      	if(trim($httpcode)!="200"){
          //self::ask($request);
          return "i-Life Genie wasn't able to find reliable information for your question. You could try again";
        } else {
          if(trim($response)=="I don't know." || trim($response)=="I'm sorry, I don't know." || trim($response)=="I do not know."){
            return "i-Life Genie wasn't able to find reliable information for your question. You could try rephrasing your question or ask a different question.";
          } else {
            if($update_word_count){
                if(auth()->user() && (auth()->user()->level=="3" || auth()->user()->level=="4" || auth()->user()->level=="5")){
                    
                    $total_words = str_word_count($query)+str_word_count($response);
                    $old_words = 0;
                    if($words){
                        $old_words = $words->total_count;
                    } else {
                       $words = new  WordLog();
                       $words->user_id = auth()->user()->id;
                       $words->month = $date;
                    }
                    $words->total_count = $old_words+$total_words;
                    $words->save();
                }
                
                
            }
            $qa_id = 0;
            
               $qa = new UserQuestion();
               $qa->user_id = auth()->user()?auth()->user()->id:0;
               $qa->file_id = $store_name;
               $qa->question = $request->question;
               $qa->answer = "<md-block>".($response)."</md-block>";
               $qa->save();
               $qa_id = $qa->id;
               
               if(auth()->user()){
                    $groups = ChatMember::where('user_id',auth()->user()->id)->with('group')->get();
                    foreach($groups as $mygrp){
                        if($mygrp->group){
                            if($mygrp->group->save_all=="1"){
                                $ans = new ChatGroupAllAnswer();
                                $ans->answer_id	= $qa_id;
                                $ans->user_id = auth()->user()->id;
                                $ans->group_id = $mygrp->group_id;
                                $ans->save();
                            }
                        }
                    }
               }
                
        
            //if(auth()->user() && auth()->user()->id=="3"){ 
            //    return "<md-block data-id='".$qa_id."'>".($response)."</md-block>";
            //}
          	return "<md-block data-id='".$qa_id."'>".($response)."</md-block>";
          }
        }
	}
	
	
  	public static function full_path($id, $path=""){
  	    $currsiteurl = $_SERVER['HTTP_HOST'];
  	    $avoid_path = array();
      	$fileData = FileList::where('id',$id)->first();
        if($currsiteurl=="app.edubuddy.ai"){
            $avoid_path = array(7226, 1020, 726);
            if($fileData->id==7226){
                $path = "<a href='".route('files',['parent'=>$fileData->id])."' class='breadcrumb_".$fileData->id."'><span class='glyphicon glyphicon-home'></span></a>";
            }
        }
      	if(auth()->user()->level==7 && ($fileData->id==726 || $fileData->id==1020)){
      	    $fileData = FileList::where('id',1379)->first();
      	    $path = "<a href='".route('files',['parent'=>$fileData->id])."' class='breadcrumb_".$fileData->id."'><span class='glyphicon glyphicon-home'></span></a>";
      	} else {
          	if($fileData->parent!="0"){
              if($path==""){
              	$path = $fileData->filename;
              	$path = self::full_path($fileData->parent, $path).' / '.$path;
              } else {
                  if(!in_array($fileData->id,$avoid_path)){
                    $path = "<a href='".route('files',['parent'=>$fileData->id])."' class='breadcrumb_".$fileData->id."'>".$fileData->filename."</a>";
                    $path = self::full_path($fileData->parent, $path).' / '.$path;
                  }
              }
              
            } else {
              $path = "<a href='".route('files')."' class='breadcrumb_".$fileData->id."'><span class='glyphicon glyphicon-home'></span></a>
              / <a href='".route('files',['parent'=>$fileData->id])."' class='breadcrumb_".$fileData->id."'>".$fileData->filename."</a>";
            }
  	    }
      	return $path;
    }
    public function index(Request $request, $parent=0) {
		
        $curlHandle = curl_init(config('app.api_url').'index');
	    
        $header = array(
		    'Content-Type: application/json'
		);
		//$cFile = curl_file_create(public_path('voices/'.$voicefile), $voicefile);
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $request);
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		curl_close($curlHandle);
		
		print_r($result);
		
		$status = $result['status'];
		$redirect = $result['redirect'];
	    $breadcrumb = $result['breadcrumb'];
        $show_new_folder = $result['show_new_folder'];
        $show_new_upload = $result['show_new_upload'];
		$parent = $result['parent'];
		$view = $result['view'];
		$warning = $result['warning'];
		
        if ($status=="failed") {
            Session::put('genie_token', '');
            return redirect('login');
        }
		if($warning!=""){
			return redirect($redirect)->withWarning('Please choose a plan to continue');
		}
		if($redirect!=""){
			return redirect($redirect);
	    }
		
        return view($view,compact('parent','breadcrumb','show_new_upload','show_new_folder'));
        
    }
    
    public function download_files($parent) {
        $files = FileList::where('user_id',auth()->user()->id)->where('parent',$parent)->orderBy('type')->get();
        foreach($files as $file){
            if($file->type=="F") {
                $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($file->user_id,'ilife-genie'));
    		    $path = '/files/pdf-files/'.$folder1;
    			if($file->parent!=0){
    				$path = $path."/".$file->parent;
    			}
    			$pdfsurl = public_path($path.'/'.$file->filename);
                $filename = $file->filename; // Name you want the downloaded file to have
                $file1 = $pdfsurl; // Path to the file you want to download
                
                // Set headers
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="' . $filename . '"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($file1));
                readfile($file1);
            }
        }
        exit;
    }
    public function download_file($id) {
        $file = FileList::where('id',$id)->first();
        $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($file->user_id,'ilife-genie'));
	    $path = '/files/pdf-files/'.$folder1;
		if($file->parent!=0){
			$path = $path."/".$file->parent;
		}
		$pdfsurl = public_path($path.'/'.$file->filename);
        $filename = $file->filename; // Name you want the downloaded file to have
        $file = $pdfsurl; // Path to the file you want to download
        
        // Set headers
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($file));
        
        // Read the file and output it to the browser
        readfile($file);
        // Alternatively, you can use file_get_contents() like this:
        // echo file_get_contents($file);
        exit;
    }
    
    public function file_list(Request $request) {
        $orderby = $request->orderby?$request->orderby:'filename';
        $sort = $request->sort?$request->sort:'ASC';
        
        if(auth()->user()->org_code!=""){
            $org_users =   User::where('org_code',auth()->user()->org_code)->pluck('id');
            $files = FileList::whereIn('user_id',$org_users)->with(['child'])->where('parent',$request->parent)->orderBy('type')->orderBy($orderby,$sort)->get();
        } else{
            $files = FileList::where('user_id',auth()->user()->id)->with(['child'])->where('parent',$request->parent)->orderBy('type')->orderBy($orderby,$sort)->get();
        }
        $output = "";
		if($files){
			$output = "";
			$download_btns_id = "";
			$download_btn_id = 0;
            $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt(Auth::user()->id,'ilife-genie'));
            $fileids = "";
			foreach($files as $file){
			    
                $fileids = $fileids.$file->id.",";
        		$path = '/files/pdf-files/'.$folder1;
        		if($file->parent!=0){
        			$path = $path."/".$file->parent;
        		}
        		$totalPages = 0;
            	$path = $path.'/'.$file->filename;
        		if($file->type=="F" && file_exists(public_path($path)) && $file->page_nos=="0"){
            		$pdf = file_get_contents(public_path($path)); 
                    $totalPages = preg_match_all("/\/Page\W/", $pdf, $dummy);
                    
                    $fileData = FileList::where('id',$file->id)->first();
                    $fileData->page_nos = $totalPages;
                    $fileData->save();
        		} else {
        		    $totalPages = $file->page_nos;
        		}
				$output .= "<tr>";
				$output .= "<td class='text_".$file->type."'>";
                if($file->type=="D"){
                	$output .= "<a href='".route('files',['parent'=>$file->id])."'>
                    <span class='glyphicon glyphicon-folder-open'></span>&nbsp;&nbsp;".$file->filename."</a>";
                } else {
                  $output .= "<span class='glyphicon glyphicon-book'></span>&nbsp;&nbsp;".$file->filename."&nbsp;<span class='text-secondary text-sm'>(".$totalPages." pages)</span>";
                }
                // if(!file_exists(public_path($path)) && auth()->user()->id=="3"){
                //     $output .= public_path($path);
                // }
                if($file->generate=="3"){
                    //$filesize = filesize(public_path($path));
                    //if($filesize==0){
                    //    $output .= "<br><span class='text-danger text-sm'>Something went wrong. Please remove the file and upload again.</span>";
                    //} else {
                        $output .= "<br><span class='text-danger text-sm'>Something went wrong. Try processing again.</span>&nbsp;<a onclick='generate_pickle(".$file->id.");'>Process again</a>";
                    //}
                }
                $output .= "</td>";
                
				$output .= "<td class='hide_td datetime'>".date('j M Y g:i a',strtotime($file->created_at))."</td>";
				
                
				$output .= "<td class='file_actions'>";
				
				$output .= "<span class='hide_generate_loader hide_generate_loader".$file->id."'>";
              	if($file->type=="D"){
                  if($file->child){
					if($file->embed=="0"){
						$ask_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"ask\",\"".$file->txt_file."\")'";
						$embed_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"embed\",\"".$file->txt_file."\")'";
					} else {
						$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
						$embed_onclick = "onclick='show_code(\"".route('chat',['id'=>$file->txt_file,'embedded'=>1])."\")'";
						$output .= "<a class='btn a_btn genie_btn show_code' title='Regenerate Chat' onclick='generate_chat(".$file->id.",\"".$file->type."\")'><i class='glyphicon glyphicon-refresh'></i> </a>&nbsp;&nbsp;";
					}	
					$output .= "<a class='btn s_btn genie_btn' target='_blank' ".$ask_onclick.">Ask</a>
					&nbsp;&nbsp;";
					
					
					
					$output .= '<div class="dropdown extra_file_btns">
                      <button class="btn p_btn dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        ...
                      </button>
                      <div class="dropdown-menu dropdown_file_btns" aria-labelledby="dropdownMenuButton">';
                        
                      
					
					
					
					$output .= "<a class='dropdown-item show_code'  ".$embed_onclick.">Embed &lt;/&gt; </a>";
					
					if(auth()->user()->id=="4"){
					    
					    $url = route('download_files',['parent'=>$file->id]);
					    
					    $output .= "<a class='dropdown-item' href='".$url."' target='_blank'><i class='glyphicon glyphicon-download'></i> </a>";
					}
					$output .= '</div>
                    </div>&nbsp;&nbsp;';
					
                  }
            	} elseif($file->generate=="2") {
					if($file->embed=="0"){
						$ask_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"ask\",\"".$file->txt_file."\")'";
						$embed_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"embed\",\"".$file->txt_file."\")'";
					} else {
						$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
						$embed_onclick = "onclick='show_code(\"".route('chat',['id'=>$file->txt_file,'embedded'=>1])."\")'";
					}
				    $output .= "<a class='btn s_btn genie_btn' ".$ask_onclick.">Ask</a>
					&nbsp;&nbsp;";
					$output .= '<div class="dropdown extra_file_btns">
                      <button class="btn p_btn dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        ...
                      </button>
                      <div class="dropdown-menu dropdown_file_btns" aria-labelledby="dropdownMenuButton">';
                        
					$output .= "<a class='dropdown-item show_code'  ".$embed_onclick.">Embed &lt;/&gt; </a>";
					if(auth()->user()->id=="4"){
					    
					    $url = route('download_file',['id'=>$file->id]);
					    if($download_btns_id!=""){
					       $download_btns_id = $download_btns_id.",";
					    }
					    $download_btns_id = $download_btns_id.$url;
					    $output .= "<a id='download_btn".$download_btn_id."' class='dropdown-item' href='".$url."'><i class='glyphicon glyphicon-download'></i> </a>";
					    $download_btn_id = $download_btn_id+1;
					}
					
                      $output .= '</div>
                    </div>&nbsp;&nbsp;';
                }
                $output .= "</span>";
                $show_processing = "style='display:none;' data-id='0'";
                if($file->generate=="1"){
				    $show_processing = "data-id='".$file->id."'";
				}
                $output .= "<span ".$show_processing." data-type='".$file->type."' class='show_generate_loader show_generate_loader".$file->id."'><img src='".url('/images/loader.gif')."' height='25px'>&nbsp;Processing...&nbsp;&nbsp;</span>";
				
				
				$output .= "<a class='btn d_btn genie_btn' onclick='delete_file(".$file->id.");'>&nbsp;<span class='icon_only_btn glyphicon glyphicon-trash'></span>&nbsp;</a></td>";
				
                $output .= "</tr>";
			}
			
			
			if(auth()->user()->id=="4" && $download_btns_id!=""){ 
			    $output .= "<tr><td><a data-ids='".$download_btns_id."' class='btn p_btn download_all' onclick='download_all();'><i class='glyphicon glyphicon-download'></i> </a>
			    &nbsp;&nbsp;</td></tr>";
			    
				$output .= '<p class="d-none">'.$fileids.'</p>';
			}
		}
		echo $output==""?"<tr><td colspan='2'>No FIles</td></tr>":$output;
    }
	
  	public function add_folder(Request $request){
  	    $validator = Validator::make($request->all(), [
			'filename'     => 'required',
		]);
		
		if ($validator->fails()) return response($validator->messages(), 200);
		
		$request->parent = isset($request->parent)?$request->parent:0;
		$folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt(Auth::user()->id,'ilife-genie'));
		$path = public_path().'/files/pdf-files/'.$folder1;
		if(!File::exists($path)) {
			File::makeDirectory($path, $mode = 0777, true, true);
		}
		
		$file_level = 2;
		if($request->parent!=0){
			$parentFolder = FileList::where('id',$request->parent)->first();
			$file_level = $parentFolder->file_level;
		}
		if(Auth::user()->level>2){
		    $file_level = Auth::user()->level;
		    if(Auth::user()->level==5){
		        $file_level = 4;
		    }
		}
		$file = FileList::where('user_id',Auth::user()->id)->where('parent',$request->parent)->where('filename',$request->filename)->first();
  	
  	    if(!$file) {
			$file = new FileList();
			$file->filename = $request->filename;
			$file->txt_file = '';
			$file->type = "D";
			$file->user_id = Auth::user()->id;
			$file->parent = $request->parent;
            $file->file_level = $file_level;
			$file->save();
          
          	$log = new Log();
            $log->log = "Added folder -".$request->filename." - ID:".$file->id;
            $log->user_id = Auth::user()?Auth::user()->id:0;
            $log->save();
          
		}
		$randStr = substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"),-3);
		$txt_file = date('YmdHis').preg_replace('/[^A-Za-z0-9]/', 'D', crypt($file->id,'ilife-genie')).$randStr;
		$file->txt_file = $txt_file;
		$file->save();
		return response()->json(['status' => 'success', 'result' => 'Folder Created SuccessFully']);
  	}
  	public function add_file(Request $request){
		for($i=0;$i<$request->files_count;$i++){
          $validator = Validator::make($request->all(), [
              'filename_'.$i     => 'required',
              'filename_'.$i.'.*' => 'mimes:pdf,docx'
          ]);
          if ($validator->fails()) return response($validator->messages(), 200);
        }
        
        $mypackage = UserPackage::where('user_id',Auth::user()->id)->where('end_date','>=',date("Y-m-d"))->orderBy('end_date','desc')->first();
        if($mypackage){
            if(date('Y-m-d')>=date('Y-m-d',strtotime($mypackage->start_date)) && date('Y-m-d')<=date('Y-m-d',strtotime($mypackage->end_date))){
                $maxpages = $mypackage->page_limit;
            } else {
                $maxpages = 100; 
            }
        } else {
            $maxpages = 100;
        }
        
		$uploaded_ids = '';
		$request->parent = isset($request->parent)?$request->parent:0;
		
    	$folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt(Auth::user()->id,'ilife-genie'));
		
    	$path = public_path().'/files/pdf-files/'.$folder1;
    	
    	//if(Auth::user()->id==3){
		    
    	//}
		if(!File::exists($path)) {
			File::makeDirectory($path, $mode = 0777, true, true);
		}
		$file_level = 2;
		if($request->parent!=0){
			$path = $path."/".$request->parent;
			$folder1 = $folder1."/".$request->parent;
			if(!File::exists($path)) {
				File::makeDirectory($path, $mode = 0777, true, true);
			}
			$parentFolder = FileList::where('id',$request->parent)->first();
			$file_level = $parentFolder->file_level;
		}
		

		
		
		if(Auth::user()->level>2){
		    $file_level = Auth::user()->level;
		    if(Auth::user()->level==5){
		        $file_level = 4;
		    }
		}
		$resultmsg = 'Uploaded, Processing...';
    	for($i=0;$i<$request->files_count;$i++){
    	      $mypages = FileList::where('user_id',Auth::user()->id)->where('type','F')->sum('page_nos');
    	      
              $pdfile = $request->file('filename_'.$i);
              $pdffile = $pdfile->getClientOriginalName();
              
              $file_ext = explode('.',$pdffile);
              $extension = strtoupper(end($file_ext));
              $allowed_exts = array('DOC', 'DOCX', 'PPT', 'PPTX', 'XLS', 'XLSX', 'ODT', 'ODP', 'ODS');
              if(in_array($extension,$allowed_exts)){
                  $doc_filename = rand(100,999).date('YmdHis').auth()->user()->id.rand(1000,9999).".docx";
                  $pdfile->move(public_path('other-files/'), $doc_filename);
                  
                  $doc_file_path = public_path('other-files/'.$doc_filename);
                  
                  $pdf_filename = substr($pdffile, 0, -5).".pdf";
                  $pdf_file_path = public_path('files/pdf-files/'.$folder1.'/'.$pdf_filename);
                  
                  $doc_file2 = 'public/other-files/'.$doc_filename;
                  $pdf_file2 = 'public/files/pdf-files/'.$folder1.'/'.$pdf_filename;
                  $pdf_file3 = 'files/pdf-files/'.$folder1.'/'.$pdf_filename;
                  
                try { 
                    $ilovepdf = new Ilovepdf('project_public_8d43a6f826b46e30edc4a15016c9d2df_AbEHWdd3e0e1456c64a865698adef2d9eab43','secret_key_ad61cc9ca86185823a73bb2221905681_ITAFwfccf722a6d9f42680408805f66a6d967');
                    $myTask = $ilovepdf->newTask('officepdf');
                    $file1 = $myTask->addFile(public_path('other-files/'.$doc_filename));
                    $myTask->setOutputFilename($pdf_file3);
                    $myTask->execute();
                    $myTask->download('files/pdf-files/'.$folder1);
                  
                } catch (\Ilovepdf\Exceptions\StartException $e) {
                    $resultmsg = "An error occured on start: " . $e->getMessage() . " ";
                    // Authentication errors
                } catch (\Ilovepdf\Exceptions\AuthException $e) {
                    $resultmsg = "An error occured on auth: " . $e->getMessage() . " ";
                    //echo implode(', ', $e->getErrors());
                    // Uploading files errors
                } catch (\Ilovepdf\Exceptions\UploadException $e) {
                    $resultmsg = "An error occured on upload: " . $e->getMessage() . " ";
                    //echo implode(', ', $e->getErrors());
                    // Processing files errors
                } catch (\Ilovepdf\Exceptions\ProcessException $e) {
                    $resultmsg = "An error occured on process - " . $e->getMessage() . " ";
                    //echo implode(', ', $e->getErrors());
                    // Downloading files errors
                } catch (\Ilovepdf\Exceptions\DownloadException $e) {
                    $resultmsg = "An error occured on process : " . $e->getMessage() . " ";
                    //echo implode(', ', $e->getErrors());
                    // Other errors (as connexion errors and other)
                } catch (\Exception $e) {
                    
                    try {
                        $ilovepdf = new Ilovepdf('project_public_8d43a6f826b46e30edc4a15016c9d2df_AbEHWdd3e0e1456c64a865698adef2d9eab43','secret_key_ad61cc9ca86185823a73bb2221905681_ITAFwfccf722a6d9f42680408805f66a6d967');
                        $myTask = $ilovepdf->newTask('officepdf');
                        $file1 = $myTask->addFile(public_path('other-files/'.$doc_filename));
                        $myTask->setOutputFilename($pdf_file3);
                        $myTask->execute();
                        $myTask->download('files/pdf-files/'.$folder1);
                    } catch (\Exception $e) {
                        $resultmsg = "An error occurred- " . $e->getMessage();
                    }
                }
                  
            //       $postParameter = array(
            //             'doc_file' => $doc_file2,
            //             'pdf_file' => $pdf_file2,
            //             'project' => 'genieweb'
            //         );
            //         $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/convert_file');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
            	    
            // 		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
            // 		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
            // 		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
            
            // 		$response = curl_exec($curlHandle);
            // 		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
            // 		curl_close($curlHandle);
            		
            		if(file_exists($pdf_file_path)){
            		    $pdf = file_get_contents($pdf_file_path);
            		    $number = preg_match_all("/\/Page\W/", $pdf, $dummy);
                          if($number>1000){
                              $resultmsg = 'Max page limit: 1000';
                              continue;
                          }
                          if(Auth::user()->level==2 && ($mypages+$number)>$maxpages){
                              $resultmsg = 'Your subscription plan page limit exceeds';
                              continue;
                          }
                          
                          $pdfFilePath = public_path('files/pdf-files/'.$folder1).'/'.$pdf_filename;
                          
                          $file = FileList::where('user_id',Auth::user()->id)->where('parent',$request->parent)->where('filename',$pdf_filename)->first();
            
                          $totalPages = 0;
                          if(file_exists($pdfFilePath)){
                            $pdf = file_get_contents($pdfFilePath); 
                            $totalPages = preg_match_all("/\/Page\W/", $pdf, $dummy);
                          }
                    		
                          $newfile = false;
                          if(!$file) {
                              $file = new FileList();
                              $file->filename = $pdf_filename;
                              $file->txt_file = '';
                              $file->type = "F";
                              $file->user_id = Auth::user()->id;
                              $file->parent = $request->parent;
                              $file->file_level = $file_level;
                              $file->trial = ($request->trial&&$request->trial==1)?1:0;
                              $file->generate = 1;
                              $file->page_nos = $totalPages;
                              $file->save();
                              $newfile= true;
                              
                              $log = new Log();
                              $log->log = "Added File -".$pdffile." - ID:".$file->id;
                              $log->user_id = Auth::user()?Auth::user()->id:0;
                              $log->save();
                              
                          }
                          $randStr = substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"),-3);
                          $txt_file = date('YmdHis').preg_replace('/[^A-Za-z0-9]/', 'F', crypt($file->id,'ilife-genie')).$randStr;
                          if($uploaded_ids!=""){
                              $uploaded_ids = $uploaded_ids.",";
                          }
                          $uploaded_ids = $uploaded_ids.$file->id;
                          if($newfile) {
                              $file->txt_file = $txt_file;
                              $file->save();
                          }
            		}
                  
              } else {
                  
                  $pdf = file_get_contents($pdfile);
                  
                  $number = preg_match_all("/\/Page\W/", $pdf, $dummy);
                  if($number>1000){
                      $resultmsg = 'Max page limit: 1000';
                      continue;
                  }
                  if(Auth::user()->level==2 && ($mypages+$number)>$maxpages){
                      $resultmsg = 'Your subscription plan page limit exceeds';
                      continue;
                  }
                  
                  $pdfFilePath = public_path('files/pdf-files/'.$folder1).'/'.$pdffile;
                  
                  $file = FileList::where('user_id',Auth::user()->id)->where('parent',$request->parent)->where('filename',$pdffile)->first();
                  
                  $move = $pdfile->move(public_path('files/pdf-files/'.$folder1), $pdffile);
                  
                  $totalPages = 0;
                  if(file_exists($pdfFilePath)){
                    $pdf = file_get_contents($pdfFilePath); 
                    $totalPages = preg_match_all("/\/Page\W/", $pdf, $dummy);
                    
                	  if(Auth::user()->id=="3"){
                          $resultmsg .=   'filepath = '.url('files/pdf-files/'.$folder1).'/'.$pdffile; 
                      }	 
                    
                  }
            	  
                  $newfile = false;
                  if(!$file) {
                      $file = new FileList();
                      $file->filename = $pdffile;
                      $file->txt_file = '';
                      $file->type = "F";
                      $file->user_id = Auth::user()->id;
                      $file->parent = $request->parent;
                      $file->file_level = $file_level;
                      $file->trial = ($request->trial&&$request->trial==1)?1:0;
                      $file->generate = 1;
                      $file->page_nos = $totalPages;
                      $file->save();
                      $newfile= true;
                      
                      $log = new Log();
                      $log->log = "Added File -".$pdffile." - ID:".$file->id;
                      $log->user_id = Auth::user()?Auth::user()->id:0;
                      $log->save();
                      
                  }
                  $randStr = substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"),-3);
                  $txt_file = date('YmdHis').preg_replace('/[^A-Za-z0-9]/', 'F', crypt($file->id,'ilife-genie')).$randStr;
                  if($uploaded_ids!=""){
                      $uploaded_ids = $uploaded_ids.",";
                  }
                  $uploaded_ids = $uploaded_ids.$file->id;
                  if($newfile) {
                      $file->txt_file = $txt_file;
                      $file->save();
                  }
              }
              
              
        
		}
        
		return response()->json(['status' => 'success', 'result' => $resultmsg, 'files'=>$uploaded_ids]);
    }
	
	public function generate_pickles_cron(){
	    $files_list = FileList::where('generate','1')->inRandomOrder()->get();
	    foreach($files_list as $files){
	        $parent = $files->parent;
    		$whole_text = "";
    		
    		$pdfs = array();
    		$pknames = array();
    		$folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($files->user_id,'ilife-genie'));
    		$whole_text = $files->txt_file;
          	
    		$path = '/files/pdf-files/'.$folder1;
    		if($files->parent!=0){
    			$path = $path."/".$files->parent;
    		}
    		$path = $path.'/'.$files->filename;
    		
            $postParameter = array(
                'filepath' => $path,
                'store_name' => $whole_text,
                'project' => 'genieweb'
            );
    		
            $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/newfile');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
    	    
    		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
    		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
    		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
    
    		$response = curl_exec($curlHandle);
    		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
    		curl_close($curlHandle); 
    		if($response=="success"){
    		    $files->generate = 2;
    		    $files->save();
    		} else {
    		    $files->generate = 3;
    		    $files->save();
    		}
	    }
	    echo "success";
	}
	public function generate_pickle(Request $request){
		$id = $request->id;
		$files = FileList::where('id',$id)->first();
		$files->generate = 1;
		$files->save();
      	$parent = $files->parent;
		$whole_text = "";
		
		$pdfs = array();
		$pknames = array();
		$folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($files->user_id,'ilife-genie'));
		$whole_text = $files->txt_file;
      	
		$path = 'files/pdf-files/'.$folder1;
		if($files->parent!=0){
			$path = $path."/".$files->parent;
		}
		$path = $path.'/'.$files->filename;
		
        $postParameter = array(
            'filepath' => $path,
            'store_name' => $whole_text,
            'project' => 'genieweb'
        );
		if(auth()->user()->id=="3"){
		    

		    
		    if(File::exists(public_path($path))) {
		        $response = $path;
		    } else {
		        $response =  "file not exist";
		    }
		    //return response()->json(['status' => 'success', 'result' => $response]);
		}
        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/newfile');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
	    
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
		curl_close($curlHandle); 
		
		//if(auth()->user()->id=="3"){
		//    return $response;
		//}
		
		if($response=="success"){
		    $files->generate = 2;
		    $files->save();
		} else {
		    $response = "Invalid file format or a PDF with only scanned pages detected. Please upload a PDF with text content.";
		    $files->generate = 3;
		    $files->save();
		}
		return response()->json(['status' => 'success', 'result' => $response]);
	}
	public function delete_children($id){
	    $files = FileList::where('user_id',Auth::user()->id)->where('parent',$id)->get();
        foreach($files as $file){
            if($file->type=="D"){
                $this->delete_children($file->id);
                
                $picklefile = public_path('../../../genie-app/files/'.$file->txt_file.'.pk1');
                if(File::exists($picklefile)) {
                    unlink($picklefile);
                }
                FileList::where('user_id',Auth::user()->id)->where('id',$file->id)->delete();
            } else {
                $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt(Auth::user()->id,'ilife-genie'));
              	if($file->parent!=0){
                  $folder1 = $folder1."/".$file->parent;
                }
              	$pdf = public_path('files/pdf-files/'.$folder1).'/'.$file->filename;
              	$txt = public_path('files/pdf-files/'.$folder1).'/'.$file->txt_file;
              	if(File::exists($pdf)) {
        			unlink($pdf);
        		}
              	if(File::exists($txt)) {
        			unlink($txt);
        		}
        		
                $picklefile = public_path('../../../genie-app/files/'.$file->txt_file.'.pk1');
                if(File::exists($picklefile)) {
                    unlink($picklefile);
                }
              	FileList::where('user_id',Auth::user()->id)->where('id',$file->id)->delete();
            }
        }
      	return "deleted";
	}
	public function delete_file(Request $request){
		$file = FileList::where('user_id',Auth::user()->id)->where('id',$request->id)->first();
        if($file->type=="D"){
            
            $this->delete_children($file->id);
            
        }
      	$folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt(Auth::user()->id,'ilife-genie'));
      	if($file->parent!=0){
          $folder1 = $folder1."/".$file->parent;
        }
      	$pdf = public_path('files/pdf-files/'.$folder1).'/'.$file->filename;
      	$txt = public_path('files/pdf-files/'.$folder1).'/'.$file->txt_file;
      	if(File::exists($pdf)) {
			unlink($pdf);
		}
      	if(File::exists($txt)) {
			unlink($txt);
		}
      	$file->delete();
		return response()->json(['status' => 'success', 'result' => 'Deleted SuccessFully']);
	}
    
  	
    public function mail_check(){
        $user = User::find(3);
        $user->message = "Test Mail";
        Mail::to('justinjamesrdrgz@gmail.com')->send(new \App\Mail\HDTutoMail($user)); 
        
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL,"https://identitytoolkit.googleapis.com/v1/accounts:sendOobCode?key=AIzaSyA3Ja_-qJEU9aHEE9zmYsEtDyeCydNObOc");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,"email=authorcrafts2020@gmail.com&requestType=PASSWORD_RESET@123");
        
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        //$server_output = curl_exec($ch);
        
        curl_close($ch);
        
        echo "response: ".$server_output;
        return view('welcome');
        
    }
	
    public function special_file_list(Request $request) {
        
       $up = UserPackage::where('user_id',auth()->user()->id)->where('end_date','>=',date("Y-m-d"))->orderBy('end_date','desc')->orderBy('package_id','desc')->first();
        
       $level = "2";
       if(!$request->parent){
           $currsiteurl = $_SERVER['HTTP_HOST'];
            if($currsiteurl=="app.edubuddy.ai"){
                $request->parent = 7226;
            } elseif(auth()->user()->level==3){
               $request->parent = 499;
           }  elseif(auth()->user()->level==4){
               $request->parent = 726;
               $request->parent = 1020;
           } elseif(auth()->user()->level==5){
               $request->parent = 726;
               $request->parent = 1020;
           }  elseif(auth()->user()->level==6){
               //$request->parent = 726;
               $request->parent = 3327;
           }  elseif(auth()->user()->level=="7"){
                
                $request->parent = 1379;//726
           } elseif(auth()->user()->level=="8"){
                
                $request->parent = 3646;//726
           } elseif(auth()->user()->level=="9"){
                
                $request->parent = 3736;//726
           } elseif(auth()->user()->level=="10" || auth()->user()->level=="11"){
                $request->parent = 7093;
           }
       }
       if($request->parent=='726'){
           $request->parent = 1020;
       }
       if(Auth::user()->level==5){
	        $file_level = 4;
	   } else {
	       $file_level = auth()->user()->level;
	   }
	   
	   if(auth()->user()->org_code!=""){
            $org_users =   User::where('org_code',auth()->user()->org_code)->pluck('id');
            $files = FileList::whereIn('user_id',$org_users)->with(['child'])->where('parent',$request->parent);
        } else{
	   
	   
           $admins = User::where('level','1')->pluck('id');
            $files = FileList::where(function($qry) use ($admins,$file_level){
                    $qry->where('user_id',auth()->user()->id)->orWhere(function($q) use ($admins,$file_level){
                        if($file_level==7){
                            $q->whereIn('file_level',[4,7])->whereIn('user_id',$admins);
                        } else {
                            $q->where('file_level',$file_level)->whereIn('user_id',$admins);
                        }
                    });
                })->with(['child'])->where(function($qq) use ($request) { 
                    if($request->parent=="1379"){
                        $qq->where('parent',$request->parent)->orWhere('id',1955);
                    } else {
                        $qq->where('parent',$request->parent);
                    }
                });
                
        }
        if($request->parent=="7226"){
            $files = $files->orderByRaw('FIELD(id, "7233") DESC')->get();  
        } else {
            $files = $files->orderByRaw('type, CAST(filename AS UNSIGNED)')->get();
        }
    
       
        $output = "";
        if($up && $up->end_date<date('Y-m-d')){
            $output="Your subscription plan expired!. <a href='".route('pricings')."'>Upgrade/Renew Now</a>";
        } elseif($files) {
			$output = "";
            $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt(Auth::user()->id,'ilife-genie'));
			foreach($files as $file){
			    $filename = $file->filename;
			    $tooltip = "";
			    if(strlen($filename)>12){
			        $tooltip = '&nbsp;&nbsp;<span class="tooltip"><i class="fa fa-info-circle"></i><span class="tooltiptext tooltip-top">'.$filename.'</span>
                    </span>';
			        $filename = substr($filename, 0, 10).'...';
			    }
			    if($file->user_id==Auth::user()->id){
			        if($file->type=="D"){
			            $output .= "<div class='col-xs-6 col-md-3 bg-light each-card'><div class='card-body text-center text_".$file->type."'>";
        				$output .= "<p>";
                        $output .= "<a href='".route('files',['parent'=>$file->id])."'>
                            <span class='glyphicon glyphicon-folder-open'></span><br>".$filename."</a>".$tooltip;
                        $output .= "<br><span class='created_spl_user'>Last updated at ".date('j M Y g:i a',strtotime($file->updated_at))."</span>";
                        $output .= "</p>";
        				$output .= "<p>";
                      if($file->child){
    					if($file->embed=="0"){
    						$ask_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"ask\",\"".$file->txt_file."\")'";
    					} else {
    						$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
    						$output .= "<a class='btn btn-info show_code' title='Regenerate Chat' onclick='generate_chat(".$file->id.",\"".$file->type."\")'><i class='glyphicon glyphicon-refresh'></i> </a>&nbsp;&nbsp;";
    					}	
    					$output .= "<a class='btn  s_btn genie_btn' target='_blank' ".$ask_onclick.">Ask</a>
    					&nbsp;&nbsp;";
    					
    					
                      }
                    
                        $show_processing = "style='display:none;' data-id='0'";
                        if($file->generate=="1"){
        				    $show_processing = "data-id='".$file->id."'";
        				}
                        $output .= "<a class='btn d_btn genie_btn' onclick='delete_file(".$file->id.");'>&nbsp;<span class='icon_only_btn glyphicon glyphicon-trash'></span>&nbsp;</a>";
                        $output .= "<br><span ".$show_processing." data-type='".$file->type."' class='show_generate_loader show_generate_loader".$file->id."'><img src='".url('/images/loader.gif')."' height='25px'>&nbsp;Processing...&nbsp;&nbsp;</span>";
        				$output .= "</p>";
        				$output .= "</div></div>";
                	} else {
                	    $output .= "<div class='col-xs-6 col-md-3 bg-light each-card'><div class='card-body text-center text_".$file->type."'>";
        				    $output .= "<p>";
                            $output .= "<span class='glyphicon glyphicon-book'></span><br>".$filename.$tooltip;
                            
                            $output .= "<br><span class='created_spl_user'>Last updated at ".date('j M Y g:i a',strtotime($file->updated_at))."</span>";
                            $output .= "</p>";
        				    $output .= "<p>";
                	    //if($file->generate=="2") {
        					if($file->embed=="0"){
        						$ask_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"ask\",\"".$file->txt_file."\")'";
        						$embed_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"embed\",\"".$file->txt_file."\")'";
        					} else {
        						$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
        						$embed_onclick = "onclick='show_code(\"".route('chat',['id'=>$file->txt_file,'embedded'=>1])."\")'";
        					}
        				    $output .= "<a class='btn  s_btn genie_btn' ".$ask_onclick.">Ask</a>
        					&nbsp;&nbsp;";
        					
                        //}
                        $show_processing = "style='display:none;' data-id='0'";
                        if($file->generate=="1"){
        				    $show_processing = "data-id='".$file->id."'";
        				}
                        //$output .= "<a class='btn d_btn genie_btn' onclick='delete_file(".$file->id.");'>&nbsp;<span class='icon_only_btn glyphicon glyphicon-trash'></span>&nbsp;</a>";
                        $output .= "<a class='btn d_btn genie_btn' onclick='delete_file(".$file->id.");'>&nbsp;<span class='icon_only_btn glyphicon glyphicon-trash'></span>&nbsp;</a>";
                        $output .= "<br><span ".$show_processing." data-type='".$file->type."' class='show_generate_loader show_generate_loader".$file->id."'><img src='".url('/images/loader.gif')."' height='25px'>&nbsp;Processing...&nbsp;&nbsp;</span>";
        				$output .= "</p>";
        				$output .= "</div></div>";
			        }
                    
			    } else {
                    if($file->type=="D"){
        				$output .= "<div class='col-xs-6 col-md-3 bg-light each-card'><div class='card-body text-center text_".$file->type."'>";
        				$output .= "<p>";
                        $output .= "<a href='".route('files',['parent'=>$file->id])."'>
                            <span class='glyphicon glyphicon-folder-open'></span><br>".$filename."</a>".$tooltip;
                        $output .= "<br><span class='created_spl_user'>Last updated at ".date('j M Y g:i a',strtotime($file->updated_at))."</span>";
                        $output .= "</p>";
        				$output .= "<p>";
        				$output .= "<span class='hide_generate_loader hide_generate_loader".$file->id."'>";
        				if($file->child && $file->embed!="0"){
        					$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
        					$output .= "<a class='btn  s_btn genie_btn' target='_blank' ".$ask_onclick.">Ask</a>&nbsp;&nbsp;";
                        } else {
                            $output .= "<a class='btn  s_btn genie_btn' href='".route('files',['parent'=>$file->id])."'>Open</a>&nbsp;&nbsp;";
                        }
                        $output .= "</span>";
        				$output .= "</p>";
        				$output .= "</div></div>";
                    } else {
                        
    				    $output .= "<div class='col-xs-6 col-md-3 bg-light each-card'><div class='card-body text-center text_".$file->type."'>";
    				    $output .= "<p>";
                        $output .= "<span class='glyphicon glyphicon-book'></span><br>".$filename.$tooltip;
                        $output .= "<br><span class='created_spl_user'>Last updated at ".date('j M Y g:i a',strtotime($file->updated_at))."</span>";
                        $output .= "</p>";
    				    $output .= "<p>";
    				    
    				    
    				    $output .= "<span class='hide_generate_loader hide_generate_loader".$file->id."'>";
    				    //if($file->generate=="2" && $file->embed!="0") {
        					$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
        					if($file->embed=="0"){
        					    $ask_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"ask\",\"".$file->txt_file."\")'";
        					}
        			        $output .= "<a class='btn  s_btn genie_btn' ".$ask_onclick.">Ask</a>&nbsp;&nbsp;";
                        //}
                        $show_processing = "style='display:none;' data-id='0'";
                        if($file->generate=="1"){
        				    $show_processing = "data-id='".$file->id."'";
        				}
        				
        				$output .= "&nbsp;<a class='btn s_btn genie_btn' onclick='view_pdf_file(\"".$file->txt_file."\");'>&nbsp;<span class='icon_only_btn fa fa-eye'></span>&nbsp;</a>";
                        $output .= "</span>";
                        if($file->user_id==auth()->user()->id || auth()->user()=="1"){
                        
        				    $output .= "<a class='btn d_btn genie_btn' onclick='delete_file(".$file->id.");'>&nbsp;<span class='icon_only_btn glyphicon glyphicon-trash'></span>&nbsp;</a>";
                        }
                        
                        $output .= "<span ".$show_processing." data-type='".$file->type."' class='show_generate_loader show_generate_loader".$file->id."'><img src='".url('/images/loader.gif')."' height='25px'>&nbsp;Processing...&nbsp;&nbsp;</span>";
                        
    				    $output .= "</p>";
    				    $output .= "</div></div>"; 
                    }
			    }
			}
		}
		echo $output==""?"<p>No FIles</p>":$output;
    }
    public function special_file_list_admin(Request $request) {
        
        $up = UserPackage::where('user_id',auth()->user()->id)->where('end_date','>=',date("Y-m-d"))->orderBy('end_date','desc')->orderBy('package_id','desc')->first();
        $level = 2;
        $route_name = "special_files";
        if($request->type=="law"){
            $level = 3;
            $route_name = "special_law_files";
        } elseif($request->type=="student"){
            $level = 4;
            $route_name = "special_student_files";
        }  elseif($request->type=="teacher"){
            $level = 4;
            $route_name = "special_teacher_files";
        }  elseif($request->type=="retail"){
            $level = 8;
            $route_name = "special_retail_files";
        }  elseif($request->type=="iit_jee_neet"){
            $level = 9;
            $route_name = "special_iit_jee_neet_files";
        }  elseif($request->type=="corporate"){
            $level = 10;
            $route_name = "special_corporate_files";
        }
         
        if($request->parent=="726"){
            $request->parent = 1020;
        }
        $admins = User::where('level','1')->pluck('id');
        $files = FileList::where(function($qry) use ($level,$admins){
            $qry->whereIn('user_id',$admins)->where('file_level',$level);
        })->with(['child'])->where('parent',$request->parent)->orderBy('type')->orderBy('filename')->get();
       
        $output = "";
        if($up && $up->end_date<date('Y-m-d')){
            $output="Your subscription plan expired!. <a href='".route('pricings')."'>Upgrade/Renew Now</a>";
        } elseif($files) {
			$output = "";
            $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt(Auth::user()->id,'ilife-genie'));
			foreach($files as $file){
			    $filename = $file->filename;
			    $tooltip = "";
			    if(strlen($filename)>12){
			        $tooltip = '&nbsp;&nbsp;<span class="tooltip"><i class="fa fa-info-circle"></i><span class="tooltiptext tooltip-top">'.$filename.'</span>
                    </span>';
			        $filename = substr($filename, 0, 10).'...';
			    }
			    if($file->user_id==Auth::user()->id){
			        if($file->type=="D"){
			            $output .= "<div class='col-xs-12 col-sm-6 col-md-3 bg-light each-card'><div class='card-body text-center text_".$file->type."'>";
        				$output .= "<p>";
                        $output .= "<a href='".route($route_name,['parent'=>$file->id])."'>
                            <span class='glyphicon glyphicon-folder-open'></span><br>".$filename."</a>".$tooltip;
                            
                        $output .= "<br><span class='created_spl_user'>Last updated at ".date('j M Y g:i a',strtotime($file->updated_at))."</span>";
                        $output .= "</p>";
        				$output .= "<p>";
                      if($file->child){
    					if($file->embed=="0"){
    						$ask_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"ask\",\"".$file->txt_file."\")'";
    					} else {
    						$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
    						$output .= "<a class='btn btn-info show_code' title='Regenerate Chat' onclick='generate_chat(".$file->id.",\"".$file->type."\")'><i class='glyphicon glyphicon-refresh'></i> </a>&nbsp;&nbsp;";
    					}	
    					$output .= "<a class='btn  s_btn genie_btn' target='_blank' ".$ask_onclick.">Ask</a>
    					&nbsp;&nbsp;";
                      }
                    
                        $show_processing = "style='display:none;' data-id='0'";
                        if($file->generate=="1"){
        				    $show_processing = "data-id='".$file->id."'";
        				}
                        $output .= "<a class='btn d_btn genie_btn' onclick='delete_file(".$file->id.");'>&nbsp;<span class='icon_only_btn glyphicon glyphicon-trash'></span>&nbsp;</a>";
                        $output .= "<br><span ".$show_processing." data-type='".$file->type."' class='show_generate_loader show_generate_loader".$file->id."'><img src='".url('/images/loader.gif')."' height='25px'>&nbsp;Processing...&nbsp;&nbsp;</span>";
        				$output .= "</p>";
        				$output .= "</div></div>";
                	} else {
                	    $output .= "<div class='col-xs-12 col-sm-6 col-md-3 bg-light each-card'><div class='card-body text-center text_".$file->type."'>";
        				    $output .= "<p>";
                            $output .= "<span class='glyphicon glyphicon-book'></span><br>".$filename.$tooltip;
                        $output .= "<br><span class='created_spl_user'>Last updated at ".date('j M Y g:i a',strtotime($file->updated_at))."</span>";
                            $output .= "</p>";
        				    $output .= "<p>";
                	    if($file->generate=="2") {
        					if($file->embed=="0"){
        						$ask_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"ask\",\"".$file->txt_file."\")'";
        						$embed_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"embed\",\"".$file->txt_file."\")'";
        					} else {
        						$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
        						$embed_onclick = "onclick='show_code(\"".route('chat',['id'=>$file->txt_file,'embedded'=>1])."\")'";
        					}
        				    $output .= "<a class='btn  s_btn genie_btn' ".$ask_onclick.">Ask</a>
        					&nbsp;&nbsp;";
        					
                        }
                        $show_processing = "style='display:none;' data-id='0'";
                        if($file->generate=="1"){
        				    $show_processing = "data-id='".$file->id."'";
        				}
        				
                        $output .= "<a class='btn d_btn genie_btn' onclick='delete_file(".$file->id.");'>&nbsp;<span class='icon_only_btn glyphicon glyphicon-trash'></span>&nbsp;</a>";
                        $output .= "<br><span ".$show_processing." data-type='".$file->type."' class='show_generate_loader show_generate_loader".$file->id."'><img src='".url('/images/loader.gif')."' height='25px'>&nbsp;Processing...&nbsp;&nbsp;</span>";
        				$output .= "</p>";
        				$output .= "</div></div>";
			        }
                    
			    } else {
                    if($file->type=="D"){
        				$output .= "<div class='col-xs-12 col-sm-6 col-md-3 bg-light each-card'><div class='card-body text-center text_".$file->type."'>";
        				$output .= "<p>";
                        $output .= "<a href='".route($route_name,['parent'=>$file->id])."'>
                            <span class='glyphicon glyphicon-folder-open'></span><br>".$filename."</a>".$tooltip;
                        $output .= "<br><span class='created_spl_user'>Last updated at ".date('j M Y g:i a',strtotime($file->updated_at))."</span>";
                        $output .= "</p>";
        				$output .= "<p>";
        				$output .= "<span class='hide_generate_loader hide_generate_loader".$file->id."'>";
        				if($file->child && $file->embed!="0"){
        					$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
        					$output .= "<a class='btn  s_btn genie_btn' target='_blank' ".$ask_onclick.">Ask</a>&nbsp;&nbsp;";
                        } else {
                            $output .= "<a class='btn  s_btn genie_btn' href='".route($route_name,['parent'=>$file->id])."'>Open</a>&nbsp;&nbsp;";
                        }
                        $output .= "</span>";
        				$output .= "</p>";
        				$output .= "</div></div>";
                    } else {
    				    $output .= "<div class='col-xs-12 col-sm-6 col-md-3 bg-light each-card'><div class='card-body text-center text_".$file->type."'>";
    				    $output .= "<p>";
                        $output .= "<span class='glyphicon glyphicon-book'></span><br>".$filename.$tooltip;
                        $output .= "<br><span class='created_spl_user'>Last updated at ".date('j M Y g:i a',strtotime($file->updated_at))."</span>";
                        $output .= "</p>";
    				    $output .= "<p>";
    				    
    				    
    				    $output .= "<span class='hide_generate_loader hide_generate_loader".$file->id."'>";
    				    if($file->generate=="2" && $file->embed!="0") {
        					$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
        			        $output .= "<a class='btn  s_btn genie_btn' ".$ask_onclick.">Ask</a>&nbsp;&nbsp;";
                        }
                        $show_processing = "style='display:none;' data-id='0'";
                        if($file->generate=="1"){
        				    $show_processing = "data-id='".$file->id."'";
        				}
                        $output .= "</span>";
                        
                        if($file->user_id==auth()->user()->id || auth()->user()=="1"){
        				    $output .= "<a class='btn d_btn genie_btn' onclick='delete_file(".$file->id.");'>&nbsp;<span class='icon_only_btn glyphicon glyphicon-trash'></span>&nbsp;</a>";
                            $output .= "<span ".$show_processing." data-type='".$file->type."' class='show_generate_loader show_generate_loader".$file->id."'><img src='".url('/images/loader.gif')."' height='25px'>&nbsp;Processing...&nbsp;&nbsp;</span>";
                        }
    				    $output .= "</p>";
    				    $output .= "</div></div>"; 
                    }
			    }
			}
		}
		echo $output==""?"<p>No FIles</p>":$output;
    }
    public function special_index($parent=0) {
      	if(!auth()->user()){
      	    return redirect('login');
      	}
      	if(auth()->user()->status!="1"){
	        //return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
	    
	    if(auth()->user()->level!="1"){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return redirect('pricings')->withWarning('Please choose a plan to continue');
            }
	    }
      	$breadcrumb = "";
      	if($parent>0){
          $breadcrumb = self::special_full_path($parent);
        }
        return view('special_file_list_admin',compact('parent','breadcrumb'));
        
    }
    
    public function special_law_index($parent=0) {
      	if(!auth()->user()){
      	    return redirect('login');
      	}
      	if(auth()->user()->status!="1"){
	        //return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
	    
	    if(auth()->user()->level!="1"){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return redirect('pricings')->withWarning('Please choose a plan to continue');
            }
	    }
      	$breadcrumb = "";
      	if($parent>0){
          $breadcrumb = self::special_full_path($parent,"","special_law_files");
        }
        $type="law";
        return view('special_file_list_admin',compact('parent','breadcrumb','type'));
        
    }
    public function special_student_index($parent=0) {
      	if(!auth()->user()){
      	    return redirect('login');
      	}
      	if(auth()->user()->status!="1"){
	        //return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
	    
	    if(auth()->user()->level!="1"){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return redirect('pricings')->withWarning('Please choose a plan to continue');
            }
	    }
      	$breadcrumb = "";
      	if($parent>0){
          $breadcrumb = self::special_full_path($parent,"","special_student_files");
        }
        $type="student";
        return view('special_file_list_admin',compact('parent','breadcrumb','type'));
        
    }
    
    public function special_retail_index($parent=0) {
      	if(!auth()->user()){
      	    return redirect('login');
      	}
      	if(auth()->user()->status!="1"){
	        //return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
	    
	    if(auth()->user()->level!="1"){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return redirect('pricings')->withWarning('Please choose a plan to continue');
            }
	    }
      	$breadcrumb = "";
      	if($parent>0){
          $breadcrumb = self::special_full_path($parent,"","special_retail_files");
        }
        $type="retail";
        return view('special_file_list_admin',compact('parent','breadcrumb','type'));
        
    }
    public function special_iit_jee_neet_index($parent=0) {
      	if(!auth()->user()){
      	    return redirect('login');
      	}
      	if(auth()->user()->status!="1"){
	        //return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
	    
	    if(auth()->user()->level!="1"){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return redirect('pricings')->withWarning('Please choose a plan to continue');
            }
	    }
      	$breadcrumb = "";
      	if($parent>0){
          $breadcrumb = self::special_full_path($parent,"","special_iit_jee_neet_files");
        }
        $type="iit_jee_neet";
        return view('special_file_list_admin',compact('parent','breadcrumb','type'));
        
    }
    public function special_corporate_index($parent=0) {
      	if(!auth()->user()){
      	    return redirect('login');
      	}
      	if(auth()->user()->status!="1"){
	        //return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
	    
	    if(auth()->user()->level!="1"){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return redirect('pricings')->withWarning('Please choose a plan to continue');
            }
	    }
      	$breadcrumb = "";
      	if($parent>0){
          $breadcrumb = self::special_full_path($parent,"","special_corporate_files");
        }
        $type="corporate";
        return view('special_file_list_admin',compact('parent','breadcrumb','type'));
        
    }
    
    public function special_teacher_index($parent=0) {
      	if(!auth()->user()){
      	    return redirect('login');
      	}
      	if(auth()->user()->status!="1"){
	        //return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
	    
	    if(auth()->user()->level!="1"){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return redirect('pricings')->withWarning('Please choose a plan to continue');
            }
	    }
      	$breadcrumb = "";
      	if($parent>0){
          $breadcrumb = self::special_full_path($parent,"","special_teacher_files");
        }
        $type="teacher";
        return view('special_file_list_admin',compact('parent','breadcrumb','type'));
        
    }
  	public static function special_full_path($id, $path="",$route="special_files"){
  	    $currsiteurl = $_SERVER['HTTP_HOST'];
  	    $avoid_path = array();
        if($currsiteurl=="app.edubuddy.ai"){
            $avoid_path = array(7226, 1020, 726);
        }
            
      	$fileData = FileList::where('id',$id)->where('file_level','>','2')->first();
      	if($fileData){
          	if($fileData->parent!="0"){
              if($path==""){
              	$path = $fileData->filename;
              } else {
                if(!in_array($fileData->id,$avoid_path)){
                $path = "<a href='".route($route,['parent'=>$fileData->id])."'>".$fileData->filename."</a>";
                }
              }
              $path = self::special_full_path($fileData->parent, $path,$route).' / '.$path;
            } else {
              $path = "<a href='".route($route,['parent'=>$fileData->id])."'>".$fileData->filename."</a>";
            }
      	}
      	return $path;
    }
    public function speechtotext(Request $request){
		$curlHandle = curl_init(config('app.api_url').'speechtotext');
	    
        $header = array(
		    'Content-Type: application/json'
		);
		//$cFile = curl_file_create(public_path('voices/'.$voicefile), $voicefile);
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $request);
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		print_r($result);
		curl_close($curlHandle);
		return $result['result'];
		
    }
    
    
  
    public function texttospeech(Request $request){
        
        $curlHandle = curl_init(config('app.api_url').'texttospeech');
	    
        $header = array(
		    'Content-Type: application/json'
		);
		//$cFile = curl_file_create(public_path('voices/'.$voicefile), $voicefile);
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $request);
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		print_r($result);
		curl_close($curlHandle);
		return $result['result'];
    }
    
    public function genietts(){
        if(!auth()->user()){
		  abort(404);
		}
        return view('genietts');
    }
    
    public function math_genie(Request $request){
        return view('math_genie');
    }
    public function math_genie_ask1(Request $request){
        
        
//         echo $postJson = '{
//             "contents":[ { "parts":[
//                     {"text": "What is this picture?"},
//                     {
//                       "inline_data": {
//                         "mime_type":"image/'.$mt.'",
//                         "data": "'.base64_encode($request->file("file")).'"
//                       }
//                     }
//                   ]
//                 }
//               ]
//             }';
        
//         $header = array(
// 		    'Content-Type: application/json'
// 		);
		
        //$curlHandle = curl_init('https://generativelanguage.googleapis.com/v1beta/models/gemini-pro-vision:generateContent?key=AIzaSyBB_gOEPlXYa46KXtkPsWt-kmmIVYg-Z0c');
	    
        
        $postParameter = array(
            'contents' => array(
                'parts'=> array(
                    'text'=>$request->question
                )
            ),
        );
        $header = array(
		    'Content-Type: application/json'
		);
        $curlHandle = curl_init('https://generativelanguage.googleapis.com/v1/models/gemini-pro:generateContent?key=AIzaSyBB_gOEPlXYa46KXtkPsWt-kmmIVYg-Z0c');
	    
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		//print_r($result);
		curl_close($curlHandle);
		if($result['candidates']){
		    return $result['candidates'][0]['content']['parts'][0]['text'];
		} else {
		    return "i-Life Genie wasn't able to find reliable information for your question. You could try rephrasing your question or ask a different question.";
		}
    }
    public function test_api(Request $request){
        
        
        if($request->type=="gemini"){
            $qstn = $request->q!=""?$request->q:'Write a story about a magic backpack';
        $postParameter = array(
            'contents' => array(
                'parts'=> array(
                    'text'=>$qstn
                )
            ),
        );
        $header = array(
		    'Content-Type: application/json'
		);
        $curlHandle = curl_init('https://generativelanguage.googleapis.com/v1/models/gemini-pro:generateContent?key=AIzaSyBB_gOEPlXYa46KXtkPsWt-kmmIVYg-Z0c');
	    
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		//print_r($result);
		echo $result['candidates'][0]['content']['parts'][0]['text'];
		curl_close($curlHandle);
        }
        return "<br>tested";
    }
    public function translate_text(Request $request){
        $qstn = 'Translate '.($request->get("query")).' from English to '.$request->language;
        $header = array(
		    'Content-Type: application/json',
		    'Authorization: Bearer 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'
		);
		$postParameter = array(
            'model' => 'gpt-3.5-turbo',
            'messages' => array(
                array('role' => 'user',
                'content' => $qstn
                ))
        );
        
        $curlHandle = curl_init('https://api.openai.com/v1/chat/completions');
	    
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		
		$responses =  $result['choices'][0]['message']['content'];
		
		$qa_id = 0;
        
           $qa = new UserQuestion();
           $qa->user_id = auth()->user()?auth()->user()->id:0;
           $qa->file_id = $request->store_name;
           $qa->question = $qstn;
           $qa->answer = "<md-block>".($responses)."</md-block>";
           $qa->save();
           $qa_id = $qa->id;
        
      	return "<md-block data-id='".$qa_id."'>".($responses)."</md-block>";
    }
    
    
    public function auto_translate_correction(Request $request) {
        $qns = UserQuestion::whereRaw('answer LIKE "%chatcmpl%"')->get();
        foreach($qns as $qn){
            $results = str_replace('<md-block>','',$qn->answer);
            $results = str_replace('</md-block>','',$results);
            $result = json_decode($results,true);
            $responses =  $result['choices'][0]['message']['content'];
            $qa = UserQuestion::where('id',$qn->id)->first();
            $qa->answer = "<md-block>".($responses)."</md-block>";
            $qa->save();
        }
    }
    public function download_audio(Request $request) {
        $postParameter = array(
            'model' => 'tts-1',
            'input' => $request->text,
            'voice' => $request->voice
        );
        //print_r($postParameter);
		$header = array(
		    'Authorization: Bearer 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',
		    'Content-Type: application/json'
		);
        
        $curlHandle = curl_init('https://api.openai.com/v1/audio/speech');
	    
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
		curl_close($curlHandle);
		
		
		$filename = rand(100,999).date('YmdHis').rand(100,999)."_genie_audio.mp3";
        $newvoice = fopen(public_path('voices/created/'.$filename),"w");
        fwrite($newvoice,$response);
        fclose($newvoice);
        
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        //header('Content-Length: ' . filesize($response));
        
        readfile(public_path('voices/created/'.$filename));
        sleep(2);
        unlink(public_path('voices/created/'.$filename));
        
        exit;
    }
    public function math_genie_ask(Request $request){
        
      $pdfile = $request->file('file');
      $pdffile = $pdfile->getClientOriginalName();
      
      $image_name_array = explode('.',$pdffile);
      $extension = end($image_name_array);
      if(strtolower($extension)=="jpg"){
          $extension = "jpeg";
      }
      
      $filename = rand(9999,999999).date('YmdHis').$pdffile;
      $pdfile->move(public_path('chat/'), $filename);
     
        $postJson = '{
            "contents":[ { "parts":[
                    {"text": "What is this picture?"},
                    {
                      "inline_data": {
                        "mime_type":"image/'.$extension.'",
                        "data": "'.base64_encode(public_path('chat/'.$filename)).'"
                      }
                    }
                  ]
                }
              ]
            }';
        // echo $postJson; exit;
        //$header = array(
		//    'Content-Type: application/json'
		//);
		
        //$curlHandle = curl_init('https://generativelanguage.googleapis.com/v1beta/models/gemini-pro-vision:generateContent?key=AIzaSyBB_gOEPlXYa46KXtkPsWt-kmmIVYg-Z0c');
	    
        
        //echo json_encode($postParameter); exit;
        // $postParameter = array(
        //     'contents' => array(
        //         'parts'=> array(
        //             'text'=>$request->question
        //         )
        //     ),
        // );
        
        
        
        //$curlHandle = curl_init('https://generativelanguage.googleapis.com/v1/models/gemini-pro:generateContent?key=AIzaSyBB_gOEPlXYa46KXtkPsWt-kmmIVYg-Z0c');
	    $curlHandle = curl_init('https://generativelanguage.googleapis.com/v1beta/models/gemini-pro-vision:generateContent?key=AIzaSyBB_gOEPlXYa46KXtkPsWt-kmmIVYg-Z0c');
	    
        $header = array(
		    'Content-Type: application/json'
		);
		
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postJson);
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		//print_r($result);
		curl_close($curlHandle);
		if($result['candidates']){
		    return $result['candidates'][0]['content']['parts'][0]['text'];
		} else {
		    return "i-Life Genie wasn't able to find reliable information for your question. You could try rephrasing your question or ask a different question.";
		}
    }
    
    public function history(Request $request){
        $history = UserQuestion::where('user_id',auth()->user()->id)->selectRaw('file_id,id')->groupBy('file_id','id')->orderBy('id','DESC')->with('file')->paginate(10);
        return view('history',compact('history'));
    }
    public function chat_history(Request $request,$file_id){
        $file = FileList::where('txt_file',$file_id)->first();
        $chat_history = UserQuestion::where('file_id',$file_id)->where('user_id',auth()->user()->id)->paginate(10);
        return view('chat_history',compact('chat_history','file'));
    }
    
    public function save_message(Request $request){
        $history = UserQuestion::where('id',$request->id)->first();
        $history->saved = $request->saved;
        $history->save();
        return response()->json(['status' => 'success', 'result' => 'Updated']);
    }
    public function like_message(Request $request){
        $history = UserQuestion::where('id',$request->id)->first();
        $history->liked = $request->liked;
        $history->save();
        return response()->json(['status' => 'success', 'result' => 'Updated']);
    }
    public function saved_messages(Request $request){
        $chat_history = UserQuestion::where('saved','1')->where('user_id',auth()->user()->id)->paginate(10);
        return view('saved_messages',compact('chat_history'));
    }
    public function fetch_videos(Request $request){
        
        $qstn = $request->q.'. In 3 to 4 words, tell me the topic which the user is referring to in this question.';
        $header = array(
		    'Content-Type: application/json',
		    'Authorization: Bearer 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'
		);
		$postParameter = array(
            'model' => 'gpt-3.5-turbo',
            'messages' => array(
                array('role' => 'user',
                'content' => $qstn
                ))
        );
        
        $curlHandle = curl_init('https://api.openai.com/v1/chat/completions');
	    
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		
		$responses =  $result['choices'][0]['message']['content'].'. Explain it in '.$request->lang;
        
        
        
        
        
        
        
        
        $url = 'https://www.googleapis.com/youtube/v3/search?key=AIzaSyCBXbpnKmuMijiG5GsMTxW5imYQQ52gmVY&part=id&q='.urlencode($responses);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        $result = curl_exec($ch);
        curl_close($ch);
        $resarr = json_decode($result,true);
        if(isset($resarr['items'])){
            $output = "Related Youtube Videos (".$responses."):";
            foreach($resarr['items'] as $key => $items){
                if(isset($items['id'])  && isset($items['id']['videoId'])){
                    $embedlink = "http://www.youtube.com/embed/".$items['id']['videoId'];
                    
                  //$output .= '<br><iframe src="'.$embedlink.'" class="genie_yt_iframe'.$request->div_id.'" width="100%" height="315" frameborder="0" allowfullscreen></iframe>';
                  //$output .= "<br>".($key+1).". <a target='_blank' href='https://youtu.be/".$items['id']['videoId']."'>youtu.be/".$items['id']['videoId']."</a>";
                  $output .= "<br>".($key+1).". <a onclick='playYouTubeModal(\"".$items['id']['videoId']."\");'>youtu.be/".$items['id']['videoId']."</a>";
                  
                  
                }
            }
        } else {
            $output =  "No related videos found";
        
        }
        
        $history = UserQuestion::where('id',$request->save_id)->first();
        $answer = $history->answer.$output;
        $history->answer = $answer;
        $history->save();
        return $output;
    }
    public function allowed_folders(Request $request){
        $folders = FileList::where('type','D')->with(['child_folders'])->where('parent','1020')->get();
        $allowed_folders = AllowedFolder::where('user_id',auth()->user()->id)->get();
        return view('allowed_folders',compact('allowed_folders','folders'));
    }
    public function my_folder_name($id){
        echo $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt($id,'ilife-genie'));
    }
    public function update_folders(Request $request){
        $exist = AllowedFolder::where('folder_id',$request->folder_id)->where('user_id',auth()->user()->id)->first();
        if($exist){
            AllowedFolder::where('folder_id',$request->folder_id)->where('user_id',auth()->user()->id)->delete();
        } else  {
            $al = new AllowedFolder();
            $al->parent_id = $request->parent_id;
            $al->folder_id = $request->folder_id;
            $al->user_id = auth()->user()->id;
            $al->save();
        }
        return response()->json(['status' => 'success', 'result' => 'Updated']);
    }
    function check_subscription(){
        $hasAdmin = false;
      	
      	if(!auth()->user()){
      	    return redirect('login');
      	}
  	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
	    $free_package = Package::where('id',1)->first();
  	    $premium_package = Package::where('id',50)->first();
  	    
      	$mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
      	    
      	if($mypackage){
      	    $question_limit = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->sum('question_limit');
      	} else {
      	    $question_limit = 100;
      	    //echo "Limit: ".date('Y-m-d H:i:s',strtotime(auth()->user()->created_at)) ."<" .date('Y-m-d H:i:s', strtotime('-3 days'));
      	    if(date('Y-m-d H:i:s',strtotime(auth()->user()->created_at)) < date('Y-m-d H:i:s', strtotime('-3 days'))){
      	        $output =  "Your i-Life Genie free trial period exceeds.&nbsp;<a href='".route('pricings')."' class='btn btn-primary'>Please subscribe </a>";
      	        return view('pricings', compact('free_package','premium_package','output'));
      	        exit();
      	    }
      	}
      	
      	if(auth()->user()->parent>0){
      	    $uqs = UserQuestion::whereRaw('user_id IN (SELECT id FROM users WHERE parent='.auth()->user()->parent.')')->where('created_at','>=','2024-06-08 00:00:00')->count();
      	} else {
      	    $uqs = UserQuestion::where('user_id',auth()->user()->id)->where('created_at','>=','2024-06-08 00:00:00')->count();
      	}
      	if($uqs>=$question_limit){
      	    $output =  "Your i-Life Genie question limit exceeds. &nbsp;<a href='".route('pricings')."' class='btn btn-primary'>Please subscribe </a>";
      	    return view('pricings', compact('free_package','premium_package','output'));
      	    exit();
      	}
    }
    public function my_business_card($my_referrer_id){
        return view('my_business_card', compact('my_referrer_id'));
    }
    public function check_downloading(){
        $filename = 'my_genie_card.pdf';
        $my_referrer_id = auth()->user()->my_referrer_id;
        $path = public_path().'/genie_cards/'.auth()->user()->my_referrer_id;
		if(!File::exists($path)) {
			File::makeDirectory($path, $mode = 0777, true, true);
		}
		
        $pdf = \PDF::loadView('my_business_card', compact('my_referrer_id'))->setPaper('a5', 'portrait');

        $pdf->save($path.'/'.$filename);
        
        return $file = $path.'/'.$filename;
    }
    public function download_business_card(){
        $my_referrer_id = auth()->user()->my_referrer_id;
        
        $filename = 'my_genie_card.pdf';
        
        $path = public_path().'/genie_cards/'.auth()->user()->my_referrer_id;
		if(!File::exists($path)) {
			File::makeDirectory($path, $mode = 0777, true, true);
		}
        
        $file = $path.'/'.$filename;
        
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($file));
        
        readfile($file);
        
        exit;
        
        //$my_referrer_id = auth()->user()->my_referrer_id;
        
        //$dompdf = new Dompdf();
        //$dompdf->loadHtml('my_business_card', compact('my_referrer_id'));
        //$dompdf->setPaper('letter', 'portrait');
        //$dompdf->render();
        
        //$file = $dompdf->output();
        
        
        //$pdf = DOMPDF::loadView('my_business_card', compact('my_referrer_id'));
        
        //return $pdf->download('disney.pdf');
        //exit;
        
//         $ilovepdf = new Ilovepdf('project_public_8d43a6f826b46e30edc4a15016c9d2df_AbEHWdd3e0e1456c64a865698adef2d9eab43','secret_key_ad61cc9ca86185823a73bb2221905681_ITAFwfccf722a6d9f42680408805f66a6d967');
//         $myTaskHtmlpdf = $ilovepdf->newTask('htmlpdf');
//         $myTaskHtmlpdf->setViewWidth(465);
//         $myTaskHtmlpdf->setPageOrientation('portrait');
//         $myTaskHtmlpdf->setPageSize('A5');
//         $myTaskHtmlpdf->setPageMargin(0);
//         $file = $myTaskHtmlpdf->addUrl(route('my_business_card',['my_referrer_id'=>auth()->user()->my_referrer_id]));
//         $myTaskHtmlpdf->execute();
        
//         $filename = 'my_genie_card_'.date('YmdHis').rand(100,999).'.pdf';
        
//         $path = public_path().'/genie_cards/'.auth()->user()->my_referrer_id;
// 		if(!File::exists($path)) {
// 			File::makeDirectory($path, $mode = 0777, true, true);
// 		}
		
//         $myTaskHtmlpdf->download('genie_cards/'.auth()->user()->my_referrer_id);
        
//         $file = $path.'/my_business_card.pdf';
        
//         header('Content-Description: File Transfer');
//         header('Content-Type: application/octet-stream');
//         header('Content-Disposition: attachment; filename="' . $filename . '"');
//         header('Expires: 0');
//         header('Cache-Control: must-revalidate');
//         header('Pragma: public');
//         header('Content-Length: ' . filesize($file));
        
//         readfile($file);
//         exit;
    }
    public function add_custom_toggle(Request $request){
        $ct = new CustomToggle();
        $ct->name = $request->name;
        $ct->value	 = $request->value;
        $ct->user_id	 = auth()->user()->id;
        $ct->save();
        return response()->json(['status' => 'success', 'result' => 'New custom toggle added','id'=>$ct->id]);
    }
    public function update_custom_toggle(Request $request){
        $ct = CustomToggle::where('id',$request->id)->first();
        $ct->name = $request->name;
        $ct->value	 = $request->value;
        $ct->save();
        return response()->json(['status' => 'success', 'result' => 'custom toggle updated','id'=>$ct->id]);
    }
    
    public function remove_custom_toggle(Request $request){
        $ct = CustomToggle::where('id',$request->id)->where('user_id',auth()->user()->id)->delete();
        
        return response()->json(['status' => 'success', 'result' => 'custom toggle removed successfully']);
    }
    
    
    
    
    public function search_list(Request $request) {
        $keyword = $request->keyword;
        $orderby = $request->orderby?$request->orderby:'filename';
        $sort = $request->sort?$request->sort:'ASC';
        $files = FileList::where('user_id',auth()->user()->id)->with(['child'])->where('filename','LIKE','%'.$keyword.'%')->orderBy('type')->orderBy($orderby,$sort)->get();
        $output = "";
		if($files){
			$output = "";
			$download_btns_id = "";
			$download_btn_id = 0;
            $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt(Auth::user()->id,'ilife-genie'));
            $fileids = "";
			foreach($files as $file){
			    
                $fileids = $fileids.$file->id.",";
        		$path = '/files/pdf-files/'.$folder1;
        		if($file->parent!=0){
        			$path = $path."/".$file->parent;
        		}
        		$totalPages = 0;
            	$path = $path.'/'.$file->filename;
        		if($file->type=="F" && file_exists(public_path($path)) && $file->page_nos=="0"){
            		$pdf = file_get_contents(public_path($path)); 
                    $totalPages = preg_match_all("/\/Page\W/", $pdf, $dummy);
                    
                    $fileData = FileList::where('id',$file->id)->first();
                    $fileData->page_nos = $totalPages;
                    $fileData->save();
        		} else {
        		    $totalPages = $file->page_nos;
        		}
				$output .= "<tr>";
				$output .= "<td class='text_".$file->type."'>";
                if($file->type=="D"){
                	$output .= "<a href='".route('files',['parent'=>$file->id])."'>
                    <span class='glyphicon glyphicon-folder-open'></span>&nbsp;&nbsp;".$file->filename."</a>";
                } else {
                  $output .= "<span class='glyphicon glyphicon-book'></span>&nbsp;&nbsp;".$file->filename."&nbsp;<span class='text-secondary text-sm'>(".$totalPages." pages)</span>";
                }
                // if(!file_exists(public_path($path)) && auth()->user()->id=="3"){
                //     $output .= public_path($path);
                // }
                if($file->generate=="3"){
                    //$filesize = filesize(public_path($path));
                    //if($filesize==0){
                    //    $output .= "<br><span class='text-danger text-sm'>Something went wrong. Please remove the file and upload again.</span>";
                    //} else {
                        $output .= "<br><span class='text-danger text-sm'>Something went wrong. Try processing again.</span>&nbsp;<a onclick='generate_pickle(".$file->id.");'>Process again</a>";
                   // }
                }
                $output .= "</td>";
                
				$output .= "<td class='hide_td datetime'>".date('j M Y g:i a',strtotime($file->created_at))."</td>";
				
                
				$output .= "<td class='file_actions'>";
				
				$output .= "<span class='hide_generate_loader hide_generate_loader".$file->id."'>";
              	if($file->type=="D"){
                  if($file->child){
					if($file->embed=="0"){
						$ask_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"ask\",\"".$file->txt_file."\")'";
						$embed_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"embed\",\"".$file->txt_file."\")'";
					} else {
						$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
						$embed_onclick = "onclick='show_code(\"".route('chat',['id'=>$file->txt_file,'embedded'=>1])."\")'";
						$output .= "<a class='btn a_btn genie_btn show_code' title='Regenerate Chat' onclick='generate_chat(".$file->id.",\"".$file->type."\")'><i class='glyphicon glyphicon-refresh'></i> </a>&nbsp;&nbsp;";
					}	
					$output .= "<a class='btn s_btn genie_btn' target='_blank' ".$ask_onclick.">Ask</a>
					&nbsp;&nbsp;";
					
					
					
					$output .= '<div class="dropdown extra_file_btns">
                      <button class="btn p_btn dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        ...
                      </button>
                      <div class="dropdown-menu dropdown_file_btns" aria-labelledby="dropdownMenuButton">';
                        
                      
					
					
					
					$output .= "<a class='dropdown-item show_code'  ".$embed_onclick.">Embed &lt;/&gt; </a>";
					
					if(auth()->user()->id=="4"){
					    
					    $url = route('download_files',['parent'=>$file->id]);
					    
					    $output .= "<a class='dropdown-item' href='".$url."' target='_blank'><i class='glyphicon glyphicon-download'></i> </a>";
					}
					$output .= '</div>
                    </div>&nbsp;&nbsp;';
					
                  }
            	} elseif($file->generate=="2") {
					if($file->embed=="0"){
						$ask_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"ask\",\"".$file->txt_file."\")'";
						$embed_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"embed\",\"".$file->txt_file."\")'";
					} else {
						$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
						$embed_onclick = "onclick='show_code(\"".route('chat',['id'=>$file->txt_file,'embedded'=>1])."\")'";
					}
				    $output .= "<a class='btn s_btn genie_btn' ".$ask_onclick.">Ask</a>
					&nbsp;&nbsp;";
					$output .= '<div class="dropdown extra_file_btns">
                      <button class="btn p_btn dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        ...
                      </button>
                      <div class="dropdown-menu dropdown_file_btns" aria-labelledby="dropdownMenuButton">';
                        
					$output .= "<a class='dropdown-item show_code'  ".$embed_onclick.">Embed &lt;/&gt; </a>";
					if(auth()->user()->id=="4"){
					    
					    $url = route('download_file',['id'=>$file->id]);
					    if($download_btns_id!=""){
					       $download_btns_id = $download_btns_id.",";
					    }
					    $download_btns_id = $download_btns_id.$url;
					    $output .= "<a id='download_btn".$download_btn_id."' class='dropdown-item' href='".$url."'><i class='glyphicon glyphicon-download'></i> </a>";
					    $download_btn_id = $download_btn_id+1;
					}
					
                      $output .= '</div>
                    </div>&nbsp;&nbsp;';
                }
                $output .= "</span>";
                $show_processing = "style='display:none;' data-id='0'";
                if($file->generate=="1"){
				    $show_processing = "data-id='".$file->id."'";
				}
                $output .= "<span ".$show_processing." data-type='".$file->type."' class='show_generate_loader show_generate_loader".$file->id."'><img src='".url('/images/loader.gif')."' height='25px'>&nbsp;Processing...&nbsp;&nbsp;</span>";
				
				
				$output .= "<a class='btn d_btn genie_btn' onclick='delete_file(".$file->id.");'>&nbsp;<span class='icon_only_btn glyphicon glyphicon-trash'></span>&nbsp;</a></td>";
				
                $output .= "</tr>";
			}
			
			
			if(auth()->user()->id=="4" && $download_btns_id!=""){ 
			    $output .= "<tr><td><a data-ids='".$download_btns_id."' class='btn p_btn download_all' onclick='download_all();'><i class='glyphicon glyphicon-download'></i> </a>
			    &nbsp;&nbsp;</td></tr>";
			    
				$output .= '<p class="d-none">'.$fileids.'</p>';
			}
		}
		echo $output==""?"<tr><td colspan='2'>No FIles</td></tr>":$output;
    }
    
    public function special_search_list(Request $request) {
        $keyword = $request->keyword;
        
       $up = UserPackage::where('user_id',auth()->user()->id)->where('end_date','>=',date("Y-m-d"))->orderBy('end_date','desc')->orderBy('package_id','desc')->first();
        
       $level = "2";
       if(!$request->parent){
            $currsiteurl = $_SERVER['HTTP_HOST'];
            if($currsiteurl=="app.edubuddy.ai"){
               $request->parent = 7226;
            } elseif(auth()->user()->level==3){
               $request->parent = 499;
           }  elseif(auth()->user()->level==4){
               $request->parent = 726;
               $request->parent = 1020;
           } elseif(auth()->user()->level==5){
               $request->parent = 726;
               $request->parent = 1020;
           }  elseif(auth()->user()->level==6){
               //$request->parent = 726;
               $request->parent = 3327;
           }  elseif(auth()->user()->level=="7"){
                
                $request->parent = 1379;//726
           } elseif(auth()->user()->level=="8"){
                
                $request->parent = 3646;//726
           } elseif(auth()->user()->level=="9"){
                
                $request->parent = 3736;//726
           } elseif(auth()->user()->level=="10" || auth()->user()->level=="11"){
                $request->parent = 7093;
           }
           
       }
       if($request->parent=='726'){
           $request->parent = 1020;
       }
       if(Auth::user()->level==5){
	        $file_level = 4;
	   } else {
	       $file_level = auth()->user()->level;
	   }
	   
       $admins = User::where('level','1')->pluck('id');
       $files = FileList::where('filename','LIKE','%'.$keyword.'%')->where(function($qry) use ($admins,$file_level){
                    $qry->where('user_id',auth()->user()->id)->orWhere(function($q) use ($admins,$file_level){
                        if($file_level==7){
                            $q->whereIn('file_level',[4,7])->whereIn('user_id',$admins);
                        } else {
                            $q->where('file_level',$file_level)->whereIn('user_id',$admins);
                        }
                    });
                })->with(['child'])->orderBy('type')->orderBy('filename')->get();
       
        $output = "";
        if($up && $up->end_date<date('Y-m-d')){
            $output="Your subscription plan expired!. <a href='".route('pricings')."'>Upgrade/Renew Now</a>";
        } elseif($files) {
			$output = "";
            $folder1 = preg_replace('/[^A-Za-z0-9]/', 'J', crypt(Auth::user()->id,'ilife-genie'));
			foreach($files as $file){
			    if($file->user_id==Auth::user()->id){
			        if($file->type=="D"){
			            $output .= "<div class='col-xs-6 col-md-3 bg-light each-card'><div class='card-body text-center text_".$file->type."'>";
        				$output .= "<p>";
                        $output .= "<a href='".route('files',['parent'=>$file->id])."'>
                            <span class='glyphicon glyphicon-folder-open'></span><br>".$file->filename."</a>";
                        $output .= "<br><span class='created_spl_user'>Last updated at ".date('j M Y g:i a',strtotime($file->updated_at))."</span>";
                        $output .= "</p>";
        				$output .= "<p>";
                      if($file->child){
    					if($file->embed=="0"){
    						$ask_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"ask\",\"".$file->txt_file."\")'";
    					} else {
    						$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
    						$output .= "<a class='btn btn-info show_code' title='Regenerate Chat' onclick='generate_chat(".$file->id.",\"".$file->type."\")'><i class='glyphicon glyphicon-refresh'></i> </a>&nbsp;&nbsp;";
    					}	
    					$output .= "<a class='btn  s_btn genie_btn' target='_blank' ".$ask_onclick.">Ask</a>
    					&nbsp;&nbsp;";
    					
    					
                      }
                    
                        $show_processing = "style='display:none;' data-id='0'";
                        if($file->generate=="1"){
        				    $show_processing = "data-id='".$file->id."'";
        				}
                        $output .= "<a class='btn d_btn genie_btn' onclick='delete_file(".$file->id.");'>&nbsp;<span class='icon_only_btn glyphicon glyphicon-trash'></span>&nbsp;</a>";
                        $output .= "<br><span ".$show_processing." data-type='".$file->type."' class='show_generate_loader show_generate_loader".$file->id."'><img src='".url('/images/loader.gif')."' height='25px'>&nbsp;Processing...&nbsp;&nbsp;</span>";
        				$output .= "</p>";
        				$output .= "</div></div>";
                	} else {
                	    $output .= "<div class='col-xs-6 col-md-3 bg-light each-card'><div class='card-body text-center text_".$file->type."'>";
        				    $output .= "<p>";
                            $output .= "<span class='glyphicon glyphicon-book'></span><br>".$file->filename;
                            
                            $output .= "<br><span class='created_spl_user'>Last updated at ".date('j M Y g:i a',strtotime($file->updated_at))."</span>";
                            $output .= "</p>";
        				    $output .= "<p>";
                	    //if($file->generate=="2") {
        					if($file->embed=="0"){
        						$ask_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"ask\",\"".$file->txt_file."\")'";
        						$embed_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"embed\",\"".$file->txt_file."\")'";
        					} else {
        						$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
        						$embed_onclick = "onclick='show_code(\"".route('chat',['id'=>$file->txt_file,'embedded'=>1])."\")'";
        					}
        				    $output .= "<a class='btn  s_btn genie_btn' ".$ask_onclick.">Ask</a>
        					&nbsp;&nbsp;";
        					
                        //}
                        $show_processing = "style='display:none;' data-id='0'";
                        if($file->generate=="1"){
        				    $show_processing = "data-id='".$file->id."'";
        				}
                        $output .= "<a class='btn d_btn genie_btn' onclick='delete_file(".$file->id.");'>&nbsp;<span class='icon_only_btn glyphicon glyphicon-trash'></span>&nbsp;</a>";
                        $output .= "<br><span ".$show_processing." data-type='".$file->type."' class='show_generate_loader show_generate_loader".$file->id."'><img src='".url('/images/loader.gif')."' height='25px'>&nbsp;Processing...&nbsp;&nbsp;</span>";
        				$output .= "</p>";
        				$output .= "</div></div>";
			        }
                    
			    } else {
                    if($file->type=="D"){
        				$output .= "<div class='col-xs-6 col-md-3 bg-light each-card'><div class='card-body text-center text_".$file->type."'>";
        				$output .= "<p>";
                        $output .= "<a href='".route('files',['parent'=>$file->id])."'>
                            <span class='glyphicon glyphicon-folder-open'></span><br>".$file->filename."</a>";
                        $output .= "<br><span class='created_spl_user'>Last updated at ".date('j M Y g:i a',strtotime($file->updated_at))."</span>";
                        $output .= "</p>";
        				$output .= "<p>";
        				$output .= "<span class='hide_generate_loader hide_generate_loader".$file->id."'>";
        				if($file->child && $file->embed!="0"){
        					$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
        					$output .= "<a class='btn  s_btn genie_btn' target='_blank' ".$ask_onclick.">Ask</a>&nbsp;&nbsp;";
                        } else {
                            $output .= "<a class='btn  s_btn genie_btn' href='".route('files',['parent'=>$file->id])."'>Open</a>&nbsp;&nbsp;";
                        }
                        $output .= "</span>";
        				$output .= "</p>";
        				$output .= "</div></div>";
                    } else {
                        
    				    $output .= "<div class='col-xs-6 col-md-3 bg-light each-card'><div class='card-body text-center text_".$file->type."'>";
    				    $output .= "<p>";
                        $output .= "<span class='glyphicon glyphicon-book'></span><br>".$file->filename;
                        $output .= "<br><span class='created_spl_user'>Last updated at ".date('j M Y g:i a',strtotime($file->updated_at))."</span>";
                        $output .= "</p>";
    				    $output .= "<p>";
    				    
    				    
    				    $output .= "<span class='hide_generate_loader hide_generate_loader".$file->id."'>";
    				    //if($file->generate=="2" && $file->embed!="0") {
        					$ask_onclick = "onclick='ask(\"".$file->txt_file."\");'";
        					if($file->embed=="0"){
        					    $ask_onclick = "onclick='generate_chat(".$file->id.",\"".$file->type."\",\"ask\",\"".$file->txt_file."\")'";
        					}
        			        $output .= "<a class='btn  s_btn genie_btn' ".$ask_onclick.">Ask</a>&nbsp;&nbsp;";
                        //}
                        $show_processing = "style='display:none;' data-id='0'";
                        if($file->generate=="1"){
        				    $show_processing = "data-id='".$file->id."'";
        				}
                        $output .= "</span>";
                        if($file->user_id==auth()->user()->id || auth()->user()=="1"){
                        
        				    $output .= "<a class='btn d_btn genie_btn' onclick='delete_file(".$file->id.");'>&nbsp;<span class='icon_only_btn glyphicon glyphicon-trash'></span>&nbsp;</a>";
                        }
                        $output .= "<span ".$show_processing." data-type='".$file->type."' class='show_generate_loader show_generate_loader".$file->id."'><img src='".url('/images/loader.gif')."' height='25px'>&nbsp;Processing...&nbsp;&nbsp;</span>";
                        
    				    $output .= "</p>";
    				    $output .= "</div></div>"; 
                    }
			    }
			}
		}
		echo $output==""?"<p>No FIles</p>":$output;
    }
    
    public function ask_normal(Request $request){
        if(auth()->user()){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return response()->json(['status' => 'failed', 'result' => 'No package added']);
            }
	    } else {
	        $asked = HomeChat::where('device_id',$request->device_id)->where('created_at','>=',date('Y-m-d').' 00:00:00')->where('created_at','<=',date('Y-m-d').' 23:59:59')->count();
	        if($asked>=5){
	            return response()->json(['status' => 'failed', 'result' => 'Limit Exceeds']);
	        }
	    }
        $qstn = $request->question;
        $header = array(
		    'Content-Type: application/json',
		    'Authorization: Bearer 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'
		);
		$postParameter = array(
            'model' => 'gpt-3.5-turbo',
            'messages' => array(
                array('role' => 'user',
                'content' => $qstn
                ))
        );
        
        $curlHandle = curl_init('https://api.openai.com/v1/chat/completions');
	    
		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postParameter));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response,true);
		
		$responses =  $result['choices'][0]['message']['content'];
		
		$qa_id = 0;
        
        $hmchat = new HomeChat();
        $hmchat->device_id = $request->device_id?$request->device_id:0;
        $hmchat->user_id = auth()->user()?auth()->user()->id:'0';
        $hmchat->question = $request->question;
        $hmchat->type = "web";
        $hmchat->answer = $responses;
        $hmchat->save();
        
        return response()->json(['status' => 'success', 'result' =>$responses]);
      	//return "<md-block data-id='".$qa_id."'>".($responses)."</md-block>";
    }
    
    public function chat_normal(){
        
	    if(auth()->user() && auth()->user()->level!="1"){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return redirect('pricings')->withWarning('Please choose a plan to continue');
            }
	    }
	    $userquestions = [];
		
        
      	$parent = 0;
		$whole_text = "";
		$pdfs = array();
		$folder1 = '';
		$whole_text = '';
      	
        $response = '';
        $groups = [];
        $custom_toggles = [];
        if(auth()->user()){
            $groups = ChatMember::where('user_id',auth()->user()->id)->with('group')->get();
            $custom_toggles = CustomToggle::where('user_id',auth()->user()->id)->get();
            //$userquestions = UserQuestion::where('user_id',auth()->user()->id)->where('file_id',$files->txt_file)->orderBy('created_at','DESC')->limit(3)->get();
            //$userquestions = $userquestions->reverse();
            
            
        }
        
		return view('chat_normal',compact('pdfs','whole_text','parent','folder1','groups','custom_toggles','userquestions'));
	} 
}
