<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Files;
use App\Models\Log;
use App\Models\Genie;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Exception;
use DB;
use Mail;
use Hash;
use Response;

class GenieController extends Controller
{
    /**
     * User login API method
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
    */
    
    public function index(){
        return view('welcome');
    }
    public function home($slug="") {
        $towns = Genie::inRandomOrder()->limit(100)->get();
        return view('home',compact('towns','slug'));
    }
    public function about(){
        return view('about');
    }
    public function contact(){
        return view('contact');
    }
    public function login_view(){
        return view('login');
    }
    public function register_view(){
        return view('user_register');
    }
    public function register_driver_view(){
        return view('driver_register');
    }
    public function password_reset(){
        return view('password_reset');
    }
    public function reset_password(){
        return view('reset_password');
    }
    public function support_developer(){
        return view('support_developer');
    }
    public function download_app(){
        $file= public_path(). "/download/taxi_nearby.apk";
        $headers = array('Content-Type: application/apk',);
        return Response::download($file, 'taxi_nearby.apk', $headers);
    }
    public function send_mail(Request $request){
        $user = new User();
        $user->name = 'Admin';
        $user->message = "<h3><u>Contact Form</u></h3>Name: ".$request->name."<br>Email: ".$request->email."<br>Message: ".$request->message;
        Mail::to('justinjamesrdrgz@gmail.com')->send(new \App\Mail\AskPDFMailCommon($user));
        return response()->json(['status' => 'success', 'result' => 'Message send successfully']);
    } 
  	public function resend_password_otp(Request $request){
      $otp = rand(100000,999999);
      $user = User::where('email',$request->email)->first();
      if($user){
          $user->otp = $otp;
          $user->save();
          $user->message = $otp." is the OTP for password changing";
            Mail::to($user->email)->send(new \App\Mail\AskPDFMailCommon($user));
          return response()->json(['status' => 'success', 'result' => 'OTP send successfully']);
      } else {
         return response()->json(['status' => 'failed', 'result' => 'Incorrect email id']);
      }
      
    }
  	public function verify_password_otp(Request $request){
      $user = User::where('email',$request->email)->first();
      if($user){
          if($request->otp==$user->otp){
              $request->session()->withSuccess('Email Verified Successfully');
              return redirect('taxi');
          } else {
              $request->session()->withWarning('Incorrect OTP');
              return redirect('verify_otp');
          }
      } else {
          $request->session()->withWarning('Incorrect Email ID');
          return redirect('verify_otp');
      }

    }
    
  	public function change_forgot_password(Request $request){
      $user = User::where('id',$request->id)->first();
      $user->password = bcrypt($request->new_password);
      $user->save();
      $request->session()->withSuccess('Password changed successfully');
        return redirect('login');
    }
    
    public function mail_check(){
        $user = User::find(4);
        $user->message = "Test Mail";
        Mail::to('justinjamesrdrgz@gmail.com')->send(new \App\Mail\HDTutoMail($user));
        return view('welcome');
    }
    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email'    => 'required|email',
            'password' => 'required'
        ]);

       if ($validator->fails()) return redirect()->back()->withErrors($validator)->withInput();

        $credentials = $request->only('email', 'password');

        if (Auth::attempt($credentials)) {
            $user             = Auth::user();
            $success['name']  = $user->name;
            $success['email']  = $user->email;
            $success['mobile']  = $user->mobile;
            $success['level']  = $user->level;
            $success['status']  = $user->status;
            $success['token'] = $user->createToken('accessToken')->accessToken;

            return redirect('taxi');
        } else {
            return abort(401);
        }
    }

    /**
     * User registration API method
     *
	 Level- 3 driver
	 Level -2 user
	 Level -1 Admin
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function register(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name'     => 'required',
            'email'    => 'required|email|unique:users',
            'mobile' => 'required|min:10',
            'password' => 'required|min:5'
        ]);

        if ($validator->fails()) return response($validator->messages(), 200);

        try {
            $otp = rand(100000,999999);
            $user = new User();
			$user->name = $request->name;
			$user->email = $request->email;
			$user->password = bcrypt($request->password);
			$user->mobile = $request->mobile;
			$user->level = 2;
			$user->status = 0;
			$user->otp = $otp;
			$user->save();
			
			$user->message = "Your i-Life Genie Account Created Successfully!";
            Mail::to($user->email)->send(new \App\Mail\AskPDFMailCommon($user));
			
			$user->message = $otp." is the OTP for your email verification. Thank you for creating accountin i-Life Genie!";
            Mail::to($user->email)->send(new \App\Mail\AskPDFMailOTP($user));
            
            $success['name']  = $user->name;
            $success['email']  = $user->email;
            $success['mobile']  = $user->mobile;
            $success['level']  = $user->level;
            $success['status']  = $user->status;
            $message          = 'Yay! A user has been successfully created.';
            $success['token'] = $user->createToken('accessToken')->accessToken;
            
            $credentials = $request->only('email', 'password');
            Auth::attempt($credentials);
        } catch (Exception $e) {
            $success['token'] = [];
            $message          = 'Oops! Unable to create a new user.';
        }

        return redirect('taxi');
    }
    
	public function logout(Request $request){
	    Auth::logout();
	    return redirect('/');
    }
  	public function resend_otp(Request $request){
      $id = auth()->user()->id;
      $otp = rand(100000,999999);
      $user = User::where('id',$id)->first();
      $user->otp = $otp;
      $user->save();
      $user->message = $otp." is the OTP for your email verification";
        Mail::to($user->email)->send(new \App\Mail\AskPDFMailOTP($user));
      
      return redirect('verify_otp')->withSuccess('OTP has been sent to your mail!');
      
    }
  	public function verify_otp(Request $request){
      $otp = auth()->user()->otp;
      if($request->otp==$otp){
        $user = User::where('id',auth()->user()->id)->first();
        if($user){
          $user->status=1;
          $user->save();
        
        }
        return redirect('taxi')->withSuccess('Verified SuccessFully');
      }
      return redirect('verify_otp')->withWarning('Incorrect OTP');
    }
	public function nearby_drivers(Request $request){
	    if(auth()->user()->status==0){
	        return redirect('verify_otp');
	    }
	    $latitude = auth()->user()->latitude;
	    $longitude = auth()->user()->longitude;
	    $msg = "";
	    $drivers = [];
	    if($latitude=="" || $longitude==""){
	        $msg = "unavailable";
	    } elseif(auth()->user()->level==2) {
		$drivers = User::where('level',3)->where('status',1)->where('available',1)->select('users.*', DB::raw('(3959 * acos(cos(radians('.$latitude.')) * cos(radians(latitude)) * cos(radians(longitude) - radians('.$longitude.')) + sin(radians('.$latitude.')) * sin(radians(latitude)))) AS distance'))->havingRaw('distance <= 10')->orderBy('distance','asc')->get(30);
	    }
		
		return view('my_home',compact('drivers','msg'));
	}
	public function view_driver(Request $request,$id){
	    if(auth()->user()->status==0){
	        return redirect('verify_otp');
	    }
		$driver = User::where('id',$id)->first();
		$view = new Files();
		$view->user_id = Auth::user()->id;
		$view->driver_id = $request->id;
		$view->save();
		
		return view('driver',compact('driver'));
	}
	
	public function profile(){
	    if(auth()->user()->status==0){
	        return redirect('verify_otp');
	    }
	    return view('profile');
	}
	public function edit_profile(){
	    if(auth()->user()->status==0){
	        return redirect('verify_otp');
	    }
	    return view('edit_profile');
	}
	public function update_profile(Request $request){
	    if(auth()->user()->status==0){
	        return redirect('verify_otp');
	    }
		$user = User::where('id',Auth::user()->id)->first();
		
		$validator = Validator::make($request->all(), [
			'name'     => 'required',
			'email'    => 'required|email|unique:users',
			'mobile' => 'required|min:10'
		]);
		
		if ($validator->fails()) return response($validator->messages(), 200);
		if($request->email!=$user->email){
			$log = new Log();
			$log->log = "Email changed from ".$user->email." to ".$request->email;
			$log->user_id = Auth::user()->id;
			$log->save();
		}
		if($request->name!=$user->name){
			$log = new Log();
			$log->log = "Name changed from ".$user->name." to ".$request->name;
			$log->user_id = Auth::user()->id;
			$log->save();
		}
		if($request->mobile!=$user->mobile){
			$log = new Log();
			$log->log = "Mobile changed from ".$user->mobile." to ".$request->mobile;
			$log->user_id = Auth::user()->id;
			$log->save();
		}
		$user->name = $request->name;
		$user->email = $request->email;
		$user->mobile = $request->mobile;
		$user->save(); 
		return redirect('profile')->withSuccess('Profile Updated SuccessFully');
	}
	public function change_password_view(){
	    if(auth()->user()->status==0){
	        return redirect('verify_otp');
	    }
	    return view('change_password');
	}
  	public function change_password(Request $request){
	    if(auth()->user()->status==0){
	        return redirect('verify_otp');
	    }
      $user = User::where('id',auth()->user()->id)->first();
      if (Hash::check($request->old_password, $user->password)) {
        $user->password = bcrypt($request->new_password);
      } else {
          return redirect('verify_otp')->withWarning('Wrong old password');
      }
      $user->save();
      $request->session()->withSuccess('Password changed successfully');
      return redirect('change_password');
    }
    
    public function verify_otp_view(){
        return view('verify_otp');
    }
	
}
