<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\GoogleMeetService;
use App\Models\ChatGroup;
use App\Models\ChatMember;
use App\Models\ChatGroupMessage;

use Session;

class GoogleController extends Controller
{
    protected $googleMeetService;
    
    public function __construct(GoogleMeetService $googleMeetService)
    {
        $this->googleMeetService = $googleMeetService;
    }
    
    public function redirectToGoogle(Request $request)
    {
        $group_code = $request->g?$request->g:'';
        $group = ChatGroup::where('join_link',$group_code)->first();
        if($group){
            $ingroup = ChatMember::where('group_id',$group->id)->where('user_id',auth()->user()->id)->first();
            if($ingroup){
                Session::put('group_code',$group_code);
                $authUrl = $this->googleMeetService->client->createAuthUrl();
                return redirect($authUrl);
            } else {
                return redirect('groups');
            }
        } else {
            return redirect('groups');
        }
        
    }
    
    public function handleGoogleCallback(Request $request)
    {
        $this->googleMeetService->authenticate($request->code);
        return redirect('/create-event');
    }
    
    public function createEvent(Request $request)
    {
        $group_code =session('group_code');
        $group = ChatGroup::where('join_link',$group_code)->first();
        if($group){
            $ingroup = ChatMember::where('group_id',$group->id)->where('user_id',auth()->user()->id)->first();
            if($ingroup){
                $event = $this->googleMeetService->createGoogleMeetEvent(
                $group->group_name.' Meeting',
                $group->group_name.' Meeting created by '.auth()->user()->name,
                '2024-05-23T10:00:00-07:00',
                '2024-05-23T11:00:00-07:00'
                );
                //echo response()->json($event)->getContent();
                $out = json_decode(response()->json($event)->getContent(),true);
                //print_r($out);
                //exit;
                $message = $out['hangoutLink'];
                
                $msg = new ChatGroupMessage();
                $msg->group_id = $group->id;
                $msg->user_id = auth()->user()->id;
                $msg->message = "<b>".$group->group_name.' Meeting</b><br>Google Meet Link: <a target="_blank" href="'.$message.'">'.$message.'</a>';
                $msg->save();
                
                $group = ChatGroup::where('id',$group->id)->first();
                $group->refreshed = date('Y-m-d H:i:s');
                $group->save();
                
                $route = route('group_chat',['id'=>$group_code]);
        
                return redirect($route);
                
            } else {
                return redirect('groups');
            }
        } else {
            return redirect('groups');
        }
        
    }
}
