<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\FileList;
use App\Models\Log;
use App\Models\Genie;

use App\Models\ChatMember;
use App\Models\ChatGroupMessage;
use App\Models\ChatGroup;
use App\Models\ChatGroupSavedAnswer;
use App\Models\ChatGroupReceipts;
use App\Models\ChatGroupRequest;
use App\Models\ChatGroupAllAnswer;
use App\Models\ChatMemberMessage;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Exception;
use DB;
use Mail;
use Hash;
use Response;
use File;

class GroupChatController extends Controller
{
    /**
     * User login API method
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
    */
    
    public function index(){
        
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
        $group_ids = [];
        $groupIds = ChatMember::where('user_id',auth()->user()->id)->groupBy('group_id')->pluck('group_id');
        if($groupIds){
            $group_ids = $groupIds;
        }
        $groups = ChatGroup::whereIn('id',$group_ids)->with('members')->orderBy('refreshed','desc')->get();
        return view('groups',compact('groups'));
    }
    public function create_group(Request $request){
        
        $group_name = $request->group_name;
        $tmp = rand(100,999).Auth::user()->id.date('YmdHis').rand(100,999);
        $join_link = preg_replace('/[^A-Za-z0-9]/', 'W', crypt($tmp,'ilife-genie'));
        
        $group = new ChatGroup();
        $group->group_name = $group_name;
        $group->created_by = auth()->user()->id;
        $group->who_can_text = 1;
        $group->join_link = $join_link;
        $group->refreshed = date('Y-m-d H:i:s');
        $group->description = $request->description;
        $group->type = $request->type;
        
        $group->save();
        
        $gm = new ChatMember();
        $gm->user_id = auth()->user()->id;
        $gm->group_id = $group->id;
        //$gm->last_viewed = date('Y-m-d H:i:s');
        $gm->user_level = 1;
        $gm->save();
        
        $route = route('group_details',['id'=>$join_link]);
        
        return redirect($route);
    }
    
    public function group_details($id){
        
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
        $group = ChatGroup::where('join_link',$id)->with('members')->first();
        $members = ChatMember::where('group_id',$group->id)->with('user')->get();
        $ingroup = ChatMember::where('group_id',$group->id)->where('user_id',auth()->user()->id)->first();
        $group_requests = ChatGroupRequest::where('group_id',$group->id)->where('status','0')->with('user')->get();
        return view('group_details',compact('group','members','ingroup','group_requests'));
    }
    
    public function send_group_message(Request $request){
        $msg = new ChatGroupMessage();
        $msg->group_id = $request->group_id;
        $msg->user_id = auth()->user()->id;
        $msg->message = $request->message;
        $msg->save();
        $group = ChatGroup::where('id',$request->group_id)->first();
        $group->refreshed = date('Y-m-d H:i:s');
        $group->save();
        return response()->json(['status' => 'success', 'result' => 'Shared Successfully']);
    }
    public function send_group_voice_message(Request $request){
        
        $vfile = $request->file('voice');
        $voicefile = auth()->user()->id.rand(100,999).date('YmdHis').rand(100,999).".mp3";
        
        $vfile->move(public_path('group_voices'), $voicefile);
        
        $msg = new ChatGroupMessage();
        $msg->group_id = $request->group_id;
        $msg->user_id = auth()->user()->id;
        $msg->voice = $voicefile;
        $msg->save();
        
        $group = ChatGroup::where('id',$request->group_id)->first();
        $group->refreshed = date('Y-m-d H:i:s');
        $group->save();
        
        $vmsg = url('group_voices/'.$voicefile) ;
        
        $msgs ='<audio controls>
                              <source src="'.$vmsg.'" type="audio/mp3">
                              Your browser does not support the audio element.
                            </audio>';
        return $msgs;
    }
    
    
    public function send_group_attach_message(Request $request){
        
        $attach = $request->file('attachment');
        $fname = $attach->getClientOriginalName();
        $file_ext = explode('.',$fname);
        $ext = strtoupper(end($file_ext));
        
        $path = public_path().'/group_chat/files/'.$request->group_id;
		if(!File::exists($path)) {
			File::makeDirectory($path, $mode = 0777, true, true);
		}
        $filename = rand(9999,999999).date('YmdHis').'.'.$ext;
        $attach->move($path, $filename);
        
        
        $msg = new ChatGroupMessage();
        $msg->group_id = $request->group_id;
        $msg->user_id = auth()->user()->id;
        $msg->file = $filename;
        $msg->save();
        
        $group = ChatGroup::where('id',$request->group_id)->first();
        $group->refreshed = date('Y-m-d H:i:s');
        $group->save();
        
        $vmsg = url('group_chat/files/'.$request->group_id.'/'.$filename) ;
        
        $msgs ='File ('.$filename.') <br><a href="'.$vmsg.'" target="_blank" class="btn btn-sm btn-primary">View</a>';
        return $msgs;
    }
    
    
    public function group_chat($id) {
        $group = ChatGroup::where('join_link',$id)->with('members')->first();
        $groupmsgs = ChatGroupMessage::where('group_id',$group->id)->with('user')->orderBy('created_at','desc')->limit(20)->get()->reverse();
        
        $gm = ChatMember::where('group_id',$group->id)->where('user_id',auth()->user()->id)->first();
        $gm->last_viewed = date('Y-m-d H:i:s');
        $gm->save();
        
        $group_ids = [];
        $groupIds = ChatMember::where('user_id',auth()->user()->id)->groupBy('group_id')->pluck('group_id');
        if($groupIds){
            $group_ids = $groupIds;
        }
        $groups = ChatGroup::whereIn('id',$group_ids)->with('members')->orderBy('refreshed','desc')->get();
        
        return view('group_chat',compact('group','groupmsgs','groups'));
    }
    public static function time_elapsed_string($datetime, $full = false) {
        $seconds_ago = (time() - strtotime($datetime));

        if ($seconds_ago >= 31536000) {
            return intval($seconds_ago / 31536000) . " years";
        } elseif ($seconds_ago >= 2419200) {
            return intval($seconds_ago / 2419200) . " months";
        } elseif ($seconds_ago >= 86400) {
            return intval($seconds_ago / 86400) . " days";
        } elseif ($seconds_ago >= 3600) {
            return intval($seconds_ago / 3600) . " hours";
        } elseif ($seconds_ago >= 120) {
            return intval($seconds_ago / 60) . " mins";
        } elseif ($seconds_ago >= 60) {
            return "1 min";
        } else {
            return "Just now";
        }
    }
    
    public function loadnew_chat(Request $request){
        $groupmsgs = ChatGroupMessage::where('group_id',$request->group_id)->with('user')->where('id','>',$request->last_id)->orderBy('created_at','desc')->limit(20)->get();
        $msgs = "";
        if(count($groupmsgs)>0){
            foreach($groupmsgs as $msg){
                if($msg->user_id == auth()->user()->id){
                    $msgs .='<li class="self msg_li" data-msg-id="'.$msg->id.'">
                      <div class="avatar"><img src="https://i.imgur.com/HYcn9xO.png" draggable="false"/></div>
                      <div class="msg">';
                        if($msg->photo!=""){
                            $msgs .='<img src="https://i.imgur.com/QAROObc.jpg" draggable="false"/>';
                        }
                        if($msg->voice!="")  {
                            $vmsg = url('group_voices/'.$msg->voice) ;
                            $msgs .='<audio controls>
                              <source src="'.$vmsg.'" type="audio/mp3">
                              Your browser does not support the audio element.
                            </audio>';
                        }
                        if($msg->file!="")  {
                            $vmsg = url('group_chat/file/'.$msg->group_id.'/'.$msg->file) ;
                            $msgs .='File ('.$msg->file.') <br><a href="'.$vmsg.'" class="btn btn-sm btn-primary" target="_blank">View</a>';
                        }
                        $msgs .= $msg->message;
                        $msgs .='<br><span class="text-sm pull-left">'.$msg->user->name.'</span>';
                        $msgs .='<br><time>'.$this->time_elapsed_string($msg->created_at).'</time>
                      </div>
                    </li>'; 
                } else {
                    $msgs .='<li class="other msg_li" data-msg-id="'.$msg->id.'">
                      <div class="avatar"><img src="https://i.imgur.com/DY6gND0.png" draggable="false"/></div>
                      <div class="msg">';
                        if($msg->photo!=""){
                            $msgs .='<img src="https://i.imgur.com/QAROObc.jpg" draggable="false"/>';
                        }
                        if($msg->voice!="")  {
                            $vmsg = url('group_voices/'.$msg->voice) ;
                            $msgs .='<audio controls>
                              <source src="'.$vmsg.'" type="audio/mp3">
                              Your browser does not support the audio element.
                            </audio>';
                        }
                        if($msg->file!="")  {
                            $vmsg = url('group_chat/file/'.$msg->group_id.'/'.$msg->file) ;
                            $msgs .='File ('.$msg->file.') <br><a href="'.$vmsg.'" class="btn btn-sm btn-primary" target="_blank">View</a>';
                        }
                        $msgs .= $msg->message;
                        $msgs .='<br><span class="text-sm pull-right">'.$msg->user->name.'</span>';
                        $msgs .='<br><time>'.$this->time_elapsed_string($msg->created_at).'</time>
                      </div>
                    </li>';
                }
            }
        } else {
            $msgs = "completed";
        }
        return $msgs;
    }
    public function loadmore_chat(Request $request){
        $groupmsgs = ChatGroupMessage::where('group_id',$request->group_id)->with('user')->where('id','<',$request->last_id)->orderBy('created_at','desc')->limit(20)->get()->reverse();
        $msgs = "";
        if(count($groupmsgs)>0){
            foreach($groupmsgs as $msg){
                if($msg->user_id == auth()->user()->id){
                    $msgs .='<li class="self msg_li" data-msg-id="'.$msg->id.'">
                      <div class="avatar"><img src="https://i.imgur.com/HYcn9xO.png" draggable="false"/></div>
                      <div class="msg">';
                        if($msg->photo!=""){
                            $msgs .='<img src="https://i.imgur.com/QAROObc.jpg" draggable="false"/>';
                        }
                        if($msg->voice!="")  {
                            $vmsg = url('group_voices/'.$msg->voice) ;
                            $msgs .='<audio controls>
                              <source src="'.$vmsg.'" type="audio/mp3">
                              Your browser does not support the audio element.
                            </audio>';
                        }
                        if($msg->file!="")  {
                            $vmsg = url('group_chat/file/'.$msg->group_id.'/'.$msg->file) ;
                            $msgs .='File ('.$msg->file.') <br><a href="'.$vmsg.'" class="btn btn-sm btn-primary" target="_blank">View</a>';
                        }
                        $msgs .= $msg->message;
                        $msgs .='<br><span class="text-sm pull-left">'.$msg->user->name.'</span>';
                        $msgs .='<br><time>'.$this->time_elapsed_string($msg->created_at).'</time>
                      </div>
                    </li>'; 
                } else {
                    $msgs .='<li class="other msg_li" data-msg-id="'.$msg->id.'">
                      <div class="avatar"><img src="https://i.imgur.com/DY6gND0.png" draggable="false"/></div>
                      <div class="msg">';
                        if($msg->photo!=""){
                            $msgs .='<img src="https://i.imgur.com/QAROObc.jpg" draggable="false"/>';
                        }
                        if($msg->voice!="")  {
                            $vmsg = url('group_voices/'.$msg->voice) ;
                            $msgs .='<audio controls>
                              <source src="'.$vmsg.'" type="audio/mp3">
                              Your browser does not support the audio element.
                            </audio>';
                        }
                        if($msg->file!="")  {
                            $vmsg = url('group_chat/file/'.$msg->group_id.'/'.$msg->file) ;
                            $msgs .='File ('.$msg->file.') <br><a href="'.$vmsg.'" class="btn btn-sm btn-primary" target="_blank">View</a>';
                        }
                        $msgs .= $msg->message;
                        $msgs .='<br><span class="text-sm pull-right">'.$msg->user->name.'</span>';
                        $msgs .='<br><time>'.$this->time_elapsed_string($msg->created_at).'</time>
                      </div>
                    </li>';
                }
            }
        } else {
            $msgs = "completed";
        }
        return $msgs;
    }
    
    public function group_remove_member($id,$user_id) {
        $group = ChatGroup::where('join_link',$id)->where('created_by',auth()->user()->id)->first();
        if($group){
            $gmr = ChatGroupRequest::where('group_id',$group->id)->where('user_id',auth()->user()->id)->first();
            if(!$gmr){
                $gmr = ChatGroupRequest();
                $gmr->group_id = $group->id;
                $gmr->user_id = $user_id;
            }
            $gmr->status = 3;
            $gmr->save();
            ChatMember::where('group_id',$group->id)->where('user_id',$user_id)->delete();
        }
        $rt = route('group_details',['id'=>$id]);
        return redirect($rt)->withWarning('User Removed from group');
    }
    
    public function join_group($id) {
        $group = ChatGroup::where('join_link',$id)->with('members')->first();
        $msg = "";
        if($group->type=="0"){
            $check_gm = ChatMember::where('user_id',auth()->user()->id)->where('group_id',$group->id)->first();
            if(!$check_gm){
                $gm = new ChatMember();
                $gm->user_id = auth()->user()->id;
                $gm->group_id = $group->id;
                $gm->user_level = 2;
                //$gm->last_viewed = date('Y-m-d H:i:s');
                $gm->save();
            }
            $msg = "Joined successfully";
        } elseif($group->type=="1"){
            $check_gm = ChatGroupRequest::where('user_id',auth()->user()->id)->where('group_id',$group->id)->where('status',0)->first();
            if(!$check_gm){
                $gmr = new ChatGroupRequest();
                $gmr->group_id = $group->id;
                $gmr->user_id = auth()->user()->id;
                $gmr->status = 0;
                $gmr->save();
            }
            $msg = "Requested to join the group.";
        }
        $rt = route('group_details',['id'=>$id]);
        return redirect($rt)->withSuccess($msg);
    }
    public function join_group_accept($id,$user_id) {
        $group = ChatGroup::where('join_link',$id)->with('members')->where('created_by',auth()->user()->id)->first();
        if($group){
            $gmr = ChatGroupRequest::where('group_id',$group->id)->where('user_id',$user_id)->first();
            $gmr->status = 1;
            $gmr->save();
            $check_gm = ChatMember::where('user_id',$user_id)->where('group_id',$group->id)->first();
            if(!$check_gm){
                $gm = new ChatMember();
                $gm->user_id = $user_id;
                $gm->group_id = $group->id;
                //$gm->last_viewed = date('Y-m-d H:i:s');
                $gm->user_level = 2;
                $gm->save();
            }
            $rt = route('group_details',['id'=>$id]);
            return redirect($rt)->withSuccess('Added to group');
        }
        else {
            
           $rt = route('group_details',['id'=>$id]);
           return redirect($rt)->withWarning('No permission to accept'); 
        }
    }
    public function join_group_reject($id,$user_id) {
        $group = ChatGroup::where('join_link',$id)->with('members')->where('created_by',auth()->user()->id)->first();
        if($group){
            $gmr = ChatGroupRequest::where('group_id',$group->id)->where('user_id',$user_id)->first();
            $gmr->status = 2;
            $gmr->save();
            
            $rt = route('group_details',['id'=>$id]);
            return redirect($rt)->withSuccess('Request declined');
        } else {
            $rt = route('group_details',['id'=>$id]);
           return redirect($rt)->withWarning('No permission to reject'); 
        }
    }
    public function group_dashboard($id) {
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
        $group = ChatGroup::where('join_link',$id)->with('members')->first();
        return view('group_dashboard',compact('group'));
    }
    public function saved_group_answers(Request $request) {
        $id = $request->id;
        $user_id = $request->user_id;
        $questions = ChatGroupSavedAnswer::where('group_id',$id)->where('user_id',$user_id)->with('question')->get();
        $result = "";
        if(count($questions)>0){
            foreach($questions as $eachQn){
                if($eachQn->question){
                    $hisdata = $eachQn->question; 
                    $result .= '<div class="card-header" id="heading'.$hisdata->id.'">
                      <h5 class="mb-0">
                        <button class="text-left" data-toggle="collapse" data-target="#collapse'.$hisdata->id.'" aria-expanded="true" aria-controls="collapse'.$hisdata->id.'">
                          '. $hisdata->question .'
                        </button>
                      </h5>
                    </div>
                
                    <div id="collapse'.$hisdata->id.'" class="collapse" aria-labelledby="heading'.$hisdata->id.'" data-parent="#accordion">
                      <div class="card-body">
                        '.nl2br($hisdata->answer).'
                        <hr>
                      </div>
                    </div>';
                }
            }
        }
        else {
            $result = "No Questions added yet";
        }
        return $result;
    }
    public function group_admin_dashboard($id) {
        $group = ChatGroup::where('join_link',$id)->with('members')->first();
        return view('group_admin_dashboard',compact('group'));
    }
    public function all_group_answers(Request $request) {
        $id = $request->id;
        $user_id = $request->user_id;
        $questions = ChatGroupAllAnswer::where('group_id',$id)->where('user_id',$user_id)->with('question')->get();
        $result = "";
        if(count($questions)>0){
            foreach($questions as $eachQn){
                if($eachQn->question){
                    $hisdata = $eachQn->question; 
                    $result .= '<div class="card-header" id="heading'.$hisdata->id.'">
                      <h5 class="mb-0">
                        <button class="text-left" data-toggle="collapse" data-target="#collapse'.$hisdata->id.'" aria-expanded="true" aria-controls="collapse'.$hisdata->id.'">
                          '. $hisdata->question .'
                        </button>
                      </h5>
                    </div>
                
                    <div id="collapse'.$hisdata->id.'" class="collapse" aria-labelledby="heading'.$hisdata->id.'" data-parent="#accordion">
                      <div class="card-body">
                        '.nl2br($hisdata->answer).'
                        <hr>
                      </div>
                    </div>';
                }
            }
        }
        else {
            $result = "No Questions added yet";
        }
        return $result;
    }
    
    public function update_save_all(Request $request){
        $group = ChatGroup::where('id',$request->group_id)->first();
        if($group){
            $group->save_all = $request->save_all;
            $group->save();
        }
        return response()->json(['status' => 'success', 'result' => 'Settings updated']);
    }
    
    public function share_to_group(Request $request){
        $elements = $request->group_id;
        for($i=0;$i<count($elements);$i++){
            $ans = new ChatGroupSavedAnswer();
            $ans->answer_id	= $request->answer_id;
            $ans->user_id = auth()->user()->id;
            $ans->group_id = $elements[$i];
            $ans->save();
        }
        return response()->json(['status' => 'success', 'result' => 'Shared Successfully']);
    }
    
    
    public function home($slug="") {
        $towns = Genie::inRandomOrder()->limit(100)->get();
        return view('home',compact('towns','slug'));
    }
    public function about(){
        return view('about');
    }
    public function contact(){
        return view('contact');
    }
    public function login_view(){
        return view('login');
    }
    
    public function register_view(){
        return view('user_register');
    }
    
    public function dashboard(){
        return view('dashboard');
    }
    
    public function register_driver_view(){
        return view('driver_register');
    }
    public function password_reset(){
        return view('password_reset');
    }
    public function reset_password(){
        return view('reset_password');
    }
    public function support_developer(){
        return view('support_developer');
    }
    public function download_app(){
        $file= public_path(). "/download/taxi_nearby.apk";
        $headers = array('Content-Type: application/apk',);
        return Response::download($file, 'taxi_nearby.apk', $headers);
    }
    public function send_mail(Request $request){
        $user = new User();
        $user->name = 'Admin';
        $user->message = "<h3><u>Contact Form</u></h3>Name: ".$request->name."<br>Email: ".$request->email."<br>Message: ".$request->message;
        Mail::to('justinjamesrdrgz@gmail.com')->send(new \App\Mail\AskPDFMailCommon($user));
        return response()->json(['status' => 'success', 'result' => 'Message send successfully']);
    } 
  	public function resend_password_otp(Request $request){
      $otp = rand(100000,999999);
      $user = User::where('email',$request->email)->first();
      if($user){
          $user->otp = $otp;
          $user->save();
          $user->message = $otp." is the OTP for password changing";
            Mail::to($user->email)->send(new \App\Mail\AskPDFMailCommon($user));
          return response()->json(['status' => 'success', 'result' => 'OTP send successfully']);
      } else {
         return response()->json(['status' => 'failed', 'result' => 'Incorrect email id']);
      }
      
    }
  	public function verify_password_otp(Request $request){
      $user = User::where('email',$request->email)->first();
      if($user){
          if($request->otp==$user->otp){
              $request->session()->withSuccess('Email Verified Successfully');
              return redirect('taxi');
          } else {
              $request->session()->withWarning('Incorrect OTP');
              return redirect('verify_otp');
          }
      } else {
          $request->session()->withWarning('Incorrect Email ID');
          return redirect('verify_otp');
      }

    }
    
  	public function change_forgot_password(Request $request){
      $user = User::where('id',$request->id)->first();
      $user->password = bcrypt($request->new_password);
      $user->save();
      $request->session()->withSuccess('Password changed successfully');
        return redirect('login');
    }
    
    public function mail_check(){
        $user = User::find(4);
        $user->message = "Test Mail";
        Mail::to('justinjamesrdrgz@gmail.com')->send(new \App\Mail\HDTutoMail($user));
        return view('welcome');
    }
    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email'    => 'required|email',
            'password' => 'required'
        ]);

       if ($validator->fails()) return redirect()->back()->withErrors($validator)->withInput();

        $credentials = $request->only('email', 'password');

        if (Auth::attempt($credentials)) {
            $user             = Auth::user();
            $success['name']  = $user->name;
            $success['email']  = $user->email;
            $success['mobile']  = $user->mobile;
            $success['level']  = $user->level;
            $success['status']  = $user->status;
            $success['token'] = $user->createToken('accessToken')->accessToken;

            return redirect('taxi');
        } else {
            return abort(401);
        }
    }

    /**
     * User registration API method
     *
	 Level- 3 driver
	 Level -2 user
	 Level -1 Admin
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function register(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name'     => 'required',
            'email'    => 'required|email|unique:users',
            'mobile' => 'required|min:10',
            'password' => 'required|min:5'
        ]);

        if ($validator->fails()) return response($validator->messages(), 200);

        try {
            $otp = rand(100000,999999);
            $user = new User();
			$user->name = $request->name;
			$user->email = $request->email;
			$user->password = bcrypt($request->password);
			$user->mobile = $request->mobile;
			$user->level = 2;
			$user->status = 0;
			$user->otp = $otp;
			$user->save();
			
			$user->message = "Your i-Life Genie Account Created Successfully!";
            Mail::to($user->email)->send(new \App\Mail\AskPDFMailCommon($user));
			
			$user->message = $otp." is the OTP for your email verification. Thank you for creating accountin i-Life Genie!";
            Mail::to($user->email)->send(new \App\Mail\AskPDFMailOTP($user));
            
            $success['name']  = $user->name;
            $success['email']  = $user->email;
            $success['mobile']  = $user->mobile;
            $success['level']  = $user->level;
            $success['status']  = $user->status;
            $message          = 'Yay! A user has been successfully created.';
            $success['token'] = $user->createToken('accessToken')->accessToken;
            
            $credentials = $request->only('email', 'password');
            Auth::attempt($credentials);
        } catch (Exception $e) {
            $success['token'] = [];
            $message          = 'Oops! Unable to create a new user.';
        }

        return redirect('taxi');
    }
    
	public function logout(Request $request){
	    Auth::logout();
	    return redirect('/');
    }
  	public function resend_otp(Request $request){
      $id = auth()->user()->id;
      $otp = rand(100000,999999);
      $user = User::where('id',$id)->first();
      $user->otp = $otp;
      $user->save();
      $user->message = $otp." is the OTP for your email verification";
        Mail::to($user->email)->send(new \App\Mail\AskPDFMailOTP($user));
      
      return redirect('verify_otp')->withSuccess('OTP has been sent to your mail!');
      
    }
  	public function verify_otp(Request $request){
      $otp = auth()->user()->otp;
      if($request->otp==$otp){
        $user = User::where('id',auth()->user()->id)->first();
        if($user){
          $user->status=1;
          $user->save();
        
        }
        return redirect('taxi')->withSuccess('Verified SuccessFully');
      }
      return redirect('verify_otp')->withWarning('Incorrect OTP');
    }
	public function nearby_drivers(Request $request){
	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
	    $latitude = auth()->user()->latitude;
	    $longitude = auth()->user()->longitude;
	    $msg = "";
	    $drivers = [];
	    if($latitude=="" || $longitude==""){
	        $msg = "unavailable";
	    } elseif(auth()->user()->level==2) {
		$drivers = User::where('level',3)->where('status',1)->where('available',1)->select('users.*', DB::raw('(3959 * acos(cos(radians('.$latitude.')) * cos(radians(latitude)) * cos(radians(longitude) - radians('.$longitude.')) + sin(radians('.$latitude.')) * sin(radians(latitude)))) AS distance'))->havingRaw('distance <= 10')->orderBy('distance','asc')->get(30);
	    }
		
		return view('my_home',compact('drivers','msg'));
	}
	public function view_driver(Request $request,$id){
	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
		$driver = User::where('id',$id)->first();
		$view = new Files();
		$view->user_id = Auth::user()->id;
		$view->driver_id = $request->id;
		$view->save();
		
		return view('driver',compact('driver'));
	}
	
	public function profile(){
	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
	    return view('profile');
	}
	public function edit_profile(){
	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
	    return view('edit_profile');
	}
	public function update_profile(Request $request){
	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
		$user = User::where('id',Auth::user()->id)->first();
		
		$validator = Validator::make($request->all(), [
			'name'     => 'required',
			'email'    => 'required|email|unique:users',
			'mobile' => 'required|min:10'
		]);
		
		if ($validator->fails()) return response($validator->messages(), 200);
		if($request->email!=$user->email){
			$log = new Log();
			$log->log = "Email changed from ".$user->email." to ".$request->email;
			$log->user_id = Auth::user()->id;
			$log->save();
		}
		if($request->name!=$user->name){
			$log = new Log();
			$log->log = "Name changed from ".$user->name." to ".$request->name;
			$log->user_id = Auth::user()->id;
			$log->save();
		}
		if($request->mobile!=$user->mobile){
			$log = new Log();
			$log->log = "Mobile changed from ".$user->mobile." to ".$request->mobile;
			$log->user_id = Auth::user()->id;
			$log->save();
		}
		$user->name = $request->name;
		$user->email = $request->email;
		$user->mobile = $request->mobile;
		$user->save(); 
		return redirect('profile')->withSuccess('Profile Updated SuccessFully');
	}
	public function change_password_view(){
	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
	    return view('change_password');
	}
  	public function change_password(Request $request){
	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
      $user = User::where('id',auth()->user()->id)->first();
      if (Hash::check($request->old_password, $user->password)) {
        $user->password = bcrypt($request->new_password);
      } else {
          return redirect('verify_otp')->withWarning('Wrong old password');
      }
      $user->save();
      $request->session()->withSuccess('Password changed successfully');
      return redirect('change_password');
    }
    
    public function verify_otp_view(){
        return view('verify_otp');
    }
    
    
    
	//User chats
	
	
    public function members_index(){
        
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
        $groups = [];
        if(auth()->user()->org_code!=""){
            $inusers = ChatMemberMessage::where('user_id',auth()->user()->id)->orWhere('to_id',auth()->user()->id)->select('user_id','to_id')->get();
            $prior = [];
            foreach($inusers as $in){
                $prior[] = $in['user_id'];
                $prior[] = $in['to_id'];
            }
            $prior = array_unique($prior);
            $groups = User::where('org_code',auth()->user()->org_code)->where('users.id','!=',auth()->user()->id)->with('member_msgs')->orderBy(DB::raw('FIELD(id, '.implode(",", $prior).')'),'DESC')->orderBy('name')->get();
        } 
        return view('members',compact('groups'));
    }
    
    public function member_chat($id) {
        $groupmsgs = ChatMemberMessage::where(function($qry) use ($id){
                            $qry->where('user_id',auth()->user()->id)->where('to_id',$id);
                        })->orWhere(function($qry1) use ($id){
                            $qry1->where('user_id',$id)->where('to_id',auth()->user()->id);
                        })->with('user')->orderBy('created_at','desc')->limit(20)->get()->reverse();
        
        ChatMemberMessage::where('to_id', $id)->update(['status' => 1]);
        
        
        
            
        $last_message = ChatMemberMessage::where(function($qry) use ($id){
                            $qry->where('user_id',auth()->user()->id)->where('to_id',$id);
                        })->orWhere(function($qry1) use ($id){
                            $qry1->where('user_id',$id)->where('to_id',auth()->user()->id);
                        })->with('user')->orderBy('created_at','desc')->first();
        
        $to = User::where(function($qry) use ($id){
                            $qry->where('id',auth()->user()->id)->orWhere('id',$id);
                        })->where('id','!=',auth()->user()->id)->first();
        
        $groups = [];
        if(auth()->user()->org_code!=""){
            $inusers = ChatMemberMessage::where('user_id',auth()->user()->id)->orWhere('to_id',auth()->user()->id)->select('user_id','to_id')->get();
            $prior = [];
            foreach($inusers as $in){
                $prior[] = $in['user_id'];
                $prior[] = $in['to_id'];
            }
            $prior = array_unique($prior);
            
            $groups = User::where('org_code',auth()->user()->org_code)->where('users.id','!=',auth()->user()->id)->with('member_msgs')->orderBy(DB::raw('FIELD(id, '.implode(",", $prior).')'),'DESC')->orderBy('name')->get();
        } 
        
        return view('member_chat',compact('groups', 'groupmsgs','id','to','last_message'));
    }
    
    public function send_member_message(Request $request){
        $msg = new ChatMemberMessage();
        $msg->to_id = $request->to_id;
        $msg->user_id = auth()->user()->id;
        $msg->message = $request->message;
        $msg->save();
        
        return response()->json(['status' => 'success', 'result' => 'Shared Successfully']);
    }
    public function send_member_voice_message(Request $request){
        
        $vfile = $request->file('voice');
        $voicefile = auth()->user()->id.rand(100,999).date('YmdHis').rand(100,999).".mp3";
        
        $path = public_path().'/member_chat/voices/'.auth()->user()->id;
		if(!File::exists($path)) {
			File::makeDirectory($path, $mode = 0777, true, true);
		}
		
        $vfile->move($path, $voicefile);
        
        $msg = new ChatMemberMessage();
        $msg->to_id = $request->to_id;
        $msg->user_id = auth()->user()->id;
        $msg->voice = $voicefile;
        $msg->save();
        
        //$group = ChatGroup::where('id',$request->group_id)->first();
        //$group->refreshed = date('Y-m-d H:i:s');
        //$group->save();
        
        $vmsg = url('member_chat/voices/'.auth()->user()->id.'/'.$voicefile) ;
        
        $msgs ='<audio controls>
                              <source src="'.$vmsg.'" type="audio/mp3">
                              Your browser does not support the audio element.
                            </audio>';
        return $msgs;
    }
    public function send_member_attach_message(Request $request){
        
        $attach = $request->file('attachment');
        $fname = $attach->getClientOriginalName();
        $file_ext = explode('.',$fname);
        $ext = strtoupper(end($file_ext));
        
        $path = public_path().'/member_chat/files/'.auth()->user()->id;
		if(!File::exists($path)) {
			File::makeDirectory($path, $mode = 0777, true, true);
		}
        $filename = rand(9999,999999).date('YmdHis').'.'.$ext;
        $attach->move($path, $filename);
        
        
        $msg = new ChatMemberMessage();
        $msg->to_id = $request->to_id;
        $msg->user_id = auth()->user()->id;
        $msg->file = $filename;
        $msg->save();
        
        //$group = ChatGroup::where('id',$request->group_id)->first();
        //$group->refreshed = date('Y-m-d H:i:s');
       // $group->save();
        
        $vmsg = url('member_chat/files/'.auth()->user()->id.'/'.$filename) ;
        
        $msgs ='File ('.$filename.') <br><a href="'.$vmsg.'" class="btn btn-sm btn-primary" target="_blank">View</a>';
        return $msgs;
    }
    
    
    public function loadnew_member_chat(Request $request){
        $id = $request->id;
        $groupmsgs = ChatGroupMessage::where(function($qry) use ($id){
                            $qry->where('user_id',auth()->user()->id)->where('to_id',$id);
                        })->orWhere(function($qry1) use ($id){
                            $qry1->where('user_id',$id)->where('to_id',auth()->user()->id);
                        })->with('user')->where('id','>',$request->last_id)->orderBy('created_at','desc')->limit(20)->get();
        $msgs = "";
        if(count($groupmsgs)>0){
            foreach($groupmsgs as $msg){
                if($msg->user_id == auth()->user()->id){
                    $msgs .='<li class="self msg_li" data-msg-id="'.$msg->id.'">
                      <div class="avatar"><img src="https://i.imgur.com/HYcn9xO.png" draggable="false"/></div>
                      <div class="msg">';
                        if($msg->photo!=""){
                            $msgs .='<img src="https://i.imgur.com/QAROObc.jpg" draggable="false"/>';
                        }
                        if($msg->voice!="")  {
                            $vmsg = url('member_chat/voices/'.$msg->user_id.'/'.$msg->voice) ;
                            $msgs .='<audio controls>
                              <source src="'.$vmsg.'" type="audio/mp3">
                              Your browser does not support the audio element.
                            </audio>';
                        }
                        if($msg->file!="")  {
                            $vmsg = url('member_chat/file/'.$msg->user_id.'/'.$msg->file) ;
                            $msgs .='File ('.$msg->file.') <br><a href="'.$vmsg.'" class="btn btn-sm btn-primary" target="_blank">View</a>';
                        }
                        $msgs .= $msg->message;
                        $msgs .='<br><span class="text-sm pull-left">'.$msg->user->name.'</span>';
                        $msgs .='<br><time>'.$this->time_elapsed_string($msg->created_at).'</time>
                      </div>
                    </li>'; 
                } else {
                    $msgs .='<li class="other msg_li" data-msg-id="'.$msg->id.'">
                      <div class="avatar"><img src="https://i.imgur.com/DY6gND0.png" draggable="false"/></div>
                      <div class="msg">';
                        if($msg->photo!=""){
                            $msgs .='<img src="https://i.imgur.com/QAROObc.jpg" draggable="false"/>';
                        }
                        if($msg->voice!="")  {
                            $vmsg = url('member_chat/voices/'.$msg->user_id.'/'.$msg->voice) ;
                            $msgs .='<audio controls>
                              <source src="'.$vmsg.'" type="audio/mp3">
                              Your browser does not support the audio element.
                            </audio>';
                        }
                        if($msg->file!="")  {
                            $vmsg = url('member_chat/file/'.$msg->user_id.'/'.$msg->file) ;
                            $msgs .='File ('.$msg->file.') <br><a href="'.$vmsg.'" class="btn btn-sm btn-primary" target="_blank">View</a>';
                        }
                        $msgs .= $msg->message;
                        $msgs .='<br><span class="text-sm pull-right">'.$msg->user->name.'</span>';
                        $msgs .='<br><time>'.$this->time_elapsed_string($msg->created_at).'</time>
                      </div>
                    </li>';
                }
            }
        } else {
            $msgs = "completed";
        }
        return $msgs;
    }
    public function loadmore_member_chat(Request $request){
        $id = $request->id;
        $groupmsgs = where(function($qry) use ($id){
                            $qry->where('user_id',auth()->user()->id)->where('to_id',$id);
                        })->orWhere(function($qry1) use ($id){
                            $qry1->where('user_id',$id)->where('to_id',auth()->user()->id);
                        })->with('user')->where('id','<',$request->last_id)->orderBy('created_at','desc')->limit(20)->get()->reverse();
        $msgs = "";
        if(count($groupmsgs)>0){
            foreach($groupmsgs as $msg){
                if($msg->user_id == auth()->user()->id){
                    $msgs .='<li class="self msg_li" data-msg-id="'.$msg->id.'">
                      <div class="avatar"><img src="https://i.imgur.com/HYcn9xO.png" draggable="false"/></div>
                      <div class="msg">';
                        if($msg->photo!=""){
                            $msgs .='<img src="https://i.imgur.com/QAROObc.jpg" draggable="false"/>';
                        }
                        if($msg->voice!="")  {
                            $vmsg = url('group_voices/'.$msg->voice) ;
                            $msgs .='<audio controls>
                              <source src="'.$vmsg.'" type="audio/mp3">
                              Your browser does not support the audio element.
                            </audio>';
                        }
                        if($msg->file!="")  {
                            $vmsg = url('member_chat/file/'.$msg->user_id.'/'.$msg->file) ;
                            $msgs .='File ('.$msg->file.') <br><a href="'.$vmsg.'" class="btn btn-sm btn-primary" target="_blank">View</a>';
                        }
                        $msgs .= $msg->message;
                        $msgs .='<br><span class="text-sm pull-left">'.$msg->user->name.'</span>';
                        $msgs .='<br><time>'.$this->time_elapsed_string($msg->created_at).'</time>
                      </div>
                    </li>'; 
                } else {
                    $msgs .='<li class="other msg_li" data-msg-id="'.$msg->id.'">
                      <div class="avatar"><img src="https://i.imgur.com/DY6gND0.png" draggable="false"/></div>
                      <div class="msg">';
                        if($msg->photo!=""){
                            $msgs .='<img src="https://i.imgur.com/QAROObc.jpg" draggable="false"/>';
                        }
                        if($msg->voice!="")  {
                            $vmsg = url('group_voices/'.$msg->voice) ;
                            $msgs .='<audio controls>
                              <source src="'.$vmsg.'" type="audio/mp3">
                              Your browser does not support the audio element.
                            </audio>';
                        }
                        if($msg->file!="")  {
                            $vmsg = url('member_chat/file/'.$msg->user_id.'/'.$msg->file) ;
                            $msgs .='File ('.$msg->file.') <br><a href="'.$vmsg.'" class="btn btn-sm btn-primary" target="_blank">View</a>';
                        }
                        $msgs .= $msg->message;
                        $msgs .='<br><span class="text-sm pull-right">'.$msg->user->name.'</span>';
                        $msgs .='<br><time>'.$this->time_elapsed_string($msg->created_at).'</time>
                      </div>
                    </li>';
                }
            }
        } else {
            $msgs = "completed";
        }
        return $msgs;
    }
}
