<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Razorpay\Api\Api;
use Session;
use App\Models\Order;
use App\Models\Invoice;
use App\Models\Payment;
use App\Models\Package;
use App\Models\UserPackage;
//use PDF;
use Illuminate\Support\Facades\Mail;

class RazorpayController extends Controller
{
	
    public function pay() {
		//echo "eeeeeeee";
		if(auth()->user() && auth()->user()->status==0){
	        return redirect('verify_otp');
	    }
		$api = new Api ('rzp_live_L8swnuW79yi11c', '8Bo2RgXRDJ1BT9212QgwhEQN');
		$amount = round(session('checkout_amount'));
		//if(auth()->user() && auth()->user()->id==22){
			//$amount = 100;
		//}
		$orderRes = $api->order->create(array('receipt' => date('YmdHis').rand(1111,9999).'999'.session('checkout_order_id'), 'amount' => $amount, 'currency' => 'INR', 'notes'=> array('key1'=> 'value3','key2'=> 'value2')));
		//echo "vvvvvv";
		return view('pay', compact('amount','orderRes'));
	}
    public function store(Request $request) {
		$input = $request->all();
		
		$api = new Api ('rzp_live_L8swnuW79yi11c', '8Bo2RgXRDJ1BT9212QgwhEQN');
		
		if(count($input) && !empty($input['razorpay_payment_id'])) {
			
			//$payment = $api->payment->fetch($input['razorpay_payment_id']);
			$response = $api->payment->fetch($input['razorpay_payment_id']); //session('checkout_amount')
			//print_r($response);
			//mail('justin@lifedflix.com','RZr', json_encode($response));
			$payment = Payment::create([
				'r_payment_id' => $response['id'],
				'method' => $response['method'],
				'order_id' => session('checkout_order_id'),
				'currency' => $response['currency'],
				'user_email' => $response['email'],
				'amount' => $response['amount']/100,
				'json_response' => json_encode((array)$response)
			]);
			$order_id = session('checkout_order_id');
			
			if($response['status']=="captured"){
    			$amount = $response['amount']/100;
    			
    			$order = Order::where('id',$order_id)->first();
    			$order->status = 1;
    			$order->save();
    			
    			$package_id = $order->package;
    			
    			$package = Package::where('id',$package_id)->first();
    			
    			
    			$userpackage = new UserPackage();
    			$userpackage->user_id = auth()->user()->id;
                $userpackage->package_id = $package_id;
                $userpackage->start_date = date('Y-m-d H:i:s');
                $userpackage->end_date	= date('Y-m-d', strtotime('+'.$package->period));
                $userpackage->status = 1;	
                
                $userpackage->order_id	= $order_id;
                $userpackage->page_limit = $package->page_limit;
                $userpackage->user_limit = $package->user_limit;
                $userpackage->question_limit = $package->question_limit;
                
                $userpackage->save();
    			
    			$invoice = new Invoice();
    			$invoice->order_id = session('checkout_order_id');
    			$invoice->amount = $amount;
    			$invoice->save();
		        $msg = '<div class="alert alert-success">Your payment was successfully.</div>';
			} else {
			    $msg = '<div class="alert alert-warning">Payment was unsuccessfully, Please try again!</div>';
			}
			
			
			if(isset($response['email']) && $response['email']!=""){
				//self::send_message($response,session('checkout_order_id'));
			}
		}
		session(['checkout_amount' => '']);
		session(['checkout_order_id' => '']);
		session(['checkout_name' => '']);
		session(['checkout_email' => '']);
        return view('response', compact('msg'));
	}
	public function send_message($response,$orderid){
		//use Illuminate\Support\Facades\Mail;
		$to = [$response['email']];
        if(auth()->user()){
            if($response['email']!=auth()->user()->email){
                $to = [auth()->user()->email,$response['email']];
            } 
        }
		$order = Order::where('id',$orderid)->with('address_data')->first();
		$data = array(
            'subject' => 'Your order is successfully placed',
            'type' => 'order_placed',
            'response' => $response,
            'order' => $order,
        );
		Mail::to($to)->send(new MailController($data));
	}
}
