<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Files;
use App\Models\Log;
use App\Models\Genie;
use App\Models\UserPackage;
use App\Models\Package;
use App\Models\CouponCode;
use App\Models\Order;
use App\Models\UserSession;
use App\Models\Contest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Exception;
use DB;
use Mail;
use Hash;
use Response;
use Session;
use Razorpay\Api\Api;
use Socialite;
use App\Models\UsersJob;
use App\Models\Organisation;
use App\Models\OrganisationUser;

class UserController extends Controller
{
    /**
     * User login API method
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
    */
    
    public function login_view(){
        $currsiteurl = $_SERVER['HTTP_HOST'];
            
        if(auth()->user()){
	        return redirect('files');
	    }
        return view('login');
    }
    public function register_view(){
        return view('user_register');
    }
    public function contest(){
        return view('contest');
    }
    
    public function password_reset(){
        return view('password_reset');
    }
    public function reset_password(){
        return view('reset_password');
    }
    public function send_mail(Request $request){
        $user = new User();
        $user->name = 'Admin';
        $user->message = "<h3><u>Contact Form</u></h3>Name: ".$request->name."<br>Email: ".$request->email."<br>Message: ".$request->message;
        Mail::to('justinjamesrdrgz@gmail.com')->send(new \App\Mail\AskPDFMailCommon($user));
        return response()->json(['status' => 'success', 'result' => 'Message send successfully']);
    }
  	public function resend_password_otp(Request $request){
      $otp = rand(100000,999999);
      $user = User::where('email',$request->email)->first();
      if($user){
          $user->otp = $otp;
          $user->save();
          $user->message = $otp." is the OTP for password changing";
            Mail::to($user->email)->send(new \App\Mail\AskPDFMailCommon($user));
          return response()->json(['status' => 'success', 'result' => 'OTP send successfully']);
      } else {
         return response()->json(['status' => 'failed', 'result' => 'Incorrect email id']);
      }
      
    }
  	public function verify_password_otp(Request $request){
      $user = User::where('email',$request->email)->first();
      if($user){
          if($request->otp==$user->otp){
              return redirect('/')->withSuccess('Email Verified Successfully');
          } else {
              return redirect('verify_otp')->withWarning('Incorrect OTP');
          }
      } else {
          return redirect('verify_otp')->withWarning('Incorrect Email ID');
      }

    }
    
  	public function change_forgot_password(Request $request){
  	    $user = User::where('email',$request->email)->first();
  	    if($user){
          if($request->otp==$user->otp){
              $user->password = bcrypt($request->new_password);
              $user->save();
              return redirect('login')->withSuccess('Password Changed Successfully');
          } else {
              return redirect('change_password')->withWarning('Incorrect OTP');
          }
      } else {
          return redirect('change_password')->withWarning('Incorrect Email ID');
      }
    }
    
    public function mail_check(){
        $user = User::find(4);
        $user->message = "Test Mail";
        Mail::to('justinjamesrdrgz@gmail.com')->send(new \App\Mail\AskPDFMailCommon($user));
        return view('welcome');
    }
    public function login(Request $request)
    {
		$html_brand = config('app.api_url').'login';
		$ch = curl_init();

		$options = array(
			CURLOPT_URL            => $html_brand,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_HEADER         => true,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_ENCODING       => "",
			CURLOPT_AUTOREFERER    => true,
			CURLOPT_CONNECTTIMEOUT => 120,
			CURLOPT_TIMEOUT        => 120,
			CURLOPT_MAXREDIRS      => 10,
		);
		curl_setopt_array( $ch, $options );
		$response = curl_exec($ch); 
		$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

		if ( $httpCode != 200 ){
			echo "Return code is {$httpCode} \n"
				.curl_error($ch);
		} else {
			echo "<pre>".htmlspecialchars($response)."</pre>";
		}

		curl_close($ch);
		exit;
		
		
		
        $curlHandle = curl_init(config('app.api_url').'login');
	    
        $header = array(
		    'Content-Type: application/json'
		);
		//$cFile = curl_file_create(public_path('voices/'.$voicefile), $voicefile);
		curl_setopt($curlHandle, CURLOPT_HEADER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $_POST);
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		print_r($response);
		$result =  json_decode($response,true);
		echo $httpcode."-<br>-aaaaaaaaaa-<pre>";
		curl_close($curlHandle);
        //if ($result['status']=="success") {
        //    Session::put('genie_token', $result['result']);
        //    return redirect('files');
        //} else {
		//	return redirect('login')->withWarning('Invalid Login');
        //}
    }

     
    public function generate_referrer_id($id){
        $my_referrer_id = strtoupper(substr(md5(microtime()),rand(0,26),3).$id.substr(md5(microtime()),rand(0,26),3));
        $exist = User::where('my_referrer_id',$my_referrer_id)->first();
        if($exist){
            $this->generate_referrer_id($id);
        } else {
            $user = User::where('id',$id)->first();
            $user->my_referrer_id = $my_referrer_id;
            $user->save();
        }
    } 
    public function register(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name'     => 'required|max:30',
            'level'     => 'required',
            'subscription_type'     => 'required',
            'email'    => 'required|email|unique:users',
            'mobile' => 'required|min:10',
            'password' => 'required|min:5'
        ]);
        
        if ($validator->fails()) {
            return redirect('register')->withWarning($validator->messages());
        }
        $currsiteurl = $_SERVER['HTTP_HOST'];
        if($currsiteurl=="corporategenie.ai"){
            if($request->account_type=="corporate"){
               $validator = Validator::make($request->all(), [
                    'org_code' => 'required|exists:organisations,code',
                ]); 
                if ($validator->fails()) {
                    return redirect('register')->withWarning($validator->messages());
                }
            }
        }
        
        
        $otp = rand(100000,999999);
        $user = new User();
		$user->name = $request->name;
		$user->email = $request->email;
		$user->password = bcrypt($request->password);
		$user->mobile = $request->mobile;
		$user->level = $request->level;
		$user->status = $request->level==7?1:0;
		$user->referral = $request->referral?$request->referral:'';
		
		$user->otp = $otp;
		$user->save();
		/*
		if($user->level=="4"){
		    $role = "Student";
		} elseif($user->level=="5"){
		    $role = "Teacher";
		} elseif($user->level=="1"){
		    $role = "Admin";
		} else {
		    $role = "Others";
		}
		
		
		$curlHandle = curl_init('https://identitytoolkit.googleapis.com/v1/accounts:signUp?key=AIzaSyBa5iWnI0dUsp-EgZzmUtgAC0XcZx9nLOw');
	    
        $header = array(
		    'Content-Type: application/json'
		);
		$postJson = array(
		            "email" => $user->email,
		            "password" => $request->password,
		            "returnSecureToken"=>true
		            );
		curl_setopt($curlHandle, CURLOPT_HEADER, false);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, json_encode($postJson));
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
		curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);

		$response = curl_exec($curlHandle);
		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
		$result =  json_decode($response, true);
		
		$uid = $result['localId'];
		
		$postParameter = array(
            'doc' => $uid,
            'username' => $request->name,
            'email' => $request->email,
            'telephone' => $request->mobile,
            'role' => $role
        );
        
        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/insertfirebase');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
    	//curl_setopt($curlHandle, CURLOPT_HEADER, true);
    	curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
    	curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
    
    	$response = curl_exec($curlHandle);
    	$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
    	curl_close($curlHandle); 
		
		
		*/
		
		$this->generate_referrer_id($user->id); 
		
		if($request->subscription_type=="10" || $request->subscription_type=="11"){
		    $package = new UserPackage();
		    $package->package_id = 10;
		    $package->user_id = $user->id;
		    $package->order_id = 0;
		    $package->page_limit = 0;
		    $package->user_limit = 0;
		    $package->start_date = date('Y-m-d');
		    $package->end_date = date('Y-m-d',(strtotime('+ 7 days')));
		    $package->save();
		} elseif($request->subscription_type=="20" || $request->subscription_type=="21"){
		    $package = new UserPackage();
		    $package->package_id = 20;
		    $package->user_id = $user->id;
		    $package->order_id = 0;
		    $package->page_limit = 0;
		    $package->user_limit = 0;
		    $package->start_date = date('Y-m-d');
		    $package->end_date = date('Y-m-d',(strtotime('+ 15 days')));
		 } elseif($request->subscription_type=="30" || $request->subscription_type=="31"){
		    $package = new UserPackage();
		    $package->package_id = 30;
		    $package->user_id = $user->id;
		    $package->order_id = 0;
		    $package->page_limit = 0;
		    $package->user_limit = 0;
		    $package->start_date = date('Y-m-d');
		    $package->end_date = date('Y-m-d',(strtotime('+ 15 days')));
		    $package->save();
		} elseif($request->subscription_type=="40" || $request->subscription_type=="41"){
		    $package = new UserPackage();
		    $package->package_id = 40;
		    $package->user_id = $user->id;
		    $package->order_id = 0;
		    $package->page_limit = 0;
		    $package->user_limit = 0;
		    $package->start_date = date('Y-m-d');
		    $package->end_date = date('Y-m-d',(strtotime('+ 1 month')));
		    $package->save();
		}
        
        /*
		$user->message = "Your i-Life Genie Account Created Successfully!";
        Mail::to($user->email)->send(new \App\Mail\AskPDFMailCommon($user));
		
		$user->message = $otp." is the OTP for your email verification. Thank you for creating accountin i-Life Genie!";
        Mail::to($user->email)->send(new \App\Mail\AskPDFMailOTP($user));
       
        */
        
        $uj = new UsersJob();
        $uj->user_id = $user->id;
        $uj->password = $request->password;
        $uj->status = 0;
        $uj->save();
        
        $credentials = $request->only('email', 'password');

        if (Auth::attempt($credentials)) {
            if($request->subscription_type=="2" || $request->subscription_type=="3" || $request->subscription_type=="4" || $request->subscription_type=="6" || $request->subscription_type=="8"){
                return redirect('pricings');
            } else {
                return redirect('files');
            }
        }
        
    }
    
	public function logout(Request $request){
	    Auth::logout();
	    return redirect('/');
    }
	public function deactivate(Request $request){
	    $user = User::where('id',auth()->user()->id)->first();
        if($user){
          $user->status=2;
          $user->save();
        }
	    Auth::logout();
	    return redirect('/');
    }
  	public function resend_otp_activate(Request $request){
      $id = auth()->user()->id;
      $otp = rand(100000,999999);
      $user = User::where('id',$id)->first();
      $user->otp = $otp;
      $user->save();
      $user->message = $otp." is the OTP for reactivate your account";
      
      Mail::to($user->email)->send(new \App\Mail\AskPDFMailOTP($user));
      
      return redirect('verify_otp')->withSuccess('OTP has been sent to your mail!');
      
    }
  	public function resend_otp(Request $request){
      $id = auth()->user()->id;
      $otp = rand(100000,999999);
      $user = User::where('id',$id)->first();
      $user->otp = $otp;
      $user->save();
      
      $user->message = $otp." is the OTP for your email verification";  
      
        Mail::to($user->email)->send(new \App\Mail\AskPDFMailOTP($user));
      
      return redirect('verify_otp')->withSuccess('OTP has been sent to your mail!');
      
    }
  	public function verify_otp(Request $request){
      $otp = auth()->user()->otp;
      if($request->otp==$otp){
        $user = User::where('id',auth()->user()->id)->first();
        if($user){
          $user->status=1;
          $user->save();
        
        }
        return redirect('/')->withSuccess('Verified SuccessFully');
      }
      return redirect('verify_otp')->withWarning('Incorrect OTP');
    }
	public function profile(){
	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
	    if(auth()->user()->level!="1"){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return redirect('pricings')->withWarning('Please choose a plan to continue');
            }
	    }
	    return view('profile');
	}
	public function edit_profile(){
	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
	    
	    if(auth()->user()->level!="1"){
    	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
            if(!$mypackage){
                return redirect('pricings')->withWarning('Please choose a plan to continue');
            }
	    }
	    return view('edit_profile');
	}
	public function update_profile(Request $request){
	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
		$user = User::where('id',Auth::user()->id)->first();
		
		$validator = Validator::make($request->all(), [
			'name'     => 'required',
			'email'    => 'required|email|unique:users',
			'mobile' => 'required|min:10'
		]);
		
		if ($validator->fails()) return response($validator->messages(), 200);
		if($request->email!=$user->email){
			$log = new Log();
			$log->log = "Email changed from ".$user->email." to ".$request->email;
			$log->user_id = Auth::user()->id;
			$log->save();
		}
		if($request->name!=$user->name){
			$log = new Log();
			$log->log = "Name changed from ".$user->name." to ".$request->name;
			$log->user_id = Auth::user()->id;
			$log->save();
		}
		if($request->mobile!=$user->mobile){
			$log = new Log();
			$log->log = "Mobile changed from ".$user->mobile." to ".$request->mobile;
			$log->user_id = Auth::user()->id;
			$log->save();
		}
		$user->name = $request->name;
		$user->email = $request->email;
		$user->mobile = $request->mobile;
		$user->save(); 
		return redirect('profile')->withSuccess('Profile Updated SuccessFully');
	}
	public function change_password_view(){
	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
	    return view('change_password');
	}
  	public function change_password(Request $request){
	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
      $user = User::where('id',auth()->user()->id)->first();
      if (Hash::check($request->old_password, $user->password)) {
        $user->password = bcrypt($request->new_password);
      } else {
          return redirect('verify_otp')->withWarning('Wrong old password');
      }
      $user->save();
      return redirect('change_password')->withSuccess('Password changed successfully');
    }
    
    public function verify_otp_view(){
        return view('verify_otp');
    }
  
  	public function pricings(){
  	    if(!auth()->user()){
      	    return redirect('login');
      	}
  	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
	    $mypackage = UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->where('end_date','>=',date("Y-m-d"))->orderBy('start_date','desc')->first();
	    
  	    $free_package = Package::where('id',51)->first();
  	    $premium_package = Package::where('id',50)->first();
  	    
  	    $all_packages = Package::where('status',1)->where('level',auth()->user()->level==1?2:auth()->user()->level)->orderby('price','asc')->get();
  	    
  	    /*$free_package3 = Package::where('id',20)->first();
  	    $free_package4 = Package::where('id',30)->first();
  	    
  	    $regular_packages = Package::where('level',2)->where('id','!=','1')->get();
  	    $law_packages = Package::where('level',3)->where('id','!=','10')->get();
  	    $student_packages = Package::where('level',4)->where('id','!=','20')->get();
  	    $teacher_packages = Package::where('level',5)->where('id','!=','30')->get();*/
  	    session(['applied_coupon' => '']);
        return view('pricings', compact('free_package','premium_package','mypackage','all_packages'));
    }
  	public function checkout(Request $request){
  	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
  	    $package_id = $request->package;
  	    
  	    $package = Package::where('id',$package_id)->first();
  	    if($package){
  	        
            $ip = $_SERVER['REMOTE_ADDR'];
            $details = json_decode(file_get_contents("http://ipinfo.io/{$ip}/json"));
            $mycountry = $details->country; 
            
            if($mycountry!="IN"){
                $price = $package->price_usd;
                $curr = "USD";
            } else {
                $price = $package->price;
                $curr = "INR";
            }
            
    		
    		$applied_coupon = session('applied_coupon');
    		$coupon = CouponCode::where('code',$applied_coupon)->where('status',1)->first();
            if($coupon){
                session(['applied_coupon' => $coupon]);
                $status = "success";
                $price = (($price)-(($price)*($coupon->off_percent/100)));
            }
            
            
  	        $order = new Order();
  	        $order->user_id = auth()->user()->id;
  	        $order->amount = $price;
  	        $order->package = $package_id;
  	        $order->billing_address = $request->address?$request->address:'';
  	        $order->response = '';
  	        $order->status = 0;
  	        $order->coupon = $applied_coupon;
  	        $order->save();
  	        $amount = round($price*100);
  	        if($price<1){
  	            
  	            $userpackage = new UserPackage();
    			$userpackage->user_id = auth()->user()->id;
                $userpackage->package_id = $package_id;
                $userpackage->start_date = date('Y-m-d H:i:s');
                $userpackage->end_date	= date('Y-m-d', strtotime('+'.$package->period));
                $userpackage->status = 1;	
                
                $userpackage->coupon = $applied_coupon;
                
                $userpackage->order_id	= $order->id;
                $userpackage->page_limit = $package->page_limit;
                $userpackage->user_limit = $package->user_limit;
                $userpackage->question_limit = $package->question_limit;
                
                $userpackage->save();
  	            
  	            return redirect('profile')->withSuccess('Your subscription was successful!');
  	        } else {
        	    $api = new Api ('rzp_live_L8swnuW79yi11c', '8Bo2RgXRDJ1BT9212QgwhEQN');
        		$orderRes = $api->order->create(array('receipt' => date('YmdHis').rand(100,9999).'458'.$order->id, 'amount' => $amount, 'currency' => $curr, 'notes'=> array('key1'=> 'value3','key2'=> 'value2')));
        		
          	    session(['checkout_amount' => $amount]);
        		session(['checkout_order_id' => $order->id]);
        		session(['checkout_name' => $request->name?$request->name:auth()->user()->name]);
        		session(['checkout_email' => $request->email?$request->name:auth()->user()->email]);
        		
        		return view('checkout', compact('amount','orderRes'));
  	        }
    		
  	    } else {
            return redirect('pricings');
  	    }
    }
    
    public function apply_coupon(Request $request){
        $coupon = CouponCode::where('code',$request->coupon_code)->where('status',1)->first();
        
        
        $used_count = UserPackage::where('coupon',$request->coupon_code)->where('status',1)->count();
        $limitexceeds = false;
        if($coupon->count_limit>0){
            if($used_count >= $coupon->count_limit){
                session(['applied_coupon' => '']);
                $status = "danger";
                $result = "Coupon limit exceeds";
                $limitexceeds = true;
            }
        }
        if(!$limitexceeds){
            $package = Package::where('id',$request->id)->first();
            if($coupon){
                session(['applied_coupon' => $request->coupon_code]);
                $status = "success";
                $ip = $_SERVER['REMOTE_ADDR'];
                $details = json_decode(file_get_contents("http://ipinfo.io/{$ip}/json"));
                $mycountry = $details->country; 
                if($mycountry!="IN"){
                    $final = (($package->price_usd)-(($package->price_usd)*($coupon->off_percent/100)));
                    $final_amount = "$".($final);
                } else {
                    $final = (($package->price)-(($package->price)*($coupon->off_percent/100)));
                    $final_amount = "Rs.".($final);
                }
                
                $result = "Coupon code applied successfully, The discounted price will be ".$final_amount;
            } else {
                session(['applied_coupon' => '']);
                $status = "danger";
                $result = "Invalid coupon code";
            }
        }
        return response()->json(['status' => $status, 'result' => $result]);
    }
    
    public function update_referrer_id(Request $request){
        
        $exist = User::where('my_referrer_id',$request->my_referrer_id)->first();
        if($exist){
            return redirect('profile')->withWarning('Referrer ID you entered is already taken. Try new one!');
        } else {
            $user = User::where('id',auth()->user()->id)->first();
            $user->my_referrer_id = $request->my_referrer_id;
            $user->save();
            return redirect('profile')->withSuccess('Your Referrer ID updated successfully!');
        }
    }
  	public function pay(){
  	    if(auth()->user()->status!="1"){
	        return redirect('verify_otp');
	    }
  	    if(auth()->user()->level=="0"){
	        return redirect('update_type');
	    }
        return view('checkout');
    }
    public function change_chat_model(Request $request){
        $user = User::where('id',Auth::user()->id)->first();
        $user->chat_model = $request->model;
        $user->save();
        return response()->json(['status' => 'success', 'result' => 'Chat model changed successfully']);
    }
	public function redirect($provider)
    {
     return Socialite::driver($provider)->redirect();
    }
    public function Callback($provider)
    {
        $userSocial =   Socialite::driver($provider)->user();
        if($userSocial){
            $users       =   User::where(['email' => $userSocial->getEmail()])->first();
            if($users){
                Auth::login($users);
                return redirect('/');
            }else{
                //return redirect('login')->withWarning('Invalid Login');
                
                $otp = rand(100000,999999);
                $user = new User();
        		$user->name = $userSocial->getName();
        		$user->email = $userSocial->getEmail();
        		$user->password = bcrypt($otp.rand(100,999));
        		$user->mobile = "";
        		$user->level = 0;
        		$user->status = 1;
        		$user->otp = $otp;
        		$user->save();
        		
        		$users = User::where(['email' => $user->email])->first();
        		Auth::login($users);
        		return redirect('/');
        		
            }
		
        } else{
            echo "error";
        }
    }
    
    public function edit_user_type(Request $request){
	    return view('user_type');
    }
    
    public function update_user_type(Request $request){
	    $id = auth()->user()->id;
        $user = User::where('id',$id)->first();
        $user->level = $request->level;
        if($request->level==7){
            $user->status = 1; 
        }
        $user->save();
        
        if($request->subscription_type=="10" || $request->subscription_type=="11"){
		    $package = new UserPackage();
		    $package->package_id = 10;
		    $package->user_id = $user->id;
		    $package->order_id = 0;
		    $package->page_limit = 0;
		    $package->user_limit = 0;
		    $package->start_date = date('Y-m-d');
		    $package->end_date = date('Y-m-d',(strtotime('+ 7 days')));
		    $package->save();
		} elseif($request->subscription_type=="20" || $request->subscription_type=="21"){
		    $package = new UserPackage();
		    $package->package_id = 20;
		    $package->user_id = $user->id;
		    $package->order_id = 0;
		    $package->page_limit = 0;
		    $package->user_limit = 0;
		    $package->start_date = date('Y-m-d');
		    $package->end_date = date('Y-m-d',(strtotime('+ 15 days')));
		 } elseif($request->subscription_type=="30" || $request->subscription_type=="31"){
		    $package = new UserPackage();
		    $package->package_id = 30;
		    $package->user_id = $user->id;
		    $package->order_id = 0;
		    $package->page_limit = 0;
		    $package->user_limit = 0;
		    $package->start_date = date('Y-m-d');
		    $package->end_date = date('Y-m-d',(strtotime('+ 15 days')));
		    $package->save();
		} elseif($request->subscription_type=="40" || $request->subscription_type=="41"){
		    $package = new UserPackage();
		    $package->package_id = 40;
		    $package->user_id = $user->id;
		    $package->order_id = 0;
		    $package->page_limit = 0;
		    $package->user_limit = 0;
		    $package->start_date = date('Y-m-d');
		    $package->end_date = date('Y-m-d',(strtotime('+ 1 month')));
		    $package->save();
		}
		
	    return redirect('/');
    }
    
    public function get_deactivated_users(){
        $users = Users::where('status','!=','1')->get();
        
        $user = new User();
        $user->email = "justin@lifedflix.com";
        $user->message = $users." is result";  
      
        Mail::to($user->email)->send(new \App\Mail\AskPDFMailOTP($user));
    }
    
    //admin functions
    
    public function coupons(){
        if(auth()->user()->level!="1"){
	        abort(404);
	    }
        $coupons =   CouponCode::orderby('id','desc')->paginate(10); 
        return view('admin/coupons',compact('coupons'));
    }
    public function referrals(){
        if(auth()->user()->level!="1"){
	        abort(404);
	    }
        $referrals =   DB::table('users AS u1')
                                ->selectRaw('COUNT(u2.referral) AS referral_count, u1.name, u1.my_referrer_id')
                                ->leftJoin('users AS u2','u1.my_referrer_id','u2.referral')
                                ->whereNotNull('u1.my_referrer_id')
                                ->whereNotNull('u2.referral')
                                ->groupBy('u2.referral','u1.name', 'u1.my_referrer_id')
                                ->get(); 
        return view('referral_report',compact('referrals'));
    }
    public function change_coupon_status(Request $request){
        if(auth()->user()->level!="1"){
	        abort(404);
	    }
        $coupon =   CouponCode::where('id',$request->id)->first();
        $coupon->status = $request->status;
        $coupon->save();
        return redirect('admin/coupons')->withSuccess('Coupon status updated successfully');
    }
    public function update_coupon(Request $request){
        if(auth()->user()->level!="1"){
	        abort(404);
	    }
        $coupon =   CouponCode::where('id',$request->id)->first();
        $coupon->off_percent = $request->off_percent;
        $coupon->count_limit = $request->count_limit;
        $coupon->save();
        return redirect('admin/coupons')->withSuccess('Coupon updated successfully');
    }
    public function add_coupon(Request $request){
        if(auth()->user()->level!="1"){
	        abort(404);
	    }
        $coupon =   new CouponCode(); 
        $coupon->code = $request->code;
        $coupon->off_percent = $request->off_percent;
        $coupon->count_limit = $request->count_limit;
        $coupon->save();
        return redirect('admin/coupons')->withSuccess('Coupon added successfully');
    }
    
    
    
    //organisation
    
    public function organisations(){
        if(auth()->user()->level!="1"){
	        abort(404);
	    }
        $organisations =   Organisation::orderby('id','desc')->paginate(10); 
        return view('admin/organisations',compact('organisations'));
    }
    public function change_organisation_status(Request $request){
        if(auth()->user()->level!="1"){
	        abort(404);
	    }
	    
        $organisation =   Organisation::where('id',$request->id)->first();
        $organisation->status = $request->status;
        $organisation->save();
        return redirect('admin/organisations')->withSuccess('Organisation status updated successfully');
    }
    public function update_organisation(Request $request){
        if(auth()->user()->level!="1"){
	        abort(404);
	    }
        $organisation =   Organisation::where('id',$request->id)->first();
        $organisation->name = $request->name;
        $organisation->branch = $request->branch;
        $organisation->city = $request->city;
        $organisation->no_of_users = $request->no_of_users;
        $organisation->save();
        return redirect('admin/organisations')->withSuccess('Organisation updated successfully');
    }
    public function add_organisation(Request $request){
        if(auth()->user()->level!="1"){
	        abort(404);
	    }
        $organisation =   new Organisation(); 
        $organisation->name = $request->name;
        $organisation->code = $request->code;
        $organisation->branch = $request->branch;
        $organisation->city = $request->city;
        $organisation->no_of_users = $request->no_of_users;
        $organisation->save();
        return redirect('admin/organisations')->withSuccess('Organisation added successfully');
    }
    public function organisation_admins($id){
        if(auth()->user()->level!="1"){
	        abort(404);
	    }
        $organisations =   OrganisationUser::where('org_id',$id)->with('user')->orderby('id','desc')->paginate(10); 
        return view('admin/organisation_admin',compact('organisations','id'));
    }
    public function change_org_admin_status(Request $request){
        if(auth()->user()->level!="1"){
	        abort(404);
	    }
	    
        $organisation =   OrganisationUser::where('user_id',$request->id)->first();
        $organisation->status = $request->status;
        $organisation->save();
        return redirect('admin/organisations')->withSuccess('Organisation user status updated successfully');
    }
    public function organisation_users(){
        if(auth()->user()->level!="11"){
	        abort(404);
	    }
	    $organisation =   OrganisationUser::with('org')->where('user_id',auth()->user()->id)->first();
        $organisations =   User::where('org_code',$organisation->org->code)->orderby('id','desc')->paginate(10); 
        return view('admin/organisation_users',compact('organisations'));
    }
    public function remove_org_user($id){
        $organisation =   User::where('id',$id)->first();
        $organisation->org_code = "";
        $organisation->save();
        return redirect('organisation/users')->withSuccess('User removed successfully');
    }
    public function add_organisation_admin(Request $request,$id){
        if(auth()->user()->level!="1"){
	        abort(404);
	    }
	    
	    $organisation =   Organisation::where('id',$id)->first();
        $otp = rand(100000,999999);
        $user = new User();
		$user->name = $request->name;
		$user->email = $request->email;
		$user->password = bcrypt($request->password);
		$user->mobile = $request->mobile;
		$user->level = 11;
		$user->status = $request->level==7?1:0;
		$user->referral = $request->referral?$request->referral:'';
		$user->org_code = $organisation->code;
		
		$user->otp = $otp;
		$user->save();
		
		$this->generate_referrer_id($user->id); 
		
        $uj = new UsersJob();
        $uj->user_id = $user->id;
        $uj->password = $request->password;
        $uj->status = 0;
        $uj->save();
        
        $org_user = new OrganisationUser();
        $org_user->org_id = $id;
        $org_user->user_id = $user->id;
        $org_user->start_date = date('Y-m-d');
        $org_user->end_date = $request->end_date;
        $org_user->save();
        
        return redirect('admin/organisations')->withSuccess('Organisation added successfully');
    }
    public function add_organisation_user(Request $request){
        if(auth()->user()->level!="11"){
	        abort(404);
	    }
	    $uorganisation =   OrganisationUser::with('org')->where('user_id',auth()->user()->id)->first();
	    $organisation =   Organisation::where('id',$request->org_id)->first();
        $otp = rand(100000,999999);
        $user = new User();
		$user->name = $request->name;
		$user->email = $request->email;
		$user->password = bcrypt($request->password);
		$user->mobile = $request->mobile;
		$user->level = 10;
		$user->status = $request->level==7?1:0;
		$user->referral = $request->referral?$request->referral:'';
		$user->org_code = $organisation?$organisation->code:$uorganisation->org->code;
		$user->parent = auth()->user()->id;
		
		$user->otp = $otp;
		$user->save();
		
		$this->generate_referrer_id($user->id); 
		
        $uj = new UsersJob();
        $uj->user_id = $user->id;
        $uj->password = $request->password;
        $uj->status = 0;
        $uj->save();
        
        // $org_user = OrganisationUser();
        // $org_user->org_id = $request->org_id;
        // $org_user->user_id = $user->id;
        // $org_user->start_date = date('Y-m-d');
        // $org_user->end_date = $request->end_date;
        // $org_user->save();
        
        return redirect('organisation/users')->withSuccess('Organisation added successfully');
    }
    //--------------
    
    public function update_user_to_firebase(Request $request){
        
        if(isset($_POST['entries'])){
            $entries = json_decode($_POST['entries'], true);
            
            $email_id = $entries['mf-email'];
            $referral_id = $entries['mf-referral-id'];
            $user = User::where('my_referrer_id',trim($referral_id))->where('email',trim($email_id))->first();
            if($user){

                $postParameter = array(
                    'doc' => md5($referral_id.$email_id),
                    'theme' => $entries['mf-image-select'],
                    'username' => $entries['mf-listing-fname'].' '.$entries['mf-listing-lname'],
                    'email' => $entries['mf-email'],
                    'telephone' => $entries['mf-telephone'],
                    'dob' => $entries['mf-date-of-birth'],
                    'school_college' => $entries['mf-school-college'],
                    'city' => $entries['mf-city'],
                    'area' => $entries['mf-area'],
                    'referral' => $entries['mf-referral-id']
                );
                
                $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/updatefirebase');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
            	//curl_setopt($curlHandle, CURLOPT_HEADER, true);
            	curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
            	curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
            
            	$response = curl_exec($curlHandle);
            	$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
            	curl_close($curlHandle); 
            	
            	//$httpcode = $this->update_user_to_firebase_py($entries);
            	
                $contest =   new Contest(); 
                $contest->user_id = $user->id;
                $contest->response = json_encode($entries);
                $contest->response_status = $httpcode;
                $contest->save();
            	
            	return $response;
            } else {
                $contest =   new Contest(); 
                $contest->user_id = 0;
                $contest->response = json_encode($entries);
                $contest->response_status = 0;
                $contest->save();
            }
        } else {
            $contest =   new Contest(); 
            $contest->user_id = 0;
            $contest->response = json_encode($_POST);
            $contest->response_status = 0;
            $contest->save();
        }
        
    }
    
    public function update_pendinguser_to_firebase($ref){
        $user = User::where('my_referrer_id',trim($ref))->first();
        $cont = Contest::where('user_id',$user->id)->first();
        
        $entries = json_decode($cont->response, true);
        $email_id = $entries['mf-email'];
        $referral_id = $entries['mf-referral-id'];
        $postParameter = array(
            'doc' => md5($referral_id.$email_id),
            'theme' => $entries['mf-image-select'],
            'username' => $entries['mf-listing-fname'].' '.$entries['mf-listing-lname'],
            'email' => $entries['mf-email'],
            'telephone' => $entries['mf-telephone'],
            'dob' => $entries['mf-date-of-birth'],
            'school_college' => $entries['mf-school-college'],
            'city' => $entries['mf-city'],
            'area' => $entries['mf-area'],
            'referral' => $entries['mf-referral-id']
        );
        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/updatefirebase');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
    	//curl_setopt($curlHandle, CURLOPT_HEADER, true);
    	curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
    	curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
    
    	$response = curl_exec($curlHandle);
    	$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
    	curl_close($curlHandle); 
    	
    	//$httpcode = $this->update_user_to_firebase_py($entries);
    	
        $cont->description = $response;
        $cont->save();
    	
    	return $response;
    }
    
    public function update_user_to_firebase_py($entries){
        $email_id = $entries['mf-email'];
        $referral_id = $entries['mf-referral-id'];
        $postParameter = array(
            'doc' => md5($referral_id.$email_id),
            'theme' => $entries['mf-image-select'],
            'username' => $entries['mf-listing-fname'].' '.$entries['mf-listing-lname'],
            'email' => $entries['mf-email'],
            'telephone' => $entries['mf-telephone'],
            'dob' => $entries['mf-date-of-birth'],
            'school_college' => $entries['mf-school-college'],
            'city' => $entries['mf-city'],
            'area' => $entries['mf-area'],
            'referral' => $entries['mf-referral-id']
        );
        $user = User::where('my_referrer_id',trim($referral_id))->where('email',trim($email_id))->first();
        $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/insertfirebase');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
    	//curl_setopt($curlHandle, CURLOPT_HEADER, true);
    	curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
    	curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
    
    	$response = curl_exec($curlHandle);
    	$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
    	curl_close($curlHandle); 
    	if($httpcode!=200){
    	    $this->update_user_to_firebase_py($entries);
    	} else {
    	    return $httpcode;
    	}
    }
    public function update_pending_to_firebase(){
        $all = Contest::where('response_status','!=',200)->get();
        foreach($all as $cont){
            $entries = json_decode($cont->response, true);
            $email_id = $entries['mf-email'];
            $referral_id = $entries['mf-referral-id'];
            $postParameter = array(
                'doc' => md5($referral_id.$email_id),
                'theme' => $entries['mf-image-select'],
                'username' => $entries['mf-listing-fname'].' '.$entries['mf-listing-lname'],
                'email' => $entries['mf-email'],
                'telephone' => $entries['mf-telephone'],
                'dob' => $entries['mf-date-of-birth'],
                'school_college' => $entries['mf-school-college'],
                'city' => $entries['mf-city'],
                'area' => $entries['mf-area'],
                'referral' => $entries['mf-referral-id']
            );
            $curlHandle = curl_init('https://genie2.ilifelearn.com/genie-app/insertfirebase');  // https://www.authorcrafts.in/pdf_flask https://genie.ilifelearn.us
        	//curl_setopt($curlHandle, CURLOPT_HEADER, true);
        	curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
        	curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
        
        	$response = curl_exec($curlHandle);
        	echo $httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
        	curl_close($curlHandle); 
        	
        	$contest =   Contest::where('id',$cont->id)->first(); 
            $contest->response_status = $httpcode;
            $contest->save();
        	
        }
        echo "done";
        
    }
    
    public function latest_news(){
        $json     = file_get_contents("http://ipinfo.io/".$_SERVER['REMOTE_ADDR']."/geo");
        //echo $json;
        //echo "<br><br>";
        $news_data = session('news_data');
        if($news_data && !empty($news_data)){
            $news = $news_data;
        } else {
            $json     = json_decode($json, true);
            $countrycode  = $json['country'];
            $region   = $json['region'];
            $city     = $json['city'];
            
            $cArr = array("BD"=>"Bangladesh", "BE"=>"Belgium", "BF"=>"Burkina Faso", "BG"=>"Bulgaria", "BA"=>"Bosnia and Herzegovina", "BB"=>"Barbados", "WF"=>"Wallis and Futuna", "BL"=>"Saint Barthelemy", "BM"=>"Bermuda", "BN"=>"Brunei", "BO"=>"Bolivia", "BH"=>"Bahrain", "BI"=>"Burundi", "BJ"=>"Benin", "BT"=>"Bhutan", "JM"=>"Jamaica", "BV"=>"Bouvet Island", "BW"=>"Botswana", "WS"=>"Samoa", "BQ"=>"Bonaire, Saint Eustatius and Saba ", "BR"=>"Brazil", "BS"=>"Bahamas", "JE"=>"Jersey", "BY"=>"Belarus", "BZ"=>"Belize", "RU"=>"Russia", "RW"=>"Rwanda", "RS"=>"Serbia", "TL"=>"East Timor", "RE"=>"Reunion", "TM"=>"Turkmenistan", "TJ"=>"Tajikistan", "RO"=>"Romania", "TK"=>"Tokelau", "GW"=>"Guinea-Bissau", "GU"=>"Guam", "GT"=>"Guatemala", "GS"=>"South Georgia and the South Sandwich Islands", "GR"=>"Greece", "GQ"=>"Equatorial Guinea", "GP"=>"Guadeloupe", "JP"=>"Japan", "GY"=>"Guyana", "GG"=>"Guernsey", "GF"=>"French Guiana", "GE"=>"Georgia", "GD"=>"Grenada", "GB"=>"United Kingdom", "GA"=>"Gabon", "SV"=>"El Salvador", "GN"=>"Guinea", "GM"=>"Gambia", "GL"=>"Greenland", "GI"=>"Gibraltar", "GH"=>"Ghana", "OM"=>"Oman", "TN"=>"Tunisia", "JO"=>"Jordan", "HR"=>"Croatia", "HT"=>"Haiti", "HU"=>"Hungary", "HK"=>"Hong Kong", "HN"=>"Honduras", "HM"=>"Heard Island and McDonald Islands", "VE"=>"Venezuela", "PR"=>"Puerto Rico", "PS"=>"Palestinian Territory", "PW"=>"Palau", "PT"=>"Portugal", "SJ"=>"Svalbard and Jan Mayen", "PY"=>"Paraguay", "IQ"=>"Iraq", "PA"=>"Panama", "PF"=>"French Polynesia", "PG"=>"Papua New Guinea", "PE"=>"Peru", "PK"=>"Pakistan", "PH"=>"Philippines", "PN"=>"Pitcairn", "PL"=>"Poland", "PM"=>"Saint Pierre and Miquelon", "ZM"=>"Zambia", "EH"=>"Western Sahara", "EE"=>"Estonia", "EG"=>"Egypt", "ZA"=>"South Africa", "EC"=>"Ecuador", "IT"=>"Italy", "VN"=>"Vietnam", "SB"=>"Solomon Islands", "ET"=>"Ethiopia", "SO"=>"Somalia", "ZW"=>"Zimbabwe", "SA"=>"Saudi Arabia", "ES"=>"Spain", "ER"=>"Eritrea", "ME"=>"Montenegro", "MD"=>"Moldova", "MG"=>"Madagascar", "MF"=>"Saint Martin", "MA"=>"Morocco", "MC"=>"Monaco", "UZ"=>"Uzbekistan", "MM"=>"Myanmar", "ML"=>"Mali", "MO"=>"Macao", "MN"=>"Mongolia", "MH"=>"Marshall Islands", "MK"=>"Macedonia", "MU"=>"Mauritius", "MT"=>"Malta", "MW"=>"Malawi", "MV"=>"Maldives", "MQ"=>"Martinique", "MP"=>"Northern Mariana Islands", "MS"=>"Montserrat", "MR"=>"Mauritania", "IM"=>"Isle of Man", "UG"=>"Uganda", "TZ"=>"Tanzania", "MY"=>"Malaysia", "MX"=>"Mexico", "IL"=>"Israel", "FR"=>"France", "IO"=>"British Indian Ocean Territory", "SH"=>"Saint Helena", "FI"=>"Finland", "FJ"=>"Fiji", "FK"=>"Falkland Islands", "FM"=>"Micronesia", "FO"=>"Faroe Islands", "NI"=>"Nicaragua", "NL"=>"Netherlands", "NO"=>"Norway", "NA"=>"Namibia", "VU"=>"Vanuatu", "NC"=>"New Caledonia", "NE"=>"Niger", "NF"=>"Norfolk Island", "NG"=>"Nigeria", "NZ"=>"New Zealand", "NP"=>"Nepal", "NR"=>"Nauru", "NU"=>"Niue", "CK"=>"Cook Islands", "XK"=>"Kosovo", "CI"=>"Ivory Coast", "CH"=>"Switzerland", "CO"=>"Colombia", "CN"=>"China", "CM"=>"Cameroon", "CL"=>"Chile", "CC"=>"Cocos Islands", "CA"=>"Canada", "CG"=>"Republic of the Congo", "CF"=>"Central African Republic", "CD"=>"Democratic Republic of the Congo", "CZ"=>"Czech Republic", "CY"=>"Cyprus", "CX"=>"Christmas Island", "CR"=>"Costa Rica", "CW"=>"Curacao", "CV"=>"Cape Verde", "CU"=>"Cuba", "SZ"=>"Swaziland", "SY"=>"Syria", "SX"=>"Sint Maarten", "KG"=>"Kyrgyzstan", "KE"=>"Kenya", "SS"=>"South Sudan", "SR"=>"Suriname", "KI"=>"Kiribati", "KH"=>"Cambodia", "KN"=>"Saint Kitts and Nevis", "KM"=>"Comoros", "ST"=>"Sao Tome and Principe", "SK"=>"Slovakia", "KR"=>"South Korea", "SI"=>"Slovenia", "KP"=>"North Korea", "KW"=>"Kuwait", "SN"=>"Senegal", "SM"=>"San Marino", "SL"=>"Sierra Leone", "SC"=>"Seychelles", "KZ"=>"Kazakhstan", "KY"=>"Cayman Islands", "SG"=>"Singapore", "SE"=>"Sweden", "SD"=>"Sudan", "DO"=>"Dominican Republic", "DM"=>"Dominica", "DJ"=>"Djibouti", "DK"=>"Denmark", "VG"=>"British Virgin Islands", "DE"=>"Germany", "YE"=>"Yemen", "DZ"=>"Algeria", "US"=>"United States", "UY"=>"Uruguay", "YT"=>"Mayotte", "UM"=>"United States Minor Outlying Islands", "LB"=>"Lebanon", "LC"=>"Saint Lucia", "LA"=>"Laos", "TV"=>"Tuvalu", "TW"=>"Taiwan", "TT"=>"Trinidad and Tobago", "TR"=>"Turkey", "LK"=>"Sri Lanka", "LI"=>"Liechtenstein", "LV"=>"Latvia", "TO"=>"Tonga", "LT"=>"Lithuania", "LU"=>"Luxembourg", "LR"=>"Liberia", "LS"=>"Lesotho", "TH"=>"Thailand", "TF"=>"French Southern Territories", "TG"=>"Togo", "TD"=>"Chad", "TC"=>"Turks and Caicos Islands", "LY"=>"Libya", "VA"=>"Vatican", "VC"=>"Saint Vincent and the Grenadines", "AE"=>"United Arab Emirates", "AD"=>"Andorra", "AG"=>"Antigua and Barbuda", "AF"=>"Afghanistan", "AI"=>"Anguilla", "VI"=>"U.S. Virgin Islands", "IS"=>"Iceland", "IR"=>"Iran", "AM"=>"Armenia", "AL"=>"Albania", "AO"=>"Angola", "AQ"=>"Antarctica", "AS"=>"American Samoa", "AR"=>"Argentina", "AU"=>"Australia", "AT"=>"Austria", "AW"=>"Aruba", "IN"=>"India", "AX"=>"Aland Islands", "AZ"=>"Azerbaijan", "IE"=>"Ireland", "ID"=>"Indonesia", "UA"=>"Ukraine", "QA"=>"Qatar", "MZ"=>"Mozambique");
            $country = $cArr[$countrycode];
            $location = "";
            //if($city!=""){
                //$location = $city;
            //}
            if($region!=""){
                if($location!=""){
                    $location .= ",";
                }
                $location .= $region;
            }
            if($country!=""){
                if($location!=""){
                    $location .= ",";
                }
                $location .= $country;
            }
            if($location==""){
                $location = "Delhi,India";
            }
            
            //$location = "Kerala,India";
            
            
            $curlHandle = curl_init("https://api.serphouse.com/serp/live");
    	    
            $header = array(
    		    'accept: application/json',
    		    'authorization: Bearer sEuUZOzZzOXEUAQrDKYvcXnYHOoyEMq58o0kxlbGLItBHQt58gwTliu5GAcE',
    		    'Content-Type: application/json',
    		);
    		if(auth()->user() && auth()->user()->level=="3") {
    		    $q = "legal news india";
    		} else {
    		    $q = "recent news";
    		}
    		$postJson = '{
                "data": {
                    "domain":"google.com",
                    "lang":"en",
                    "q": "'.$q.'",
                    "loc":"'.$location.'",
                    "device": "desktop",
                    "serp_type": "web",
                    "num_result": 10
                    }
                }';
    	        //"loc":"Texas,United States",
                // "loc":"'.$location.'",
    		//echo $postJson; echo "<br>";
    		
    		//curl_setopt($curlHandle, CURLOPT_HEADER, true);
            curl_setopt($curlHandle, CURLOPT_HTTPHEADER,$header);
    		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postJson);
    		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
    		//curl_setopt($curlHandle, CURLOPT_BINARYTRANSFER,1);
    		//curl_setopt($curlHandle, CURLOPT_FOLLOWLOCATION, true);
    
    		$response = curl_exec($curlHandle);
    		$httpcode = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE); 
    		$news =  json_decode($response,true);
    		//echo "<pre>";
    		//print_r($news);
    		curl_close($curlHandle);
            session(['news_data' => $news]);
        		
            //echo $response;
            //exit;
        }
        //print_r($news);
        return view('latest_news',compact('news'));
    }
}
