<!DOCTYPE html>
<html lang="en">
<head>
  <title>Coupons</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
  .form-group {
     font-size: 16px; 
  }
  label {
    display: inline-block;
    width: 100%;
    margin-bottom: 5px;
    font-weight: 500;
    color: #aaa;
    font-size:12px;
  }
  .user_icon {
      border: 1px solid;
    width: 100px;
    height: 100px;
    margin: 0 auto;
    border-radius: 50%;
    text-align: center;
    overflow: hidden;
  }
  .user_icon i {
      font-size: 100px;
  }
  .pt-20 {
      padding-top: 20px;
  }
  .text-sm {
      font-size: 12px;
    color: #aaa;
  }
  
  .common_main_div {
    background-size: auto;
    padding:10px;
    background-position: center;
  }
  
      .modal-header {
            padding: 10px 30px;
        }
        .badge-success {
            background-color: green;
        }
        .badge-danger {
            background-color: red;
        }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left ">
    <div class="row">
        <div class="common_main_div">
        
          <h3 class="pt-20 text-center">Coupons </h3>
          <p><em></em></p>
            @if(Session::has( 'success' ))
             <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
            @elseif( Session::has( 'warning' ))
             <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
            @endif
            <p class="pull-right"><a onclick="add_coupon()" class="btn btn-primary">Add New</a></p>
            <p>&nbsp;</p>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Coupon Code</th>
                            <th>Off Percentage</th>
                            <th>Created at</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($coupons  as $coupon)
                        <tr>
                            <td>{{ $coupon->code }}</td>
                            <td>
                                {{ $coupon->off_percent }}
                            </td>
                            <td>{{ $coupon->created_at }}</td>
                            <td>{!! $coupon->status=="1"?"<span class='badge badge-success'>Active</span>":"<span class='badge badge-danger'>Inactive</span>" !!}</td>
                            <td>
                                <a onclick="edit_coupon({{ $coupon->id }},{{ $coupon->off_percent }},{{$coupon->count_limit}})" class="btn btn-sm btn-warning">Edit</a>&nbsp;
                                <a onclick="return confirm('Are you sure you want to change?');" class="btn btn-sm btn-danger" href="{{ route('change_coupon_status') }}?id={{$coupon->id}}&status={{$coupon->status=='1'?'0':'1'}}">Change Status</a>&nbsp;
                                
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                
            </div>
            @include('pagination.limit_links', ['paginator' => $coupons])

    
   

        </div>

</div>
</div>
<!-- Image of location/map -->

<div class="modal" id="myModaladd">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">New Coupon</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
          <form action="{{ route('add_coupon') }}" method="post">
             @csrf
          <div class="form-group">
            <label for="code">Coupon Code</label>
            <input type="text" class="form-control" id="code" name="code" placeholder="Enter Coupon Code" required>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <div class="form-group">
            <label for="off_percent">OFF Percentage</label>
            <input type="number" class="form-control" id="off_percent" name="off_percent" placeholder="Enter off percentage" required>
          </div>
          <div class="form-group">
            <label for="count_limit">Limit</label>
            <input type="number" class="form-control" id="count_limit" name="count_limit" placeholder="Enter off percentage" required>
            <small id="emailHelp" class="form-text text-muted">Leave "0" if coupon has no limit</small>
          </div>
            <button type="submit" class="btn btn-primary">Add</button>
            </form>
          
      </div>
      

    </div>
  </div>
</div>

<div class="modal" id="myModaledit">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">Edit Coupon</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <div class="modal-body">
          <form action="{{ route('update_coupon') }}" method="post">
             @csrf
          <div class="form-group">
            <label for="off_percent">OFF Percentage</label>
            <input type="number" class="form-control" id="off_percent2" name="off_percent" placeholder="Enter off percentage" required>
          </div>
          <div class="form-group">
            <label for="count_limit">Limit</label>
            <input type="number" class="form-control" id="count_limit2" name="count_limit" placeholder="Enter off percentage" required>
            <small id="emailHelp" class="form-text text-muted">Leave "0" if coupon has no limit</small>
          </div>
            <input type="hidden" name="id" id="couponid" value="">
            <button type="submit" class="btn btn-primary">Update</button>
            </form>
          
      </div>

    </div>
  </div>
</div>


<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    function edit_coupon(id, off,count_limit){
        $('#couponid').val(id);
        $('#off_percent2').val(off);
        $('#count_limit2').val(count_limit);
        $('#myModaledit').modal('show');
    }
    function add_coupon(){
        $('#myModaladd').modal('show');
    }
    function update_model(model){
        var _token= "{{ csrf_token() }}";
		
		var request = $.ajax({
		  url: "{{route('change_chat_model')}}",
		  method: "POST",
		  data: { _token : _token, model: model },
		  dataType: "json"
		});
		 
		request.done(function( msg ) {
		  //file_list();
		  //show_shackbar_message('Folder Created Successfully');
          //document.getElementById("addFolderModal").style.display = "none";
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  //show_shackbar_message( "Request failed: " + textStatus );
		});
		
    
    }
    
</script>
</body>
</html>
