<!DOCTYPE html>
<html lang="en">
<head>
  <title>Users</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
  .form-group {
     font-size: 16px; 
  }
  label {
    display: inline-block;
    width: 100%;
    margin-bottom: 5px;
    font-weight: 500;
    color: #aaa;
    font-size:12px;
  }
  .user_icon {
      border: 1px solid;
    width: 100px;
    height: 100px;
    margin: 0 auto;
    border-radius: 50%;
    text-align: center;
    overflow: hidden;
  }
  .user_icon i {
      font-size: 100px;
  }
  .pt-20 {
      padding-top: 20px;
  }
  .text-sm {
      font-size: 12px;
    color: #aaa;
  }
  
  .common_main_div {
    background-size: auto;
    padding:10px;
    background-position: center;
  }
  
      .modal-header {
            padding: 10px 30px;
        }
        .badge-success {
            background-color: green;
        }
        .badge-danger {
            background-color: red;
        }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left ">
    <div class="row">
        <div class="common_main_div">
        
          <h3 class="pt-20 text-center">Admins </h3>
          <p><em></em></p>
            @if(Session::has( 'success' ))
             <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
            @elseif( Session::has( 'warning' ))
             <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
            @endif
            
            <p class="pull-right"><a href="{{ route('organisations') }}" class="btn btn-primary">Organisations</a>&nbsp;
            <a onclick="add_user()" class="btn btn-primary">Add New</a></p>
            <p>&nbsp;</p>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($organisations  as $user)
                        <tr>
                            <td>{{ $user->user->name }}</td>
                            <td>{{ $user->user->email }}</td>
                            <td>{{ $user->status=="1"?"Active":"Inactive" }}</td>
                            <td>
                                <a onclick="return confirm('Are you sure you want to remove?');" class="btn btn-sm btn-danger" href="{{ route('change_org_admin_status',['id'=>$user->id,'status'=>($user->status=="1"?"0":"1")]) }}">Remove</a>&nbsp;
                                
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                
            </div>
            @include('pagination.limit_links', ['paginator' => $organisations])

    
   

        </div>

</div>
</div>
<!-- Image of location/map -->

<div class="modal" id="myModaladd">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">New User</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
          <form action="{{ route('add_organisation_admin',['id'=>$id]) }}" method="post">
             @csrf
          <div class="form-group">
            <label for="exampleInputEmail1">Name</label>
            <input type="text" name="name" class="form-control" id="name" aria-describedby="emailHelp" placeholder="Enter name" required>
            <span class="text-danger">{{ $errors->has('name') ? $errors->first('name') : '' }}</span>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
            <div class="form-group">
            <label for="exampleInputEmail1">Mobile Number</label>
            <input type="text" name="mobile" class="form-control" id="mobile" aria-describedby="emailHelp" placeholder="Enter mobile" required>
            <span class="text-danger">{{ $errors->has('mobile') ? $errors->first('mobile') : '' }}</span>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
            <div class="form-group">
            <label for="exampleInputEmail1">Email address</label>
            <input type="email" name="email" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Enter email" required>
            <span class="text-danger">{{ $errors->has('email') ? $errors->first('email') : '' }}</span>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <div class="form-group">
            <label for="exampleInputPassword1">Password</label>
            <input type="password" name="password" class="form-control" id="exampleInputPassword1" placeholder="Password" required>
            <span class="text-danger">{{ $errors->has('password') ? $errors->first('password') : '' }}</span>
          </div>
            <div class="form-group">
            <label for="end_date">Valid Till</label>
            <input type="date" name="end_date" class="form-control" id="end_date" aria-describedby="emailHelp" placeholder="Select end date" required>
            <span class="text-danger">{{ $errors->has('end_date') ? $errors->first('end_date') : '' }}</span>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <input type="hidden" name="level" class="" onclick="" id="" value="11">
          <input type="hidden" name="subscription_type" class="" id="subscription_type" value="72">
            <button type="submit" class="btn btn-primary">Add</button>
            </form>
          
      </div>
      

    </div>
  </div>
</div>

<div class="modal" id="myModaledit">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">Edit User</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <div class="modal-body">
          <form action="" method="post">
             @csrf
          
          <div class="form-group">
            <label for="name">User Name</label>
            <input type="text" class="form-control" id="name2" name="name" placeholder="Enter User Name" required>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <div class="form-group">
            <label for="branch">Branch</label>
            <input type="text" class="form-control" id="branch2" name="branch" placeholder="Enter Branch" required>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <div class="form-group">
            <label for="city">City</label>
            <input type="text" class="form-control" id="city2" name="city" placeholder="Enter City" required>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <div class="form-group">
            <label for="no_of_users">No of users</label>
            <input type="number" class="form-control" id="no_of_users2" name="no_of_users" placeholder="No of users" required>
          </div>
            <input type="hidden" name="id" id="userid" value="">
            <button type="submit" class="btn btn-primary">Update</button>
            </form>
          
      </div>

    </div>
  </div>
</div>


<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    function edit_user(id, name,branch,city,no_of_users){
        $('#userid').val(id);
        $('#name2').val(name);
        $('#branch2').val(branch);
        $('#city2').val(city);
        $('#no_of_users2').val(no_of_users);
        $('#myModaledit').modal('show');
    }
    function add_user(){
        $('#myModaladd').modal('show');
    }
    
</script>
</body>
</html>
