<!DOCTYPE html>
<html lang="en">
<head>
  <title>Organisations</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
  .form-group {
     font-size: 16px; 
  }
  label {
    display: inline-block;
    width: 100%;
    margin-bottom: 5px;
    font-weight: 500;
    color: #aaa;
    font-size:12px;
  }
  .user_icon {
      border: 1px solid;
    width: 100px;
    height: 100px;
    margin: 0 auto;
    border-radius: 50%;
    text-align: center;
    overflow: hidden;
  }
  .user_icon i {
      font-size: 100px;
  }
  .pt-20 {
      padding-top: 20px;
  }
  .text-sm {
      font-size: 12px;
    color: #aaa;
  }
  
  .common_main_div {
    background-size: auto;
    padding:10px;
    background-position: center;
  }
  
      .modal-header {
            padding: 10px 30px;
        }
        .badge-success {
            background-color: green;
        }
        .badge-danger {
            background-color: red;
        }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left ">
    <div class="row">
        <div class="common_main_div">
        
          <h3 class="pt-20 text-center">Organisations </h3>
          <p><em></em></p>
            @if(Session::has( 'success' ))
             <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
            @elseif( Session::has( 'warning' ))
             <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
            @endif
            <p class="pull-right"><a onclick="add_organisation()" class="btn btn-primary">Add New</a></p>
            <p>&nbsp;</p>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Code</th>
                            <th>Place</th>
                            <th>Users limit</th>
                            <th>Created at</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($organisations  as $organisation)
                        <tr>
                            <td>{{ $organisation->name }}</td>
                            <td>{{ $organisation->code }}</td>
                            <td>{{ $organisation->branch }}, {{ $organisation->city }}</td>
                            <td>{{ $organisation->no_of_users }}</td>
                            <td>{{ $organisation->created_at }}</td>
                            <td>{!! $organisation->status=="1"?"<span class='badge badge-success'>Active</span>":"<span class='badge badge-danger'>Inactive</span>" !!}</td>
                            <td>
                                <a onclick="edit_organisation({{ $organisation->id }},'{{ $organisation->name }}','{{$organisation->branch}}','{{$organisation->city}}',{{$organisation->no_of_users}})" class="btn btn-sm btn-warning">Edit</a>&nbsp;
                                <a onclick="return confirm('Are you sure you want to change?');" class="btn btn-sm btn-danger" href="{{ route('change_organisation_status') }}?id={{$organisation->id}}&status={{$organisation->status=='1'?'0':'1'}}">Change Status</a>&nbsp;
                                <a onclick="" class="btn btn-sm btn-primary" href="{{ route('organisation_admins',['id'=>$organisation->id]) }}">Admin List</a>&nbsp;
                                
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                
            </div>
            @include('pagination.limit_links', ['paginator' => $organisations])

    
   

        </div>

</div>
</div>
<!-- Image of location/map -->

<div class="modal" id="myModaladd">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">New Organisation</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
          <form action="{{ route('add_organisation') }}" method="post">
             @csrf
          <div class="form-group">
            <label for="name">Organisation Name</label>
            <input type="text" class="form-control" id="name" name="name" placeholder="Enter Organisation Name" required>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <div class="form-group">
            <label for="code">Organisation Code</label>
            <input type="text" class="form-control" id="code" name="code" placeholder="Enter Organisation Code" required>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <div class="form-group">
            <label for="branch">Branch</label>
            <input type="text" class="form-control" id="branch" name="branch" placeholder="Enter Branch" required>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <div class="form-group">
            <label for="city">City</label>
            <input type="text" class="form-control" id="city" name="city" placeholder="Enter City" required>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <div class="form-group">
            <label for="no_of_users">No of users</label>
            <input type="number" class="form-control" id="no_of_users" name="no_of_users" placeholder="No of users" required>
          </div>
            <button type="submit" class="btn btn-primary">Add</button>
            </form>
          
      </div>
      

    </div>
  </div>
</div>

<div class="modal" id="myModaledit">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">Edit Organisation</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <div class="modal-body">
          <form action="{{ route('update_organisation') }}" method="post">
             @csrf
          
          <div class="form-group">
            <label for="name">Organisation Name</label>
            <input type="text" class="form-control" id="name2" name="name" placeholder="Enter Organisation Name" required>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <div class="form-group">
            <label for="branch">Branch</label>
            <input type="text" class="form-control" id="branch2" name="branch" placeholder="Enter Branch" required>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <div class="form-group">
            <label for="city">City</label>
            <input type="text" class="form-control" id="city2" name="city" placeholder="Enter City" required>
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <div class="form-group">
            <label for="no_of_users">No of users</label>
            <input type="number" class="form-control" id="no_of_users2" name="no_of_users" placeholder="No of users" required>
          </div>
            <input type="hidden" name="id" id="organisationid" value="">
            <button type="submit" class="btn btn-primary">Update</button>
            </form>
          
      </div>

    </div>
  </div>
</div>


<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    function edit_organisation(id, name,branch,city,no_of_users){
        $('#organisationid').val(id);
        $('#name2').val(name);
        $('#branch2').val(branch);
        $('#city2').val(city);
        $('#no_of_users2').val(no_of_users);
        $('#myModaledit').modal('show');
    }
    function add_organisation(){
        $('#myModaladd').modal('show');
    }
    
</script>
</body>
</html>
