<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Theme Made By www.w3schools.com - No Copyright -->
  <title>Checkout - {{ config('app.name') }}</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
      .card-row {
          margin: 30px auto;
      }
      .card {
          padding-bottom: 20px;
          padding-top: 10px;
          border-radius: 5px;
          border: 1px solid #eee;
      }
      .card-text {
          padding: 6px;
      }
      .card-title span {
         font-size: 16px;
         padding: 2px;
      }
      .package_name {
         font-size: 16px;
         padding: 3px;
         color: darkblue;
      }
.razorpay-payment-button {
	width: 200px;
    text-align: center;
    margin: 0 auto;
    background: #2c5dbf;
    color: white;
}
.razorpay-payment-button:focus {
    background: #2c5dbf;
    color: white;
}
      #band {
        min-height: calc(100vh - 150px);
      }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



@php
	$currency = '₹';
@endphp
       
        <section class="mt-10 mb-50 " id="band">
            <div class="container">
                <div class="row">
            
                    <div class="col-lg-12">
                       @if($message = Session::get('error'))
							<div class="alert alert-danger alert-dismissible fade in" role="alert">
								<button type="button" class="close" data-dismiss="alert" aria-label="Close">
									<span aria-hidden="true">×</span>
								</button>
								<strong>Error!</strong> {{ $message }}
							</div>
						@endif
						{!! Session::forget('error') !!}
						@if($message = Session::get('success'))
							<div class="alert alert-info alert-dismissible fade in" role="alert">
								<button type="button" class="close" data-dismiss="alert" aria-label="Close">
									<span aria-hidden="true">×</span>
								</button>
								<strong>Success!</strong> {{ $message }}
							</div>
						@endif
						{!! Session::forget('success') !!}
						<div class="panel panel-default" style="">
							<h3></h3><br>
							<div class="panel-heading">
								<h2></h2>
							    
								@php
								$orderID = $orderRes['id'];								
								@endphp
								<form action="{!!route('payment.store')!!}" method="POST" style="text-align: center;">
									<script src="https://checkout.razorpay.com/v1/checkout.js"
											data-key="rzp_live_L8swnuW79yi11c"
											data-amount="{{ $amount }}"
											data-order_id="{{ $orderID }}"
											data-buttontext="Pay Now&nbsp;({{ $currency.($amount/100) }})"
											data-name="i-Life Genie"
											data-description="Payment"
											data-prefill.name="{{ session('checkout_name') }}"
											data-prefill.email="{{ session('checkout_email') }}"
											data-theme.color="#ff7529">
									</script>
									<input type="hidden" name="_token" value="{!!csrf_token()!!}">
								</form>
							</div>
						</div>
                    </div>
                </div>
            </div>
        </section>



<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
  $(document).ready(function(){
		@if(session('checkout_amount') && session('checkout_amount')!="")
			    $('.razorpay-payment-button').click();
			
		@else
			$('.razorpay-payment-button').hide();
		@endif
  });
</script>
</body>
</html>
