@php
$currsiteurl = $_SERVER['HTTP_HOST'];
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <title>My Profile</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  
  
  <link href="https://fonts.googleapis.com/css?family=Lato:100,300,400,700" rel="stylesheet" type="text/css">
  <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet" type="text/css">
  <style>
    
    html, body {
        background: #e5e5e5;
        font-family: 'Lato', sans-serif;
        margin: 0px auto;
    }
    ::selection{
      background: rgba(82,179,217,0.3);
      color: inherit;
    }
    a{
      color: rgba(82,179,217,0.9);
    }
    
    /* M E N U */
    
    .menu {
        position: fixed;
        top: 0px;
        left: 0px;
        right: 0px;
        width: 100%;
        height: 50px;
        background: rgba(82,179,217,0.9);
        z-index: 100;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
    }
    
    .back a {
        position: absolute;
        height: 50px;
        top: 0px;
        left: 0px;
        color: #fff;
        line-height: 50px;
        font-size: 30px;
        padding-left: 10px;
        cursor: pointer;
    }
    .back img {
        position: absolute;
        top: 5px;
        left: 30px;
        width: 40px;
        height: 40px;
        background-color: rgba(255,255,255,0.98);
        border-radius: 100%;
        -webkit-border-radius: 100%;
        -moz-border-radius: 100%;
        -ms-border-radius: 100%;
        margin-left: 15px;
        }
    .back:active {
        background: rgba(255,255,255,0.2);
    }
    .name a {
        position: absolute;
        top: 3px;
        left: 50px;
        font-family: 'Lato';
        font-size: 25px;
        font-weight: 300;
        color: rgba(255,255,255,0.98);
        cursor: default;
    }
    .last a {
        color: rgba(255,255,255,0.98);
    }
    .last{
        position: absolute;
        top: 10px;
        right: 25px;
        font-family: 'Lato';
        font-size: 20px;
        font-weight: 400;
        color: rgba(255,255,255,0.6);
        cursor: default;
    }
    
    /* M E S S A G E S */
    
    .chat {
        list-style: none;
        background: none;
        margin: 0;
        padding: 0 0 50px 0;
        margin-top: 60px;
        margin-bottom: 10px;
    }
    .chat li {
        padding: 0.5rem;
        overflow: hidden;
        display: flex;
    }
    .chat .avatar {
        width: 40px;
        height: 40px;
        position: absolute;
        display: block;
        z-index: 2;
        border-radius: 100%;
        -webkit-border-radius: 100%;
        -moz-border-radius: 100%;
        -ms-border-radius: 100%;
        background-color: rgba(255,255,255,0.9);
        font-size: 10px;
        background: #fff;
    }
    .chat .avatar img {
        width: 40px;
        height: 40px;
        border-radius: 100%;
        -webkit-border-radius: 100%;
        -moz-border-radius: 100%;
        -ms-border-radius: 100%;
        background-color: rgba(255,255,255,0.9);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
    }
    .chat .day {
        position: relative;
        display: block;
        text-align: center;
        color: #c0c0c0;
        height: 20px;
        text-shadow: 7px 0px 0px #e5e5e5, 6px 0px 0px #e5e5e5, 5px 0px 0px #e5e5e5, 4px 0px 0px #e5e5e5, 3px 0px 0px #e5e5e5, 2px 0px 0px #e5e5e5, 1px 0px 0px #e5e5e5, 1px 0px 0px #e5e5e5, 0px 0px 0px #e5e5e5, -1px 0px 0px #e5e5e5, -2px 0px 0px #e5e5e5, -3px 0px 0px #e5e5e5, -4px 0px 0px #e5e5e5, -5px 0px 0px #e5e5e5, -6px 0px 0px #e5e5e5, -7px 0px 0px #e5e5e5;
        box-shadow: inset 20px 0px 0px #e5e5e5, inset -20px 0px 0px #e5e5e5, inset 0px -2px 0px #d7d7d7;
        line-height: 38px;
        margin-top: 5px;
        margin-bottom: 20px;
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
    }
    
    .other .msg {
        order: 1;
        border-top-left-radius: 0px;
        box-shadow: -1px 2px 0px #D4D4D4;
        padding-left: 40px;
    }
    .other:before {
        content: "";
        position: relative;
        top: 0px;
        right: 0px;
        left: 40px;
        width: 0px;
        height: 0px;
        border: 5px solid #fff;
        border-left-color: transparent;
        border-bottom-color: transparent;
    }
    
    .self {
        justify-content: flex-end;
        align-items: flex-end;
    }
    .self .msg {
        order: 1;
        border-bottom-right-radius: 0px;
        box-shadow: 1px 2px 0px #D4D4D4;
        padding-right: 40px;
    }
    .self .avatar {
        order: 2;
    }
    .self .avatar:after {
        content: "";
        position: relative;
        display: inline-block;
        bottom: 19px;
        right: 0px;
        width: 0px;
        height: 0px;
        border: 5px solid #fff;
        border-right-color: transparent;
        border-top-color: transparent;
        box-shadow: 0px 2px 0px #D4D4D4;
    }
    
    .msg {
        background: white;
        min-width: 50px;
        padding: 10px;
        border-radius: 2px;
        box-shadow: 0px 2px 0px rgba(0, 0, 0, 0.07);
    }
    .msg p {
        font-size: 14px;
        margin: 0 0 0.2rem 0;
        color: #777;
    }
    .msg img {
        position: relative;
        display: block;
        width: 450px;
        border-radius: 5px;
        box-shadow: 0px 0px 3px #eee;
        transition: all .4s cubic-bezier(0.565, -0.260, 0.255, 1.410);
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
    }
    @media screen and (max-width: 800px) {
        .msg img {
        width: 300px;
    }
    }
    @media screen and (max-width: 550px) {
        .msg img {
        width: 200px;
    }
    }
    
    .msg time {
        font-size: 0.7rem;
        color: #ccc;
        margin-top: 3px;
        float: right;
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
    }
    .msg time:before{
        content:"\f017";
        color: #ddd;
        font-family: FontAwesome;
        display: inline-block;
        margin-right: 4px;
    }
    
    emoji{
        display: inline-block;
        height: 18px;
        width: 18px;
        background-size: cover;
        background-repeat: no-repeat;
        margin-top: -7px;
        margin-right: 2px;
        transform: translate3d(0px, 3px, 0px);
    }
    emoji.please{background-image: url(https://imgur.com/ftowh0s.png);}
    emoji.lmao{background-image: url(https://i.imgur.com/MllSy5N.png);}
    emoji.happy{background-image: url(https://imgur.com/5WUpcPZ.png);}
    emoji.pizza{background-image: url(https://imgur.com/voEvJld.png);}
    emoji.cryalot{background-image: url(https://i.imgur.com/UUrRRo6.png);}
    emoji.books{background-image: url(https://i.imgur.com/UjZLf1R.png);}
    emoji.moai{background-image: url(https://imgur.com/uSpaYy8.png);}
    emoji.suffocated{background-image: url(https://i.imgur.com/jfTyB5F.png);}
    emoji.scream{background-image: url(https://i.imgur.com/tOLNJgg.png);}
    emoji.hearth_blue{background-image: url(https://i.imgur.com/gR9juts.png);}
    emoji.funny{background-image: url(https://i.imgur.com/qKia58V.png);}
    
    @-webikt-keyframes pulse {
      from { opacity: 0; }
      to { opacity: 0.5; }
    }
    
    ::-webkit-scrollbar {
        min-width: 12px;
        width: 12px;
        max-width: 12px;
        min-height: 12px;
        height: 12px;
        max-height: 12px;
        background: #e5e5e5;
        box-shadow: inset 0px 50px 0px rgba(82,179,217,0.9), inset 0px -52px 0px #fafafa;
    }
    
    ::-webkit-scrollbar-thumb {
        background: #bbb;
        border: none;
        border-radius: 100px;
        border: solid 3px #e5e5e5;
        box-shadow: inset 0px 0px 3px #999;
    }
    
    ::-webkit-scrollbar-thumb:hover {
        background: #b0b0b0;
      box-shadow: inset 0px 0px 3px #888;
    }
    
    ::-webkit-scrollbar-thumb:active {
        background: #aaa;
      box-shadow: inset 0px 0px 3px #7f7f7f;
    }
    
    ::-webkit-scrollbar-button {
        display: block;
        height: 26px;
    }
    
    /* T Y P E */
    
    input.textarea {
        position: fixed;
        bottom: 0px;
        left: 0px;
        right: 0px;
        width: 100%;
        height: 60px;
        z-index: 99;
        background: #fafafa;
        border: none;
        outline: none;
        padding-left: 5px;
        padding-right: 55px;
        color: #666;
        font-weight: 400;
    }
    .emojis {
        position: fixed;
        display: block;
        bottom: 8px;
        left: 7px;
        width: 34px;
        height: 34px;
        background-image: url(https://i.imgur.com/5WUpcPZ.png);
        background-repeat: no-repeat;
        background-size: cover;
        z-index: 100;
        cursor: pointer;
    }
    .emojis:active {
        opacity: 0.9;
    }
    .chat {
        list-style: none;
        /* background: none; */
        margin: 0;
        padding: 0 0 50px 0;
        margin-top: 60px;
        margin-bottom: 10px;
        bottom: 60px;
        width: 100%;
    }
    
    .send_btn,
    .audio_btn,
    .stop_btn,
    .delete_btn,
    .send_audio_btn,
    .recording_data,
    .attach {
       position: fixed;
        display: block;
        bottom: 8px;
        width: 34px;
        height: 34px;
        z-index: 100;
        cursor: pointer; 
        font-size: 20px;
        padding: 5px;
    }
    
    
    .send_btn {
        right: 50px;
        bottom: 10px;
    }
    .attach {
        
       position: fixed ;
        left: 0;
        height: 60px;
        bottom: 0;
        background: #fff;
        padding: 15px 10px 10px 10px;
        width: 40px;
    }
    .audio_btn {
       right: 0px; 
       
    }
    .stop_btn{
        right: 50px;
    }
    .delete_btn{
        right: 0px;
    }
    .send_audio_btn {
        right: 50px;
        bottom: 9px;
    }
    .recording_data {
        right: 95px;
        font-size: small;
        padding-top: 8px;
        color: orange;
    }
    
    
    .text-sm {
        font-size: 11px;
        color: #aaa;
    }
    .chat_fa {
        font-size: 30px;
    }
    .fa-send {
       font-size: 28px; 
    }
    .dropup .dropdown-menu, .navbar-fixed-bottom .dropdown .dropdown-menu {
        top: auto;
        bottom: 40px !important;
        margin-bottom: 2px;
    }
    .text-medium {
        font-size: 15px;
    }
    .chat_list {
        display: none;
    }
    @media only screen and (max-width: 768px) {
        .only_on_mobile {
            display: block;
        }
        .chat_screen {
            width: 100%;
        }
        
        .attach {
            left: 0;  
        }
        input.textarea {
            width: calc(100% - 40px);
            right: 0;
            left: auto;
        }
    }
    @media only screen and (min-width: 768px) {
        
        .attach {
            left: 30%;  
        }
        .only_on_desktop {
          display: block;
        }
        .chat_list {
            width: 30%;
            left: 0;
            position: fixed;
            background: #fff;
        }
        .each_group{
            border: 1px solid #aaa;
            padding: 20px;
          }
        .chat_screen {
            width: 70%;
            float: right;
            border-left: 1px solid #aaa;
        }
        .menu {
            width: 70%;
            right: 0;
            left: auto;
        }
        input.textarea {
            width: calc(70% - 40px);
            right: 0;
            left: auto;
        }
        .scroll_div {
            height: 100vh;
            overflow: auto;
        }
        .each_group a {
            color: #111;
        }
        .selected_group {
            background: #ddd;
        }
        .unread_msg a {
            font-weight: bold;
        }
    }
  </style>
  
  <style>
    /* The Modal (background) */
    .modal {
      display: none; /* Hidden by default */
      position: fixed; /* Stay in place */
      z-index: 1; /* Sit on top */
      left: 0;
      top: 0;
      width: 100%; /* Full width */
      height: 100%; /* Full height */
      overflow: auto; /* Enable scroll if needed */
      background-color: rgb(0,0,0); /* Fallback color */
      background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
      -webkit-animation-name: fadeIn; /* Fade in the background */
      -webkit-animation-duration: 0.4s;
      animation-name: fadeIn;
      animation-duration: 0.4s
    }
    
    /* Modal Content */
    .modal-content {
      top: 100px;
      background-color: #fefefe;
      width: 80%;
      -webkit-animation-name: slideIn;
      -webkit-animation-duration: 0.4s;
      animation-name: slideIn;
      animation-duration: 0.4s;
      margin: 0 auto;
    }
    
    /* The Close Button */
    .close {
      color: white;
      float: right;
      font-size: 28px;
      font-weight: bold;
    }
    
    .close:hover,
    .close:focus {
      color: #000;
      text-decoration: none;
      cursor: pointer;
    }
    
    .modal-header {
      padding: 2px 16px;
      background-color: #ddd;
      color: black;
    }
    
    .modal-body {padding: 2px 16px;}
    
    .modal-footer {
      padding: 2px 16px;
      background-color: #ddd;
      color: black;
      text-align: left !important;
    }
    
    /* Add Animation */
    @-webkit-keyframes slideIn {
      from {bottom: -300px; opacity: 0} 
      to {bottom: 0; opacity: 1}
    }
    
    @keyframes slideIn {
      from {bottom: -300px; opacity: 0}
      to {bottom: 0; opacity: 1}
    }
    
    @-webkit-keyframes fadeIn {
      from {opacity: 0} 
      to {opacity: 1}
    }
    
    @keyframes fadeIn {
      from {opacity: 0} 
      to {opacity: 1}
    }
    </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
    <div class="only_on_desktop chat_list">
        <div class="scroll_div">
        
            @foreach($groups as $grp)
                <div class="">
                    <div class="group_{{$grp->id}} each_group @if($grp->join_link==$group->join_link) selected_group @endif">
                        
                        <span class="group_icon"><i class="fa fa-users"></i></span>
                        &nbsp;<a href="{{ route('group_chat', ['id'=>$grp->join_link]) }}">{{ $grp->group_name }}</a> 
                        <span class="text-sm pull-right msg_count_{{ $grp->id}} "></span> <br>
                        <time class="text-sm pull-right msg_time_{{ $grp->id }} "> Last updated: {{ App\Http\Controllers\GroupChatController::time_elapsed_string($grp->refreshed) }} </time>
                    </div>
                </div>
            @endforeach
        
        </div>
    </div>
    <div class="chat_screen">
        <div class="menu">
            <div class="back"><a class="" href="{{ route('groups') }}"><i class="fa fa-chevron-left"></i></a> 
            </div>
            <div class="name">
                <a class="" href="{{ route('group_details', ['id'=>$group->join_link]) }}">
                <i class="fa fa-users"></i> &nbsp;{{ $group->group_name }}
                </a> 
            </div>
            <div class="last">
                @if($currsiteurl!="qwikaide.com")
                <a href="{{ route('redirectToGoogle') }}?g={{$group->join_link}}" class="text-medium">Create Meeting Link</a>&nbsp;&nbsp;
                @endif
                <a class="" href="{{ route('group_details', ['id'=>$group->join_link]) }}"><i class="fa fa-cog"></i></a>
            </div>
        </div>
        <ol class="chat">
        @foreach(($groupmsgs) as $msg)
            @if($msg->user_id == auth()->user()->id)
                <li class="self msg_li" data-msg-id="{{$msg->id}}">
                  <div class="avatar"><img src="https://i.imgur.com/HYcn9xO.png" draggable="false"/></div>
                  <div class="msg">
                    @if($msg->photo!="")
                        <img src="https://i.imgur.com/QAROObc.jpg" draggable="false"/>
                    @endif
                     @if($msg->voice!="")    
                    <audio controls>
                      <source src="{{url('group_voices/'.$msg->voice)}}" type="audio/mp3">
                      Your browser does not support the audio element.
                    </audio>
                    @endif
                     
                    @if($msg->file!="")    
                        File ({{$msg->file}})<br>
                        <a href="{{ url('group_chat/file/'.$msg->group_id.'/'.$msg->file) }}" class="btn btn-sm btn-primary" target="_blank">View</a>
                    @endif
                    {!!$msg->message!!}<br> 
                    <span class="text-sm pull-left">{{$msg->user->name}}</span><br>
                    <time>{{ App\Http\Controllers\GroupChatController::time_elapsed_string($msg->created_at) }}</time>
                  </div>
                </li>
            @else
                <li class="other msg_li" data-msg-id="{{$msg->id}}">
                  <div class="avatar"><img src="https://i.imgur.com/DY6gND0.png" draggable="false"/></div>
                  <div class="msg">
                    @if($msg->photo!="")
                        <img src="https://i.imgur.com/QAROObc.jpg" draggable="false"/>
                    @endif    
                    @if($msg->voice!="")    
                    <audio controls>
                      <source src="{{url('group_voices/'.$msg->voice)}}" type="audio/mp3">
                      Your browser does not support the audio element.
                    </audio>
                    @endif
                    
                    @if($msg->file!="")    
                        File ({{$msg->file}})<br>
                        <a href="{{ url('group_chat/file/'.$msg->group_id.'/'.$msg->file) }}" class="btn btn-sm btn-primary" target="_blank">View</a>
                    @endif
                    {!!$msg->message!!}<br>
                    <span class="text-sm pull-right">{{$msg->user->name}}</span><br>
                    <time>{{ App\Http\Controllers\GroupChatController::time_elapsed_string($msg->created_at) }}</time>
                  </div>
                </li>
            @endif 
        @endforeach
        </ol>
        
        @if(auth()->user()->id==3)
        <!---->
        <div class="dropdown dropup">
            <ul class="dropdown-menu">
              <li><a href="{{ route('redirectToGoogle') }}?g={{$group->join_link}}">Create Google Meet</a></li>
            </ul>
            <a class="attach dropdown-toggle" onclick="" data-toggle="dropdown"><i class="chat_fa fa fa-paperclip"></i> </a>
            
            
          </div>
        @endif
        <input class="textarea" id="message_text" type="text" placeholder="Type here!"/>
        
        <span class="recording_data"></span>
        <a class="send_btn" onclick="send_group_message();"><i class="chat_fa fa fa-send"></i> </a>
        <a id="btnStart" onclick="speakNow();" class="audio_btn " style=""><i class="chat_fa fa fa-microphone text-success"></i></a>
        <a id="btnStop" onclick="pauseNow();" class="stop_btn"  style="display:none;"><i class="chat_fa fa fa-pause text-warning"></i></a>
        
        <a id="btnDelete" onclick="abortAudio()" class="delete_btn"  style="display:none;"><i class="chat_fa fa fa-trash text-danger"></i></a>
        <a class="send_audio_btn" onclick="sendAudio()"  style="display:none;"><i class="chat_fa fa fa-send"></i> </a>
        
        
        <input type="hidden" id="more_data" value="yes">
        <a class="attach " id="myBtn" onclick=""><i class="chat_fa fa fa-paperclip"></i> </a>
    </div>
<!-- The Modal -->
<div id="myModal" class="modal">

  <!-- Modal content -->
  <div class="modal-content">
    <div class="modal-header">
      <span class="close">&times;</span>
      Upload File
    </div>
    <div class="modal-body">
      
          <br>
          Select file to upload:<br><br>
          <input type="file" name="attachment" id="attachment" class="form-control"><br>
          <a onclick="send_file()" class="btn btn-sm btn-primary">Upload</a><br><br>
     
    </div>
    <div class="modal-footer">
    </div>
  </div>
  </div>
    
@include('layouts.script')
<script>
var modal = document.getElementById("myModal");
    var btn = document.getElementById("myBtn");
    var span = document.getElementsByClassName("close")[0];
    
    btn.onclick = function() {
      modal.style.display = "block";
      
    }
    
    span.onclick = function() {
      modal.style.display = "none";
      
    }
    
    window.onclick = function(event) {
      if (event.target == modal) {
        modal.style.display = "none";
      }
    }
    
    $(window).scroll(function() {
        //if($(window).scrollTop() == $(document).height() - $(window).height()) {
            
        //}
        console.log('the minused value: '+($(document).height() - $(window).height())+' the scroll value: '+$(window).scrollTop())
        if($(window).scrollTop() == 0) {
            var more_data = $('#more_data').val();
            if(more_data=="yes"){
                loadmore_chat();
            }
            
        }
    });
    function send_group_message(){
        
        var message = $('.textarea').val();
        if(message.trim()!=""){
            var _token= "{{ csrf_token() }}";
            var group_id= "{{ $group->id }}";
    		
    		var request = $.ajax({
    		  url: "{{route('send_group_message')}}",
    		  method: "POST",
    		  data: { _token : _token, group_id: group_id, message: message },
    		  dataType: "json"
    		});
    		 
    		request.done(function( msg ) {
    		  var msg ='<li class="self msg_li" data-msg-id=""><div class="avatar"><img src="https://i.imgur.com/HYcn9xO.png" draggable="false"/></div><div class="msg">'+message+'<br><span class="text-sm pull-left">{{auth()->user()->name}}</span><br><time>Just now</time></div></li>';
    		  $('.chat').append(msg);
    		  $('.textarea').val('');
    		  var cfirst = $('.chat li:last');
    		  $('html, body').animate({
                    scrollTop: cfirst.offset().top-35
                }, 0);
    		});
    		 
    		request.fail(function( jqXHR, textStatus ) {
    		  show_shackbar_message( "Request failed: " + textStatus );
    		});
        } else {
            alert('Please enter message');
        }
    }
    function loadmore_chat(){
        $('#more_data').val('no');
        var cfirst = $('.chat li:first');
        var last_id = $(".chat li:first").attr('data-msg-id');
        var _token= "{{ csrf_token() }}";
		var group_id= "{{ $group->id }}";
		var request = $.ajax({
		  url: "{{route('loadmore_chat')}}",
		  method: "POST",
		  data: { _token : _token, last_id: last_id, group_id: group_id },
		  dataType: "html"
		});
		 
		request.done(function( msg ) {
		    if(msg.trim()=="completed"){
    		    $('#more_data').val('completed');
		    } else {
		        $('#more_data').val('yes');
    		    $('.chat').prepend(msg);
    		    $('html, body').animate({
                    scrollTop: cfirst.offset().top-35
                }, 0);
		    }
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  show_shackbar_message( "Request failed: " + textStatus );
		});
    }
    function loadnew_chat(){
        var cfirst = $('.chat li:last');
        var last_id = $(".chat li:last").attr('data-msg-id');
        var _token= "{{ csrf_token() }}";
		var group_id= "{{ $group->id }}";
		var request = $.ajax({
		  url: "{{route('loadnew_chat')}}",
		  method: "POST",
		  data: { _token : _token, last_id: last_id, group_id: group_id },
		  dataType: "html"
		});
		 
		request.done(function( msg ) {
		    if(msg.trim()=="completed"){
		        
		    } else {
    		    $('.chat').append(msg);
    		    $('html, body').animate({
                    scrollTop: cfirst.offset().top-35
                }, 0);
		    }
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  //show_shackbar_message( "Request failed: " + textStatus );
		});
    }
    $(document).ready(function(){
	    
        var input = document.getElementById("message_text");
        input.addEventListener("keypress", function(event) {
            if (event.key === "Enter") {
              event.preventDefault();
              send_group_message();
            }
        
        });
        $('#message_text').focus();
        var cfirst = $('.chat li:last');
	    $('html, body').animate({
            scrollTop: cfirst.offset().top-35
        }, 0);
        setTimeout(function () {
    	    loadnew_chat();
        }, 60000);
    });
    
    var xhr;
	let audioIN = { audio: true };
    var startTime = 0;
    let mediaRecorder;
    let dataArray = [];
    let mediaStreamObjdata;
    var audioList = [];
    var myTimer;
    function stop_timer(){
        if(myTimer){
            clearInterval(myTimer);
        }
    }
    
    function start_timer(){
        
        if(myTimer){
            clearInterval(myTimer);
        }
        var time = 0;
        var minutes = Math.floor(time / 60);
        var seconds = time - minutes * 60;
        if(minutes<10){
            minutes = '0'+minutes;
        }
        if(seconds<10){
            seconds = '0'+seconds;
        }
        var time_val = minutes+':'+seconds;
        $(".recording_data").text(time_val);
        myTimer = setInterval(function(){
            
                time = time + 1;
                minutes = Math.floor(time / 60);
                
                seconds = time - minutes * 60;
                
                if(minutes<10){
                    minutes = '0'+minutes;
                }
                if(seconds<10){
                    seconds = '0'+seconds;
                }
                
                time_val = minutes+':'+seconds;
                $(".recording_data").text(time_val);
            
            
        },1000);
        
    }
    function reset_chat_btns(){
        $('.send_btn').show();
        $('.audio_btn').show();
        $('.stop_btn').hide();
        $('.delete_btn').hide();
        $('.send_audio_btn').hide();
        $('.recording_data').hide();
    }
    function speakNow() {
        startTime = Date.now();
        dataArray = [];
        
        $('.stop_btn').show();
        $('.delete_btn').show();
        $('.recording_data').show();
        
        $('.send_btn').hide();
        $('.audio_btn').hide();
        $('.send_audio_btn').hide();
        
        start_timer();
        
        
        if(mediaStreamObjdata){
            mediaStreamObjdata.getTracks().forEach( track => track.stop() );
        }
        navigator.mediaDevices.getUserMedia(audioIN).then(function (mediaStreamObj) {
            
    	    mediaRecorder = new MediaRecorder(mediaStreamObj);
    		mediaRecorder.start();
            $('#audio_span').html('Ask now...');
            $('#audio_span2').html('Ask now...');
            show_shackbar_message('Ask now...'); 
			console.log(mediaRecorder.state);
			mediaStreamObjdata = mediaStreamObj;
			@if(auth()->user() && (auth()->user()->id=="3" || auth()->user()->id=="4"))
    			setTimeout(function () {
                  if(mediaStreamObjdata){
                      //$('#audio_span').html('Speaking...c');
                  } else {
                      
                      //$('#audio_span').html('Speaking...nop');
                  }
                }, 1001);
            @endif
        });
    }
    
    function pauseNow(){
        $('.delete_btn').show();
        $('.send_audio_btn').show();
        $('.recording_data').show();
        
        $('.stop_btn').hide();
        $('.send_btn').hide();
        $('.audio_btn').hide();
        
        stop_timer();
        
        
       mediaRecorder.pause(); 
       
    }
    function sendAudio(){
        
        reset_chat_btns();
        
        
        mediaRecorder.stop();
		console.log(mediaRecorder.state);
	
	    var end = Date.now();
        diff = (end - startTime) + 1;
        var total = diff/1000;
        if(total>1){
			$('.delete_btn_div').show();
            $('.speak_btn_div').hide();
            mediaRecorder.ondataavailable = function (ev) {
                console.log(ev.data);
    		    dataArray.push(ev.data);
    		    
    		   
                let audioData = new Blob(dataArray,{ 'type': 'audio/webm;codecs=opus' });
        					
        		//dataArray = [];
        		console.log(audioData);
        		var form_data = new FormData();
        		var _token= "{{ csrf_token() }}";
        		var group_id= "{{ $group->id }}";
        		form_data.append('voice', audioData);   
        		form_data.append('_token', _token);  
        		form_data.append('group_id', group_id);  
        		xhr = $.ajax({
        			url: "{{route('send_group_voice_message')}}",
        			dataType: 'html', 
        			cache: false,
        			contentType: false,
        			processData: false,
        			data: form_data,                         
        			type: 'post',
        			success: function(response){
                        reset_chat_btns();
                        mediaStreamObjdata.getTracks().forEach( track => track.stop() );
                        var msg ='<li class="self msg_li" data-msg-id=""><div class="avatar"><img src="https://i.imgur.com/HYcn9xO.png" draggable="false"/></div><div class="msg">'+response+'<br><span class="text-sm pull-left">{{auth()->user()->name}}</span><br><time>Just now</time></div></li>';
                		  $('.chat').append(msg);
                		  $('.textarea').val('');
                		  var cfirst = $('.chat li:last');
                		  $('html, body').animate({
                                scrollTop: cfirst.offset().top-35
                            }, 0);
        			},
                    error: function() { 
                        reset_chat_btns();
                        mediaStreamObjdata.getTracks().forEach( track => track.stop() );
                    }  
        		 });
        //        mediaStreamObjdata.getTracks().forEach( track => track.stop() );
            }
		} else {
            mediaStreamObjdata.getTracks().forEach( track => track.stop() );
            reset_chat_btns();
        }
        
    }
    function abortAudio(){
        reset_chat_btns();
        stop_timer();
        
        mediaStreamObjdata.getTracks().forEach( track => track.stop() );
        xhr.abort();
           
    }
    
    function send_file(){
        $('.modal-footer').html('Uploading...');

        var attachment = $('#attachment').prop('files')[0];   
        var _token= "{{ csrf_token() }}";
        var group_id= "{{ $group->id }}";
        
        var formData = new FormData();
		formData.append('_token', _token);  
		formData.append('group_id', group_id);
        formData.append('attachment', attachment);
        
        $.ajax({
            url: "{{ route('send_group_attach_message') }}",
            type: "POST",
            data:  formData,
            contentType: false,
            cache: false,
            processData:false,
            beforeSend : function() {
                $('.modal-footer').html('Uploading...');
            },
            success: function(data) {
                reset_chat_btns();
                var msg ='<li class="self msg_li" data-msg-id=""><div class="avatar"><img src="https://i.imgur.com/HYcn9xO.png" draggable="false"/></div><div class="msg">'+data+'<br><span class="text-sm pull-left">{{auth()->user()->name}}</span><br><time>Just now</time></div></li>';
        		  $('.chat').append(msg);
        		  $('.textarea').val('');
        		  var cfirst = $('.chat li:last');
        		  $('html, body').animate({
                        scrollTop: cfirst.offset().top-35
                    }, 0);
                $('#attachment').val('');
                $('.modal-footer').html('');
                modal.style.display = "none";
            },
            error: function(e)  {
                reset_chat_btns();
                $('#attachment').val('');
                $('.modal-footer').html('');
            }          
        });
    }
</script>
</body>
</html>
