<!DOCTYPE html>
<html lang="en">
<head>
  <title>My Profile</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
  .form-group {
     font-size: 16px; 
  }
  label {
    display: inline-block;
    width: 100%;
    margin-bottom: 5px;
    font-weight: 500;
    color: #aaa;
    font-size:12px;
  }
  .user_icon {
      border: 1px solid;
    width: 100px;
    height: 100px;
    margin: 0 auto;
    border-radius: 50%;
    text-align: center;
    overflow: hidden;
  }
  .user_icon i {
      font-size: 100px;
  }
  .pt-20 {
      padding-top: 20px;
  }
  .text-sm {
      font-size: 12px;
    color: #aaa;
  }
  .mr-50 {
      margin-right: 50px;
  }
  .modal-header, h4, .close {
    background-color: inherit;
    color: inherit !important;
    text-align: inherit;
    font-size: inherit;
}
.switch {
          margin-top:10px;
          position: relative;
          display: inline-block;
          width: 40px;
          height: 20px;
        }
        
        .switch input { 
          opacity: 0;
          width: 0;
          height: 0;
        }
        
        .slider {
          position: absolute;
          cursor: pointer;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
          background-color: #ccc;
          -webkit-transition: .4s;
          transition: .4s;
        }
        
        .slider:before {
          position: absolute;
          content: "";
          height: 13px;
          width: 13px;
          left: 4px;
          bottom: 4px;
          background-color: white;
          -webkit-transition: .4s;
          transition: .4s;
        }
        
        input:checked + .slider {
          background-color: #2196F3;
        }
        
        input:focus + .slider {
          box-shadow: 0 0 1px #2196F3;
        }
        
        input:checked + .slider:before {
          -webkit-transform: translateX(20px);
          -ms-transform: translateX(20px);
          transform: translateX(20px);
        }
        
        /* Rounded sliders */
        .slider.round {
          border-radius: 34px;
        }
        
        .slider.round:before {
          border-radius: 50%;
        }
        .swith_div {
            padding-right: 20px;
            overflow: hidden;
            
            text-align: center;
            width: 100%;
        }
        .swith_row {
            margin-right: 0 !important;
            overflow: hidden;
        }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left ">
    <div class="row">
        <div class="col-md-1"></div>
        <div class="common_main_div2 col-md-10">
        
          <h3 class="pt-20 text-left">Group Name: {{ $group->group_name }}</h3>
          <p><em>{{ $group->description }}</em></p>
            @if(Session::has( 'success' ))
             <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
            @elseif( Session::has( 'warning' ))
             <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
            @endif
            
            <div class="form-group form-check">
                 
                 @if(!$ingroup)
                 <a class="btn btn-warning" href="{{ route('join_group', ['id'=>$group->join_link]) }}"><i class="fa fa-add"></i>&nbsp;&nbsp;Join Group</a>
                 @else
                 <a class="btn btn-primary" href="{{ route('group_chat', ['id'=>$group->join_link]) }}"><i class="fa fa-message"></i>&nbsp;&nbsp;Message</a>
                 &nbsp;<a class="btn btn-warning" href="{{ route('group_dashboard', ['id'=>$group->join_link]) }}"><i class="fa fa-chat"></i>&nbsp;&nbsp;Question Dashboard</a>
                 @endif
                 
                 @if($group->created_by==auth()->user()->id)
                 <a class="btn btn-danger admin_dashboard" href="{{ route('group_admin_dashboard', ['id'=>$group->join_link]) }}" style="display:@if($group->save_all=="1") auto; @else none; @endif"><i class="fa fa-chat"></i>&nbsp;&nbsp;Admin Dashboard</a>
                 @endif
                 &nbsp;<a class="btn btn-secondary" onclick="copy_link();"><i class="fa fa-copy"></i>&nbsp;&nbsp;Invite Users Using Link</a>
                 
            </div>
            @if($group->created_by==auth()->user()->id)
            
            <div class="form-group form-check">
                <label class="switch">
                  <input type="checkbox" class="save_all" @if($group->save_all=="1") checked @endif onchange="update_saveall();">
                  <span class="slider save_all_slider round"></span>
                </label>
                <span class="save_all_span">Save all member chats</span>
                
                
            </div>
            
            
            @endif
            @if($ingroup)
            
            @php
            $used_limit = App\Models\UserQuestion::whereRaw('user_id IN (SELECT user_id FROM chat_members WHERE group_id="'.$group->id.'")')->count();
	        $today_used_limit = App\Models\UserQuestion::whereRaw('user_id IN (SELECT user_id FROM chat_members WHERE group_id="'.$group->id.'")')->where('created_at',date("Y-m-d"))->count();
	        $monthly_used_limit = App\Models\UserQuestion::whereRaw('user_id IN (SELECT user_id FROM chat_members WHERE group_id="'.$group->id.'")')->where('created_at','LIKE','%'.date("Y-m-").'%')->count();
            @endphp
            <h3>Question Asked Stats</h3>
            <p>Total questions asked: <b>{{$used_limit}}</b></p>
            <p>Total questions asked today: <b>{{$today_used_limit}}</b></p>
            <p>Total questions asked this month: <b>{{$monthly_used_limit}}</b></p>
            <p>&nbsp;</p>
            <h3>Group Members</h3>
            @if(count($members)>0)
                <table class="table" style="border: 1px solid #ddd;">
                    <thead class="thead-dark">
                    <tr>
                        <th rowspan="2">Name</th>
                        <th  style="border-left: 1px solid #eee;" colspan="3" class="text-center">Questions Asked</th>
                    </tr>
                    <tr>
                        <th style="border-left: 1px solid #eee;">Today</th>
                        <th>This Month</th>
                        <th>Total</th>
                    </tr>
                        
                    </thead>
                    <tbody>
                    
                    
                @foreach($members as $member)
                @if($member->user)
                    
                    
                    <tr>
                        <td>{{ $member->user->name }} &nbsp;
                    @if($member->user_level=="1")
                        <span class="text-sm">(Admin)</span> 
                    @elseif($group->created_by==auth()->user()->id) 
                        <a class="btn btn-danger btn-xs" href="{{ route('group_remove_member', ['id'=>$group->join_link,'user_id'=>$member->user_id]) }}"><i class="fa fa-trash"></i></a> 
                    @endif</td>
                        <td>{{count($member->user->asked_qns_count_today)}}</td>
                        <td>{{count($member->user->asked_qns_count_monthly)}}</td>
                        <td>{{count($member->user->asked_qns_count)}}</td>
                    </tr>
                    
                    
                    
                @endif
                @endforeach
                        
                    </tbody>
                    
                </table>
            
                
            @else
                <p>No Members</p>
            @endif
            @endif
            
            @if($group->created_by==auth()->user()->id) 
            
            
            <h3>Join Requests</h3>
                @if(count($group_requests)>0)
                    @foreach($group_requests as $requests)
                        @if($requests->user)
                            <p>
                                {{ $requests->user->name }} &nbsp;&nbsp;  
                                <a class="btn btn-success btn-xs" href="{{ route('join_group_accept', ['id'=>$group->join_link,'user_id'=>$requests->user_id]) }}">Accept</a>&nbsp;
                                <a class="btn btn-danger btn-xs" href="{{ route('join_group_reject', ['id'=>$group->join_link,'user_id'=>$requests->user_id]) }}">Reject</a>
                            </p>&nbsp;
                        @endif
                    @endforeach
                @else 
                <p>No new requests</p>
                @endif
            @endif
            <p></p>
        </div>
        <div class="col-md-1"></div>

</div>
</div>
<!-- Image of location/map -->


<div class="modal" id="myModal">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">New Group</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
        <form action="" method="post">
          <div class="form-group">
            <label for="email">Group Name</label>
            <input type="text" class="form-control" placeholder="Enter group name" id="group_name" name="group_name">
          </div>
          
          <button type="submit" class="btn btn-primary">Submit</button>
        </form>
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    function copy_link(){
        navigator.clipboard.writeText("{{ route('group_details', ['id'=>$group->join_link]) }}");
        //alert('Group link copied to clipboard');
        show_shackbar_message('Group link copied to clipboard');
    }
    function update_model(model){
        var _token= "{{ csrf_token() }}";
		
		var request = $.ajax({
		  url: "{{route('change_chat_model')}}",
		  method: "POST",
		  data: { _token : _token, model: model },
		  dataType: "json"
		});
		 
		request.done(function( msg ) {
		  //file_list();
		  //show_shackbar_message('Folder Created Successfully');
          //document.getElementById("addFolderModal").style.display = "none";
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  //show_shackbar_message( "Request failed: " + textStatus );
		});
		
    
    }
    function update_saveall(){
        var _token= "{{ csrf_token() }}";
		var save_all = 0;
		$('.admin_dashboard').hide();
		if($(".save_all").is(":checked")){
		    save_all = 1;
		    $('.admin_dashboard').show();
		}
		var request = $.ajax({
		  url: "{{route('update_save_all')}}",
		  method: "POST",
		  data: { _token : _token, group_id: '{{ $group->id }}', save_all: save_all },
		  dataType: "json"
		});
		 
		request.done(function( msg ) {
		  //file_list();
		  //show_shackbar_message('Folder Created Successfully');
          //document.getElementById("addFolderModal").style.display = "none";
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  //show_shackbar_message( "Request failed: " + textStatus );
		});
    }
</script>
</body>
</html>
