<!DOCTYPE html>
<html lang="en">
<head>
  <title>My Profile</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
  .form-group {
     font-size: 16px; 
  }
  label {
    display: inline-block;
    width: 100%;
    margin-bottom: 5px;
    font-weight: 500;
    color: #aaa;
    font-size:12px;
  }
  .user_icon {
      border: 1px solid;
    width: 100px;
    height: 100px;
    margin: 0 auto;
    border-radius: 50%;
    text-align: center;
    overflow: hidden;
  }
  .user_icon i {
      font-size: 100px;
  }
  .pt-20 {
      padding-top: 20px;
  }
  .text-sm {
      font-size: 12px;
    color: #aaa;
  }
  .mr-50 {
      margin-right: 50px;
  }
  .mt-20 {
      margin-top: 20px;
  }
  .each_group{
     border: 1px solid #aaa;
    padding: 10px;
  }
  .group_icon i {
      font-size: 25px;
    border: 1px solid #ddd;
    padding: 10px;
    border-radius: 50%;
  }
  .details_cog i {
      font-size: 15px;
  }
  .m-30 {
      margin-top: 20px;
  }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left ">
    <div class="row">
        <div class="col-md-1"></div>
        <div class="common_main_div2 col-md-10">
        
  <h3 class="pt-20 text-center">My Groups </h3>
  <p><em></em></p>
    @if(Session::has( 'success' ))
     <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
    @elseif( Session::has( 'warning' ))
     <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
    @endif
    <p class="m-30">
    <a class="pull-right btn btn-primary btn-sm" data-toggle="modal" data-target="#myModal">Start New Group</a>
    </p>
    <p>&nbsp;</p>
    <p>&nbsp;</p>
    <div class="row mr-20">
    @foreach($groups as $group)
        <div class="col-md-12 form-group form-check">
            <div class="each_group">
                <span class="text-sm pull-right">
                    <a class="details_cog" href="{{ route('group_chat', ['id'=>$group->join_link]) }}"><i class="fa fa-message"></i></a>
                </span>
                <span class="group_icon"><i class="fa fa-users"></i></span>
                &nbsp;<a href="{{ route('group_details',['id'=>$group->join_link]) }}">{{ $group->group_name }}</a>  <br>
                <span class="text-sm">({{count($group->members) }} members)</span>
                <time class="text-sm pull-right"> Last updated: {{ App\Http\Controllers\GroupChatController::time_elapsed_string($group->refreshed) }} </time>
            </div>
            
        </div>
    @endforeach
        </div>
    </div>
    <div class="col-md-1"></div>

</div>
</div>
<!-- Image of location/map -->


<div class="modal" id="myModal">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">New Group</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
        <form action="{{ route('create_group') }}" method="post">
            @csrf
          <div class="form-group">
            <label for="email">Group Name</label>
            <input type="text" class="form-control" placeholder="Enter group name" id="group_name" name="group_name">
          </div>
          <div class="form-group">
            <label for="email">Type</label>
            <input type="radio" id="public" name="type" value="0" checked>&nbsp;Public&nbsp;&nbsp;
            <input type="radio" id="private" name="type" value="1">&nbsp;Private&nbsp;&nbsp;
          </div>
          <div class="form-group">
            <label for="email">Group Description</label>
            <textarea class="form-control" placeholder="Enter description" id="description" name="description"></textarea>
          </div>
          
          <button type="submit" class="btn btn-primary">Submit</button>
        </form>
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    function update_model(model){
        var _token= "{{ csrf_token() }}";
		
		var request = $.ajax({
		  url: "{{route('change_chat_model')}}",
		  method: "POST",
		  data: { _token : _token, model: model },
		  dataType: "json"
		});
		 
		request.done(function( msg ) {
		  //file_list();
		  //show_shackbar_message('Folder Created Successfully');
          //document.getElementById("addFolderModal").style.display = "none";
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  //show_shackbar_message( "Request failed: " + textStatus );
		});
		
    
    }
    
</script>
</body>
</html>
