<!DOCTYPE html>
<html lang="en">
<head>
  <title>{{ config('app.name') }} News</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
  .form-group {
     font-size: 16px; 
  }
  label {
    display: inline-block;
    width: 100%;
    margin-bottom: 5px;
    font-weight: 500;
    color: #aaa;
    font-size:12px;
  }
  .user_icon {
      border: 1px solid;
    width: 100px;
    height: 100px;
    margin: 0 auto;
    border-radius: 50%;
    text-align: center;
    overflow: hidden;
  }
  .user_icon i {
      font-size: 100px;
  }
  .pt-20 {
      padding-top: 20px;
  }
  .text-sm {
      font-size: 12px;
    color: #aaa;
  }
  
  .cp_main_div {
      min-height: calc(100vh - 300px);
      background: transparent;
      padding: 15px;
  }
  .each_skill {
      display: inline-block;
      margin-bottom: 12px;
      
  }
  .skill_checkbox {
      position: absolute;
      opacity: 0;
      cursor: pointer;
      height: 0;
      width: 0;
  }
  .skill_div {
      text-align: center;
          padding: 20px;
  }
  .skill_name {
      cursor: pointer;
      margin-right: 12px;
      padding: 4px 8px;
      text-align: center;
      border-radius: 5px;
      border: 1px solid #666;
  }
  .checked_box {
      background-color: green;
      color: #fff;
  }
  .answered_question {
      background-color: #90EE90;
  }
  .current_step {
      
      background-color: #FFD580;
  }
  .hide_extra_skill {
      display:none;
  }
  .show_extra_skill {
      display:block;
  }
  .eachnews {
      margin-top: 20px;
      float:left;
      background: transparent;
      border-bottom: 1px solid #666;
  }
  .eachnews img {
      width:100px;
      float:left;
  }
  .eachnews .caption {
      float:left;width: calc(100% - 100px);
      color: #fff;
  }
  .thumbnail {
    background: transparent;
  }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left ">
    <div class="row">
        <div class="cp_main_div col-md-12">
        <h2 style="color: #fff;">Recent News</h2>
        @if(isset($news['results']))
            @if(isset($news['results']['results']) && isset($news['results']['results']['top_stories']))
                <hr>
                <div class="row">
                @foreach($news['results']['results']['top_stories'] as $story)
                      <div class="col-md-12 eachnews">
                        <div class="thumbnail">
                          <img src="{{ $story['image'] }}" alt="" style="">
                          <div class="caption" style="">
                            {{ $story['title'] }}
                            <p>
                            <a href="{{ $story['link'] }}" target="_blank" class="btn btn-default" role="button">View</a></p>
                          </div>
                        </div>
                      </div>
                @endforeach
                </div>
            @endif
            <!--
            @if(isset($news['results']['results']) && isset($news['results']['results']['inline_videos']))
                
                <hr>
                @foreach($news['results']['results']['inline_videos'] as $videos)
                      <div class="col-xs-6 col-md-4">
                        <video width="100%" height="240" controls>
                          <source src="{{$videos['url']}}" type="video/mp4">
                          <source src="{{$videos['url']}}" type="video/ogg">
                          Your browser does not support the video tag.
                        </video>
                      {{ $videos['title'] }}
                      </div>
                @endforeach
                </div>
            @endif
            -->
        @else
                <hr>
            <p style="color:white;">Comming Soon!</p>
        @endif
        
        </div>

</div>
</div>
<div class="modal" id="myModal">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">Previous Result</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
       
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>
<!-- Image of location/map -->

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    $(document).ready(function(){
      
    });
    
</script>
</body>
</html>
