<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Theme Made By www.w3schools.com - No Copyright -->
  <title>Home - Taxi Nearby</title></title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
      .card {
        border: 1px solid;
        border-radius: 10px;
        padding: 10px 0px;
      }
      .driver_div {
          margin-bottom: 10px;
      }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')

<div id="band" class="container text-center">
  <h3>Taxi Nearby</h3>
  
  <div class="row">
      
    @if ( session()->has('msg') )
    <div class="alert alert-success">{{ session()->get('msg') }}</div>
    @endif
    @if($msg == "unavailable") 
    <div class="alert alert-success">{{ 'Unable to get your location. Allow Location and click on "Refresh Location" Button' }}</div>
    @endif
    <a class="btn btn-danger" onclick="getLocation();">Refresh Location</a>
    @if(Auth()->user()->level==3)
    <div class="col-sm-12">
        <p>
           <div class="custom-control custom-switch">
              <input type="checkbox" class="custom-control-input" id="available" value="1" {{ Auth()->user()->available=='1'?'checked':''}}>
              <label class="custom-control-label" for="available">Available for ride</label>
            </div>
        </p>
    </div>
    @else
    @foreach($drivers as $driver)
    <div class="col-sm-4 driver_div">
      <div class="card">
          <img class="card-img-top" src="{{ $driver->vehicle_type=='Auto'?url('images/auto.png'):url('images/car.png')}}" alt="{{ $driver->vehicle_type }}" width="200px">
          <div class="card-body">
            <h5 class="card-title">{{ $driver->vehicle_name }} ({{$driver->vehicle_type}}) - {{ $driver->vehicle_model }}</h5>
            <p class="card-text">{{ ceil($driver->distance) }} kms away</p>
            <a href="{{ route('view_driver',$driver->id) }}" class="btn btn-sm btn-primary">View</a>
          </div>
        </div>
    </div>
    @endforeach
    @endif
    
  </div>
</div>


@php
$disclaimer = true;
@endphp
<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    $(document).ready(function(){
       $('#available').change(function(){
           var available = 0;
           if($(this).prop('checked') == true){
               available = 1;
           }
           var _token= "{{ csrf_token() }}";
          const xhttp=new XMLHttpRequest();
          xhttp.onload = function() {
              
            var chatData = JSON.parse(xhttp.responseText);
          }
          xhttp.open("POST", "{{route('update_availability')}}");
          xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
          xhttp.send("_token="+_token+"&available="+available);
             
       }); 
    });
    
getLocation();
function getLocation(manual=0) {
  if (navigator.geolocation) {
      if(manual==1){
          navigator.geolocation.getCurrentPosition(showPosition1);
      } else {
        navigator.geolocation.getCurrentPosition(showPosition);
      }
  } else {
    alert("Geolocation is not supported by this browser.");
  }
}

function showPosition(position) {
    
    var latitude = position.coords.latitude;
    var longitude = position.coords.longitude;
    var _token= "{{ csrf_token() }}";
      const xhttp=new XMLHttpRequest();
      xhttp.onload = function() {
          
        var chatData = JSON.parse(xhttp.responseText);
      }
      xhttp.open("POST", "{{route('update_location')}}");
      xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
      xhttp.send("_token="+_token+"&latitude="+latitude+"&longitude="+longitude);
}
function showPosition1(position) {
    loader_on();
    var latitude = position.coords.latitude;
    var longitude = position.coords.longitude;
    var _token= "{{ csrf_token() }}";
      const xhttp=new XMLHttpRequest();
      xhttp.onload = function() {
          
        var chatData = JSON.parse(xhttp.responseText);
        loader_off();
        location.reload();
      }
      xhttp.open("POST", "{{route('update_location')}}");
      xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
      xhttp.send("_token="+_token+"&latitude="+latitude+"&longitude="+longitude);
}
</script>
</body>
</html>
