<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Theme Made By www.w3schools.com - No Copyright -->
  <title>Pricings - {{ config('app.name') }}</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
      .card-row {
          margin: 30px auto;
      }
      .card {
          padding-bottom: 20px;
          padding-top: 10px;
          border-radius: 5px;
          border: 1px solid #eee;
      }
      .card-text {
          padding: 6px;
      }
      .card-title span {
         font-size: 16px;
         padding: 2px;
      }
      .package_name {
         font-size: 16px;
         padding: 3px;
         color: darkblue;
      }
      .price_div {
          color: #eeeeee;
      }
      .price_div .card-body {
      }
      .free_div {
          background-color: #345171;
          border-left : 8px solid #343a5a;
      }
      
      .price_div1 {
          background-color: #47868b;
          border-left : 8px solid #236976;
      }
      .price_div2 {
          background-color: #6a5979;
          border-left : 8px solid #573460;
      }
      .price_div3 {
          background-color: #b36477;
          border-left : 8px solid #873f55;
      }
      .price_div4 {
          background-color: #e76a6e;
          border-left : 8px solid #c84864;
      }
      
      .free_div .card-body .btn-primary {
          background-color: #343a5a;
      }
      .price_div1 .card-body .btn-primary {
          background-color: #236976;
      }
      .price_div2 .card-body .btn-primary {
          background-color: #573460;
      }
      .price_div3 .card-body .btn-primary {
          background-color: #873f55;
      }
      .price_div4  .card-body .btn-primary{
          background-color: #c84864;
      }
      .side_tag {
            position: absolute;
            left: -12px;
            top: 0px;
            z-index: 1;
      }
      
      .side_tag_free svg polygon {
          fill:#343a5a;
      }
      .side_tag_1 svg polygon {
          fill:#236976;
      }
      .side_tag_2 svg polygon {
          fill:#573460;
      }
      .side_tag_3 svg polygon {
          fill:#873f55;
      }
      .side_tag_4 svg polygon {
          fill:#c84864;
      }
      .side_tag p {
          transform: rotate(-90deg);
          position: absolute;
            top: 45px;
      }
      .side_tag .prem_text {
        top: 50px;
        left: -8px;
      }
      .card {
          border:none;
      }
      .modal-header {
            padding: 10px 30px;
        }
        .coupon_msg  {
        }
        .level_free {
            margin-bottom: 10px;
        }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')

<div id="band" class="container-fluid text-center common_main_div">
  <h3>Pricings</h3>
  <p><em>SIMPLE & TRANSPARENT PRICING.</em></p>
  @if( Session::has( 'warning' ))
     <p><b class="text-danger">{{ Session::get( 'warning' ) }}</b></p>
    @endif
  <form action="{{ route('checkout') }}" method="post" id="checkout_form">
      @csrf
  <div class="row card-row">
   
  
  <div class="col-sm-3"></div>
  <!--<div class="col-sm-3 level_2 level_free">
    @if(isset($output))
    <p class="text-danger">
        {!! $output !!}
    </p>
    @endif
    <div class="card free_div price_div">
    <div class="side_tag side_tag_free">
        <p>Free</p>
        <svg height="150" width="30" xmlns="http://www.w3.org/2000/svg">
            <polygon points="0,0 0,120 30,150 30,0" style="" />
        </svg>
    </div>
    
    
      <div class="card-body">
        <h2 class="card-title"><span>₹</span> {{$free_package->price}} <span> /{{ $free_package->period }}</span></h2>
        <p class="card-text">Question limit: {{ $free_package->question_limit }}</p>
        <p class="card-text">GPT 3.5</p>
        
        <a onclick="#" class="btn btn-primary">Free</a>
        
      </div>
    </div>
  </div>-->
  @php
    $ip = $_SERVER['REMOTE_ADDR'];
    $details = json_decode(file_get_contents("http://ipinfo.io/{$ip}/json"));
    $mycountry = $details->country; 
  @endphp
  @foreach($all_packages as $apk)
  <div class="col-sm-3 level_2 level_free">
    <div class="card free_div price_div">
        
    <div class="side_tag side_tag_free">
        <p class="prem_text">{{$apk->name}}</p>
        <svg height="150" width="30" xmlns="http://www.w3.org/2000/svg">
            <polygon points="0,0 0,120 30,150 30,0" style="" />
        </svg>
    </div>
    
    
      <div class="card-body">
        @if($mycountry=="IN") 
            <h2 class="card-title"><span>₹</span> {{$apk->price}} <span></span></h2>
             @if($apk->price!=$apk->mrp)
            <h3 class="card-subheading package_name"><strike>₹{{$apk->mrp}}</strike> {{ (int)(100-($apk->price*100)/$apk->mrp) }}% off</h3>
            @endif
        @else
        
            <h2 class="card-title"><span>$</span> {{$apk->price_usd}} <span></span></h2>
             @if($apk->price_usd!=$apk->mrp_usd)
            <h3 class="card-subheading package_name"><strike>₹{{$apk->mrp_usd}}</strike> {{ (int)(100-($apk->price_usd*100)/$apk->mrp_usd) }}% off</h3>
            @endif
        @endif
        <p class="card-text">Question limit: {{ $apk->question_limit }}</p>
        <p class="card-text">Validity: {{ $apk->period }}</p>
        <p class="card-text">Email, Chat, On-Call Support</p>
        <p class="card-text">Access to Advanced Features (Create folders and ask multiple PDFs at a time)</p>
        <p class="card-text">No Time limit</p>
        <p class="card-text">Embed Chat Window Anywhere</p>
        <p class="card-text">Improved Performance & Responses with GPT 4.0</p>
        @if(auth()->user())
        <a onclick="setPackage({{$apk->id}})" class="btn btn-primary">Upgrade Now</a>
        @endif
      </div>
    </div>
  </div>
  @endforeach
  
  <!--
  @if(!$mypackage)
  <div class="col-sm-3 level_2 level_free">
    <div class="card free_div price_div">
        
    <div class="side_tag side_tag_free">
        <p class="prem_text">Basic</p>
        <svg height="150" width="30" xmlns="http://www.w3.org/2000/svg">
            <polygon points="0,0 0,120 30,150 30,0" style="" />
        </svg>
    </div>
    
    
      <div class="card-body">
        <h2 class="card-title"><span>₹</span> {{$free_package->price}} <span></span></h2>
         @if($free_package->price!=$free_package->mrp)
        <h3 class="card-subheading package_name"><strike>₹{{$free_package->mrp}}</strike> {{ (int)(100-($free_package->price*100)/$free_package->mrp) }}% off</h3>
        @endif
        <p class="card-text">Question limit: {{ $free_package->question_limit }}</p>
        <p class="card-text">Email, Chat, On-Call Support</p>
        <p class="card-text">Access to Advanced Features (Create folders and ask multiple PDFs at a time)</p>
        <p class="card-text">No Time limit</p>
        <p class="card-text">Embed Chat Window Anywhere</p>
        <p class="card-text">Improved Performance & Responses with GPT 4.0</p>
        @if(auth()->user())
        <a onclick="setPackage({{$free_package->id}})" class="btn btn-primary">Upgrade Now</a>
        @endif
      </div>
    </div>
  </div>
  @endif
  <div class="@if($mypackage) col-sm-4 @else col-sm-3 @endif level_2 level_pre">
    <div class="card price_div1 price_div">
        
    <div class="side_tag side_tag_1">
        <p class="prem_text">Premium</p>
        <svg height="150" width="30" xmlns="http://www.w3.org/2000/svg">
            <polygon points="0,0 0,120 30,150 30,0" style="" />
        </svg>
    </div>
    
    
      <div class="card-body">
        <h2 class="card-title"><span>₹</span> {{$premium_package->price}} <span></span></h2>
         @if($premium_package->price!=$premium_package->mrp)
        <h3 class="card-subheading package_name"><strike>₹{{$premium_package->mrp}}</strike> {{ (int)(100-($premium_package->price*100)/$premium_package->mrp) }}% off</h3>
        @endif
        <p class="card-text">Question limit: {{ $premium_package->question_limit }}</p>
        <p class="card-text">Email, Chat, On-Call Support</p>
        <p class="card-text">Access to Advanced Features (Create folders and ask multiple PDFs at a time)</p>
        <p class="card-text">No Time limit</p>
        <p class="card-text">Embed Chat Window Anywhere</p>
        <p class="card-text">Improved Performance & Responses with GPT 4.0</p>
        @if(auth()->user())
        <a onclick="setPackage({{$premium_package->id}})" class="btn btn-primary">Upgrade Now</a>
        @endif
      </div>
    </div>
  </div>
  -->
  <div class="col-sm-3"></div>
  
  </div>
  
  <input type="hidden" name="package" id="package_id" value="">
</form>
</div>


<div class="modal" id="myModalgrp">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">Checkout</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body text-center">
          <div class="form-group mb-2">
            <span>Coupon Code</span>
          </div>
          <div class="form-group mx-sm-3 mb-2">
            
            <input type="text" class="form-control" id="coupon_code" name="coupon_code" placeholder="Enter Coupon Code">
          </div>
          <a class="btn btn-warning mb-2" onclick="apply_coupon()">APPLY</a>
      </div>
      <p class="coupon_msg text-center"></p>
      <input type="hidden" value="" id="pkg_id">
      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-success share_btn" onclick="checkout()">Checkout</button>
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    @if(auth()->user())
     @if(auth()->user()->level=="2")
        $('.level_st').hide();
        $('.level_2').show();
     @elseif(auth()->user()->level=="3")
        $('.level_st').hide();
        $('.level_3').show();
     @elseif(auth()->user()->level=="4")
        $('.level_st').hide();
        $('.level_4').show();
     @elseif(auth()->user()->level=="5")
        $('.level_st').hide();
        $('.level_4').show();
     @endif
    @else
     @if(isset($_GET['type']) && $_GET['type']=="2")
        $('.level_st').hide();
        $('.level_2').show();
     @elseif(isset($_GET['type']) && $_GET['type']=="3")
        $('.level_st').hide();
        $('.level_3').show();
     @elseif(isset($_GET['type']) && $_GET['type']=="4")
        $('.level_st').hide();
        $('.level_4').show();
     @elseif(isset($_GET['type']) && $_GET['type']=="5")
        $('.level_st').hide();
        $('.level_4').show();
     @else
        $('.level_st').hide();
        $('.level_2').show();
     @endif
    @endif
    function setPackage(package){
        $('.coupon_msg').html('');
        $('#package_id').val(package);
        $('#pkg_id').val(package);
        
        $('#myModalgrp').modal('show');
        
        
    }
   
    function apply_coupon(){ 
        $('.coupon_msg').removeClass('text-success');
        $('.coupon_msg').removeClass('text-danger');
        $('.coupon_msg').html('Checking...<img src="images/loader.gif" height="50px">');
        var coupon_code = $('#coupon_code').val();
        var id = $('#pkg_id').val();
        var _token= "{{ csrf_token() }}";
        var request = $.ajax({
            url: '{{ route("apply_coupon") }}',
            method: "POST",
            data: { _token : _token, coupon_code: coupon_code, id: id  },
            dataType: "json"
          });

          request.done(function( msg ) {
            $('.coupon_msg').html(msg.result);
            $('.coupon_msg').addClass('text-'+msg.status);
          });

          request.fail(function( jqXHR, textStatus ) {
            $('.coupon_msg').html('');
            
          });
    }
    function checkout(){
        $('#checkout_form').submit();
    }
</script>
</body>
</html>
