<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Theme Made By www.w3schools.com - No Copyright -->
  @php
    $currsiteurl = $_SERVER['HTTP_HOST'];
    if($currsiteurl=="legalbox.ai"){
        $sitename = "LegalBox AI";
        $loginheading = "Legalbox<br>AI";
        $siteuser="law";
    }  elseif($currsiteurl=="corporategenie.ai"){
        $sitename = "CorporateGenie AI";
        $loginheading = "CorporateGenie<br>AI";
        $siteuser="corporate";
    } elseif($currsiteurl=="app.edubuddy.ai"){
        $sitename = "Edubuddy AI";
        $loginheading = "Edubuddy<br>AI";
        $siteuser="student";
    }   elseif($currsiteurl=="qwikaide.com"){
        $sitename = "QwikAide";
        $loginheading = "Qwik<br>Aide";
        $siteuser="student";
    }  else {
        $sitename = "iLife Genie";
        $loginheading = "i-Life<br>Genie";
        $siteuser="normal";
    }
    @endphp
  <title>Privacy Policy - {{ $sitename }}</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')

<div id="band" class="container text common_main_div">
  <h3>Privacy Policy</h3>
   <div><p>Your privacy is paramount to us at&nbsp;<a href="https://ilifeaceit.com/">QwikAide.com</a>. This Privacy Policy outlines our commitment to safeguarding your personal information and complying with all applicable laws and regulations related to privacy across our website and other sites we operate.</p>

<p>Personal information refers to any data that can identify you, such as your name, address, date of birth, payment details, or information about how you interact with our website and services. Our privacy principles reflect our dedication to handling your data responsibly:</p>

<p>We only request personal information when necessary to deliver or improve our services.</p>

<p>We do not:</p>

<p>Rent your personal information to any third parties.</p>

<p>Sell your personal information to others.</p>

<p>Exchange your personal information with any third parties for commercial purposes.</p>

<p>However, we may share your personal information in the following circumstances:</p>

<p><strong>As required by law:</strong>&nbsp;If we are legally obligated to disclose your data, such as complying with a court order or government request.</p>

<p><strong>To </strong><strong>fulfill</strong><strong> our services:</strong>&nbsp;When sharing is necessary to provide or improve our services to you, such as with service providers who help us run our platform.</p>

<p><strong>To protect our rights:</strong>&nbsp;If sharing your information is essential to protect the safety, rights, or property of our company, users, or the public.</p>

<p>We strive to make it easy for you to manage your data preferences, including controlling what information is:</p>

<p>(a) visible to the public,</p>

<p>(b) accessible to third-party search engines, browsers, or platforms,</p>

<p>(c) kept private,</p>

<p>(d) permanently deleted when no longer needed.</p>

<p>If our site contains links to third-party websites or services, please note that they are governed by their own privacy policies. Once you leave our site, this Privacy Policy no longer applies to your activities on external platforms. We recommend reviewing the privacy policies of any third-party services to understand how they manage personal data.</p>

<p>By using QwikAide's services, you agree to the terms outlined in this Privacy Policy and consent to the collection, use, and storage of your personal information as described here. This is in accordance with our commitment to providing a secure and educational environment.</p>

<p><strong>1: Safeguarding Student Privacy and Personal Information</strong></p>

<p>At QwikAide, we prioritize the protection of children and student data, ensuring that their personally identifiable information is treated with the utmost care. Our privacy practices comply with global data protection laws, including the Children's Online Privacy Protection Act (COPPA) in the United States, the General Data Protection Regulation (GDPR) in the European Union, and regional privacy laws in the US, India, and the UAE. We also support schools in fulfilling their obligations under the Family Educational Rights and Privacy Act (FERPA) in the US.</p>

<p>Minimal Data Collection and Privacy-Focused Experience</p>

<p>QwikAide offers a privacy-centric platform that limits data collection to protect young users worldwide. Students are not required to provide personal information, such as names or contact details, nor are they required to create accounts. For students under the legal age to provide consent (as defined by COPPA, GDPR, and other laws), QwikAide does not collect personal information and takes additional measures to safeguard privacy where required by law.</p>

<p>Except as specified in this privacy policy, QwikAide does not collect, distribute, share, or sell personal information. We implement safeguards for data access, control, and deletion, emphasizing the rights of parents and educational institutions to manage and review student data.</p>

<p>Privacy Protection Features</p>

<p>No Behaviorally Targeted Advertising: There is no behavioral profiling or targeted advertising directed at students.</p>

<p>Anonymous Participation: Students can engage in games without the need to create accounts, ensuring their anonymity.</p>

<p>No Direct Messaging: To prevent inappropriate contact, QwikAide does not allow direct messaging between students.</p>

<p>Content Moderation: All content, including quizzes, is subject to proactive content filters and reporting tools to maintain a safe and respectful platform.</p>

<p>Global Data Storage and Compliance</p>

<p>QwikAide is committed to storing user data securely while complying with local data protection standards in different regions, including the US, UAE, India, and beyond. Data is processed according to regional regulations, such as FERPA and GDPR. Where applicable, QwikAide provides parents and schools with the ability to access or delete limited information related to student participation.</p>

<p>Continuous Privacy Audits and Policy Updates</p>

<p>To stay aligned with evolving privacy standards, QwikAide conducts regular audits and updates its privacy policies in line with global data protection regulations. This ensures the platform remains a safe, transparent, and privacy-conscious space for students, educators, and parents worldwide.</p>

<p><strong>2: Parental Rights and Data Consent</strong></p>

<p>QwikAide is committed to safeguarding children's privacy and empowering parents and guardians to manage and control their child's personal information. We comply with privacy laws, such as COPPA in the United States, GDPR in the European Union, the UAE's Personal Data Protection Law, and India's Information Technology (IT) Act, to ensure responsible data practices for children under the age of consent (under 13 in the U.S. or as specified by local regulations).</p>

<p>Minimal Data Collection for Child Users</p>

<p>For children under the age of consent, QwikAide collects only essential information, such as a parent or guardian's email address. In some cases, we may also collect a student's first name, which is generally not considered personally identifiable information (PII) but may be considered personal information in certain contexts. This data is used strictly for educational purposes and is never shared with third parties for non-essential activities.</p>

<p>Parental Control and Access to Child Accounts</p>

<p><strong>Manage Data:</strong>&nbsp;Review, modify, or delete their child's information by accessing their child's account.</p>

<p><strong>Disable Data Collection:</strong>&nbsp;Disable further data collection by deleting their child's account via the parental dashboard at&nbsp;<a href="https://ilifeaceit.com/profile">QwikAide.com/profile</a>&nbsp;or by contacting us at&nbsp;<a href="mailto:privacy@ilifeaceit.com">privacy@QwikAide.com</a>.</p>

<p>To protect privacy, QwikAide requires all requests to review, modify, or delete data to come from a verified parent or guardian. We may ask for security questions or other identity verification steps to confirm the requester's identity.</p>

<p>Privacy Protections for Children</p>

<p>Limited Data Collection: We collect only the necessary data to provide educational services.</p>

<p>Non-Personal Identifiers: Persistent identifiers are assigned only for the purpose of recognizing repeat visitors and enhancing their experience, without linking them to personal information unless parental consent is provided.</p>

<p>Parental Consent: Parental consent is required for educational use, with no authorization for broader marketing or use beyond the educational services.</p>

<p>Immediate Action for Non-Consent: If we learn that personal information has been collected from a child under the age of consent without proper permission, we will either obtain verified parental consent or delete the data immediately.</p>

<p>Data Retention and Deletion</p>

<p>QwikAide retains children's data only for as long as necessary to provide educational services or as required by law. For inactive accounts, QwikAide adheres to a strict data retention period and ensures that data is deleted once it is no longer needed.</p>

<p><strong>3: Information Collected by </strong><strong>QwikAide</strong></p>

<p>QwikAide is committed to respecting users' privacy and only collects the minimum necessary data to provide and improve our services. We adhere to privacy laws such as COPPA, FERPA, CCPA, GDPR, and similar regulations in the US, EU, UK, EEA, Canada, Australia, Brazil, and other regions where QwikAide operates.</p>

<p><strong>3.1. Sensitive Information</strong></p>

<p>QwikAide does not collect sensitive data such as race, ethnicity, health information, biometric data, political affiliations, or free/reduced lunch eligibility. We are committed to protecting the privacy of all users globally and ensure compliance with applicable privacy laws across all regions where our services are available.</p>

<p><strong>3.2. Information Provided by Users</strong></p>

<p>While creating an account is optional, it is required to access specific features and save progress. Based on account types, QwikAide collects the following types of data:</p>

<p><strong>General Account Information:</strong></p>

<p><strong>Teacher Accounts:</strong>&nbsp;Name, email, school name, phone number, country, and zip code.</p>

<p><strong>Corporate/Organization Accounts:</strong>&nbsp;Name, email, organization name, phone number, country, and zip code.</p>

<p><strong>Individual Accounts:</strong>&nbsp;Name, email, profession/occupation, and phone number.</p>

<p><strong>Optional Data:</strong>&nbsp;Profile photo and organization name (for certain features).</p>

<p><strong>Additional data:</strong>&nbsp;May include:</p>

<p>Support Interactions: Information provided when contacting support.</p>

<p>Research or Marketing Campaigns: Data collected during participation in surveys or promotions.</p>

<p>Sweepstakes: Information shared when entering contests or sweepstakes.</p>

<p>Academic Content: Users may create content (such as quizzes or responses), which is typically non-identifiable. This data can be deleted by the user or by contacting support at&nbsp;<a href="mailto:support@ilifeaceit.com">support@QwikAide.com</a>.</p>

<p>Financial Transactions: Payments are processed securely through PCI-compliant payment providers, and QwikAide does not store financial data.</p>

<p><strong>3.3. Automatically Collected Information</strong></p>

<p>To enhance user experience and improve our services, QwikAide automatically collects certain data, including:</p>

<p>Device and Network Data: Includes device type, operating system, device identifiers (e.g., IDFA, UDID), and network information.</p>

<p>Usage Logs: Captures browser type, language, time zone, IP address, referral source, and login/logout times. IP addresses are used solely to approximate location for regional versions of QwikAide. Fine location data (e.g., GPS, Bluetooth) is not collected.</p>

<p>Google Analytics: We use Google Analytics to understand how our services are used without identifying individual users. Google Analytics uses cookies, and users can opt out at any time while continuing to access QwikAide services.</p>

<p>Aggregated Data: Non-personal, aggregated demographic and activity data may be used for research and improving the platform.</p>

<p>QwikAide does not collect covert data, such as audio or video recordings, without user consent.</p>

<p><strong>4: Data Retention and Information Storage</strong></p>

<p>QwikAide retains user information for as long as necessary to provide services, maintain your account, and comply with applicable legal obligations. To ensure platform security and user privacy, we periodically review accounts and may delete inactive accounts after a minimum of one year of inactivity.</p>

<p><strong>Retention of Information for Legal and Operational Purposes</strong></p>

<p>Certain information may be retained as necessary to comply with legal obligations, resolve disputes, and enforce our agreements. This includes any data required for ongoing legal matters or unresolved issues.</p>

<p><strong>Account Deletion and Data Removal</strong></p>

<p>You have the right to delete your account or update your information at any time by visiting&nbsp;<a href="https://ilifeaceit.com/profile">QwikAide.com/profile</a>. Deleting your account will remove associated information from active databases, but some data may be retained as required by law or to address any unresolved issues.</p>

<p><strong>5: Data Sharing with Third Parties</strong></p>

<p>QwikAide is committed to protecting your privacy and shares data with third parties only under strict conditions to improve platform functionality, ensure legal compliance, or with your explicit consent. Below are the details of our practices regarding data sharing and third-party services:</p>

<p><strong>5.1 Third-Party Service Providers</strong></p>

<p>QwikAide partners with third-party providers to enhance platform features and user experience. These providers comply with privacy and security standards to ensure data protection.</p>

<p><strong>Cloud Hosting and Database Management:</strong>&nbsp;QwikAide uses Google Firebase and Firestore for secure and scalable cloud hosting and database management, ensuring data processing and storage are compliant with privacy regulations.</p>

<p><strong>Communication Services:</strong>&nbsp;Customer communication is handled via Brevo, used exclusively for transactional and informational emails, excluding student communications.</p>

<p><strong>Analytics and Tracking:</strong>&nbsp;We use Google Analytics to analyze platform usage patterns and improve performance. The data collected is anonymized and complies with applicable privacy standards.</p>

<p><strong>Payment Processing:</strong>&nbsp;Payments are processed securely through Razorpay, which adheres to PCI DSS standards. Sensitive payment information is never stored on our platform.</p>

<p><strong>5.2 Google and YouTube API Integrations</strong></p>

<p>QwikAide integrates Google and YouTube API Services for authentication, user management, and educational content delivery:</p>

<p><strong>Google API Services:</strong></p>

<p>We use Google APIs, including Google Sign-In, for secure authentication and user authorization. This grants QwikAide access to user data such as names and email addresses, but passwords are not accessible by QwikAide.</p>

<p>We comply with the Google API Services User Data Policy and adhere to its Limited Use requirements.</p>

<p><strong>YouTube API Services:</strong></p>

<p>QwikAide uses YouTube API services to provide educational content. We comply with YouTube's Terms of Service and Developer Policies.</p>

<p>Data accessed through YouTube APIs is limited to what is necessary for the service and is governed by YouTube and Google's privacy policies.</p>

<p><strong>Commitment to Privacy:</strong>&nbsp;QwikAide does not use Google Workspace APIs for developing, improving, or training AI models.</p>

<p>By using QwikAide, you acknowledge and agree to comply with YouTube's Terms of Service and Google's Privacy Policy.</p>

<p><strong>5.3 Reasons for Data Sharing</strong></p>

<p>QwikAide shares user data with third parties only in the following circumstances:</p>

<p><strong>Service Provisioning:</strong>&nbsp;To enable platform functionalities such as hosting, payment processing, and API integrations.</p>

<p><strong>Legal Compliance:</strong>&nbsp;To comply with applicable laws and respond to lawful government requests.</p>

<p><strong>Aggregate Insights:</strong>&nbsp;Non-personally identifiable data may be shared for research or service improvement purposes.</p>

<p><strong>Ownership Changes:</strong>&nbsp;In the event of a merger or acquisition, data will be transferred to the new entity with prior notification, ensuring adherence to our privacy commitments.</p>

<p><strong>5.4 User Control and Transparency</strong></p>

<p>QwikAide prioritizes user control over data sharing:</p>

<p><strong>Opt-Out Options:</strong>&nbsp;Users can opt out of non-essential services, though foundational services like hosting and authentication are required for platform functionality.</p>

<p><strong>Notifications:</strong>&nbsp;Significant changes in data-sharing practices will be communicated to users in advance.</p>

<p><strong>5.5 Third-Party Compliance and Security</strong></p>

<p>QwikAide ensures that all third-party providers comply with strict security standards and privacy regulations:</p>

<p>Data is used only for specified purposes as outlined in agreements with QwikAide.</p>

<p>Providers adhere to global privacy laws, including GDPR and COPPA.</p>

<p><strong>Third-Party Service Providers</strong></p>

<p>For clarity, the table below summarizes the third-party services QwikAide uses, their purpose, and the type of data they process:</p>

<table><colgroup><col><col><col><col></colgroup><tbody><tr><td><p><strong>Service Provider</strong></p></td><td><p><strong>Purpose</strong></p></td><td><p><strong>Data Processed</strong></p></td><td><p><strong>Compliance</strong></p></td></tr>
<tr><td><p>Google Firebase</p></td><td><p>Cloud hosting and database management</p></td><td><p>User data, application data</p></td><td><p>Adheres to Google's privacy and security standards.</p></td></tr>
<tr><td><p>Google Firestore</p></td><td><p>Real-time database management</p></td><td><p>User information and app data</p></td><td><p>Compliant with industry security standards.</p></td></tr>
<tr><td><p>Google APIs</p></td><td><p>Authentication, Google Sign-In</p></td><td><p>Name, email address (with consent)</p></td><td><p>Follows Google API Services User Data Policy.</p></td></tr>
<tr><td><p>Google Classroom API</p></td><td><p>Integration for classroom features</p></td><td><p>Names, email addresses (with consent)</p></td><td><p>Compliant with Google Privacy Policy.</p></td></tr>
<tr><td><p>YouTube API Services</p></td><td><p>Educational content integration</p></td><td><p>YouTube data (as required by projects)</p></td><td><p>Adheres to YouTube Terms of Service.</p></td></tr>
<tr><td><p>Brevo (formerly Sendinblue)</p></td><td><p>Communication via email and notifications</p></td><td><p>Email addresses (non-student users)</p></td><td><p>Complies with GDPR for email communications.</p></td></tr>
<tr><td><p>Razorpay</p></td><td><p>Payment processing</p></td><td><p>Payment details (via secure gateway)</p></td><td><p>PCI DSS certified. QwikAide does not store payment information.</p></td></tr>
<tr><td><p>Google Analytics</p></td><td><p>Analytics and usage tracking</p></td><td><p>Anonymized user behavior data</p></td><td><p>Complies with Google Analytics privacy and data protection guidelines.</p></td></tr>
</tbody></table>

<p><strong>6: Collection of Minimum Necessary Personal Information</strong></p>

<p>QwikAide is committed to collecting only the essential personal information required to operate its diverse range of products and services, which include web and mobile applications, gamified learning platforms, quiz-hosting tools, and enterprise solutions. The specific data collected depends on the user type and the services requested, ensuring that only minimal data is collected for each interaction.</p>

<p><strong>6.1 Data Collection by User Type</strong></p>

<p><strong>For Students and Individuals:</strong>&nbsp;Students or individuals using QwikAide's services may be required to provide minimal information to participate in games, quizzes, or other activities. In some cases, users can participate anonymously, requiring no identifiable data.</p>

<p><strong>For Educators and Teachers:</strong>&nbsp;Educators creating accounts to manage activities such as quizzes or classroom tasks may provide basic identifying details (e.g., name, email). Generic profiles can be used to further minimize the collection of student data.</p>

<p><strong>For Organizations and Corporates:</strong>&nbsp;QwikAide collects relevant organizational data from institutions or businesses to provide enterprise-level solutions. This may include organizational details, administrator contact information, and account-related data.</p>

<p><strong>6.2 Avoidance of Unnecessary Data Collection</strong></p>

<p>QwikAide does not collect or access unnecessary personal data such as browser history, contact lists, search terms, preferences, device identifiers, or location unless directly required to provide the service. This approach ensures that user privacy is respected by limiting data collection to only what is necessary for service delivery.</p>

<p><strong>6.3 Metadata Collection and Security</strong></p>

<p>All interactions with the QwikAide platform generate metadata, which may become identifiable when paired with other information. This metadata is collected for operational purposes, such as analytics, feature improvements, or ensuring platform performance. QwikAide takes stringent measures to secure this metadata and all collected information to maintain user privacy.</p>

<p><strong>6.4 Compliance with Global Privacy Regulations</strong></p>

<p>QwikAide is fully compliant with global privacy regulations, including GDPR (for users in Europe) and COPPA (for users under 13 in the U.S.), ensuring that all data collection and usage align with legal standards.</p>

<p><strong>6.5 User Control over Data Collection</strong></p>

<p>Visitors to the platform may refuse to provide personally identifiable information, although doing so may limit access to certain features or services.</p>

<p><strong>6.6 Commitment to Minimum Data Collection</strong></p>

<p>QwikAide continually strives to collect only the minimum necessary data to deliver its services effectively while ensuring the privacy of its global user base.</p>

<p><strong>7: How </strong><strong>QwikAide</strong><strong> Uses and Protects Information</strong></p>

<p>QwikAide is committed to using user information responsibly and securely. The information collected is utilized to operate, enhance, and personalize our services while safeguarding user privacy and complying with global regulations.</p>

<p><strong>7.1 Limited Disclosure of Information</strong></p>

<p>QwikAide only shares personal data when necessary, under strict conditions, and to enhance user experience. Information is disclosed in the following cases:</p>

<p><strong>Service Provision:</strong>&nbsp;To enable partners or contractors to process data on QwikAide's behalf or provide specific functionalities of the platform.</p>

<p><strong>Agreement Compliance:</strong>&nbsp;To ensure that recipients of the information adhere to confidentiality obligations and do not further disclose the data.</p>

<p><strong>Customer Reference (for Business Users):</strong>&nbsp;With explicit consent, QwikAide may list business customers, such as schools or corporations, in marketing materials, sales presentations, and press releases. However, individual students or children will never be identified in any promotional content.</p>

<p><strong>7.2 No Monetization or Sale of Student Data</strong></p>

<p>QwikAide prioritizes the protection of user data, particularly that of students. Key practices include:</p>

<p><strong>No Sale or Exchange:</strong>&nbsp;QwikAide does not sell, rent, or exchange user data to third parties.</p>

<p><strong>Legal Disclosure Only:</strong>&nbsp;Personally identifiable information is disclosed only when legally required or to protect QwikAide's rights, safety, or property.</p>

<p><strong>Retention and Anonymization:</strong>&nbsp;Data is securely destroyed or anonymized once no longer needed, with clear retention timelines followed.</p>

<p><strong>Purpose of Data Use</strong></p>

<p><strong>Account Access:</strong>&nbsp;Track and maintain user progress and achievements.</p>

<p><strong>Teacher Tools:</strong>&nbsp;Provide educators with the ability to monitor and support individual student needs.</p>

<p><strong>Feature Engagement:</strong>&nbsp;Identify trends to enhance platform functionality and user experience.</p>

<p><strong>7.3 Compliance with Global Privacy Laws</strong></p>

<p>QwikAide complies with stringent data protection laws across multiple regions:</p>

<p><strong>European Union:</strong>&nbsp;Adheres to the GDPR, ensuring lawful data collection, user access rights, portability, and erasure.</p>

<p><strong>United Arab Emirates:</strong>&nbsp;Follows the UAE Personal Data Protection Law (PDPL), emphasizing consent-based data collection.</p>

<p><strong>India:</strong>&nbsp;Complies with the Digital Personal Data Protection Act (DPDP Act) 2023, ensuring transparency and consent-based data processing.</p>

<p><strong>United States:</strong>&nbsp;Meets the requirements of COPPA (Children's Online Privacy Protection Act) and CCPA (California Consumer Privacy Act).</p>

<p><strong>Australia:</strong>&nbsp;Complies with the Australian Privacy Act 1988 to ensure ethical data use.</p>

<p><strong>Other Regions:</strong>&nbsp;For regions without specific regulations, QwikAide follows international privacy standards.</p>

<p>QwikAide ensures compliance with cross-border data protection standards, safeguarding data processing and storage across jurisdictions.</p>

<p><strong>7.4 Communication and User Updates</strong></p>

<p>QwikAide communicates with users to keep them informed about updates, new features, and opportunities for feedback. Communication methods include:</p>

<p><strong>Email:</strong>&nbsp;Sent to registered users who have provided their email addresses.</p>

<p><strong>Push Notifications:</strong>&nbsp;Sent to mobile app users.</p>

<p>Users have the option to unsubscribe from promotional emails or disable push notifications at any time. QwikAide may also publish anonymized user queries or support requests to enhance the platform's knowledge base. Participation in optional promotional activities (e.g., sweepstakes or contests) is governed by additional terms and conditions.</p>

<p><strong>7.5 Ensuring Privacy and Security</strong></p>

<p>QwikAide ensures robust privacy and security through the following measures:</p>

<p><strong>Aggregated Insights:</strong>&nbsp;User behavior is analyzed at an aggregated level (e.g., popular quizzes) to improve features while preserving individual privacy.</p>

<p><strong>Data Security:</strong>&nbsp;Strong measures are taken to prevent unauthorized access and breaches.</p>

<p><strong>Regulatory Compliance:</strong>&nbsp;QwikAide adheres to global laws such as GDPR, PDPL, DPDP, CCPA, COPPA, and others, ensuring that data practices align with privacy standards.</p>

<p>QwikAide's global privacy and security measures are designed to protect all users, including individuals, educational institutions, and corporate clients.</p>

<p><strong>8: Advertising and Marketing Practices</strong></p>

<p>QwikAide is dedicated to providing a secure, ethical, and distraction-free environment for all users, particularly children. Our advertising and marketing practices strictly follow global privacy and advertising regulations, ensuring a trusted and safe platform for all users.</p>

<p><strong>8.1 Ad-Free Experience</strong></p>

<p><strong>No Third-Party Advertisements:</strong>&nbsp;We do not display or allow any third-party advertisements or marketing within our website, applications, or services.</p>

<p><strong>No Personalized Ads or Tracking:</strong>&nbsp;We prohibit the use of personalized ads, tracking, or the collection of user data for advertising purposes.</p>

<p><strong>8.2 No Third-Party Promotions</strong></p>

<p><strong>No Endorsement of External Products/Services:</strong>&nbsp;QwikAide does not promote or endorse third-party products or services in any form.</p>

<p><strong>Exclusive Promotional Content:</strong>&nbsp;Any updates, notifications, or promotional messages sent to users are solely related to QwikAide's own services, features, or enhancements.</p>

<p><strong>8.3 Protecting Children's Privacy</strong></p>

<p><strong>Adherence to Global Regulations:</strong>&nbsp;QwikAide complies with international laws such as COPPA (USA), GDPR (EU), PDPL (UAE), and India's Data Protection Bill, ensuring that children's data and privacy are safeguarded and not exposed to inappropriate advertising practices.</p>

<p><strong>Strict Ban on Third-Party Ads Targeting Children:</strong>&nbsp;Paid ads encouraging children or their parents to purchase third-party products or services are strictly prohibited.</p>

<p><strong>8.4 Ethical and Transparent Marketing</strong></p>

<p><strong>No Monetization of User Data:</strong>&nbsp;QwikAide does not sell, rent, or exchange user data for advertising or promotional purposes.</p>

<p><strong>Transparency and Control:</strong>&nbsp;We ensure transparency in all user communications and provide users with clear options to unsubscribe from promotional emails or disable app notifications at any time.</p>

<p><strong>8.5 Focus on Educational Content</strong></p>

<p><strong>Enhancing User Experience:</strong>&nbsp;All communication related to updates or new features is focused on improving the user experience with QwikAide's services.</p>

<p><strong>No Third-Party Trackers or Cross-Promotions:</strong>&nbsp;We do not use third-party trackers or engage in cross-promotions that could compromise user trust or privacy.</p>

<p>By adhering to these high standards, QwikAide ensures a safe, ethical, and ad-free environment, prioritizing the privacy and security of its users.</p>

<p><strong>9: Changes to the Privacy Policy and User Notifications</strong></p>

<p>QwikAide is committed to keeping its Privacy Policy transparent, up-to-date, and compliant with applicable laws, including COPPA, GDPR, and other global regulations.</p>

<p><strong>9.1 Policy Updates</strong></p>

<p><strong>Right to Revise:</strong>&nbsp;QwikAide reserves the right to update or revise this Privacy Policy to ensure compliance with evolving laws, industry standards, or changes to QwikAide's services (such as the introduction of new features).</p>

<p><strong>Last Updated Date:</strong>&nbsp;The "Last Updated" date at the top of this document reflects the most recent revision.</p>

<p><strong>9.2 User Notifications</strong></p>

<p><strong>Notification of Significant Changes:</strong>&nbsp;For updates that significantly affect the handling of personally identifiable information, QwikAide will notify users in the following ways:</p>

<p>By email, prior to the changes becoming effective.</p>

<p>Through a prominent notice displayed upon login to the website or app.</p>

<p><strong>9.3 Review and Acceptance</strong></p>

<p><strong>User Responsibility:</strong>&nbsp;Users are required to review the updated Privacy Policy to continue using QwikAide's services.</p>

<p>If users do not accept the updated policy, they may terminate their accounts or stop using QwikAide services at any time.</p>

<p><strong>9.4 Access to Previous Versions</strong></p>

<p><strong>Request for Previous Versions:</strong>&nbsp;Users may request access to prior versions of the Privacy Policy by contacting us at&nbsp;<a href="mailto:privacy@ilifeaceit.com">privacy@QwikAide.com</a>.</p>

<p><strong>9.5 Continued Use Indicates Agreement</strong></p>

<p><strong>Agreement to Updated Policy:</strong>&nbsp;By continuing to use QwikAide's services, website, or applications after changes are made, users agree to the updated Privacy Policy.</p>

<p><strong>10: Commitment to Openness and Transparency</strong></p>

<p>QwikAide is dedicated to providing clear and straightforward privacy-related documents, including privacy notices, terms of use, and contracts. We aim to ensure users fully understand how their personal information is:</p>

<p>Used and Processed</p>

<p>Disclosed to and Retained by QwikAide and Authorized Third Parties</p>

<p><strong>10.1 Regular Review and Updates</strong></p>

<p>We periodically review and update our policies to ensure they are clear, compliant, and relevant to the evolving needs of our users and regulations.</p>

<p><strong>10.2 Addressing User Questions</strong></p>

<p>If any aspect of our policies is unclear, users are encouraged to reach out to us through:</p>

<p><strong>Email:</strong>&nbsp;<a href="mailto:privacy@ilifeaceit.com">privacy@QwikAide.com</a></p>

<p><strong>10.3 Transparency in Data Handling</strong></p>

<p>QwikAide values your trust and is committed to maintaining transparent communication regarding how we handle user data.</p>

<p><strong>11: Managing Your Data and User-Generated Content</strong></p>

<p><strong>11.1 User Rights and Data Management</strong></p>

<p>You have the right to access, update, correct, delete, and export your personal information. QwikAide supports these rights in compliance with global privacy standards:</p>

<p><strong>Access and Update:</strong>&nbsp;View and modify your personal information by contacting our support team at&nbsp;<a href="mailto:support@ilifeaceit.com">support@QwikAide.com</a></p>

<p><strong>Correction:</strong>&nbsp;If you notice errors in your data, please reach out to our support team to request corrections.</p>

<p><strong>Deletion:</strong>&nbsp;You can request to delete your account and associated data. Some data may be retained as required by law or for administrative purposes.</p>

<p><strong>Export:</strong>&nbsp;You can request a copy of your data in a structured, machine-readable format (e.g., CSV), which may include personal information, activity summaries, and usage reports.</p>

<p><strong>11.2 Ownership and License for User-Generated Content</strong></p>

<p><strong>Ownership of Data:</strong>&nbsp;You retain full ownership of all personal information provided to QwikAide. This data is used in accordance with this Privacy Policy and applicable laws.</p>

<p><strong>License for Content:</strong>&nbsp;By using QwikAide, you grant a non-exclusive, royalty-free license to QwikAide to use, copy, modify, display, distribute, and create derivative works from user-generated content (e.g., quizzes, study materials) for the purpose of:</p>

<p>Providing and enhancing services.</p>

<p>Facilitating collaboration and sharing within QwikAide's platform.</p>

<p>Conducting research and analytics to improve educational outcomes.</p>

<p>This license only applies to user-generated content and does not extend to your personal data. You retain ownership of your content.</p>

<p><strong>11.3 Visibility and Collaboration of User-Generated Content</strong></p>

<p>Content shared or created within QwikAide's collaborative features (e.g., public quizzes, shared projects) may be visible to other users. Once shared, this content cannot be entirely hidden or restricted from view. If you need assistance managing shared content, please contact support at&nbsp;<a href="mailto:support@ilifeaceit.com">support@QwikAide.com</a>.</p>

<p><strong>11.4 Parental Control</strong></p>

<p>Parents can manage their child's account and associated data by:</p>

<p>Coordinating with their child's teacher (if applicable).</p>

<p>Contacting QwikAide support to update or delete their child's account or data.</p>

<p><strong>12: Data Security and Protection</strong></p>

<p><strong>12.1 Security Measures and Practices</strong></p>

<p>QwikAide implements industry-standard security practices to safeguard personal information during transmission and storage. Key security measures include:</p>

<p><strong>Data </strong><strong>Centers</strong><strong>:</strong>&nbsp;Access-controlled facilities hosted in Asia with strict physical and virtual security protocols.</p>

<p><strong>Encryption:</strong>&nbsp;All data is encrypted during transmission and while stored to ensure confidentiality and integrity, including user passwords.</p>

<p><strong>Access Control:</strong>&nbsp;Robust password policies are in place to enhance user account security.</p>

<p><strong>Regular Security Reviews:</strong>&nbsp;QwikAide continuously reviews its security practices to address risks such as unauthorized access, data loss, or inappropriate disclosure. These reviews help improve security and ensure privacy compliance.</p>

<p>While no system can guarantee 100% security, QwikAide takes significant steps to protect personal data through a combination of technological, physical, and administrative measures. We also work with trusted third-party providers, such as Google Firestore and Firebase, whose security standards match or exceed QwikAide's internal policies.</p>

<p><strong>12.2 Response to Data Breaches</strong></p>

<p><strong>Timely Notification:</strong>&nbsp;We will notify you as soon as reasonably possible if your data is compromised, as required by law.</p>

<p><strong>Actions to Protect Data:</strong>&nbsp;We will provide guidance on how to protect your information following a breach.</p>

<p><strong>12.3 Contact for Security Inquiries</strong></p>

<p>If you have any questions regarding QwikAide's security practices, please contact us at&nbsp;<a href="mailto:privacy@ilifeaceit.com">privacy@QwikAide.com</a>.</p>

<p>Please note that QwikAide may not disclose specific details about our security methods and technologies to preserve the integrity of our data security practices.</p>

<p><strong>13: Cookies and Tracking Technologies</strong></p>

<p><strong>13.1 Use of Cookies and Their Purpose</strong></p>

<p>Cookies are small data files stored on your device that enhance website functionality and improve your user experience. QwikAide uses cookies for the following purposes:</p>

<p>Testing and implementing new features.</p>

<p>Identifying and tracking user behavior and preferences.</p>

<p>Enhancing website performance and usability.</p>

<p><strong>13.2 Managing Cookies</strong></p>

<p>You can manage cookies through your browser settings, where you have the option to block or delete them. Please note, however, that certain features of the QwikAide website may not function properly if cookies are disabled.</p>

<p><strong>14: Compliance With Global Privacy Laws</strong></p>

<p><strong>14.1 Adherence to Privacy Regulations</strong></p>

<p>QwikAide complies with privacy regulations across all regions where it operates, ensuring robust data protection for users. The following are some of the key regulations:</p>

<p><strong>United States:</strong></p>

<p>Children's Online Privacy Protection Act (COPPA)</p>

<p>Family Educational Rights and Privacy Act (FERPA)</p>

<p>California Consumer Privacy Act (CCPA) and California Privacy Rights Act (CPRA)</p>

<p>Virginia Consumer Data Protection Act (VCDPA)</p>

<p>Colorado Privacy Act (ColoPA)</p>

<p><strong>European Union and Non-EU Nations:</strong></p>

<p>General Data Protection Regulation (GDPR) and applicable laws in Switzerland, the UK, and other jurisdictions.</p>

<p><strong>Other Countries:</strong></p>

<p>Privacy laws in Canada, Brazil, Australia, UAE, India, and additional countries.</p>

<p><strong>14.2 Legal Compliance and Global Applicability</strong></p>

<p>This Privacy Policy incorporates all mandatory elements of the above laws. In the case of any conflict between this policy and applicable legal requirements, the legal provisions will take precedence. QwikAide is committed to protecting the data of users globally, including students, teachers, schools, and organizations in regions such as the United States, Canada, UAE, India, and others.</p>

<p><strong>15: Additional Policy Provisions for Specific Jurisdictions</strong></p>

<p><strong>15.1 Indian Residents (Data Protection under Indian Laws)</strong></p>

<p>QwikAide adheres to India's Information Technology (Reasonable Security Practices and Procedures and Sensitive Personal Data or Information) Rules, 2011 and the Data Protection Bill (draft). These provisions ensure secure handling of user data and the protection of privacy rights for Indian users.</p>

<p><strong>Data Storage:</strong>&nbsp;Personal data is securely stored on Google servers in Asia, complying with Indian data localization requirements.</p>

<p><strong>Data Security:</strong>&nbsp;Robust security measures, such as encryption and access control protocols, are implemented to safeguard data.</p>

<p><strong>15.2 Residents of Asia (Data Hosting and Transfers)</strong></p>

<p><strong>Data Hosting:</strong>&nbsp;Data is stored in compliance with Asian data protection laws.</p>

<p><strong>Data Transfers:</strong>&nbsp;Transfers within Asia are carried out following regional regulations, with security measures in place.</p>

<p><strong>15.3 United States (U.S.) Residents</strong></p>

<p><strong>Data Collection and Use:</strong>&nbsp;Data is collected in compliance with U.S. laws, and users have the right to access, delete, and control their data.</p>

<p><strong>Data Transfers:</strong>&nbsp;User data may be transferred to servers in Asia, with compliance to Standard Contractual Clauses (SCCs) ensuring protection during international transfers.</p>

<p><strong>15.4 United Arab Emirates (UAE) Residents</strong></p>

<p><strong>Data Processing:</strong>&nbsp;Data is processed in line with UAE regulations, ensuring privacy and security.</p>

<p><strong>Data Transfers:</strong>&nbsp;Data may be stored in Asia, with safeguards to protect it when transferred outside the UAE.</p>

<p><strong>16: Contact Us for Issues</strong></p>

<p>For any questions or concerns regarding your data or this policy, please contact us at:</p>

<p><strong>Email:</strong>&nbsp;<a href="mailto:support@ilifeaceit.com">support@QwikAide.com</a></p>

</div>
</div>



<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
</body>
</html>
