@php
$currsiteurl = $_SERVER['HTTP_HOST'];
if($currsiteurl=="qwikaide.com"){
    $sitename = "QwikAide";
    $email = "support@qwikaide.com";
    $download=false;
}   else {
    $sitename = "iLife Genie";
    $email = "info@ilifegenie.com";
    $download=true;
}
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <title>My Profile</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
  .form-group {
     font-size: 16px; 
  }
  label {
    display: inline-block;
    width: 100%;
    margin-bottom: 5px;
    font-weight: 500;
    color: #aaa;
    font-size:12px;
  }
  .user_icon {
      border: 1px solid;
    width: 100px;
    height: 100px;
    margin: 0 auto;
    border-radius: 50%;
    text-align: center;
    overflow: hidden;
  }
  .user_icon i {
      font-size: 100px;
  }
  .pt-20 {
      padding-top: 20px;
  }
  .text-sm {
      font-size: 12px;
    color: #aaa;
  }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left ">
    <div class="row">
        <div class="col-md-3"></div>
        <div class="common_main_div col-md-6">
        
  <h3 class="pt-20 text-center">My Profile </h3>
  <p><em></em></p>
    @if(Session::has( 'success' ))
     <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
    @elseif( Session::has( 'warning' ))
     <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
    @endif
  
    <div class="form-group"> <div class='user_icon'><i class='glyphicon glyphicon-user'></i></div></div>
    <div class="form-group">
    <label for="name">Name</label> {{ (Auth()->user()->name) }} 
  </div>
    <div class="form-group">
    <label for="mobile">Mobile Number</label> {{ (Auth()->user()->mobile) }} 
  </div>
    <div class="form-group">
    <label for="email">Email address</label>  {{ (Auth()->user()->email) }} 
  </div>
    <div class="form-group">
    <label for="email">Package</label>  
    
    @php
        $up = App\Models\UserPackage::where('user_id',auth()->user()->id)->orderBy('end_date','desc')->orderBy('package_id','desc')->first();
        
        $total_limit = App\Models\UserPackage::where('user_id',(auth()->user()->parent>0?auth()->user()->parent:auth()->user()->id))->sum('question_limit');
        
        if(auth()->user()->parent>0){
	        $used_limit = App\Models\UserQuestion::whereRaw('user_id IN (SELECT id FROM users WHERE parent="'.auth()->user()->parent.'")')->count();
	        $today_used_limit = App\Models\UserQuestion::whereRaw('user_id IN (SELECT id FROM users WHERE parent="'.auth()->user()->parent.'")')->where('created_at',date("Y-m-d"))->count();
	        $monthly_used_limit = App\Models\UserQuestion::whereRaw('user_id IN (SELECT id FROM users WHERE parent="'.auth()->user()->parent.'")')->where('created_at','LIKE','%'.date("Y-m-").'%')->count();
	        
	    } else {
	        $used_limit = App\Models\UserQuestion::where('user_id',auth()->user()->id)->count();
	        $today_used_limit = App\Models\UserQuestion::where('user_id',auth()->user()->id)->where('created_at',date("Y-m-d"))->count();
	        $monthly_used_limit = App\Models\UserQuestion::where('user_id',auth()->user()->id)->where('created_at','LIKE','%'.date("Y-m-").'%')->count();
	    }
        
    @endphp
    @if($up && $up->package)
        {{ $up->package->name }}
        </div>
        <div class="form-group">
        <label for="email">Expire on</label> 
        {{ $up->end_date }}
     @else
        Forever Free
     @endif
    
  </div>
  
  <div class="form-group">
    <label for="email">Question Limit</label>
    {{$total_limit}}
  </div>
  <div class="form-group">
    <label for="email">Questions Asked</label>
    {{$used_limit}} total questions asked<br> 
    {{$monthly_used_limit}} questions asked this month<br> 
    {{$today_used_limit}} questions asked today<br> 
  </div>
    @php
       $referral_count = false; 
    @endphp
    <div class="form-group">
    <label for="email">My Referrer ID</label>
    @if(auth()->user()->my_referrer_id=="")
        <form action="{{ route('update_referrer_id') }}" method="post">
            @csrf
        <input type="text" name="my_referrer_id" value="{{ auth()->user()->my_referrer_id }}" style="color:black;">
            
        &nbsp;<button type="submit" class="btn btn-primary">Update</button><br>
        <span class="text-sm">You cannot change your referrer id once you update.</span>
        </form>
    @else 
        @php
        $referral_count = true; 
        $rc = App\Models\User::where('referral',auth()->user()->my_referrer_id)->count();
        @endphp
        <input type="text" readonly id="referrer_id" value="{{ auth()->user()->my_referrer_id }}" style="color:black;"> &nbsp;
        <a class="btn btn-primary" onclick="copy_message()">Copy ID</a><br>
        <span class="text-sm">Contact {{$email}} to change your referrer ID</span>
        
    @endif
    @if($download)
    <br>
    <a onclick="download_card();" class="btn btn-sm btn-warning download_card_btn download_card">Download your referral card</a><br>
    @endif
  </div>
  @if($referral_count)
  <div class="form-group">
    <label for="email">Total Referrals</label>
    {{$rc}}
  </div>
  
  @endif
  
  @if(Auth()->user()->level=="3" || Auth()->user()->level=="4" || Auth()->user()->level=="5" || Auth()->user()->level=="1")
  
  
    <div class="form-group">
    <label for="email">GPT Model</label>
    <input type="radio" name="chat_model" id="chat_model1" onclick="update_model(1);" value="1" @if(Auth()->user()->chat_model=="1") checked @endif> gpt-3.5-turbo &nbsp;&nbsp;
    <input type="radio" name="chat_model" id="chat_model2" onclick="update_model(2);" value="2" @if(Auth()->user()->chat_model=="2") checked @endif> gpt-4
    </div>
    @php
    $words = App\Models\WordLog::where('user_id',auth()->user()->id)->where('month',date('m-Y'))->first();
    @endphp
    <p class="text-sm">
        ({{$words?$words->total_count:0}} out of 5,00,000 words used with GPT-4)
    </p>
  @endif
  <div class="form-group">
    <!--<a href="{{ route('edit_profile') }}" class="btn btn-warning">Edit Profile</a>-->
  </div>
  <div class="form-group form-check">
  </div>
  
    @if(Auth()->user()->id==3 || Auth()->user()->id==4)
            <div class="row">
              <div class="col-xs-6 col-md-6 card">
                <a href="{{ route('history') }}" class=" btn btn-secondary">
                 Chat History
                </a>
              </div>
              <div class="col-xs-6 col-md-6 card">
                <a href="{{ route('saved_messages') }}" class=" btn btn-secondary">
                  Saved Answers
                </a>
              </div>
            </div>
            @endif
            <br>
  <div class="form-group form-check">
      <a onclick="return confirm('Are you sure you want to deactivate the i-Life Genie account?');" href="{{ route('deactivate') }}" class="btn btn-danger">Deactivate</a>
  </div>
    @if(Auth()->user()->id==3)
    <a class="btn btn-danger float-right" onclick="Convert_HTML_To_PDF();">Export PDF</a>
    <div id="mybc" style="display:none;">
        
        <div style="position:relative;height:550px;width:450px;overflow:hidden;">
            
            <img src="{{ url('images/business_card/BG-01.png?v3') }}" style="position:absolute;z-index:990;">
            
            
            
            
            <img src="{{ url('images/business_card/Bt-01.png?v3') }}" style="position:absolute;right:-10px; z-index:991;top: -55px;width: 320px;height: 220px;">
            
            <p style="position:absolute;z-index:993;top: 0px;right: 10px;color:white;padding: 10px;">
                <b>i-Life Genie</b><br>
                <b style="color:#ff578f;">
                    
                    AI Study & Work Assistant:<br>
                    Smart Personalized Learning
                </b>
                
            </p>
            
            <p style="position:absolute;z-index:993;top: 100px;right: 110px;color:white;">
                <b>Hi!</b><br>
                Ask me Anything...
            </p>
            
            <img src="{{ url('images/business_card/Bt-02.png') }}" style="position:absolute;z-index:991;top: 46px;width: 200px;right: 80px;">
            <img src="{{ url('images/business_card/Genie-01.png') }}" style="position:absolute;z-index:991;top: 120px;width: 120px;left: 70px;">
            
            
            
            <p style="position:absolute;z-index:992;top: 240px;left: 70px;color:white;background: rgba(0,0,0,0.5);padding: 5px;text-align: center;">
              Sign up today for just <del>₹1500</del>  <b style="color:#ff578f;">₹99</b> and win amazing prizes by scanning the QR code
            </p>
            <img src="{{ url('images/business_card/QR.png') }}" style="position:absolute;z-index:991;top: 320px;width: 120px;left: 70px;">
            
            
            <img src="{{ url('images/business_card/Bt-01.png?v3') }}" style="position:absolute;right:-10px;z-index:991;top: 289px;" height="100" width="250">
            <p style="position:absolute;z-index:991;top: 315px;right: 100px;color:#ffffff;"><b style="color:#ff578f;">1</b> US Trip</p>
            
            
            <img src="{{ url('images/business_card/Bt-01.png?v3') }}" style="position:absolute;right:-10px;z-index:991;top:336px;" height="100" width="220">
            <p style="position:absolute;z-index:991;top: 360px;right: 20px;color:#ffffff;"><b style="color:#ff578f;">2</b> Gaming Laptop</p>
            
            
            <img src="{{ url('images/business_card/Bt-01.png?v3') }}" style="position:absolute;right:-10px;z-index:992;top:381px;" height="100" width="180">
            <p style="position:absolute;z-index:993;top: 405px;right: 30px;color:#ffffff;"><b style="color:#ff578f;">3</b> Sony PS5</p>
            
            
            <img src="{{ url('images/business_card/Website icon.png') }}" style="position:absolute;z-index:991;top: 500px;width: 24px;left: 10px;">
            
            <p style="position:absolute;z-index:991;top: 488px;left: 40px;color:white;">ilifegenie.com</p>
            
            <p style="position:absolute;z-index:992;top: 465px;left: 190px;background-color:#dddddd; width:110px; height: 40px;"></p>
            
            <p style="position:absolute;z-index:993;top: 475px;left: 200px;color:#000000"><b>{{ auth()->user()->my_referrer_id }}</b></p>
            
            <p style="position:absolute;z-index:992;top: 460px;left: 310px;color:white;">Ask your volunteer<br>for the discount<br>coupon code</p>
            
            
            <img src="{{ url('images/business_card/Bt-01.png?v3') }}" style="position:absolute;right:-10px;z-index:991;top: 381px;" height="250" width="330">
            
        </div>
        
    </div>
    <!--
    <div id="genie_card_content">
        
        <div style="position:relative;height:550px;width:450px;overflow:hidden;">
            
            <img src="{{ url('images/business_card/BG-01.png?v3') }}" style="position:absolute;z-index:990;">
            
            
            
            <svg style="position:absolute;right:0;z-index:991;top:5px;" height="100" width="270" xmlns="http://www.w3.org/2000/svg">
                <polygon points="0,0 250,0 250,80 40,80" style="fill: rgba(0,0,0,0.5);stroke: none;stroke-width:1" />
            </svg>
            
            <p style="position:absolute;z-index:993;top: 20px;right: 10px;color:white;">
                <b>i-Life Genie</b><br>
                <b style="color:#ff578f;">
                    
                    AI Study & Work Assistant:<br>
                    Smart Personalized Learning
                </b>
                
            </p>
            
            <p style="position:absolute;z-index:993;top: 120px;right: 110px;color:white;">
                <b>Hi!</b><br>
                Ask me Anything...
            </p>
            
            <img src="{{ url('images/business_card/Bt-02.png') }}" style="position:absolute;z-index:991;top: 46px;width: 200px;right: 80px;">
            <img src="{{ url('images/business_card/Genie-01.png') }}" style="position:absolute;z-index:991;top: 120px;width: 120px;left: 70px;">
            
            
            
            <p style="position:absolute;z-index:992;top: 250px;left: 70px;color:white;background: rgba(0,0,0,0.5);padding: 5px;font-size: 15px;text-align: center;">
              Sign up today for just <del>₹1500</del>  <b style="color:#ff578f;">₹99</b> and win amazing prizes by scanning the QR code
            </p>
            <img src="{{ url('images/business_card/QR.png') }}" style="position:absolute;z-index:991;top: 320px;width: 120px;left: 70px;">
            
            
            <svg style="position:absolute;right:0;z-index:991;top:316px;" height="100" style="float:right;" width="250" xmlns="http://www.w3.org/2000/svg">
                <polygon points="40,10 250,10 250,40 60,40" style="fill: rgba(0,0,0,0.5);stroke: none;stroke-width:1" />
            </svg>
            <p style="position:absolute;z-index:991;top: 330px;right: 100px;"><b style="color:#ff578f;">1</b> US Trip</p>
            
            <svg style="position:absolute;right:0;z-index:991;top:360px;"  height="100" style="float:right;" width="250" xmlns="http://www.w3.org/2000/svg">
                <polygon points="60,10 250,10 250,40 80,40" style="fill: rgba(0,0,0,0.5);stroke: none;stroke-width:1" />
            </svg>
            <p style="position:absolute;z-index:991;top: 375px;right: 10px;"><b style="color:#ff578f;">2</b> Gaming Laptop</p>
            
            
            <svg style="position:absolute;right:0;z-index:991;top:404px;" height="100" style="float:right;" width="250" xmlns="http://www.w3.org/2000/svg">
                <polygon points="80,10 250,10 250,40 100,40" style="fill: rgba(0,0,0,0.5);stroke: none;stroke-width:1" />
            </svg>
            <p style="position:absolute;z-index:991;top: 420px;right: 30px;"><b style="color:#ff578f;">3</b> Sony PS5</p>
            
            
            <img src="{{ url('images/business_card/Website icon.png') }}" style="position:absolute;z-index:991;top: 500px;width: 24px;left: 10px;">
            
            <p style="position:absolute;z-index:991;top: 503px;left: 40px;color:white;">ilifegenie.com</p>
            
            <p style="position:absolute;z-index:992;top: 480px;left: 190px;background-color:#dddddd; width:110px; height: 40px;"></p>
            
            <p style="position:absolute;z-index:993;top: 495px;left: 200px;color:#000000">{{ auth()->user()->my_referrer_id }}</p>
            
            <p style="position:absolute;z-index:992;top: 475px;left: 310px;color:white;">Ask your volunteer<br>for the discount<br>coupon code</p>
            
            <svg style="position:absolute;right:0;z-index:991;top:460px;" height="100" width="300" xmlns="http://www.w3.org/2000/svg">
                <polygon points="10,10 300,10 300,80 40,80" style="fill: rgba(0,0,0,0.5);stroke: none;stroke-width:1" />
            </svg>
            
        </div>
        
    </div>-->
    @endif
        </div>
        <div class="col-md-3"></div>

</div>
</div>
<!-- Image of location/map -->

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')

        <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
        
<script>
    window.jsPDF = window.jspdf.jsPDF;
        function Convert_HTML_To_PDF() {
            var doc = new jsPDF();
			$("#mybc").css('display','block');
            var elementHTML = document.querySelector("#mybc");
          	doc.rect(20, 20, doc.internal.pageSize.width - 40, doc.internal.pageSize.height - 40, 'S');
            doc.html(elementHTML, {
                callback: function(doc) {
                    doc.save('genie_card_{{ auth()->user()->my_referrer_id }}.pdf');
                    $("#mybc").css('display','none');
                },
                margin: [10, 5, 5, 10],
        		autoPaging: "text",
                x: 0,
                y: 0,
                width: 280, //target width in the PDF document
                windowWidth: 675 //window width in CSS pixels
            });
        }

    function copy_message(){
        navigator.clipboard.writeText($('#referrer_id').val());
        alert('Referrer ID copied to clipboard');
    }
    function download_card(){
        $('.download_card').attr('onclick','');
        
        $('.download_card').html('Generating your referral card &nbsp;<img src="{{url('images/loader.gif')}}" height="25px">'); 
        var _token= "{{ csrf_token() }}";
		
		var request = $.ajax({
		  url: "{{route('check_downloading')}}",
		  method: "POST",
		  data: { _token : _token },
		  dataType: "html"
		});
		 
		request.done(function( msg ) {
		   $('.download_card').html('Download your referral card');
		   window.location.href = "{{ route('download_business_card') }}";
            $('.download_card').attr('onclick','download_card();');
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		});
    }
    
    function update_model(model){
        var _token= "{{ csrf_token() }}";
		
		var request = $.ajax({
		  url: "{{route('change_chat_model')}}",
		  method: "POST",
		  data: { _token : _token, model: model },
		  dataType: "json"
		});
		 
		request.done(function( msg ) {
		  //file_list();
		  //show_shackbar_message('Folder Created Successfully');
          //document.getElementById("addFolderModal").style.display = "none";
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  //show_shackbar_message( "Request failed: " + textStatus );
		});
		
    
    }
    
</script>
</body>
</html>
