<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Theme Made By www.w3schools.com - No Copyright -->
  <title>Password Reset - Taxi Nearby</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container common_main_div text-left">
  <h3>Password Reset</h3>
  <p><em></em></p>
    @if ( session()->has('msg') )
    <div class="alert alert-success">{{ session()->get('msg') }}</div>
    @endif
  <form action="/reset_password" method="post">
    @csrf
    <div class="form-group">
    <label for="exampleInputEmail1">Email address</label>
    <input type="email" name="email" id="email" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Enter email">
    <span class="text-danger">{{ $errors->has('email') ? $errors->first('email') : '' }}</span>
    <small id="emailHelp" class="form-text text-muted"></small>
  </div>
  <a onclick="send_otp()" class="btn btn-primary">Send OTP</a>&nbsp;&nbsp;<span class="otp_message"></span>
  <p></p>
  <div class="form-group">
    <label for="exampleInputPassword1">OTP</label>
    <input type="text" name="otp" class="form-control" id="otp" placeholder="Enter OTP">
    <span class="text-danger">{{ $errors->has('otp') ? $errors->first('otp') : '' }}</span>
  </div>
  <div class="form-group">
    <label for="exampleInputPassword1">New Password</label>
    <input type="password" name="new_password" class="form-control" id="new_password" placeholder="New password">
    <span class="text-danger">{{ $errors->has('new_password') ? $errors->first('new_password') : '' }}</span>
  </div>
  
  <div class="form-group form-check">
  </div>
  <button type="submit" class="btn btn-primary">Verify</button>
  </form>
  
</div>


<!-- Image of location/map -->

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')

<script>
    function send_otp(){
        var _token= "{{ csrf_token() }}";
		var email = $('#email').val();
		if(email!=''){
		    $('.otp_message').html('Sending...');
    		var request = $.ajax({
    		  url: "{{route('resend_password_otp')}}",
    		  method: "POST",
    		  data: { _token : _token, email: email },
    		  dataType: "json"
    		});
    		 
    		request.done(function( msg ) {
    		  $('.otp_message').html(msg.result);
    		});
    		 
    		request.fail(function( jqXHR, textStatus ) {
    		  show_shackbar_message( "Request failed: " + textStatus );
    		});
		} else {
          $('.otp_message').html('Please enter a valid email id');
          setTimeout(function () {
            $(".otp_message").html('');
          }, 2000);
        }
    
    }
</script>
</body>
</html>
