<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Theme Made By www.w3schools.com - No Copyright -->
  <title>Pricings - {{ config('app.name') }}</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
      .card-row {
          margin: 30px auto;
      }
      .card {
          padding-bottom: 20px;
          padding-top: 10px;
          border-radius: 5px;
          border: 1px solid #eee;
      }
      .card-text {
          padding: 6px;
      }
      .card-title span {
         font-size: 16px;
         padding: 2px;
      }
      .package_name {
         font-size: 16px;
         padding: 3px;
         color: darkblue;
      }
      .price_div {
          color: #eeeeee;
      }
      .price_div .card-body {
      }
      .free_div {
          background-color: #345171;
          border-left : 8px solid #343a5a;
      }
      
      .price_div1 {
          background-color: #47868b;
          border-left : 8px solid #236976;
      }
      .price_div2 {
          background-color: #6a5979;
          border-left : 8px solid #573460;
      }
      .price_div3 {
          background-color: #b36477;
          border-left : 8px solid #873f55;
      }
      .price_div4 {
          background-color: #e76a6e;
          border-left : 8px solid #c84864;
      }
      
      .free_div .card-body .btn-primary {
          background-color: #343a5a;
      }
      .price_div1 .card-body .btn-primary {
          background-color: #236976;
      }
      .price_div2 .card-body .btn-primary {
          background-color: #573460;
      }
      .price_div3 .card-body .btn-primary {
          background-color: #873f55;
      }
      .price_div4  .card-body .btn-primary{
          background-color: #c84864;
      }
      .side_tag {
            position: absolute;
            left: -12px;
            top: 0px;
            z-index: 1;
      }
      
      .side_tag_free svg polygon {
          fill:#343a5a;
      }
      .side_tag_1 svg polygon {
          fill:#236976;
      }
      .side_tag_2 svg polygon {
          fill:#573460;
      }
      .side_tag_3 svg polygon {
          fill:#873f55;
      }
      .side_tag_4 svg polygon {
          fill:#c84864;
      }
      .side_tag p {
          transform: rotate(-90deg);
          position: absolute;
            top: 45px;
      }
      .side_tag .prem_text {
        top: 50px;
        left: -8px;
      }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')

<div id="band" class="container-fluid text-center common_main_div">
  <h3>Pricings</h3>
  <p><em>SIMPLE & TRANSPARENT PRICING. START FOR FREE AND UPGRADE AS YOU GO.</em></p>
  <form action="{{ route('checkout') }}" method="post" id="checkout_form">
      @csrf
  <div class="row card-row">
   
  
  <div class="col-sm-3 level_2 level_free"></div>
  <div class="col-sm-3 level_2 level_free">
    @if(isset($output))
    <p class="text-danger">
        {!! $output !!}
    </p>
    @endif
    <div class="card free_div price_div">
    <div class="side_tag side_tag_free">
        <p>Free</p>
        <svg height="150" width="30" xmlns="http://www.w3.org/2000/svg">
            <polygon points="0,0 0,120 30,150 30,0" style="" />
        </svg>
    </div>
    
    
      <div class="card-body">
        <h2 class="card-title"><span>₹</span> {{$free_package->price}} <span> /{{ $free_package->period }}</span></h2>
        <p class="card-text">Question limit: {{ $free_package->question_limit }}</p>
        <p class="card-text">GPT 3.5</p>
        
        <a onclick="#" class="btn btn-primary">Free</a>
        
      </div>
    </div>
  </div>
  <div class="col-sm-3 level_2 level_pre">
    <div class="card price_div1 price_div">
        
    <div class="side_tag side_tag_1">
        <p class="prem_text">Premium</p>
        <svg height="150" width="30" xmlns="http://www.w3.org/2000/svg">
            <polygon points="0,0 0,120 30,150 30,0" style="" />
        </svg>
    </div>
    
    
      <div class="card-body">
        <h2 class="card-title"><span>₹</span> {{$premium_package->price}} <span></span></h2>
         @if($premium_package->price!=$premium_package->mrp)
        <h3 class="card-subheading package_name"><strike>₹{{$premium_package->mrp}}</strike> {{ (int)(100-($premium_package->price*100)/$premium_package->mrp) }}% off</h3>
        @endif
        <p class="card-text">Question limit: {{ $premium_package->question_limit }}</p>
        <p class="card-text">Email, Chat, On-Call Support</p>
        <p class="card-text">Access to Advanced Features (Create folders and ask multiple PDFs at a time)</p>
        <p class="card-text">No Time limit</p>
        <p class="card-text">Embed Chat Window Anywhere</p>
        <p class="card-text">Improved Performance & Responses with GPT 4.0</p>
        @if(auth()->user())
        <a onclick="setPackage({{$premium_package->id}})" class="btn btn-primary">Upgrade Now</a>
        @endif
      </div>
    </div>
  </div>
  
  <div class="col-sm-3 level_2 level_st"></div>
  
  </div>
  
  <input type="hidden" name="package" id="package_id" value="">
</form>
</div>



<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    @if(auth()->user())
     @if(auth()->user()->level=="2")
        $('.level_st').hide();
        $('.level_2').show();
     @elseif(auth()->user()->level=="3")
        $('.level_st').hide();
        $('.level_3').show();
     @elseif(auth()->user()->level=="4")
        $('.level_st').hide();
        $('.level_4').show();
     @elseif(auth()->user()->level=="5")
        $('.level_st').hide();
        $('.level_4').show();
     @endif
    @else
     @if(isset($_GET['type']) && $_GET['type']=="2")
        $('.level_st').hide();
        $('.level_2').show();
     @elseif(isset($_GET['type']) && $_GET['type']=="3")
        $('.level_st').hide();
        $('.level_3').show();
     @elseif(isset($_GET['type']) && $_GET['type']=="4")
        $('.level_st').hide();
        $('.level_4').show();
     @elseif(isset($_GET['type']) && $_GET['type']=="5")
        $('.level_st').hide();
        $('.level_4').show();
     @else
        $('.level_st').hide();
        $('.level_2').show();
     @endif
    @endif
    function setPackage(package){
        $('#package_id').val(package);
        $('#checkout_form').submit();
        
    }
    
</script>
</body>
</html>
