<!DOCTYPE html>
<html lang="en">
<head>
  <title>My Profile</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
  .form-group {
     font-size: 16px; 
  }
  label {
    display: inline-block;
    width: 100%;
    margin-bottom: 5px;
    font-weight: 500;
    color: #aaa;
    font-size:12px;
  }
  .user_icon {
      border: 1px solid;
    width: 100px;
    height: 100px;
    margin: 0 auto;
    border-radius: 50%;
    text-align: center;
    overflow: hidden;
  }
  .user_icon i {
      font-size: 100px;
  }
  .pt-20 {
      padding-top: 20px;
  }
  .text-sm {
      font-size: 12px;
    color: #aaa;
  }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left ">
    <div class="row">
        <div class="col-md-3"></div>
        <div class="common_main_div col-md-6">
        
  <h3 class="pt-20 text-center">My Profile </h3>
  <p><em></em></p>
    @if(Session::has( 'success' ))
     <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
    @elseif( Session::has( 'warning' ))
     <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
    @endif
  <form action="/edit_profile" method="post">
    @csrf
    <div class="form-group"> <div class='user_icon'><i class='glyphicon glyphicon-user'></i></div></div>
    <div class="form-group">
    <label for="name">Name</label> {{ (Auth()->user()->name) }} 
  </div>
    <div class="form-group">
    <label for="mobile">Mobile Number</label> {{ (Auth()->user()->mobile) }} 
  </div>
    <div class="form-group">
    <label for="email">Email address</label>  {{ (Auth()->user()->email) }} 
  </div>
    <div class="form-group">
    <label for="email">Package</label>  
    
    @php
            $up = App\Models\UserPackage::where('user_id',auth()->user()->id)->orderBy('end_date','desc')->orderBy('package_id','desc')->first();
        @endphp
    @if($up && $up->package)
        {{ $up->package->name }}
        </div>
        <div class="form-group">
        <label for="email">Expire on</label> 
        {{ $up->end_date }}
     @else
        Forever Free
     @endif
    
  </div>
  @if(Auth()->user()->level=="3" || Auth()->user()->level=="4" || Auth()->user()->level=="5" || Auth()->user()->level=="1")
  
    <div class="form-group">
    <label for="email">GPT Model</label>
    <input type="radio" name="chat_model" id="chat_model1" onclick="update_model(1);" value="1" @if(Auth()->user()->chat_model=="1") checked @endif> gpt-3.5-turbo &nbsp;&nbsp;
    <input type="radio" name="chat_model" id="chat_model2" onclick="update_model(2);" value="2" @if(Auth()->user()->chat_model=="2") checked @endif> gpt-4
    </div>
    @php
    $words = App\Models\WordLog::where('user_id',auth()->user()->id)->where('month',date('m-Y'))->first();
    @endphp
    <p class="text-sm">
        ({{$words?$words->total_count:0}} out of 5,00,000 words used with GPT-4)
    </p>
  @endif
  <div class="form-group">
    <!--<a href="{{ route('edit_profile') }}" class="btn btn-warning">Edit Profile</a>-->
  </div>
  <div class="form-group form-check">
  </div>
  </form>
  @if(Auth()->user()->id==3 || Auth()->user()->id==4)
            <div class="row">
              <div class="col-xs-6 col-md-6 card">
                <a href="{{ route('history') }}" class=" btn btn-secondary">
                 Chat History
                </a>
              </div>
              <div class="col-xs-6 col-md-6 card">
                <a href="{{ route('saved_messages') }}" class=" btn btn-secondary">
                  Saved Answers
                </a>
              </div>
            </div>
            @endif
            <br>
  <div class="form-group form-check">
      <a onclick="return confirm('Are you sure you want to deactivate the i-Life Genie account?');" href="{{ route('deactivate') }}" class="btn btn-danger">Deactivate</a>
  </div>
    
        </div>
        <div class="col-md-3"></div>

</div>
</div>
<!-- Image of location/map -->

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    function update_model(model){
        var _token= "{{ csrf_token() }}";
		
		var request = $.ajax({
		  url: "{{route('change_chat_model')}}",
		  method: "POST",
		  data: { _token : _token, model: model },
		  dataType: "json"
		});
		 
		request.done(function( msg ) {
		  //file_list();
		  //show_shackbar_message('Folder Created Successfully');
          //document.getElementById("addFolderModal").style.display = "none";
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  //show_shackbar_message( "Request failed: " + textStatus );
		});
		
    
    }
    
</script>
</body>
</html>
