<!DOCTYPE html>
<html lang="en">
<head>
  <title>Referral Report</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
  .form-group {
     font-size: 16px; 
  }
  label {
    display: inline-block;
    width: 100%;
    margin-bottom: 5px;
    font-weight: 500;
    color: #aaa;
    font-size:12px;
  }
  .user_icon {
      border: 1px solid;
    width: 100px;
    height: 100px;
    margin: 0 auto;
    border-radius: 50%;
    text-align: center;
    overflow: hidden;
  }
  .user_icon i {
      font-size: 100px;
  }
  .pt-20 {
      padding-top: 20px;
  }
  .text-sm {
      font-size: 12px;
    color: #aaa;
  }
  
  .common_main_div {
    background-size: auto;
    padding:10px;
    background-position: center;
  }
  
      .modal-header {
            padding: 10px 30px;
        }
        .badge-success {
            background-color: green;
        }
        .badge-danger {
            background-color: red;
        }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left ">
    <div class="row">
        <div class="common_main_div">
        
          <h3 class="pt-20 text-center">Referral Report </h3>
          <p><em></em></p>
            @if(Session::has( 'success' ))
             <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
            @elseif( Session::has( 'warning' ))
             <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
            @endif
            <!--<p class="pull-right"><a onclick="add_coupon()" class="btn btn-primary">Add New</a></p>-->
            <p>&nbsp;</p>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Referrer ID</th>
                            <th>Referral Count</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(count($referrals)>0)
                        @foreach($referrals  as $referral)
                        <tr>
                            <td>{{ $referral->name }}</td>
                            <td>
                                {{ $referral->my_referrer_id }}
                            </td>
                            <td>{{ $referral->referral_count }}</td>
                            
                        </tr>
                        @endforeach
                        @else 
                        <tr><td>No Records</td></tr>
                        @endif
                    </tbody>
                </table>
                
            </div>

    
   

        </div>

</div>
</div>
<!-- Image of location/map -->

<div class="modal" id="myModaladd">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">New Coupon</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
          <form action="{{ route('add_coupon') }}" method="post">
             @csrf
          <div class="form-group">
            <label for="code">Coupon Code</label>
            <input type="text" class="form-control" id="code" name="code" placeholder="Enter Coupon Code">
            <small id="emailHelp" class="form-text text-muted"></small>
          </div>
          <div class="form-group">
            <label for="off_percent">OFF Percentage</label>
            <input type="number" class="form-control" id="off_percent" name="off_percent" placeholder="Enter off percentage">
          </div>
            <button type="submit" class="btn btn-primary">Add</button>
            </form>
          
      </div>
      

    </div>
  </div>
</div>

<div class="modal" id="myModaledit">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">Edit Coupon</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <div class="modal-body">
          <form action="{{ route('update_coupon') }}" method="post">
             @csrf
          <div class="form-group">
            <label for="off_percent">OFF Percentage</label>
            <input type="number" class="form-control" id="off_percent2" name="off_percent" placeholder="Enter off percentage">
          </div>
            <input type="hidden" name="id" id="couponid" value="">
            <button type="submit" class="btn btn-primary">Update</button>
            </form>
          
      </div>

    </div>
  </div>
</div>


<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    function edit_coupon(id, off){
        $('#couponid').val(id);
        $('#off_percent2').val(off);
        $('#myModaledit').modal('show');
    }
    function add_coupon(){
        $('#myModaladd').modal('show');
    }
    function update_model(model){
        var _token= "{{ csrf_token() }}";
		
		var request = $.ajax({
		  url: "{{route('change_chat_model')}}",
		  method: "POST",
		  data: { _token : _token, model: model },
		  dataType: "json"
		});
		 
		request.done(function( msg ) {
		  //file_list();
		  //show_shackbar_message('Folder Created Successfully');
          //document.getElementById("addFolderModal").style.display = "none";
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  //show_shackbar_message( "Request failed: " + textStatus );
		});
		
    
    }
    
</script>
</body>
</html>
