@php
    $currsiteurl = $_SERVER['HTTP_HOST'];
    if($currsiteurl=="legalbox.ai"){
        $sitename = "LegalBox AI";
        $loginheading = "LegalBox<br>AI";
        $siteuser="law";
    } else {
        $sitename = "iLife Genie";
        $loginheading = "i-Life<br>Genie";
        $siteuser="normal";
    }
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $isSafari = false;
    if (stripos( $user_agent, 'Chrome') !== false){
        $isSafari = false;
    } elseif (stripos( $user_agent, 'Safari') !== false) {
       $isSafari = true;
    }
    $show_new_folder = "yes";
    @endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <title>My Files - {{ config('app.name') }}</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content=""/>
  
  @include('layouts.style')
  <style>
    .card {
        border: 1px solid;
        border-radius: 10px;
        padding: 0px 0px 10px 0px;
        overflow: hidden;
    }
    .driver_div {
        margin-bottom: 10px;
    }
    .card-img-top {
        width: 100%;
        overflow: hidden;
    }
    .btn {
        display: inline-block;
        margin-bottom: 10px;
    }
    .item {
        height: 100vh;
        width: 100%;
    }
    
    /* The Modal (background) */
    .modal {
      display: none; /* Hidden by default */
      position: fixed; /* Stay in place */
      z-index: 1; /* Sit on top */
      left: 0;
      top: 0;
      width: 100%; /* Full width */
      height: 100%; /* Full height */
      overflow: auto; /* Enable scroll if needed */
      background-color: rgb(0,0,0); /* Fallback color */
      background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
    }
    
    /* Modal Content/Box */
    .modal-content {
      background-color: #fefefe;
      margin: 5% auto; /* 15% from the top and centered */
      padding: 20px;
      border: 1px solid #888;
      width: 50%; /* Could be more or less, depending on screen size */
    }
    
    /* The Close Button */
    .close {
      color: #aaa;
      float: right;
      font-size: 28px;
      font-weight: bold;
    }
    
    .close:hover,
    .close:focus {
      color: black;
      text-decoration: none;
      cursor: pointer;
    }
    .text_D {
      font-size: 15px; 
    }
    .glyphicon-folder-open {
      color: #F8D775; 
      font-size: 30px;
    }
    .glyphicon-book {
      color: #F40F02; 
      font-size: 30px;
    }
	#cover_spin, #welcome_overlay {
		position:fixed;
		width:100%;
		left:0;
		right:0;
		top:0;
		bottom:0;
		background-color: rgba(255,255,255,0.7);
		z-index:9999;
		display:none;
	}
	#cover_spin img {
		position:absolute;
		left:45%;
		right:0;
		top:35%;
		bottom:0;
	}
	#loader_msg {
		position:absolute;
		left:45%;
		right:0;
		top:55%;
		bottom:0;
	}
    .show_generate_loader {
        font-size: 12px;
    }
    .text-sm {
        font-size: 12px;
    }
    .card-body {
        border: 1px solid #666;
        border-radius: 5px;
        padding: 10px;
        word-wrap: break-word;
    }
    .each-card {
        margin-bottom: 5px;
    }
    #file_list .each-card p {
    min-height: 102px;
    }
    
    #file_list .each-card .card-body {
    height: 163px;
    }
    
    .upload_file span {
        font-size: 11px;
        color: #666;
    }
    .genie_welcome {
        position: relative;
        text-align: center;
        width: 100%;
        background: rgba(0, 0, 0, 0.8);
        height: 100vh;
    }
    .created_spl_user {
        font-size: 10px;
    }
    .tooltip fa {
            font-size: 14px;
    }
    /* Tooltip container */
    .tooltip {
        opacity: 1;
        color: #fff;
      position: relative;
      display: inline-block;
      border-bottom: 1px dotted black; /* If you want dots under the hoverable text */
    }
    
    /* Tooltip text */
    .tooltip .tooltiptext {
      visibility: hidden;
      width: 120px;
      background-color: black;
      color: #fff;
      text-align: center;
      padding: 5px 0;
      border-radius: 6px;
     
      /* Position the tooltip text - see examples below! */
      position: absolute;
      z-index: 1;
    }
    
    /* Show the tooltip text when you mouse over the tooltip container */
    .tooltip:hover .tooltiptext {
      visibility: visible;
    }
.tooltip-top {
    bottom: 125%;
    left: 50%;
    margin-left: -60px;
}

    
    
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
<div id="cover_spin">
<img src="{{ url('/images/loader.gif') }}" height="80px"><br><br>
<div id="loader_msg">Generating...</div>
</div>

<div id="welcome_overlay">
    <div class="genie_welcome">
        <img src="{{ url('/images/genie_says_hi_v2.gif') }}"><br>
        <a id="welcome_play" class="btn btn-primary">Start</a>
    </div>

</div>


@include('layouts.nav')


<div class="container common_main_div">
<div class="row">
    <p class="col-md-12 pull-left">{!! $breadcrumb !!}</p>
    @php
    $up = App\Models\UserPackage::where('user_id',auth()->user()->id)->orderBy('end_date','desc')->orderBy('package_id','desc')->first();
    @endphp
    @if($up && $up->package_id!="10" && $up->package_id!="20" && $up->package_id!="1" && $up->end_date>=date('Y-m-d') || $show_new_folder=="yes")
	<p class="col-md-12  pull-right">
	    @if($show_new_folder=="yes")
		<a id="addfolder" class="pull-right btn btn-primary" onclick="add_new_folder();">New Folder</a>
        @endif
        @if($show_new_upload=="yes" )
		<a id="upload" class="pull-right btn btn-warning" style="margin-right:10px;">Upload</a>
		<span class="upload_file pull-right">
		    
		<input type="file" name="filename[]"  accept=".pdf,.docx,.doc" class="pull-right form-control" style="margin-right:10px; max-width:300px;" id="filename" multiple><br>
		<span>
		    *Supports PDF, DOC and DOCX format
		</span>
		</span>
		@endif
		@if(auth()->user()->level=="3" && $parent=="499")
	    &nbsp;<a class='btn s_btn genie_btn' @if(!$isSafari) target='_blank' @endif onclick="ask('20240125060648ilR8y2ircCZjMQun?wholelaw=yes');">Ask All</a>
		@endif
	</p>
	@endif
    
    <div class="float-left">
        <form class="form-inline">
          
          <div class="form-group mb-2">
            <label for="search_keyword" class="sr-only">Search Keyword</label>
            <input type="text" class="form-control" style="margin-top: -10px;" id="search_keyword" placeholder="Enter Keyword">
          </div>
          <button type="button" class="btn btn-primary mb-2" onclick="search_list();">Search</button>&nbsp;<a href="{{ route('files') }}" class="btn btn">Clear Search</a>
        </form>
    </div>
    <p>&nbsp;</p>
</div>

		<div class="row">
		<div class="file_list card-deck" id="file_list">
		
		</div>
		</div>
</div>
<!-- The Modal -->
<div id="myModal" class="modal">

  <!-- Modal content -->
  <div class="modal-content">
    <a class="close" onclick="close_modal()">&times;</a>
    <h3>Embedded Code</h3>
    <p>
        <input type="text" readonly class="form-control" id="embedded_code">
    </p>
    <p>
        <a onclick="copy_code()" class="btn btn-info">Copy to Clipboard</a> &nbsp; <span class="text-success copied"></span>
    </p>
  </div>

</div>
<!-- The Modal -->
<div id="addFolderModal" class="modal">

  <!-- Modal content -->
  <div class="modal-content">
    <a class="close" onclick="close_modal()">&times;</a>
    <h3>Add Folder</h3>
    <p>
        <input type="text" class="form-control" id="folder_name">
    </p>
    <p>
        <a onclick="add_folder()" class="btn btn-warning">Add</a> &nbsp; <span class="text-danger folder_msg"></span>
    </p>
  </div>

</div>
<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')

<script>
	
    @if(session()->get('logged_in')!="true" && $siteuser=="normal")
        //$("#welcome_overlay").show();
    @endif
    function add_new_folder(){
      $("#addFolderModal").show();
    }
    function add_folder(){
        var _token= "{{ csrf_token() }}";
		var filename = $('#folder_name').val();
		if(filename!=''){
    		var request = $.ajax({
    		  url: "{{route('add_folder')}}",
    		  method: "POST",
    		  data: { _token : _token, filename: filename, parent: '{{ $parent }}' },
    		  dataType: "json"
    		});
    		 
    		request.done(function( msg ) {
    		  file_list();
    		  show_shackbar_message('Folder Created Successfully');
              document.getElementById("addFolderModal").style.display = "none";
    		});
    		 
    		request.fail(function( jqXHR, textStatus ) {
    		  show_shackbar_message( "Request failed: " + textStatus );
    		});
		} else {
          $('.folder_msg').html('Please enter a valid folder name');
          setTimeout(function () {
            $(".folder_msg").html('');
          }, 2000);
        }
    
    }
    function file_list(type='') {
		$('#file_list').html('loading...');
		var _token= "{{ csrf_token() }}";
		var request = $.ajax({
		  url: "{{route('special_file_list')}}",
		  method: "POST",
		  data: { _token : _token, parent: '{{ $parent }}' },
		  dataType: "html"
		});
		 
		request.done(function( msg ) {
		  $('#file_list').html(msg);
		  if(type=='first'){
		      generate_pending_pickles();
		  }
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  show_shackbar_message( "Request failed: " + textStatus );
		});
    }
	file_list('first');
	
	
	var xhr;
	function search_list(){
		var keyword = $('#search_keyword').val();
		if(keyword==""){
		    alert('Please enter keyword!');
		    return false;
		} else if(keyword.length<3){
		    alert('Please enter atleast 3 characters as keyword!');
		    return false;
		} else {
		    if(xhr){
		        
    		xhr.abort();
		    }
    	    $('#file_list').html('loading...');
    		var _token= "{{ csrf_token() }}";
    		
    		var orderby = $('.active_sort').attr('data-name');
            var sort = $('.active_sort').attr('data-sort');
    		
    		
    		
    		xhr = $.ajax({
    			url: "{{route('special_search_list')}}", 
    		    method: "POST",
    		    data: { _token : _token, keyword: keyword, orderby:orderby, sort:sort },
    		    dataType: "html",
    			success: function(msg){
    				$('#file_list').html(msg);
    			},
                error: function(jqXHR, textStatus) { 
                    console.log( "Request failed: " + textStatus );
                }  
    		 });
		}
		
	}
	
	function delete_file(id){
		var _token= "{{ csrf_token() }}";
		var cc = confirm('Are you sure?');
		if(cc==true){
		var request = $.ajax({
		  url: "{{route('delete_file')}}",
		  method: "POST",
		  data: { _token : _token, id: id },
		  dataType: "text"
		});
		 
		request.done(function( msg ) {
		  file_list();
		  show_shackbar_message('Deleted Successfully');
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  show_shackbar_message( "Request failed: " + textStatus );
		});
		}
	}
	
	function generate_pickle(id){
		var _token= "{{ csrf_token() }}";
		$('.show_generate_loader'+id).show();
		$('.hide_generate_loader'+id).hide();
		var request = $.ajax({
		  url: "{{route('generate_pickle')}}",
		  method: "POST",
		  data: { _token : _token, id: id },
		  dataType: "text"
		});
		 
		request.done(function( msg ) {
		    console.log(msg)
		    $('.show_generate_loader'+id).hide();
        	$('.hide_generate_loader'+id).show();
        	file_list();
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  console.log( "Request failed: " + textStatus );
		  $('.show_generate_loader'+id).hide();
          $('.hide_generate_loader'+id).show();
          file_list();
		});
		
	}
	function generate_pending_pickles(){
		$('.show_generate_loader').each(function(){
		    var id = $(this).attr('data-id');
		    var type = $(this).attr('data-type');
		    if(id!="0"){
    		    if(type=='F'){
    		        generate_pickle(id);
    		    } else {
    		        generate_chat(id,'D')
    		    }
		    }
		});
	}
	function generate_chat(id,type,key="",txt="",merged=''){
		var _token= "{{ csrf_token() }}";
		$('#loader_msg').html('Generating...');
		//$('#cover_spin').show();
		$('.show_generate_loader'+id).show();
		$('.hide_generate_loader'+id).hide();
		var ajaxurl =  "{{ route('create_chat') }}";
		var request = $.ajax({
			url:ajaxurl,
			method: "POST",
			data: { _token : _token, id: id, merged: merged },
			dataType: "html"
		});

		request.done(function( msg ) {
			console.log(msg);
			$('#loader_msg').html('Generated');
			//$('#cover_spin').hide();
			
    		$('.show_generate_loader'+id).hide();
    		$('.hide_generate_loader'+id).show();
			var res = JSON.parse(msg);
			console.log(res.status);
			if(res.status=="merged"){
			    generate_chat(id,type,key,txt,"merged");
			}
			else if(res.status=="success"){
				if(key=="ask"){
					ask(txt);
				} else if(key=="embed"){
					show_code('{{ url("/chat/") }}/'+txt+'/1')
				} else {
					show_shackbar_message('Processed Successfully');
				}
			} else {
				show_shackbar_message(res.result);
			}
			
			file_list();
			
		});

		request.fail(function( jqXHR, textStatus ) {
			show_shackbar_message(textStatus);
			console.log(jqXHR);
    		$('.show_generate_loader'+id).hide();
    		$('.hide_generate_loader'+id).show();
		});
	}
	function view_pdf_file(txt){
	    var win = window.open('{{ url("/view/") }}/'+txt+'/file', '_blank');
		if (win) {
			win.focus();
		} else {
			window.open('{{ url("/view/") }}/'+txt+'/file');
		}
	}
	function ask(txt){
	    @if($isSafari)
	        var win = window.open('{{ url("/chat/") }}/'+txt);
	    @else
		    var win = window.open('{{ url("/chat/") }}/'+txt, '_blank');
		@endif
		if (win) {
			win.focus();
		} else {
			window.open('{{ url("/chat/") }}/'+txt);
		}
	}
	function show_code(url){
	    var code = '<iframe src="'+url+'" style="border: 1px solid grey" frameborder="0" width="100%" height="600" ></iframe>'
	    $('#embedded_code').val(code);
	    $('#myModal').show();
	}
	function copy_code() {
	    var copyText = document.getElementById("embedded_code");
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        navigator.clipboard.writeText(copyText.value);
        $(".copied").html('Copied');
        setTimeout(function () {
          $(".copied").html('');
        }, 2000);
	}
	$(document).ready(function(){
        $('#search_keyword').keyup(function(e) {
	        var keyword = $(this).val();
	        if(keyword.length>=3){
	            search_list();
	        } else {
	            if(e.keyCode==8 || e.keyCode==46 || e.key === "Backspace" || e.key === "Delete"){
	                file_list();
	            }
	        }
	    });
    	$('#upload').on('click', function() {
    		var file_data = $('#filename').get(0).files; 
          	if(file_data==undefined){
                  show_shackbar_message('Please select a file');
                  return false;
            }
          	file_datas = [];
    		var form_data = new FormData();
          	for(var i=0;i<$('#filename').get(0).files.length;i++){
              var filename = $('#filename').get(0).files[i].name;
              console.log(filename);
              var filename = $('#filename').val();
              var n = filename.lastIndexOf('.');
              var extension = filename.substring(n+1);
              if(extension!="pdf" && extension!="PDF"){
                  show_shackbar_message('Invalid File Format. Please upload pdf file');
                  return false;
              }	   
              form_data.append('filename_'+i, $('#filename').get(0).files[i]); 
            }
    		//return false;
          	$('#upload').text('Uploading');
          	$('#upload').addClass('disabled');
    		var _token= "{{ csrf_token() }}";               
    		form_data.append('files_count', i);   
    		form_data.append('_token', _token);   
    		form_data.append('parent', '{{ $parent }}');   
    	
    		$.ajax({
    			url: "{{route('add_file')}}",
    			dataType: 'json', 
    			cache: false,
    			contentType: false,
    			processData: false,
    			data: form_data,                         
    			type: 'post',
    			success: function(response){
    				file_list();
                  	$('#filename').val('');
                    $('#upload').text('Upload');
                    $('#upload').removeClass('disabled');
                    console.log(response);
                    //var res = JSON.parse(response);
        			console.log(response.status);
        			if(response.status=="success"){
        			    show_shackbar_message(response.result);
        			    var uploadeds = response.files;
        			    fileids = uploadeds.split(',');
        			    for(var u=0;u<fileids.length;u++){
        			        generate_pickle(fileids[u]);
        			    }
        			    
        			}
    			}
    		 });
    	});
        var btn = document.getElementById("myBtn");
        var span = document.getElementsByClassName("close")[0];
        span.onclick = function() {
          $('.modal').hide();
        }
        window.onclick = function(event) {
          if (event.target == modal) {
            $('.modal').hide();
          }
        }
        
        $('#welcome_play').click(function() {
          const audio = new Audio("{{ url('/voices/default/welcome_genie_audio.mp3') }}");
          audio.play();
          $("#welcome_overlay").hide();
        });
	});
  	function close_modal(){
      $(".modal").hide();
    }
</script>
{{ session()->put('logged_in','true')}}
</body>
</html>
