<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Theme Made By www.w3schools.com - No Copyright -->
  <title>Update User Type</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left common_main_div">
  <h3>Hey {{ auth()->user()->name }}! Let's customise your experience in Genie</h3>
  <p><em></em></p>
    @if(Session::has( 'success' ))
     <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
    @elseif( Session::has( 'warning' ))
     <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
    @endif
  <form action="{{ route('update_user_type') }}" method="post">
    @csrf
   
  <div class="form-group">
    <label for="exampleInputEmail1">Choose the profession that best describes you...</label><br>
    <input type="radio" name="level" class="" @if(auth()->user()->level=="3") checked @endif onclick="setLevel(3);" id="exampleInputlevel3" value="3"> Lawyer &nbsp;&nbsp;
    <input type="radio" name="level" class="" @if(auth()->user()->level=="4") checked @endif onclick="setLevel(4);" id="exampleInputlevel4" value="4"> Student &nbsp;&nbsp;
    <input type="radio" name="level" class="" @if(auth()->user()->level=="5") checked @endif onclick="setLevel(5);" id="exampleInputlevel5" value="5"> Teacher &nbsp;&nbsp;
    <input type="radio" name="level" class="" @if(auth()->user()->level=="2") checked @elseif(auth()->user()->level=="0") checked @endif onclick="setLevel(2);" id="exampleInputlevel2" value="2"> None of the above &nbsp;&nbsp;
    <span class="text-danger">{{ $errors->has('level') ? $errors->first('level') : '' }}</span>
    <input type="hidden" name="subscription_type" class="" id="subscription_type" value="1">
  </div>
  <div class="form-group form-check">
  </div>
  <button type="submit" class="btn btn-primary">Update</button>
  &nbsp;
  
  </form>
  
</div>


<!-- Image of location/map -->

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    setLevel(2);
    function setLevel(level){
        $('.st_level').hide();
        $('.level_'+level).show();
        if(level==2){
            $('#subscription_type').val(1);
        } else if(level==3){
            $('#subscription_type').val(10);
        } else if(level==4){
            $('#subscription_type').val(20);
        }  else if(level==5){
            $('#subscription_type').val(30);
        } 
    }
</script>
</body>
</html>
