<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Theme Made By www.w3schools.com - No Copyright -->
  <title>OTP Verification</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left common_main_div">
  <h3>OTP Verification</h3>
  <p><em></em></p>
    @if(Session::has( 'success' ))
     <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
    @elseif( Session::has( 'warning' ))
     <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
    @endif
  <form action="/verify_otp" method="post">
    @csrf
   
  <div class="form-group">
    <p>An OTP has been sent to your registered Email ID. Please Enter it</p>
    <b>In case you haven't received the OTP in your mailbox, please check your spam folder</b>
    <label for="exampleInputPassword1">OTP</label>
    <input type="text" name="otp" class="form-control" id="otp" placeholder="Enter OTP">
    <span class="text-danger">{{ $errors->has('otp') ? $errors->first('otp') : '' }}</span>
  </div>
  <div class="form-group form-check">
  </div>
  <button type="submit" class="btn btn-primary">Verify</button>
  &nbsp;
  @if(auth()->user() && auth()->user()->status=="2")
  <a href="{{ route('resend_otp_activate') }}" class="btn btn-warning">Resend OTP</a>
  @else 
  <a href="{{ route('resend_otp') }}" class="btn btn-warning">Resend OTP</a>
  @endif
  </form>
  
</div>


<!-- Image of location/map -->

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
</body>
</html>
