<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\FileListController;
use App\Http\Controllers\RazorpayController;
use App\Http\Controllers\CPController;
use App\Http\Controllers\GroupChatController;
use App\Http\Controllers\GoogleController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/about', [HomeController::class, 'about'])->name('about');

Route::get("/terms-and-conditions", function(){
   return view("terms-and-conditions");
})->name('terms-and-conditions');

Route::get("/privacy-policy", function(){
   return view("privacy-policy");
})->name('privacy-policy');

Route::get("/qa/terms-and-conditions", function(){
   return view("terms-and-conditions");
})->name('terms-and-conditions');

Route::get("/qa/privacy-policy", function(){
   return view("privacy-policy");
})->name('privacy-policy');


Route::get("/storybook2", function(){
   return view("storybook2");
})->name('storybook2');



Route::get("/gmeet", function(){
   return view("gmeet");
})->name('gmeet');

Route::get("/phpinfo", function(){
   phpinfo();
})->name('phpinfo');



Route::get("/test", function(){
   return view("test");
})->name('test');

Route::get('/contact', [HomeController::class, 'contact'])->name('contact');


Route::get('/login', [UserController::class, 'login_view'])->name('login');
Route::post('/login', [UserController::class, 'login'])->name('login');
Route::get('login/{provider}', [UserController::class, 'redirect'])->name('social_login');
Route::get('login/{provider}/callback',[UserController::class, 'callback'])->name('social_login_callback');

Route::get('/', [FileListController::class, 'index'])->name('home');
Route::get('/home', [FileListController::class, 'index'])->name('home');


Route::get('/register', [UserController::class, 'register_view'])->name('register');
Route::get('/contest', [UserController::class, 'contest'])->name('contest');

Route::post('/register', [UserController::class, 'register'])->name('register');
Route::post('/send_mail', [UserController::class, 'send_mail'])->name('send_mail');

Route::post('resend_password_otp', [UserController::class, 'resend_password_otp'])->name('resend_password_otp');
    
Route::get('forgot_password', [UserController::class, 'password_reset'])->name('forgot_password');
Route::post('forgot_password', [UserController::class, 'verify_password_otp'])->name('forgot_password');
    
Route::get('reset_password', [UserController::class, 'reset_password'])->name('reset_password');
Route::post('reset_password', [UserController::class, 'change_forgot_password'])->name('reset_password');

///////
//did//
///////

Route::post("/speechtotext", [FileListController::class, 'speechtotext'])->name('speechtotext');
Route::post("/texttospeech", [FileListController::class, 'texttospeech'])->name('texttospeech');

Route::get("/my_folder_name/{id}", [FileListController::class, 'my_folder_name'])->name('my_folder_name');





Route::get('chat/{id}/{embedded?}', [FileListController::class, 'chat'])->name('chat');
Route::post('ask', [FileListController::class, 'ask'])->name('ask');

Route::post('chat/fetch_videos', [FileListController::class, 'fetch_videos'])->name('fetch_videos');

Route::post('chat/translate_text', [FileListController::class, 'translate_text'])->name('translate_text');




Route::get('pricings', [UserController::class, 'pricings'])->name('pricings');

Route::post('download_audio', [FileListController::class, 'download_audio'])->name('download_audio');

Route::group(['middleware' => 'auth'], function () {
    
    Route::get('user/deactivate', [UserController::class, 'deactivate'])->name('deactivate');
    
    Route::post('create_chat', [FileListController::class, 'create_chat'])->name('create_chat');
    Route::post('generate_pickle', [FileListController::class, 'generate_pickle'])->name('generate_pickle');
    
    Route::get('files/{parent?}', [FileListController::class, 'index'])->name('files');
    
    
    Route::get('download_files/{parent?}', [FileListController::class, 'download_files'])->name('download_files');
    Route::get('download_file/{id?}', [FileListController::class, 'download_file'])->name('download_file');
    
    Route::get("/math_genie", [FileListController::class, 'math_genie'])->name('math_genie');
    Route::post("/math_genie_ask", [FileListController::class, 'math_genie_ask'])->name('math_genie_ask');
    
    
    Route::post('file_list', [FileListController::class, 'file_list'])->name('file_list');
    Route::post('special_file_list', [FileListController::class, 'special_file_list'])->name('special_file_list');
    
    Route::post('change_chat_model', [UserController::class, 'change_chat_model'])->name('change_chat_model');
    
    
    Route::get('special_files/{parent?}', [FileListController::class, 'special_index'])->name('special_files');
    Route::post('special_file_list_admin', [FileListController::class, 'special_file_list_admin'])->name('special_file_list_admin');
    
    
    Route::get('law/{parent?}', [FileListController::class, 'special_law_index'])->name('special_law_files');
    Route::get('student/{parent?}', [FileListController::class, 'special_student_index'])->name('special_student_files');
    Route::get('teacher/{parent?}', [FileListController::class, 'special_teacher_index'])->name('special_teacher_files');
    Route::get('retail/{parent?}', [FileListController::class, 'special_retail_index'])->name('special_retail_files');
    Route::get('iit_jee_neet/{parent?}', [FileListController::class, 'special_iit_jee_neet_index'])->name('special_iit_jee_neet_files');
    Route::get('corporate/{parent?}', [FileListController::class, 'special_corporate_index'])->name('special_corporate_files');
    
    //Route::get('auto_translate_correction', [FileListController::class, 'auto_translate_correction'])->name('auto_translate_correction');
    
    
    Route::post('add_folder', [FileListController::class, 'add_folder'])->name('add_folder');
    Route::post('add_file', [FileListController::class, 'add_file'])->name('add_file');
    Route::post('delete_file', [FileListController::class, 'delete_file'])->name('delete_file');
	
	Route::post('checkout', [UserController::class, 'checkout'])->name('checkout');
	Route::get('checkout', [UserController::class, 'checkout'])->name('checkout');
	
	Route::post('apply_coupon', [UserController::class, 'apply_coupon'])->name('apply_coupon');
	
	
	
	Route::post('update_referrer_id', [UserController::class, 'update_referrer_id'])->name('update_referrer_id');
	
	
	Route::post('payment', [RazorpayController::class, 'store'])->name('payment.store');
	
	Route::get('profile', [UserController::class, 'profile'])->name('profile');
	Route::get('edit_profile', [UserController::class, 'edit_profile'])->name('edit_profile');
	Route::post('edit_profile', [UserController::class, 'update_profile']);
	
    Route::get('change_password', [UserController::class, 'change_password_view'])->name('change_password');
    Route::post('change_password', [UserController::class, 'change_password'])->name('change_password');
    
    Route::get('resend_otp', [UserController::class, 'resend_otp'])->name('resend_otp');
    Route::get('resend_otp_activate', [UserController::class, 'resend_otp_activate'])->name('resend_otp_activate');
    
    
    Route::get('verify_otp', [UserController::class, 'verify_otp_view']);
    Route::post('verify_otp', [UserController::class, 'verify_otp']);
	Route::get('logout', [UserController::class, 'logout'])->name('logout');
	
	
    Route::get('generate_pickles_cron', [FileListController::class, 'generate_pickles_cron'])->name('generate_pickles_cron');
    
    
    
    Route::get('/dashboard', [FileListController::class, 'dashboard'])->name('dashboard');
    
    Route::get('/history', [FileListController::class, 'history'])->name('history');
    Route::get('/chat_history/{file_id}', [FileListController::class, 'chat_history'])->name('chat_history');
    
    Route::post('/save_message', [FileListController::class, 'save_message'])->name('save_message');
    Route::post('/like_message', [FileListController::class, 'like_message'])->name('like_message');
    
    Route::get('/saved_messages', [FileListController::class, 'saved_messages'])->name('saved_messages');
    
    Route::get('/career_planning/{step?}', [CPController::class, 'index'])->name('career_planning');
    Route::post('/save_answer', [CPController::class, 'save_answer'])->name('save_answer');
    
    Route::get('/career_planning_history/{id}', [CPController::class, 'career_planning_history'])->name('career_planning_history');    
    
    Route::get('/allowed_folders', [FileListController::class, 'allowed_folders'])->name('allowed_folders');
    Route::post('/update_folders', [FileListController::class, 'update_folders'])->name('update_folders');
    
    //groups
    Route::get('/groups', [GroupChatController::class, 'index'])->name('groups');
    Route::get('/group/{id}', [GroupChatController::class, 'group_details'])->name('group_details');
    
    Route::post('/groups/add', [GroupChatController::class, 'create_group'])->name('create_group');
    
    Route::get('/group/chat/{id}', [GroupChatController::class, 'group_chat'])->name('group_chat');
    
    
    
    Route::get('/group/remove/{id}/user/{user_id}', [GroupChatController::class, 'group_remove_member'])->name('group_remove_member');
    Route::get('/group/join/{id}', [GroupChatController::class, 'join_group'])->name('join_group');
    Route::get('/group/join/{id}/accept/{user_id}', [GroupChatController::class, 'join_group_accept'])->name('join_group_accept');
    Route::get('/group/join/{id}/reject/{user_id}', [GroupChatController::class, 'join_group_reject'])->name('join_group_reject');
    
    Route::get('/group/{id}/dashboard/', [GroupChatController::class, 'group_dashboard'])->name('group_dashboard');
    Route::post('/group/user/questions', [GroupChatController::class, 'saved_group_answers'])->name('saved_group_answers');
    
    Route::get('/group/{id}/admin/dashboard/', [GroupChatController::class, 'group_admin_dashboard'])->name('group_admin_dashboard');
    Route::post('/group/admin/questions', [GroupChatController::class, 'all_group_answers'])->name('all_group_answers');
    Route::post('group/update_save_all', [GroupChatController::class, 'update_save_all'])->name('update_save_all');
    
    Route::get('/auth/google', [GoogleController::class, 'redirectToGoogle'])->name('redirectToGoogle');
    Route::get('/auth/google/callback', [GoogleController::class, 'handleGoogleCallback'])->name('handleGoogleCallback');
    Route::get('/create-event', [GoogleController::class, 'createEvent'])->name('createEvent');

    
    Route::post('share_to_group', [GroupChatController::class, 'share_to_group'])->name('share_to_group');
    
    Route::post('loadmore_chat', [GroupChatController::class, 'loadmore_chat'])->name('loadmore_chat');
    Route::post('loadnew_chat', [GroupChatController::class, 'loadnew_chat'])->name('loadnew_chat');
    
    
    Route::post('send_group_message', [GroupChatController::class, 'send_group_message'])->name('send_group_message');
    Route::post('send_group_voice_message', [GroupChatController::class, 'send_group_voice_message'])->name('send_group_voice_message');
    Route::post('send_group_attach_message', [GroupChatController::class, 'send_group_attach_message'])->name('send_group_attach_message');
    
    
    Route::get('/update_type', [UserController::class, 'edit_user_type'])->name('update_user_type');
    Route::post('/update_type', [UserController::class, 'update_user_type'])->name('update_user_type');
    
    //admin routes
    Route::get('admin/referrals', [UserController::class, 'referrals'])->name('referrals');
    
	Route::get('admin/coupons', [UserController::class, 'coupons'])->name('coupons');
	
	Route::get('admin/coupons/change_status', [UserController::class, 'change_coupon_status'])->name('change_coupon_status');
	Route::post('admin/coupons/add', [UserController::class, 'add_coupon'])->name('add_coupon');
	Route::post('admin/coupons/update', [UserController::class, 'update_coupon'])->name('update_coupon');
	
	Route::get('admin/organisations', [UserController::class, 'organisations'])->name('organisations');
	Route::get('admin/organisations/change_status', [UserController::class, 'change_organisation_status'])->name('change_organisation_status');
	Route::post('admin/organisations/add', [UserController::class, 'add_organisation'])->name('add_organisation');
	Route::post('admin/organisations/update', [UserController::class, 'update_organisation'])->name('update_organisation');
	
	Route::get('admin/organisation/{id}/admins', [UserController::class, 'organisation_admins'])->name('organisation_admins');
	Route::post('admin/organisation/{id}/admin/add', [UserController::class, 'add_organisation_admin'])->name('add_organisation_admin');
	Route::get('admin/organisation/{id}/admin/{status}/change', [UserController::class, 'change_org_admin_status'])->name('change_org_admin_status');
	
	Route::get('organisation/users', [UserController::class, 'organisation_users'])->name('organisation_users');
	Route::post('organisation/users/add', [UserController::class, 'add_organisation_user'])->name('add_organisation_user');
	Route::get('organisation/users/{id}/remove', [UserController::class, 'remove_org_user'])->name('remove_org_user');
	
    Route::get('profile/download_business_card', [FileListController::class, 'download_business_card'])->name('download_business_card');
    Route::post('profile/check_downloading', [FileListController::class, 'check_downloading'])->name('check_downloading');
	
    Route::post('chat/add_custom_toggle', [FileListController::class, 'add_custom_toggle'])->name('add_custom_toggle');
    Route::post('chat/update_custom_toggle', [FileListController::class, 'update_custom_toggle'])->name('update_custom_toggle');
    Route::post('chat/remove_custom_toggle', [FileListController::class, 'remove_custom_toggle'])->name('remove_custom_toggle');
    
    Route::post('search_list', [FileListController::class, 'search_list'])->name('search_list');
    
    Route::post('special_search_list', [FileListController::class, 'special_search_list'])->name('special_search_list');
    
    Route::post('load_chat_history', [FileListController::class, 'load_chat_history'])->name('load_chat_history');
    
    Route::post('convert_markdown', [FileListController::class, 'convert_markdown'])->name('convert_markdown');
    
    Route::get('create_law_chat', [FileListController::class, 'create_law_chat'])->name('create_law_chat');
    
    Route::get('news/latest', [UserController::class, 'latest_news'])->name('latest_news');
    Route::get('view/{id}/file', [FileListController::class, 'view_pdf_file'])->name('view_pdf_file');
    
    Route::get('global/chat', [FileListController::class, 'chat_normal'])->name('chat_normal');
    Route::post('ask_normal', [FileListController::class, 'ask_normal'])->name('ask_normal');
    
    Route::get('members', [GroupChatController::class, 'members_index'])->name('members_index');
    Route::get('member/{id}/chat', [GroupChatController::class, 'member_chat'])->name('member_chat'); 
    
    Route::post('loadmore_member_chat', [GroupChatController::class, 'loadmore_member_chat'])->name('loadmore_member_chat');
    Route::post('loadnew_member_chat', [GroupChatController::class, 'loadnew_member_chat'])->name('loadnew_member_chat');
    
    Route::post('send_member_message', [GroupChatController::class, 'send_member_message'])->name('send_member_message');
    Route::post('send_member_voice_message', [GroupChatController::class, 'send_member_voice_message'])->name('send_member_voice_message');
    Route::post('send_member_attach_message', [GroupChatController::class, 'send_member_attach_message'])->name('send_member_attach_message');
    
    //send_member_message 
});


Route::get('profile/{my_referrer_id}/my_business_card', [FileListController::class, 'my_business_card'])->name('my_business_card');


Route::get('/clear-cache', function() {
    $exitCode = Artisan::call('cache:clear');
    $exitCode = Artisan::call('config:cache');
    $exitCode = Artisan::call('config:clear');
    
    return 'DONE.'; //Return anything
});


Route::get('/mail_check', [UserController::class, 'mail_check'])->name('mail_check');
Route::get('/test_api', [FileListController::class, 'test_api'])->name('test_api');
Route::get('/genietts', [FileListController::class, 'genietts'])->name('genietts');


Route::get('/testmail', function () {

	$user = \App\Models\User::find(4);

    Mail::to('justinjamesrdrgz@gmail.com')->send(new \App\Mail\HDTutoMail($user));

    

    dd("Email is Send.");

});