<!DOCTYPE html>
<html lang="en">
<head>
  <title>Career Planning</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
  .form-group {
     font-size: 16px; 
  }
  label {
    display: inline-block;
    width: 100%;
    margin-bottom: 5px;
    font-weight: 500;
    color: #aaa;
    font-size:12px;
  }
  .user_icon {
      border: 1px solid;
    width: 100px;
    height: 100px;
    margin: 0 auto;
    border-radius: 50%;
    text-align: center;
    overflow: hidden;
  }
  .user_icon i {
      font-size: 100px;
  }
  .pt-20 {
      padding-top: 20px;
  }
  .text-sm {
      font-size: 12px;
    color: #aaa;
  }
  
  .cp_main_div {
      min-height: calc(100vh - 300px);
      background: #fff;
      padding: 15px;
  }
  .each_skill {
      display: inline-block;
      margin-bottom: 12px;
      
  }
  .skill_checkbox {
      position: absolute;
      opacity: 0;
      cursor: pointer;
      height: 0;
      width: 0;
  }
  .skill_div {
      text-align: center;
          padding: 20px;
  }
  .skill_name {
      cursor: pointer;
      margin-right: 12px;
      padding: 4px 8px;
      text-align: center;
      border-radius: 5px;
      border: 1px solid #666;
  }
  .checked_box {
      background-color: green;
      color: #fff;
  }
  .answered_question {
      background-color: #90EE90;
  }
  .current_step {
      
      background-color: #FFD580;
  }
  .hide_extra_skill {
      display:none;
  }
  .show_extra_skill {
      display:block;
  }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left ">
    <div class="row">
        <div class="col-md-2"></div>
        <div class="cp_main_div col-md-8">
        
        <form action="{{ route('save_answer') }}" method="post">
              @csrf
        @if($exist)
            @if($question)
                @php 
                $no_of_qns = count($all_questions);
                @endphp
                <div class="nav_steps" style="width:100%;">
                    @foreach($all_questions as $key => $eachStep)
                    
                    <p class="text-center @if(in_array($eachStep->id,$active_qns)) answered_question @endif @if($eachStep->id==$question->id) current_step @endif" style="width:{{ (100/$no_of_qns) }}%;float:left; border: 1px solid #666;"> 
                    <a @if(in_array($eachStep->id-1,$active_qns) || in_array($eachStep->id,$active_qns)) href="{{ route('career_planning',['step'=>$eachStep->id]) }}" @endif>
                    Step {{ $key+1 }}
                    </a>
                    </p>
                    @endforeach
                </div>
                <p>&nbsp;</p>
                <h3 class="text-center">{{ $question->question }}</h3>
                <input type="hidden" name="question_id" value="{{ $question->id }}">
                
                
                
                 <div class="row skill_div">
                 @foreach($skills as $skill)
                 <div class="each_skill">
                    <input type="checkbox" name="answers[]" class="skill_checkbox" id="skill_{{ $skill->id }}" value="{{ $skill->id }}" @if(in_array($skill->id,$selected_ans)) checked @endif>
                    <span class="skill_name @if(in_array($skill->id,$selected_ans)) checked_box @endif" data-id="{{ $skill->id }}" title='{{ $skill->description }}'>{{ $skill->name }}</span>
                 </div>
                 @endforeach
                 </div>
                <br>
                <a class="showExtraText" data-show="0">Add More</a>
                
                <div class="extra_skill hide_extra_skill">
                    <textarea class="form-control" name="extra_skills"></textarea>
                    <label>Write your skills/work values comma seperated</label>
                    <p>&nbsp;</p>
                </div>
                 <p class="text-center">
                     @if(count($active_qns)==5) 
                     <button type="submit" class="btn btn-warning btn-lg generate_cp_btn">Generate</button>
                     @else
                     
                     <button type="submit" class="btn btn-primary btn-lg next_btn">Next</button>
                     @endif
                     </p>
             @else 
                {!! nl2br($final_result) !!}
             @endif
        @else
            @if($prev && count($prev)>0)
                Your Previous Results: <a class="btn btn-primary" data-toggle="modal" data-target="#myModal" style="margin-right:5px;">Open</a>
            @endif
              <div class="form-group">
                <label for="exampleInputName">Name</label>
                <input type="text" name="name" class="form-control" id="name" placeholder="Enter name">
                <span class="text-danger">{{ $errors->has('name') ? $errors->first('name') : '' }}</span>
                <small id="nameHelp" class="form-text text-muted"></small>
              </div>
                @php
                $grades = App\Models\Grade::all();
                @endphp
                <div class="form-group">
                <label for="exampleInputGrade">Grade</label>
                <select name="grade" class="form-control" id="grade">
                    <option value="">Select Grade</option>
                    @foreach($grades as $grade)
                    <option value="{{ $grade->id }}">{{ $grade->name }}</option>
                    @endforeach
                </select>
                <span class="text-danger">{{ $errors->has('grade') ? $errors->first('grade') : '' }}</span>
                <small id="gradeHelp" class="form-text text-muted"></small>
              </div>
              <p class="text-center"><button type="submit" class="btn btn-primary btn-lg start_btn">Start Assessment</button></p>
              
            
        @endif
        </form>
        </div>
        <div class="col-md-2"></div>

</div>
</div>
<div class="modal" id="myModal">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">Previous Result</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
       @if($prev && count($prev)>0)
                Your Previous Results: <br>
                @foreach($prev as $previous)
                <a href="{{ route('career_planning_history', ['id'=>$previous->id]) }}" target="_blank">{{ $previous->name }} - {{ date('d F Y h:i a',strtotime($previous->created_at)) }}</a><br>
                @endforeach
            @endif
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>
<!-- Image of location/map -->

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    $(document).ready(function(){
       $('.skill_name').click(function(){
           var id = $(this).attr('data-id');
           if($("#skill_"+id).prop('checked') == true){
               $("#skill_"+id).prop('checked',false);
               $(this).removeClass('checked_box');
            } else {
                $("#skill_"+id).prop('checked',true);
                $(this).addClass('checked_box');
            }
       }); 
       $('.generate_cp_btn').click(function(){
            $(this).text('Generating...');
        });
       $('.next_btn').click(function(){
            $(this).text('Saving...');
        });
        $('.showExtraText').click(function(){
            var show = $(this).attr('data-show');
            if(show=="1"){
                $('.extra_skill').addClass('hide_extra_skill');
                $('.extra_skill').removeClass('show_extra_skill');
                $(this).attr('data-show','0');
                $(this).text('Add More');
            } else {
                $('.extra_skill').addClass('show_extra_skill');
                $('.extra_skill').removeClass('hide_extra_skill');
                $(this).attr('data-show','1');
                $(this).text('Hide');
            }
        });
    });
    
</script>
</body>
</html>
