<!DOCTYPE html>
<html lang="en">
<head>
  <title>Chat History</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
  .form-group {
     font-size: 16px; 
  }
  label {
    display: inline-block;
    width: 100%;
    margin-bottom: 5px;
    font-weight: 500;
    color: #aaa;
    font-size:12px;
  }
  .user_icon {
      border: 1px solid;
    width: 100px;
    height: 100px;
    margin: 0 auto;
    border-radius: 50%;
    text-align: center;
    overflow: hidden;
  }
  .user_icon i {
      font-size: 100px;
  }
  .pt-20 {
      padding-top: 20px;
  }
  .text-sm {
      font-size: 12px;
    color: #aaa;
  }
  
  .btn-link {
      text-wrap: wrap;
      text-align: left;
  }
  .common_main_div {
    background-size: auto;
    padding:10px;
    background-position: center;
    }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left ">
    <div class="row">
        <div class=" common_main_div">
        
          <h3 class="pt-20 text-center">Chat History </h3>
          <h4><em>File/Folder: {{ $file->filename }}</em></h4>
            @if(Session::has( 'success' ))
             <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
            @elseif( Session::has( 'warning' ))
             <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
            @endif
            
    
            <div id="accordion">
              <div class="card">
                  @foreach($chat_history  as $hisdata)
                <div class="card-header" id="heading{{$hisdata->id}}">
                  <h5 class="mb-0">
                    <button class="btn btn-link" data-toggle="collapse" data-target="#collapse{{$hisdata->id}}" aria-expanded="true" aria-controls="collapse{{$hisdata->id}}">
                      {{ $hisdata->question }}
                    </button>
                  </h5>
                </div>
            
                <div id="collapse{{$hisdata->id}}" class="collapse" aria-labelledby="heading{{$hisdata->id}}" data-parent="#accordion">
                  <div class="card-body">
                    {!! $hisdata->answer !!}
                  </div>
                </div>
                @endforeach
                
                @include('pagination.limit_links', ['paginator' => $chat_history])
              </div>
            </div>

        </div>

</div>
</div>
<!-- Image of location/map -->

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/showdown/2.1.0/showdown.min.js"></script>
<script>
    $(document).ready(function(){
        $('md-block').each(function(){
	        var markmsg = $(this).html();
	        var converter = new showdown.Converter();
	        var htmlmsg      = converter.makeHtml(markmsg);
	        //console.log(htmlmsg);
	        $(this).html(htmlmsg);
	    });
    });
    function update_model(model){
        var _token= "{{ csrf_token() }}";
		
		var request = $.ajax({
		  url: "{{route('change_chat_model')}}",
		  method: "POST",
		  data: { _token : _token, model: model },
		  dataType: "json"
		});
		 
		request.done(function( msg ) {
		  //file_list();
		  //show_shackbar_message('Folder Created Successfully');
          //document.getElementById("addFolderModal").style.display = "none";
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  //show_shackbar_message( "Request failed: " + textStatus );
		});
		
    
    }
    
</script>
</body>
</html>
