<!DOCTYPE html>
<html lang="en">
<head>
  <title>My Files - {{ config('app.name') }}</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content=""/>
  
  @include('layouts.style')
  <style>
    .card {
        border: 1px solid;
        border-radius: 10px;
        padding: 0px 0px 10px 0px;
        overflow: hidden;
    }
    .driver_div {
        margin-bottom: 10px;
    }
    .card-img-top {
        width: 100%;
        overflow: hidden;
    }
    .btn {
        display: inline-block;
        margin-bottom: 10px;
    }
    .item {
        height: 100vh;
        width: 100%;
    }
    
    /* The Modal (background) */
    .modal {
      display: none; /* Hidden by default */
      position: fixed; /* Stay in place */
      z-index: 1; /* Sit on top */
      left: 0;
      top: 0;
      width: 100%; /* Full width */
      height: 100%; /* Full height */
      overflow: auto; /* Enable scroll if needed */
      background-color: rgb(0,0,0); /* Fallback color */
      background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
    }
    
    /* Modal Content/Box */
    .modal-content {
      background-color: #fefefe;
      margin: 5% auto; /* 15% from the top and centered */
      padding: 20px;
      border: 1px solid #888;
      width: 50%; /* Could be more or less, depending on screen size */
    }
    
    /* The Close Button */
    .close {
      color: #aaa;
      float: right;
      font-size: 28px;
      font-weight: bold;
    }
    
    .close:hover,
    .close:focus {
      color: black;
      text-decoration: none;
      cursor: pointer;
    }
    .text_D {
      font-size: 15px; 
    }
    .text_D .glyphicon {
      color: #F8D775; 
      font-size: 16px;
    }
    .text_F .glyphicon {
      color: #F40F02; 
      font-size: 16px;
    }
    
	#cover_spin, #welcome_overlay {
		position:fixed;
		width:100%;
		left:0;
		right:0;
		top:0;
		bottom:0;
		background-color: rgba(255,255,255,0.7);
		z-index:9999;
		display:none;
	}
	#cover_spin img {
		position:absolute;
		left:45%;
		right:0;
		top:35%;
		bottom:0;
	}
	
	#loader_msg {
		position:absolute;
		left:45%;
		right:0;
		top:55%;
		bottom:0;
	}
    .show_generate_loader {
        font-size: 12px;
    }
    .text-sm {
        font-size: 12px;
    }
    .upload_file span {
        font-size: 11px;
        color: #666;
    }
    .sort_icon {
        color: #fff;
        font-size: 10px;
    }
    .sort_icon.active {
        color: blue;
    }
    @media only screen and (min-width: 768px) {
        .first_th {
            width: calc(100% - 490px);
        }
        .second_th {
            width: 280px;
        }
        .hide_th {
            width: 210px;
        }
    }
    @media only screen and (max-width: 768px) {
        
        .first_th {
            width: 100%;
        }
        .hide_th {
            display: none;
        }
        .hide_td {
            display: none;
        }
        .second_th {
            width: 0%;
            font-size: 0px;
            line-height:0;
        }
        .text_D, .text_F  {
          width: 100%;
                float: left;
        }
        .file_actions {
            width: 100%;
            float: left;
            border-top: none !important
        }
    }
    .genie_welcome {
        position: relative;
        text-align: center;
        width: 100%;
        background: rgba(0, 0, 0, 0.8);
        height: 100vh;
    }
    .genie_welcome img {
       
        margin-top: 70px;
    }
    .welcome_play {
        margin-top:10px;
    }
    .extra_file_btns {
        display: inline-block;
    }
    .dropdown_file_btns a {
        display: block;
    }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
<div id="cover_spin">
<img src="{{ url('/images/loader.gif') }}" height="80px"><br><br>
<div id="loader_msg">Generating...</div>
</div>


<div id="welcome_overlay">
    <div class="genie_welcome">
        <img src="{{ url('/images/genie_says_hi_v2.gif') }}"><br>
        <a id="welcome_play" class="btn btn-primary">Start</a>
    </div>

</div>

@include('layouts.nav')


<div class="container common_main_div">
<div class="row">
  <p class="col-md-12 pull-left">{!! $breadcrumb !!}</p>
	<p class="col-md-12 pull-right">
		<a id="addfolder" class="pull-right btn btn-primary" onclick="add_new_folder();">New Folder</a>
      
		<a id="upload" class="pull-right btn s_btn" style="margin-right:10px;">Upload</a>
		<span class="upload_file pull-right">
		    
		<input type="file" name="filename[]" class="pull-right form-control" style="margin-right:10px; max-width:300px;" id="filename" multiple><br>
		<span>
		    *Supports PDF, DOC and DOCX format
		</span>
		</span>
		@if(auth()->user()->id==4)
		<span class="pull-right" style="margin-right:10px;">
		    <input type="checkbox" id="trial"> Trial
		</span>
		@endif
		
		
	</p>
  
</div>
	<table class="table">
		<thead>
		  <tr>
			<th class="first_th" width="">Filename&nbsp; <a class="sort_order active_sort" data-name="filename" data-sort="ASC"><i class="sort_icon fa fa-long-arrow-down"></i><i class="sort_icon fa fa-long-arrow-up"></i></a></th>
			<th class="hide_th" width="">Date&nbsp; <a class="sort_order" data-name="created_at" data-sort="ASC"><i class="sort_icon fa fa-long-arrow-down"></i><i class="sort_icon fa fa-long-arrow-up"></i></a></th>
			<th class="second_th" width="">Action</th>
		  </tr>
		</thead>
		<tbody class="file_list" id="file_list">
		
		</tbody>
	</table>
</div>
<!-- The Modal -->
<div id="myModal" class="modal">

  <!-- Modal content -->
  <div class="modal-content">
    <a class="close" onclick="close_modal()">&times;</a>
    <h3>Embedded Code</h3>
    <p>
        <input type="text" readonly class="form-control" id="embedded_code1">
    </p>
    <p>
        <a onclick="copy_code(1)" class="btn btn-info">Copy to Clipboard</a> &nbsp; <span class="text-success copied1"></span>
    </p>
    <h3>Embedded Code without document (Only chat)</h3>
    <p>
        <input type="text" readonly class="form-control" id="embedded_code2">
    </p>
    <p>
        <a onclick="copy_code(2)" class="btn btn-info">Copy to Clipboard</a> &nbsp; <span class="text-success copied2"></span>
    </p>
  </div>

</div>
<!-- The Modal -->
<div id="addFolderModal" class="modal">

  <!-- Modal content -->
  <div class="modal-content">
    <a class="close" onclick="close_modal()">&times;</a>
    <h3>Add Folder</h3>
    <p>
        <input type="text" class="form-control" id="folder_name">
    </p>
    <p>
        <a onclick="add_folder()" class="btn btn-warning">Add</a> &nbsp; <span class="text-danger folder_msg"></span>
    </p>
  </div>

</div>
<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')

<script>
	
    @if(session()->get('logged_in')!="true")
        $("#welcome_overlay").show();
    @endif
    function add_new_folder(){
      $("#addFolderModal").show();
    }
    function add_folder(){
        var _token= "{{ csrf_token() }}";
		var filename = $('#folder_name').val();
		if(filename!=''){
    		var request = $.ajax({
    		  url: "{{route('add_folder')}}",
    		  method: "POST",
    		  data: { _token : _token, filename: filename, parent: '{{ $parent }}' },
    		  dataType: "json"
    		});
    		 
    		request.done(function( msg ) {
    		  file_list();
    		  show_shackbar_message('Folder Created Successfully');
              document.getElementById("addFolderModal").style.display = "none";
    		});
    		 
    		request.fail(function( jqXHR, textStatus ) {
    		  show_shackbar_message( "Request failed: " + textStatus );
    		});
		} else {
          $('.folder_msg').html('Please enter a valid folder name');
          setTimeout(function () {
            $(".folder_msg").html('');
          }, 2000);
        }
    
    }
    function download_me(id,result){
        console.log(id);
        setTimeout(function () {
            console.log('inside-'+id);
            $("#download_btn"+id).trigger('click');
            $("#download_btn"+id).click();
            window.open(result[id],"_self");
        }, id*2000); 
    }
    function download_all(){
        var ids = $('.download_all').attr('data-ids');
        var result = ids.split(',');
        for(var i=0; i<result.length;i++){
            download_me(i,result);
        }
        //$('.download_btn').each(function(){
           // var id = $(this).attr('id');
            //console.log(id);
            //setTimeout(function () {
               // $("#"+id).trigger('click');
            //}, i*1000);
           // i=i+1;
        //});
    }
    function file_list(type='') {
		$('#file_list').html('loading...');
		var _token= "{{ csrf_token() }}";
		
		var orderby = $('.active_sort').attr('data-name');
        var sort = $('.active_sort').attr('data-sort');
		
		var request = $.ajax({
		  url: "{{route('file_list')}}", 
		  method: "POST",
		  data: { _token : _token, parent: '{{ $parent }}', orderby:orderby, sort:sort },
		  dataType: "html"
		});
		 
		request.done(function( msg ) {
		  $('#file_list').html(msg);
		  if(type=='first'){
		      generate_pending_pickles();
		  }
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  show_shackbar_message( "Request failed: " + textStatus );
		});
    }
	file_list('first');
	function delete_file(id){
		var _token= "{{ csrf_token() }}";
		var cc = confirm('Are you sure?');
		if(cc==true){
		var request = $.ajax({
		  url: "{{route('delete_file')}}",
		  method: "POST",
		  data: { _token : _token, id: id },
		  dataType: "text"
		});
		 
		request.done(function( msg ) {
		  file_list();
		  show_shackbar_message('Deleted Successfully');
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  show_shackbar_message( "Request failed: " + textStatus );
		});
		}
	}
	
	function generate_pickle(id){
		var _token= "{{ csrf_token() }}";
		$('.show_generate_loader'+id).show();
		$('.hide_generate_loader'+id).hide();
		var request = $.ajax({
		  url: "{{route('generate_pickle')}}",
		  method: "POST",
		  data: { _token : _token, id: id },
		  dataType: "json"
		});
		 
		request.done(function( msg ) {
		    console.log(msg)
		    show_shackbar_message(msg.result);
		    $('.show_generate_loader'+id).hide();
        	$('.hide_generate_loader'+id).show();
        	file_list();
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  console.log( "Request failed: " + textStatus );
		  $('.show_generate_loader'+id).hide();
          $('.hide_generate_loader'+id).show();
          file_list();
		});
		
	}
	function generate_pending_pickles(){
		$('.show_generate_loader').each(function(){
		    var id = $(this).attr('data-id');
		    var type = $(this).attr('data-type');
		    if(id!="0"){
    		    if(type=='F'){
    		        generate_pickle(id);
    		    } else {
    		        generate_chat(id,'D')
    		    }
		    }
		});
	}
	function generate_chat(id,type,key="",txt="",merged=''){
		var _token= "{{ csrf_token() }}";
		$('#loader_msg').html('Generating...');
		//$('#cover_spin').show();
		$('.show_generate_loader'+id).show();
		$('.hide_generate_loader'+id).hide();
		var ajaxurl =  "{{ route('create_chat') }}";
		var request = $.ajax({
			url:ajaxurl,
			method: "POST",
			data: { _token : _token, id: id, merged: merged },
			dataType: "html"
		});

		request.done(function( msg ) {
			console.log(msg);
			$('#loader_msg').html('Generated');
			//$('#cover_spin').hide();
			
    		$('.show_generate_loader'+id).hide();
    		$('.hide_generate_loader'+id).show();
			var res = JSON.parse(msg);
			console.log(res.status);
			if(res.status=="merged"){
			    generate_chat(id,type,key,txt,"merged");
			}
			else if(res.status=="success"){
				if(key=="ask"){
					ask(txt);
				} else if(key=="embed"){
					show_code('{{ url("/chat/") }}/'+txt+'/1')
				} else {
					show_shackbar_message('Processed Successfully');
				}
			} else {
				show_shackbar_message(res.result);
			}
			
			file_list();
			
		});

		request.fail(function( jqXHR, textStatus ) {
			show_shackbar_message(textStatus);
			console.log(jqXHR);
    		$('.show_generate_loader'+id).hide();
    		$('.hide_generate_loader'+id).show();
		});
	}
	
	function ask(txt){
		var win = window.open('{{ url("/chat/") }}/'+txt, '_blank');
		if (win) {
			win.focus();
		} else {
			window.open('{{ url("/chat/") }}/'+txt);
		}
	}
	function show_code(url){
	    var code = '<iframe src="'+url+'" style="border: 1px solid grey" frameborder="0" width="100%" height="600" allow="microphone"></iframe>';
	    $('#embedded_code1').val(code);
	    
	    url = url.slice(0, -2);
	    var code = '<iframe src="'+url+'/2" style="border: 1px solid grey" frameborder="0" width="100%" height="600" allow="microphone"></iframe>';
	    $('#embedded_code2').val(code);
	    $('#myModal').show();
	}
	function copy_code(type) {
	    var copyText = document.getElementById("embedded_code"+type);
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        navigator.clipboard.writeText(copyText.value);
        $(".copied"+type).html('Copied');
        setTimeout(function () {
          $(".copied"+type).html('');
        }, 2000);
	}
	$(document).ready(function(){
        $('.sort_order').click(function(){
            
            $('.sort_order').removeClass('active_sort');
            $('.sort_icon').removeClass('active');
            
            var orderby = $(this).attr('data-name');
            var sort = $(this).attr('data-sort');
            if(sort=="ASC"){
                $(this).children('i').eq(0).addClass('active');
                $(this).attr('data-sort','DESC');
            } else {
                $(this).children('i').eq(1).addClass('active');
                $(this).attr('data-sort','ASC');
            }
            $(this).addClass('active_sort');
            file_list();
        });
    	$('#upload').on('click', function() {
    	    
    		var file_data = $('#filename').get(0).files; 
          	if(file_data==undefined){
                  show_shackbar_message('Please select a file');
                  return false;
            }
          	file_datas = [];
    		var form_data = new FormData();
          	for(var i=0;i<$('#filename').get(0).files.length;i++){
              var filename = $('#filename').get(0).files[i].name;
              console.log(filename);
              var filename = $('#filename').val();
              var n = filename.lastIndexOf('.');
              var extension = filename.substring(n+1);
              if(extension!="pdf" && extension!="PDF" //PPT, PPTX, XLS, XLSX
                && extension!="docx" && extension!="DOCX"
                 && extension!="doc" && extension!="DOC"
                  && extension!="ppt" && extension!="PPT"
                   && extension!="pptx" && extension!="PPTX"
                   && extension!="xls" && extension!="XLS"
                   && extension!="xlsx" && extension!="XLSX"){
                  show_shackbar_message('Invalid File Format. Please upload PDF, DOC, DOCX, PPT, PPTX, XLS, XLSX file');
                  return false;
              }	   
              form_data.append('filename_'+i, $('#filename').get(0).files[i]); 
            }
    		//return false;
          	$('#upload').text('Uploading...');
          	$('#upload').addClass('disabled');
    		var _token= "{{ csrf_token() }}"; 
    	    if ($('#trial').is(':checked')) {
    	        form_data.append('trial', '1'); 
    	    }              
    		form_data.append('files_count', i);   
    		form_data.append('_token', _token);   
    		form_data.append('parent', '{{ $parent }}');   
    	
    		$.ajax({
    			url: "{{route('add_file')}}",
    			dataType: 'json', 
    			cache: false,
    			contentType: false,
    			processData: false,
    			data: form_data,                         
    			type: 'post',
    			success: function(response){
    				file_list();
                  	$('#filename').val('');
                    $('#upload').text('Upload');
                    $('#upload').removeClass('disabled');
                    console.log(response);
                    //var res = JSON.parse(response);
        			console.log(response.status);
        			if(response.status=="success"){
        			    show_shackbar_message(response.result);
        			    var uploadeds = response.files;
        			    fileids = uploadeds.split(',');
        			    for(var u=0;u<fileids.length;u++){
        			        generate_pickle(fileids[u]);
        			    }
        			    
        			}
    			}
    		 });
    	});
        var btn = document.getElementById("myBtn");
        var span = document.getElementsByClassName("close")[0];
        span.onclick = function() {
          $('.modal').hide();
        }
        window.onclick = function(event) {
          //if (modal && event.target == modal) {
            //$('.modal').hide();
          //}
        }
        $('#welcome_play').click(function() {
          const audio = new Audio("{{ url('/voices/default/welcome_genie_audio.mp3') }}");
          audio.play();
          $("#welcome_overlay").hide();
        });
        //$('#welcome_play').trigger("click");
	});
  	function close_modal(){
      $(".modal").hide();
    }
</script>

{{ session()->put('logged_in','true')}}
</body>
</html>
