<!DOCTYPE html>
<html lang="en">
<head>
  <title>My Profile</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
  .form-group {
     font-size: 16px; 
  }
  label {
    display: inline-block;
    width: 100%;
    margin-bottom: 5px;
    font-weight: 500;
    color: #aaa;
    font-size:12px;
  }
  .user_icon {
      border: 1px solid;
    width: 100px;
    height: 100px;
    margin: 0 auto;
    border-radius: 50%;
    text-align: center;
    overflow: hidden;
  }
  .user_icon i {
      font-size: 100px;
  }
  .pt-20 {
      padding-top: 20px;
  }
  .text-sm {
      font-size: 12px;
    color: #aaa;
  }
  .mr-50 {
      margin-right: 50px;
  }
  .modal-header, h4, .close {
    background-color: inherit;
    color: inherit !important;
    text-align: inherit;
    font-size: inherit;
  }
  
  img {
    	max-width: 100%;
    	height: auto;
    	vertical-align: middle;
    	display: inline-block;
    }
    
    /* Main CSS */
    .grid-wrapper > div {
    	display: flex;
    	justify-content: center;
    	align-items: center;
    }
    .grid-wrapper > div > img {
    	width: 100%;
    	height: 100%;
    	object-fit: cover;
    	border-radius: 5px;
    }
    
    .grid-wrapper {
    	display: grid;
    	grid-gap: 10px;
    	grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    	grid-auto-rows: 200px;
    	grid-auto-flow: dense;
    }
    .grid-wrapper .wide {
    	grid-column: span 2;
    }
    .grid-wrapper .tall {
    	grid-row: span 2;
    }
    .grid-wrapper .big {
    	grid-column: span 2;
    	grid-row: span 2;
    }
    .card {
      /* Add shadows to create the "card" effect */
      box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);
      transition: 0.3s;
      
      height: calc(100vh - 280px);
      overflow: auto;
      
      padding: 10px;
      
      background: #fff;
    }
    .member_row {
        overflow: auto;
        margin-bottom: 40px;
    }
    .member_col {
        width: 400px;
    float: left;
    margin: 10px;
    }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container-fluid text-left ">
    <div class="row">
        <div class="common_main_div3 col-md-12">
            @if(Session::has( 'success' ))
             <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
            @elseif( Session::has( 'warning' ))
             <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
            @endif
            <p class="pull-right"></p>
            <h3 class="pt-20 text-left"><a class="" href="{{ route('group_details', ['id'=>$group->join_link]) }}"><i class="fa fa-arrow-left"></i></a>&nbsp;Member Questions</h3>
            
            <p><em></em></p>
            <div class="member_row">
                @if($group->members)
                @foreach($group->members as $member)
            	<div class="member_col">
            	    <div class="card" id="user_card_{{$member->user_id}}">
                      <h3 class="card-header">{{ $member->user->name}}</h3>
                      <div class="card-body" id="user_body_{{$member->user_id}}">
                          
                          
                      </div>
                    </div>
            	</div>
            	@endforeach
            	@endif
            </div>
            
            
        </div>

</div>
</div>
<!-- Image of location/map -->


<div class="modal" id="myModal">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">New Group</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
        <form action="" method="post">
          <div class="form-group">
            <label for="email">Group Name</label>
            <input type="text" class="form-control" placeholder="Enter group name" id="group_name" name="group_name">
          </div>
          
          <button type="submit" class="btn btn-primary">Submit</button>
        </form>
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/showdown/2.1.0/showdown.min.js"></script>
<script>
    function copy_link(){
        navigator.clipboard.writeText("{{ route('group_details', ['id'=>$group->join_link]) }}");
        //alert('Group link copied to clipboard');
        show_shackbar_message('Group link copied to clipboard');
    }
    function user_questions(user_id){
        var _token= "{{ csrf_token() }}";
		
		var request = $.ajax({
		  url: "{{route('all_group_answers')}}",
		  method: "POST",
		  data: { _token : _token, id: "{{$group->id}}",user_id: user_id },
		  dataType: "html"
		});
		 
		request.done(function( msg ) {
		    console.log(msg);
		    $('#user_body_'+user_id).html(msg);
		    $('md-block').each(function(){
		        var markmsg = $(this).html();
		        var converter = new showdown.Converter();
		        var htmlmsg      = converter.makeHtml(markmsg);
		        //console.log(htmlmsg);
		        $(this).html(htmlmsg);
		    });
		  //file_list();
		  //show_shackbar_message('Folder Created Successfully');
          //document.getElementById("addFolderModal").style.display = "none";
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		    console.log(textStatus);
		  //show_shackbar_message( "Request failed: " + textStatus );
		});
		
    
    }
    function getRandomColor() {
        var letters = 'BCDEF'.split('');
        var color = '#';
        for (var i = 0; i < 6; i++ ) {
            color += letters[Math.floor(Math.random() * letters.length)];
        }
        return color;
    }
    $(document).ready(function(){
        @foreach($group->members as $member)
            user_questions({{$member->user_id}});
            $("#user_card_{{$member->user_id}}").css('background',getRandomColor());
        @endforeach
    });
    
</script>
</body>
</html>
