<!DOCTYPE html>
<html lang="en">
<head>
  <title>Ask PDF - {{ config('app.name') }}</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content=""/>
  
  @include('layouts.style')
  <style>
      canvas {
      	max-width: 100%;  
      }
      .msg {
        padding: 5px;
       	border-radius: 5px;
		margin: 10px 5px;
        font-weight: normal;
      }
      .my_msg {
        background-color: #c7e3ff;
        text-align: right;
      }
      .ai_msg {
        background-color: #e1cfff;
        text-align: left;
      }
      .load_msg {
        background-color: #fffecf;
        text-align: center;
      }
	  .question-part {
	  }
	  
      .ask_button {
        width: 20%;
        float: right;
        margin-top: 5px;
      }
      .copy_answer {
           border: 1px solid;
            border-radius: 5px;
            font-size: 14px;
            padding: 5px;
            margin-left: 5px;
        
      }
      .chat-part {
        height: calc(100vh - 137px);
		margin-top:50px;
        overflow-y: scroll;
      }
      .pmsg {
      	width: 80%;  
      }
      .embedded-part {
        border: 1px solid #111;
        padding: 0;
      }
      #myPage {
      }
      .d-none {
          display: none;
      }
      .pdf-part {
      	height: calc(100vh - 84px) !important;
		margin-top:50px;
        
        width: 100%;
        overflow-y: scroll;
        text-align: center;
      }
      .inner_row {
        min-height: 200px;
      }
	  .loaderimage {
		position: absolute;
		top: 45%;
		margin: 0px auto;
		width: 75px;
		text-align: center;
		left: 45%;
	  }
	  .fa-volume-up {
	      font-size: 16px;
	  }
      @media only screen and (max-width: 992px) {
          .pdf-part {
            height: calc(100vh - 265px) !important;
          }
          .chat-part {
            height: calc(100vh - 248px);
          }
        
        .embedded-part {
            border-top: 1px solid #111;
        }
        .mobile_btns {
         	padding-top: 60px; 
        }
        .pdf-screen {
          display: none;
        }
      }
      .answer_span {
          margin-right: -2px;
      }
  </style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.6.347/pdf_viewer.min.css" rel="stylesheet" type="text/css" />
</head>
<body id="myPage1" data-spy="scroll" data-target=".navbar" data-offset="50">

@include('layouts.nav')


<div class="container-fluid main-div common_main_div1">
	<div class="row inner_row">
	    
		<div class=" col-md-12 col-sm-12 col-xs-12 embedded-part chat-screen">
			<div class="chat-part" id="scroll_chat">
              <h5 class="text-center">Ask Questions</h5>
              <p class="main_msg">
			  Math Genie
			  <br><br>Here are some sample questions<br>
			  <b>Area and Perimeter</b>: A rectangular garden is 12 meters long and 8 meters wide.  If Sarah wants to put a fence around the entire garden, how much fencing (in meters) will she need?
            <br><br>
            <b>Linear Equations</b>:  The local bakery sells cupcakes for $1.25 each and muffins for $0.75 each.  Last weekend, Sarah bought a total of 10 baked goods (cupcakes and muffins) and spent $10.00.  Let x represent the number of cupcakes Sarah bought.  Write down an equation to find how many cupcakes Sarah bought.
            <br><br>
            <b>Pythagorean Theorem</b>:  A straight ladder 13 feet long leans against a building, reaching a height of 12 feet on the wall.  If there are no gaps between the ladder and the building or the ground, how far away is the base of the ladder from the building?
			  </p>
              <hr>
          	</div>
			<div class="question-part">
			    
			    <input type="file" id="inputImg" style="height:0;width:0;">
			    <button  id="btnImg" class=" btn " style="margin-top: 5px;width:40px;float:left;border:1px solid;"><i class="fa fa-paperclip"></i></button>
              <input class="form-control" style="width:calc(100% - 160px);float:left;border-radius: 30px; height:42px;" id="question" placeholder="Enter Question">
              
              <button id="btnStart" class=" btn " style="margin-top: 5px;width:40px;float:right;border:1px solid;"><i class="fa fa-microphone"></i></button>
              <button id="btnStop" class=" btn "  style="margin-top: 5px;display:none;width:40px;float:right;border:1px solid;"><i class="glyphicon glyphicon-stop text-danger"></i></button>
              <button id="btnRefresh" class=" btn "  style="margin-top: 5px;display:none;width:40px;float:right;border:1px solid;">....</button>
              
              <button class=" btn btn-success ask_button" style="width:80px;float:right;border:1px solid;" onclick="ask_chat()"><i class="glyphicon glyphicon-send"></i></button>
              
              
			</div>
		</div>
		
		</div>
	</div>
</div>
<input type="hidden" id="mediaObj">
@include('layouts.footer')

@include('layouts.script')
  <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.6.347/pdf.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/showdown/2.1.0/showdown.min.js"></script>
<script type="text/javascript">
    let sound;
    function speak_message(id){
        $('.stop'+id).hide();
        $('.speak'+id).hide();
        $('.load'+id).show();
        var msg = $('.answer_'+id).text();
		var _token= "{{ csrf_token() }}";
		$.ajax({
			url: "{{route('texttospeech')}}", 
			data: {text:msg, _token:_token },                         
			type: 'post',
			success: function(response){
				console.log(response);
				sound = new Audio("data:audio/mp3;base64," + response);
                sound.play();
                $('.stop'+id).show();
                $('.speak'+id).hide();
                $('.load'+id).hide();
                sound.addEventListener("ended", function(){
                     sound.currentTime = 0;
                     $('.speak_btn').show();
                    $('.stop_btn').hide();
                    $('.load').hide();
                });
			}
		 });
	}
	function stop_speak(id){
	    if (sound && !sound.paused) {
            sound.pause();
            sound.currentTime = 0; // Rewind track to beginning (is you need this)
          }
        $('.speak_btn').show();
        $('.stop_btn').hide();
        $('.load').hide();
	}
    function show_new_pdf(type){
        
    }
    var pdfjsLib = window['pdfjs-dist/build/pdf'];
    pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.6.347/pdf.worker.min.js';
    var pdfDoc = null;
    var scale = 1; //Set Scale for Zoom.
    var resolution = IsMobile() ? 1.5 : 1; //Set Resolution as per Desktop and Mobile.
    function LoadPdfFromUrl(url,append) {
        console.log(url);
        //Read PDF from URL.
        pdfjsLib.getDocument(url).promise.then(function (pdfDoc_) {
            pdfDoc = pdfDoc_;
			
            //Reference the Container DIV.
            var pdf_container = document.getElementById("pdf_container_"+append);
            pdf_container.style.display = "block";
            //pdf_container.style.height = IsMobile() ? "1200px" : "820px";
 
            for (var i = 1; i <= pdfDoc.numPages; i++) {
				RenderPage(pdf_container, i);
            }
        });
    };
    
    function RenderPage(pdf_container, num) {
		
        pdfDoc.getPage(num).then(function (page) {
            //Create Canvas element and append to the Container DIV.

            var canvas = document.createElement('canvas');
            canvas.id = 'pdf-' + num;
            ctx = canvas.getContext('2d');
            pdf_container.appendChild(canvas);
            //Create and add empty DIV to add SPACE between pages.
            var spacer = document.createElement("div");
            spacer.style.height = "20px";
            pdf_container.appendChild(spacer);
 
            //Set the Canvas dimensions using ViewPort and Scale.
            var viewport = page.getViewport({ scale: scale });
            canvas.height = resolution * viewport.height;
            canvas.width = resolution * viewport.width;
               
            //Render the PDF page.
            var renderContext = {
                canvasContext: ctx,
                viewport: viewport,
                transform: [resolution, 0, 0, resolution, 0, 0]
            };
 
            page.render(renderContext);
        });
		$('.loaderimage').hide();
    };
 
    function IsMobile() {
        var r = new RegExp("Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini");
        return false;//r.test(navigator.userAgent);
    }
</script>
<script>
  
  	$('.main_msg').show();
  	
  	function ask_chat(voice=""){
  	    var q_id = Date.now().toString(36) + Math.random().toString(36).substr(2);
      var _token= "{{ csrf_token() }}";
      var question = $("#question").val();
		if(question!=""){
		    
            $('.image_preview_div').remove();
          $("#scroll_chat").animate({ scrollTop: $('#scroll_chat').prop("scrollHeight")}, 1000);
          var extra = '';
          if($('#inputImg')[0].files.length>0){
                var imgURL = URL.createObjectURL($('#inputImg')[0].files[0]);
                extra  = "<img src='"+imgURL+"' height='100px'><br>"; 
            }
		  var my_msg = "<p class='pmsg pull-right text-right'><label class='msg my_msg'>"+extra+question+"</label></p>";
          var load_msg = "<p class='pmsg pull-right text-center' id='loader_p'><label class='msg load_msg'>Loading...&nbsp;</label></p>";
          $('.chat-part').append(my_msg);
          $('.chat-part').append(load_msg);
          $('.ask_button').attr('disabled',true);
      	  $('#question').attr('disabled',true);
      	  var form_data = new FormData();
		var _token= "{{ csrf_token() }}";
		form_data.append('question', question);   
		form_data.append('_token', _token);  
		form_data.append('file', $('#inputImg')[0].files[0]);
        var request = $.ajax({
            url: "{{ route('math_genie_ask') }}",
            dataType: 'html', 
			cache: false,
			contentType: false,
			processData: false,
			data: form_data,                         
			type: 'post',
          });

          request.done(function( msg ) {
            $('.load_msg').remove();
            var scroll_id = "scroll_"+q_id;
            var ai_msg = "<div class='pmsg pull-left text-left' id='"+scroll_id+"'>";
            
            ai_msg += "<label class='msg ai_msg msg_"+q_id+"'>";
            var converter = new showdown.Converter();
            var htmlmsg      = converter.makeHtml(msg);
            ai_msg += "<span class='answer_span answer_"+q_id+"'>"+(htmlmsg)+"</span>";
            ai_msg += "<span class='pull-right'>";
            ai_msg += "<a class='pull-right copy_answer' onclick='copy_message(\""+q_id+"\");' title='Copy Answer'><i class='glyphicon glyphicon-copy'></i></a>&nbsp;";
            
            
            ai_msg += "<a class='pull-right copy_answer speak_btn speak"+q_id+"' onclick='speak_message(\""+q_id+"\");' title='Speak Answer'><i class='fas fa-volume-up'></i></a>";
            ai_msg += "<a class='pull-right copy_answer stop_btn d-none stop"+q_id+"' onclick='stop_speak(\""+q_id+"\");' title='Stop Answer'><i class='fas fa-stop'></i></a>";
            ai_msg += "<a class='pull-right copy_answer load_btn d-none load"+q_id+"' title='Load Answer'><i class='fa fa-spinner'></i></a>";
            
            ai_msg += "</span>";
            ai_msg += "</label>";
            ai_msg += "</div>";
            ai_msg = ai_msg.replace('```markdown','');
            ai_msg = ai_msg.replace('```','');
            $('.chat-part').append(ai_msg);
            $("#question").val('');
            $("#scroll_chat").animate({ scrollTop: $('#scroll_chat').prop("scrollHeight")}, 1000);
            $('.ask_button').attr('disabled',false);
      	    $('#question').attr('disabled',false);
      	    if(voice=="yes"){
      	        speak_message(q_id);
      	    }
          });

          request.fail(function( jqXHR, textStatus ) {
            $('.load_msg').remove();
            alert( "Request failed: " + textStatus );
            $("#question").val('');
            $('.ask_button').attr('disabled',false);
      	    $('#question').attr('disabled',false);
            $('.image_preview_div').remove();
          });
        } else {
         alert('Please enter question'); 
        }
    }
    function copy_message(id){
        navigator.clipboard.writeText($('.answer_'+id).text());
        alert('Answer copied to clipboard');
    }
	function showBlock(type){
      	$('.tab_btn').removeClass('active');
     	if(type==2){
          $('.pdf-screen').show();
          $('.chat-screen').hide();
          $('.doc_btn').addClass('active');
        } else {
          $('.pdf-screen').hide();
          $('.chat-screen').show();
          $('.chat_btn').addClass('active');
        }
    }
	$(document).ready(function(){
		var input = document.getElementById("question");
        input.addEventListener("keypress", function(event) {
          if (event.key === "Enter") {
          event.preventDefault();
          ask_chat();
        }
      });
      $('#btnImg').click(function(){
          $('#inputImg').trigger("click");
      });
      $('#inputImg').change(function(e){
          var imgURL = URL.createObjectURL(e.target.files[0]);
          var ai_msg = "<div class='image_preview_div pmsg  pull-right text-right'>";
            ai_msg += "<label class='msg ai_msg'>";
            ai_msg += "<span class='answer_span'><img src='"+imgURL+"' height='100px'></span>";
            
            ai_msg += "</label>";
            ai_msg += "</div>";
            $('.chat-part').append(ai_msg);
          $("#scroll_chat").animate({ scrollTop: $('#scroll_chat').prop("scrollHeight")}, 1000);
      });
	});
	

	let audioIN = { audio: true };


		let start = document.getElementById('btnStart');

		let stop = document.getElementById('btnStop');

		let refresh = document.getElementById('btnRefresh');

		
		start.addEventListener('click', function (ev) {
		    
	        navigator.mediaDevices.getUserMedia(audioIN).then(function (mediaStreamObj) {
    		    let mediaRecorder = new MediaRecorder(mediaStreamObj);
    		    
    			mediaRecorder.start();
    			console.log(mediaRecorder.state);
    			start.style.display = "none";
    			stop.style.display = "block";
    			refresh.style.display = "none";
    			
        		stop.addEventListener('click', function (ev) {
        			mediaRecorder.stop();
        			console.log(mediaRecorder.state);
        			refresh.style.display = "block";
                    stop.style.display = "none";
                    start.style.display = "none";
        		});
        		mediaRecorder.ondataavailable = function (ev) {
        		    dataArray.push(ev.data);
        		}
        		
        		let dataArray = [];
        		
        		mediaRecorder.onstop = function (ev) {
                    
                    refresh.style.display = "block";
                    stop.style.display = "none";
                    start.style.display = "none";
                    
            		let audioData = new Blob(dataArray,{ 'type': 'audio/mp3;' });
            					
            		dataArray = [];
            		
            		var form_data = new FormData();
            		var _token= "{{ csrf_token() }}";
            		form_data.append('voice', audioData);   
            		form_data.append('_token', _token);  
            		$.ajax({
            			url: "{{route('speechtotext')}}",
            			dataType: 'json', 
            			cache: false,
            			contentType: false,
            			processData: false,
            			data: form_data,                         
            			type: 'post',
            			success: function(response){
            				$('#question').val(response.text);
                            start.style.display = "block";
                            refresh.style.display = "none";
                            stop.style.display = "none";
                            if(response.text!=""){
                                ask_chat("yes");
                            }
                            mediaStreamObj.getTracks().forEach( track => track.stop() );
            			}
            		 });
        		}
	        }).catch(function (err) {
        		console.log(err.name, err.message);
        		show_shackbar_message('Unable to get the voice. Please try again');
        	});
    	});
	
</script>
</body>
</html>
