<!DOCTYPE html>
<html lang="en">
<head>
  <title>Career Planning</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
  .form-group {
     font-size: 16px; 
  }
  label {
    display: inline-block;
    width: 100%;
    margin-bottom: 5px;
    font-weight: 500;
    color: #aaa;
    font-size:12px;
  }
  .user_icon {
      border: 1px solid;
    width: 100px;
    height: 100px;
    margin: 0 auto;
    border-radius: 50%;
    text-align: center;
    overflow: hidden;
  }
  .user_icon i {
      font-size: 100px;
  }
  .pt-20 {
      padding-top: 20px;
  }
  .text-sm {
      font-size: 12px;
    color: #aaa;
  }
  
  .cp_main_div {
      min-height: calc(100vh - 300px);
      background: #fff;
      padding: 15px;
  }
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left ">
    <div class="row">
        <div class="col-md-2"></div>
        <div class="cp_main_div col-md-8">
        
        @if($exist)
            <p><b>Name:</b> {{ $exist->name }}</p>
            <p><b>Grade:</b> {{ $exist->gradedata->name }}</p>
            @php 
            $qstn = "";
            $ansr = "";
            @endphp
            @foreach($exist->answers as $ans)
                @if($qstn!=$ans->question->id)
                    @if($qstn!="")
                        </p>
                        <p>
                    @else 
                        <p>
                    @endif
                    <b>{{$ans->question->question}}:</b>
                    @php 
                    $ansr = "";
                    $qstn = $ans->question->id;
                    @endphp
                @endif
                @if($ansr!="")
                    {{", ".$ans->skilldata->name}}
                @else 
                    {{$ans->skilldata->name}}
                @endif
                @php 
                $ansr = "1";
                @endphp
                    
            @endforeach
            </p>
            
            <p><b>Result:</b> {!! nl2br($exist->result) !!}</p>
        @else
            Invalid Page
            
        @endif
        </div>
        <div class="col-md-2"></div>

</div>
</div>
<!-- Image of location/map -->

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    function update_model(model){
        var _token= "{{ csrf_token() }}";
		
		var request = $.ajax({
		  url: "{{route('change_chat_model')}}",
		  method: "POST",
		  data: { _token : _token, model: model },
		  dataType: "json"
		});
		 
		request.done(function( msg ) {
		  //file_list();
		  //show_shackbar_message('Folder Created Successfully');
          //document.getElementById("addFolderModal").style.display = "none";
		});
		 
		request.fail(function( jqXHR, textStatus ) {
		  //show_shackbar_message( "Request failed: " + textStatus );
		});
		
    
    }
    
</script>
</body>
</html>
