<!DOCTYPE html>
<html lang="en">
<head>
  <title>Ask PDF - {{ config('app.name') }}</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content=""/>
  
  @include('layouts.style')
  @php
    $show_toggles = false;
    if($files->file_level=="4"){
        $show_toggles = true;
    }
    @endphp
  <style>
      canvas {
      	max-width: 100%;  
      }
      
  .main_msg {
    padding: 10px 20px;
    width: 80%;
    margin: 0 auto;
    background: #faebd7;
    border-radius: 15px;
  }
      .msg {
        padding: 5px;
       	border-radius: 5px;
		margin: 10px 5px;
        font-weight: normal;
      }
      .my_msg {
        background-color: #fff8e7;
        text-align: right;
      }
      .ai_msg {
        background-color: #faebd7;
        text-align: left;
      }
      .load_msg {
        background-color: #fffecf;
        text-align: center;
      }
	  .question-part {
	  }
	  
      .ask_button {
        
      }
      .copy_answer {
           border: 1px solid;
            border-radius: 5px;
            font-size: 14px;
            padding: 5px;
            margin-left: 5px;
        
      }
      .chat-part {
        @if(!$embedded || $embedded<1)
        @if((auth()->user() && (auth()->user()->level=="4" || auth()->user()->level=="1")) || $show_toggles)
        height: calc(100vh - 217px);
        @else 
        height: calc(100vh - 217px);
        @endif
		padding-top: 15px;
        @else
        @if((auth()->user() && (auth()->user()->level=="4" || auth()->user()->level=="1")) || $show_toggles)
        height: calc(100vh - 217px);
        @else 
        height: calc(100vh - 217px);
        @endif
        @endif
        overflow-y: scroll;
      }
      .pmsg {
      	width: 80%;  
      }
      .embedded-part {
        padding: 0;
      }
      #myPage {
      }
      .d-none {
          display: none;
      }
      .pdf-part {
        @if(!$embedded || $embedded<1)
      	height: calc(100vh - 118px) !important;
		margin-top: 15px;
        @else
        height: calc(100vh - 85px) !important;
		margin-top: 15px;
        @endif
        width: 100%;
        overflow-y: scroll;
        text-align: center;
      }
      .inner_row {
        min-height: 200px;
      }
	  .loaderimage {
		position: absolute;
		top: 45%;
		margin: 0px auto;
		width: 75px;
		text-align: center;
		left: 45%;
	  }
	  .fa-volume-up {
	      font-size: 16px;
	  }
	  /*
      @media only screen and (max-width: 992px) {
        @if(!$embedded || $embedded<1)
          .pdf-part {
            height: calc(100vh - 217px) !important;
          }
          .chat-part {
            height: calc(100vh - 217px);
          }
        @else
          .pdf-part {
            height: calc(100vh - 265px) !important;
          }
          .chat-part {
            height: calc(100vh - 248px);
          }
        @endif
        
        .mobile_btns {
         	padding-top: 60px; 
        }
        .pdf-screen {
          display: none;
        }
      }
      */
      .answer_span {
          margin-right: -2px;
      }
      .switch {
          margin-top:10px;
          position: relative;
          display: inline-block;
          width: 40px;
          height: 20px;
        }
        
        .switch input { 
          opacity: 0;
          width: 0;
          height: 0;
        }
        
        .slider {
          position: absolute;
          cursor: pointer;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
          background-color: #ccc;
          -webkit-transition: .4s;
          transition: .4s;
        }
        
        .slider:before {
          position: absolute;
          content: "";
          height: 13px;
          width: 13px;
          left: 4px;
          bottom: 4px;
          background-color: white;
          -webkit-transition: .4s;
          transition: .4s;
        }
        
        input:checked + .slider {
          background-color: #2196F3;
        }
        
        input:focus + .slider {
          box-shadow: 0 0 1px #2196F3;
        }
        
        input:checked + .slider:before {
          -webkit-transform: translateX(20px);
          -ms-transform: translateX(20px);
          transform: translateX(20px);
        }
        
        /* Rounded sliders */
        .slider.round {
          border-radius: 34px;
        }
        
        .slider.round:before {
          border-radius: 50%;
        }
        .swith_div {
            padding-right: 20px;
            overflow: hidden;
            
            text-align: center;
            width: 100%;
        }
        .swith_row {
            margin-right: 0 !important;
            overflow: hidden;
        }
        .speak_btn_div {
            margin-top: 5px;
            margin-bottom: 5px;
        }
        .speaking_btn,
        .delete_btn {
          animation: mymove 2s infinite;
          animation-timing-function: linear;
        }
        
        @keyframes mymove {
          0% {border: 4px solid red;}
          25% {border: 4px solid yellow;}
          50% {border: 4px solid blue;}
          75% {border: 4px solid pink;}
          100% {border: 4px solid black;}
        }
        #audio_span2,
        #delete_span2 {
            font-size: 12px;
            color: #666;
            position: absolute;
            width: 118px;
            left: -10px;
            top: 85px;
        }
        #audio_span,
        #delete_span {
            font-size: 12px;
            color: #666;
        }
        .modal-header {
            padding: 10px 30px;
        }
        .t_languages span {
            display: inline-block;
            margin-top: 10px;
            margin-right: 10px;
        }
        .pl-15 {
            padding-left: 15px;
        }
        .question-part-desktop {
            display: none;
        }
        .question-part-desktop-inner {
            height: calc(100vh - 70px);
            overflow-y: auto;
            width: 100%;
            overflow-x: hidden;
        }
        .chat_top {
            position: fixed;
            width: 100%;
            z-index: 9999;
            border-bottom: 1px solid #666;
            padding-bottom: 10px;
            background: #fff;
        }
        .embedded-part {
            margin-top: 54px;
        }
        
        .chat_doc_div{
            padding-left: 20px;
        }
        .chat_doc_span {
            font-size: 12px;
            display: block;
            color: #fff;
        }
        
        .question-part {
            display: none;
        }
        .mob_toggles {
            display: none;
        }
        .only_on_mobile {
          display: none;
        }
        .only_on_desktop {
          display: none;
        }
        .chat_doc_div {
              display: none;
          }
          .chat_doc_div2 {
              display: none;
          }
        @media only screen and (max-width: 768px) {
          .only_on_mobile {
            display: block;
          }
          .chat_doc_div {
              display: block;
          }
          .chat_doc_div2 {
              display: none;
          }
          .input-wrapper { 
            position: relative; 
            display: inline-block; 
            width: 100%;
            float: left;
            
        }
        .input-wrapper button i { 
            color: #355070;
        } 
  
        .input-wrapper input { 
            padding-right: 40px; 
            background: #eee;
            border-radius: 30px;
            border: none;
        } 
  
        .input-wrapper button { 
            position: absolute; 
            top: 0; 
            right: 0; 
            border: none; 
            cursor: pointer; 
            background: transparent;
            
            padding: 8px 10px;
        } 
        .audio_mob_btn_div {
            width: 40px;
            float: right;
            margin-right: 5px;
            margin-left: 5px;
            margin-top: -8px;
        }
        .audio_mob_btn_div i {
            color: #355070;
        }
        .tab_btn2 {
            border: none;
            color: #fff;
            margin-top: 10px;
            box-shadow: 0px 0px 0px 0px #355070;
        }
        .tab_btn2 .glyphicon {
            font-size: 20px;
        }
        .slider {
          border: 1px solid #fff;
          background-color: #355070;
        }
        .chat_doc:checked + .slider {
          background-color: #355070;
        }
        .embedded-part {
            margin-top: 60px;
        }
            .question-part {
                
                display: block;
                position: fixed;
                width: 100%;
                padding-bottom: 5px;
                background: #fff;
                bottom: 54px;
                /* height: 53px; */
                padding-top: 5px;
            }
          .mob_toggles {
            display: block;
            }
            
            .chat_top {
                background: #355070;
            }
            .chat-part {
                padding-bottom: 10px;
            }
            .tip_of_day {
                
                width:100%;
                font-size: 11px;
                color: #aaa;
            }
            
          .pdf-part {
          }
          .chat-part {
            height: calc(100vh - 270px);
          }
        }
        
        @media only screen and (min-width: 768px) {
          .chat_doc_div {
              display: none;
          }
          .chat_doc_div2 {
              display: block;
          }
          .chat-part {
            width: 70%;
            float: right;
            height: auto;
            border-left: 1px solid #666;
            min-height: calc(100vh - 55px);
                overflow-y: hidden;
          }
          .question-part-desktop {
            display: block;
              width: 30%;
              float: left;
              position: fixed;
              padding: 10px;
          }
          
            .tab_btn2 {
                border: none;
                color: #fff;
                margin-top: 10px;
                box-shadow: 1px 1px 1px 2px #2e6da4;
                background-color: #337ab7;
            }
        }
        
/* Mobile view */


.mobile-footer {
    position: fixed;
    width: 100%;
    z-index: 9999;
    background: #355070;
    bottom: 0;
    color: #fff;
}
.col20 {
    display: inline-block;
    width: 20%;
    text-align: center;
    float: left;
    padding-top: 10px;
    padding-bottom: 10px;
}
.col20 a {
    line-height: 0px;
    color: #fff;
}
.col20 .fa {
    font-size: 16px;
}
.col20 .fa-home {
    font-size: 20px;
}
.col20 span {
    width: 100%;
    font-size: 12px;
    float: left;
}

.only_on_mobile {
  display: none;
}
.only_on_desktop {
  display: none;
}
.typing_only_on_mobile {
    display: none;
}
@media only screen and (max-width: 768px) {
  .only_on_mobile {
    display: block;
  }
  .typing_only_on_mobile {
        height: 100%;
        width: 100%;
        position: absolute;
        left: 0;
        top: 0;
    }
    .genie_typing img {
        margin-top: 20%;
    }
}

@media only screen and (min-width: 768px) {
    .only_on_desktop {
      display: block;
    }
    
    .genie_typing img {
        margin-top: 50%;
    }
}
.genie_typing {
    height: 100vh;
    width: 100%;
    position: absolute;
    vertical-align: middle;
    background: rgba(0, 0, 0, 0.7);
    left: 0;
    top: 0;
    z-index: 999;
    text-align: center;
}
.genie_typing h3 {
    color: #fff;
}
.genie_typing img {
    text-align: center;
    display: block;
    margin-left: auto;
    margin-right: auto;
    width: 40%;
    vertical-align: middle;
}
@if(auth()->user() && auth()->user()->id=="3")
#myPage1 {
        background-position: right bottom;
        background-repeat: no-repeat;
        background-size: cover;
        background-attachment: fixed;
        
        background-image: url('{{ url("images/appgenie_bg.jpg") }}');
  }
  .question-part-desktop-inner b {
      color: #ddd;
  }
  
  .alltoggles {
      color: #ccc;
  }
@endif
  </style>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.6.347/pdf_viewer.min.css" rel="stylesheet" type="text/css" />
</head>
<body id="myPage1" data-spy="scroll" data-target=".navbar" data-offset="50">


<div class="container-fluid main-div common_main_div1">
	<div class="row inner_row">
	    @if($embedded!="2")
	    <div class="chat_top">
	       <div class="" style="margin-top:10px;">
      	    
      	        <div class="pull-left chat_doc_div">
      	       &nbsp;&nbsp;&nbsp;&nbsp;
      	        <label class="switch">
                  <input type="checkbox" class="chat_doc">
                  <span class="slider chat_doc_slider round"></span>
                </label>
                 
                <span class="chat_doc_span">Chat / Document</span>
      	        </div>
      	        
                <div class="pull-left chat_doc_div2">
                <a class="btn btn-primary tab_btn chat_btn active" onclick="showBlock(1)">Chat</a>&nbsp;
                <a class="btn btn-primary tab_btn doc_btn" onclick="showBlock(2)">Document</a>
                </div>
                  @if(!$embedded || $embedded<1)
                  @endif
                  @if((auth()->user() && (auth()->user()->level=="4" || auth()->user()->level=="5" || auth()->user()->level=="1")) || $show_toggles)    
                  <div class="btn-group pull-right" role="group"><a class="btn tab_btn2 mob_toggles dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-right:5px;"><i class="fa fa-bars"></i></a>
                  
             
                    <ul class="dropdown-menu">
                      <li><a href="{{ route('profile') }}">MY PROFILE</a></li>
                      <li><a href="{{ route('history') }}">CHAT HISTORY</a></li>
                      <li><a href="{{ route('saved_messages') }}">SAVED MESSAGES</a></li>
                    </ul>
                  </div>

                  @endif 
                  <a class="btn tab_btn2 doc_btn pull-right only_on_desktop" style="margin-right:5px;" href="{{ route('files') }}"><i class="fa fa-home"></i></a>
                  <a class="btn tab_btn2 doc_btn pull-right" data-toggle="modal" data-target="#myModal3" style="margin-right:10px;"><i class="fa fa-question-circle"></i></a>
           <!--
                <div class="pull-left chat_doc_div2">
                <a class="btn btn-primary tab_btn chat_btn active" onclick="showBlock(1)">Chat</a>&nbsp;
                <a class="btn btn-primary tab_btn doc_btn" onclick="showBlock(2)">Document</a>
                </div>
                  @if(!$embedded || $embedded<1)
                  <a class="btn btn-primary tab_btn doc_btn pull-right" style="margin-right:5px;" href="{{ route('files') }}">X</a>
                  @endif
                  @if((auth()->user() && (auth()->user()->level=="4" || auth()->user()->level=="5" || auth()->user()->level=="1")) || $show_toggles)    
                  <a class="btn btn-primary pull-right mob_toggles" data-toggle="modal" data-target="#myModal" style="margin-right:5px;"><i class="glyphicon glyphicon-cog"></i></a>
                  @endif
            -->
        </div> 
	    </div>
      	
        @endif
		<div class="col-md-12 col-sm-12 col-xs-12 embedded-part chat-screen">
		    @if(auth()->user() && (auth()->user()->id=="3" || auth()->user()->id=="4"))
			  
			      
			    <div class="genie_typing typing_only_on_mobile" style="display:none">
			        <img width="" src="https://app.ilifegenie.com/images/genie_is_typing.gif" style=""><br>
                    <h3>Please wait while Genie finds your answer...</h3>
    			    </div>
			    @endif  
		    <div class="row swith_row">
		    
		    <div class="col-12 pl-15">
		     
			<div class="chat-part" id="scroll_chat">
			  
              <h5 class="text-center">Ask Questions to the PDF</h5>
              <p class="main_msg">
              <span class='summary_text'>
			  {!! $files->summary !!}
			  </span>
			  <br><br>Here are some sample questions<br>
			  <span class='question_text'>
			      {!! $files->sample_questions !!}
			  </span>
			  
			  <br> <br>
			  <b>Genie is not yet 100% accurate in subjects like Math, Chemistry or Physics. You may ask conceptual questions on these subjects but Genie may not be able to solve complex equations or problems in these subjects.</b>
			  </p> 
          	</div>
          	
			<div class="question-part-desktop">
			    @if(auth()->user() && (auth()->user()->id=="3" || auth()->user()->id=="4"))
			    <div class="genie_typing" style="display:none;">
			        <img width="" src="https://app.ilifegenie.com/images/genie_is_typing.gif" style="
                        text-align: center;
                        display: block;
                        margin-left: auto;
                        margin-right: auto;
                        width: 40%;
                        vertical-align: middle;
                        margin-top: 50%;
                    "><br>
                    <h3>Please wait while Genie finds your answer...</h3>
			    </div>
			    <!--
			    <div class="genie_listening" style="display:none;">
			        <img width="" src="https://app.ilifegenie.com/images/genie_is_typing.gif" style="
                        text-align: center;
                        display: block;
                        margin-left: auto;
                        margin-right: auto;
                        width: 40%;
                        vertical-align: middle;
                        margin-top: 50%;
                    "><br>
                    <h3>Please wait while Genie finds your answer...</h3>
			    </div>
			    -->
			    @endif
			    <div class="question-part-desktop-inner">
			    <b>Use any one or a combination of the below toggle buttons to fine tune Genie's response</b>
			    <div class="alltoggles">
			        <label class="switch">
                  <input type="checkbox" class="story_mode1">
                  <span class="slider round"></span>
                </label>&nbsp;Story Mode
			    <br>
    			<label class="switch">
                  <input type="checkbox" class="real_life_examples1">
                  <span class="slider round"></span>
                </label>&nbsp;Real Life Examples
			    <br>
    			<label class="switch">
                  <input type="checkbox" class="generate_questions1">
                  <span class="slider round"></span>
                </label>&nbsp;Generate Questions
			    <br>
    			<label class="switch">
                  <input type="checkbox" class="practical_activity1">
                  <span class="slider round"></span>
                </label>&nbsp;Practical Activity
			    <br>
    			<label class="switch">
                  <input type="checkbox" class="easy_explain1">
                  <span class="slider round"></span>
                </label>&nbsp;Ezy Explain
                <br>
    			<label class="switch">
                  <input type="checkbox" class="validate_answer1">
                  <span class="slider round"></span>
                </label>&nbsp;Validate Answer
                <br>
    			<label class="switch">
                  <input type="checkbox" class="youtube1" onclick="show_youtube_languages()">
                  <span class="slider round"></span>
                </label>&nbsp;Youtube Videos
                <br>
                @if(auth()->user() && auth()->user()->level=="5")
                
    			<label class="switch">
                  <input type="checkbox" class="lesson_plan1">
                  <span class="slider round"></span>
                </label>&nbsp;Lesson Plan
                <br>
                @endif
			    </div>
			    <hr>
			    <div class="clearfix text-center">
			        
			    <textarea class="form-control"  rows="4" style="width:100%;border-radius: 5px;" id="question1" placeholder="Enter Question"></textarea>
			    </div>
			    
			    <div class="row">
			    <div class="col-md-6 col-sm-6">
			        
			     <div class="clearfix text-center" style="float: right;margin-top: 5px;">   
			    <button class=" btn ask_button btn-success" style="margin-top: 5px; height: 70px; width: 70px;border:1px solid; border-radius: 50%;" onclick="ask_chat()"><i  style="font-size:25px;" class="glyphicon glyphicon-send"></i></button>
			    </div></div>
			    
			    <div class="col-md-6 col-sm-6">
			    
			    <div class="clearfix speak_btn_div text-center" style="float: left;">
			    <button id=" " class="btnStart btn" style="margin-top: 5px; height: 70px; width: 70px;border:1px solid; border-radius: 50%;"
			        onmousedown="speakNow();" onmouseup="sendAudio();" ontouchstart="speakNow();" ontouchend="sendAudio();">
			        <i class="fa fa-microphone" style="font-size:25px;"></i>
			    </button>
			    <br><span id="audio_span2">Press and hold to ask</span>
			    </div>
			    <div class="clearfix delete_btn_div text-center" style="display:none;float: left; margin-top: 5px;">
			    <button id="btnAbort " class="abort btn delete_btn" style="margin-top: 5px; height: 70px; width: 70px;border:1px solid; border-radius: 50%;position: relative;" onclick="abortAudio();">
			        <img width='100px' style='position: absolute;top: 0;right: -20px;' src='https://app.ilifegenie.com/images/genie_listening.gif'>
			        <!--<i class="fa fa-trash" style="color:red; font-size:25px;"></i>-->
			    </button>
			    <br><span id="delete_span2">&nbsp;</span>
			    </div>
			    </div>
			    
			    
			    </div>
			    </div>
			    
			    
			</div>
			<div class="question-part">
			    <div class="clearfix speak_btn_div text-center" style="">
			    <button id=" " class="btnStart btn" style="margin-top: 5px; height: 70px; width: 120px;border:1px solid; border-radius: 5px"
			        onmousedown="speakNow();" onmouseup="sendAudio();" ontouchstart="speakNow();" ontouchend="sendAudio();">
			        <i class="fa fa-microphone" style="font-size:25px;"></i>
			    </button>
			    <br><span id="audio_span">Press and hold to ask</span>
			    </div>
			    <div class="clearfix delete_btn_div text-center" style="display:none; margin-top: 5px;">
			    <button id="btnAbort " class="abort btn delete_btn" style="margin-top: 5px; height: 70px; width: 120px;border:1px solid; border-radius: 5px" onclick="abortAudio();"><i class="fa fa-trash" style="color:red; font-size:25px;"></i></button>
			    <br><span id="delete_span">&nbsp;</span>
			    </div>
			    <div class="input-wrapper">
			        
			    <input class="form-control" style="" id="question" placeholder="Enter Question">
			    <button class="ask_button" style="" onclick="ask_chat()"><i class="glyphicon glyphicon-send"></i></button>
			    </div>
			    
			    
			    <!--
			    
              <input class="form-control" style="width:calc(100% - 120px);float:left;border-radius: 30px; height:42px;" id="question" placeholder="Enter Question">
              
              <button id="btnStart" class=" btn " style="margin-top: 5px;width:40px;float:right;border:1px solid;"><i class="fa fa-microphone"></i></button>
              <button id="btnStop" class=" btn "  style="margin-top: 5px;display:none;width:40px;float:right;border:1px solid;"><i class="glyphicon glyphicon-stop text-danger"></i></button>
              <button id="btnRefresh" class=" btn "  style="margin-top: 5px;display:none;width:40px;float:right;border:1px solid;">....</button>
              
              <button class=" btn btn-success ask_button" style="width:80px;float:right;border:1px solid;" onclick="ask_chat()"><i class="glyphicon glyphicon-send"></i></button>-->
              
               
			</div>
			
		    </div> 
		    </div> 
		</div>
		@php $i=0; @endphp
		@if($embedded!="2")
		<div class="col-md-12 col-sm-12 col-xs-12  embedded-part pdf-screen">
			<div class="pdf-part" id="pdf_container">
			<input type="hidden" id="selected_pdf" value="0">
			@if(count($pdfs)>1)
			<a class=" btn " onclick="show_new_pdf(1);"> <b> < </b> </a>&nbsp;<a class=" btn " onclick="show_new_pdf(2);"> <b> > </b> </a>
			@endif
            @for($i=0;$i<count($pdfs);$i++)
				<div id="pdf_container_{{$i}}" class="eachpdf_div @if($i==0) d-block @else d-none @endif">
                
                <!--<object data="https://drive.google.com/viewerng/viewer?embedded=true&url=http://health.ntuh.gov.tw/health/NTUH_e_Net/NTUH_e_Net_no91/%E7%99%8C%E7%97%87%E7%AF%A9%E6%AA%A2.pdf" type="application/pdf">
                <embed src="https://drive.google.com/viewerng/viewer?embedded=true&url=http://health.ntuh.gov.tw/health/NTUH_e_Net/NTUH_e_Net_no91/%E7%99%8C%E7%97%87%E7%AF%A9%E6%AA%A2.pdf" type='application/pdf'>
                </object>-->
                
                <object data="{{($pdfs[$i])}}#toolbar=0" type="application/pdf" frameborder="0" width="100%" height="600px" style="padding: 20px;">
                    <!--<embed src="https://drive.google.com/file/d/1CRFdbp6uBDE-YKJFaqRm4uy9Z4wgMS7H/preview?usp=sharing#toolbar=0" width="100%" height="600px" /> -->
                    <embed src="https://drive.google.com/viewerng/viewer?embedded=true&url={{($pdfs[$i])}}?usp=sharing#toolbar=0" width="100%" height="600px" /> 
                </object>
                <!--<iframe id="pdfviewer" src="http://docs.google.com/gview?embedded=true&url={{$pdfs[$i]}}&amp;embedded=true" frameborder="0" width="100%" height="100%"></iframe>-->
                
                </div>
			@endfor                       
                
		</div>
		@endif
		</div>
	</div>
</div>

<footer class="text-center mobile-footer only_on_mobile">
    <div class=" footer_menu">
        <div class="col20">
            <a href="{{ route('profile') }}">
            <i class="fa fa-user"></i>
            <span>Account</span></a>
            </div>
        <div class="col20">
            <a href="{{ route('files') }}">
            <i class="fa fa-upload"></i>
            <span>Upload</span></a>
            </div>
        <div class="col20">
            <a href="{{ route('home') }}">
            <b><i class="fa fa-home"></i>
            <span>Home</span></b></a>
            </div>
        <div class="col20">
            <a href="{{ route('saved_messages') }}">
            <i class="fa fa-clock"></i>
            <span>Chat History</span></a>
            </div>
        <div class="col20">
            <a data-toggle="modal" data-target="#myModal">
            <i class="fa fa-exchange"></i>
            <span>Modes</span></a>
            
            </div>
    </div>
</footer>


<div class="modal" id="myModalgrp">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">Share to Group</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
        @if(auth()->user())  
			    
		    @foreach($groups as $grp)
		    @if($grp->group)
		    <label class="tick">
              <input type="checkbox" class="share_group" value="{{ $grp->group_id }}">
            </label>&nbsp;{{ $grp->group->group_name }}
		    <br>
		    @endif
		    @endforeach
		    
		    @endif
      </div>
      <input type="hidden" value="" id="msg_id">
      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-warning share_btn" onclick="share_to_group();"><i class="fa fa-share"></i>&nbsp; Share</button>
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>


<div class="modal" id="myModal">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">Chat Settings</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
        @if((auth()->user() && (auth()->user()->level=="4" || auth()->user()->level=="5" || auth()->user()->level=="1")) || $show_toggles)    
			    
			    <b>Use any one or a combination of the below toggle buttons to fine tune Genie's response</b><br>
    			<label class="switch">
                  <input type="checkbox" class="story_mode">
                  <span class="slider round"></span>
                </label>&nbsp;Story Mode
			    <br>
    			<label class="switch">
                  <input type="checkbox" class="real_life_examples">
                  <span class="slider round"></span>
                </label>&nbsp;Real Life Examples
			    <br>
    			<label class="switch">
                  <input type="checkbox" class="generate_questions">
                  <span class="slider round"></span>
                </label>&nbsp;Generate Questions
			    <br>
    			<label class="switch">
                  <input type="checkbox" class="practical_activity">
                  <span class="slider round"></span>
                </label>&nbsp;Practical Activity
			    <br>
    			<label class="switch">
                  <input type="checkbox" class="easy_explain">
                  <span class="slider round"></span>
                </label>&nbsp;Ezy Explain
                <br>
    			<label class="switch">
                  <input type="checkbox" class="validate_answer">
                  <span class="slider round"></span>
                </label>&nbsp;Validate Answer
                <br>
    			<label class="switch">
                  <input type="checkbox" class="youtube" onclick="show_youtube_languages()">
                  <span class="slider round"></span>
                </label>&nbsp;Youtube Videos
                <br>
                @if(auth()->user() && auth()->user()->level=="5")
                
    			<label class="switch">
                  <input type="checkbox" class="lesson_plan">
                  <span class="slider round"></span>
                </label>&nbsp;Lesson Plan
                <br>
                @endif
                @endif
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>
<div class="modal" id="myModal3">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">Icons & Functionalities</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
            
			    
    			<label class="switch">
                  <i class='glyphicon glyphicon-copy'></i>
                </label>&nbsp;Copy Answer
			    <br>
    			<label class="switch">
                  <i class='fas fa-thumbs-up'></i>
                </label>&nbsp;Like the answer
			    <br>
    			<label class="switch">
                  <i class='fas fa-thumbs-down'></i>
                </label>&nbsp;Dislike the answer
			    <br>
    			<label class="switch">
                  <i class='fa fa-download'></i>
                </label>&nbsp;Download answer in mp3 format
			    <br>
    			<label class="switch">
                  <i class='fas fa-bookmark'></i>
                </label>&nbsp;Save Answer for future referance
                <br>
    			<label class="switch">
                  <i class='fas fa-language'></i>
                </label>&nbsp;Translate Answer
                <br>
    			<label class="switch">
                  <i class='fas fa-volume-up'></i>
                </label>&nbsp;Text to Speech
                <br>
    			<label class="switch">
                  <i class='fas fa-pause'></i>
                </label>&nbsp;Pause the answer
                <br>
    			<label class="switch">
                  <i class='fa fa-spinner'></i>
                </label>&nbsp;Text to Speech is generating
                <br>
                
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>



<div class="modal" id="myModal2">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">Translate</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
          <p class="t_languages">
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Arabic" data-id="">&nbsp;Arabic&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Spanish" data-id="">&nbsp;Spanish&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Bengali" data-id="">&nbsp;Bengali&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Chinese" data-id="">&nbsp;Chinese&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Czech" data-id="">&nbsp;Czech&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Danish" data-id="">&nbsp;Danish&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Dutch" data-id="">&nbsp;Dutch&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Estonian" data-id="">&nbsp;Estonian&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Finnish" data-id="">&nbsp;Finnish&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="French" data-id="">&nbsp;French&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Gujarati" data-id="">&nbsp;Gujarati&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Hindi" data-id="">&nbsp;Hindi&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Japanese" data-id="">&nbsp;Japanese&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Kannada" data-id="">&nbsp;Kannada&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Kashmiri" data-id="">&nbsp;Kashmiri&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Konkani" data-id="">&nbsp;Konkani&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Korean" data-id="">&nbsp;Korean&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Latvian" data-id="">&nbsp;Latvian&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Malay" data-id="">&nbsp;Malay&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Malayalam" data-id="">&nbsp;Malayalam&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Marathi" data-id="">&nbsp;Marathi&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Oriya" data-id="">&nbsp;Oriya&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Polish" data-id="">&nbsp;Polish&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Portuguese" data-id="">&nbsp;Portuguese&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Sanskrit" data-id="">&nbsp;Sanskrit&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Tamil" data-id="">&nbsp;Tamil&nbsp;&nbsp;</span>
        <span><input type="radio" class="translate_msg" name="translateMsg" data-language="Telugu" data-id="">&nbsp;Telugu&nbsp;&nbsp;</span>
          </p>
        <div class="translate_result">
            
        </div>
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>

<div class="modal" id="myModalGl">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="pull-left">Youtube Video Language</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
          <p class="t_languages">
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="English" value="English" checked>&nbsp;English&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Spanish" value="Spanish" checked>&nbsp;Spanish&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Arabic" value="Arabic">&nbsp;Arabic&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Bengali" value="Bengali">&nbsp;Bengali&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Chinese" value="Chinese">&nbsp;Chinese&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Czech" value="Czech">&nbsp;Czech&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Danish" value="Danish">&nbsp;Danish&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Dutch" value="Dutch">&nbsp;Dutch&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Estonian" value="Estonian">&nbsp;Estonian&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Finnish" value="Finnish">&nbsp;Finnish&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="French" value="French">&nbsp;French&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Gujarati" value="Gujarati">&nbsp;Gujarati&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Hindi" value="Hindi">&nbsp;Hindi&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Japanese" value="Japanese">&nbsp;Japanese&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Kannada" value="Kannada">&nbsp;Kannada&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Kashmiri" value="Kashmiri">&nbsp;Kashmiri&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Konkani" value="Konkani">&nbsp;Konkani&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Korean" value="">&nbsp;Korean&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Latvian" value="Latvian">&nbsp;Latvian&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Malay" value="Malay">&nbsp;Malay&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Malayalam" value="Malayalam">&nbsp;Malayalam&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Marathi" value="Marathi">&nbsp;Marathi&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Oriya" value="Oriya">&nbsp;Oriya&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Polish" value="Polish">&nbsp;Polish&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Portuguese" value="Portuguese">&nbsp;Portuguese&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Sanskrit" value="Sanskrit">&nbsp;Sanskrit&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Tamil" value="Tamil">&nbsp;Tamil&nbsp;&nbsp;</span>
        <span><input type="radio" class="gl_msg" name="gl_msg" data-language="Telugu" value="Telugu">&nbsp;Telugu&nbsp;&nbsp;</span>
          </p>
        <div class="translate_result">
            
        </div>
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>

<input type="hidden" id="mediaObj">
<form action="{{ route('download_audio') }}" method="post" id="download_audio">
    @csrf
    <input type="hidden" id="voice_msg" name="text">
</form>


@include('layouts.script')
  <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.6.347/pdf.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/showdown/2.1.0/showdown.min.js"></script>
<script type="text/javascript">
    let sound;
    var audioLists = [];
    function download_message(id){
        var msg = $('.answer_'+id).text();
        $('#voice_msg').val(msg);
        $('#download_audio').submit();
    }
    async function speak_message(id){
        $('.stop'+id).hide();
        $('.speak'+id).hide();
        $('.load'+id).show();
        if(typeof audioLists[id]!=='undefined'){
            
            
            $('.speak_btn').show();
            $('.stop_btn').hide();
            $('.load').hide();
            var sound1 = await new Audio("data:audio/mp3;base64," + audioLists[id]);
            
            if (sound && sound.src==sound1.src){
                sound.play();
                console.log('same');
            } else {
                console.log('different');
                sound = sound1;
                sound.play();
            }
                
            $('.stop'+id).show();
            $('.speak'+id).hide();
            $('.load'+id).hide();
            sound.addEventListener("ended", function(){
                 sound.currentTime = 0;
                 $('.speak_btn').show();
                $('.stop_btn').hide();
                $('.load').hide();
            });
        } else {
            var msg = $('.answer_'+id).text();
    		var _token= "{{ csrf_token() }}";
    		$.ajax({
    			url: "{{route('texttospeech')}}", 
    			data: {text:msg, _token:_token },                         
    			type: 'post',
    			success: function(response){
    				//console.log(response);
    				sound = new Audio("data:audio/mp3;base64," + response);
                    sound.play();
                    audioLists[id] = response;
                    $('.stop'+id).show();
                    $('.speak'+id).hide();
                    $('.load'+id).hide();
                    sound.addEventListener("ended", function(){
                         sound.currentTime = 0;
                         $('.speak_btn').show();
                        $('.stop_btn').hide();
                        $('.load').hide();
                    });
    			}
    		 });
        }
	}
	function stop_speak(id){
	    if (sound && !sound.paused) {
            sound.pause();
            //sound.currentTime = 0; // Rewind track to beginning (is you need this)
          }
        $('.speak_btn').show();
        $('.stop_btn').hide();
        $('.load').hide();
	}
    function show_new_pdf(type){
        var current_pdf = $('#selected_pdf').val();
        if(type==2){
            var next = parseInt(current_pdf)+1;
            if(parseInt(current_pdf)=={{$i-1}}){
                next = 0;
            }
        } else {
            var next = parseInt(current_pdf)-1;
            if(parseInt(current_pdf)==0){
                next = {{$i-1}};
            }
        }
        $('#selected_pdf').val(next);
        $('.eachpdf_div').hide();
        $('#pdf_container_'+next).show();
    }
    var pdfjsLib = window['pdfjs-dist/build/pdf'];
    pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.6.347/pdf.worker.min.js';
    var pdfDoc = null;
    var scale = 1; //Set Scale for Zoom.
    var resolution = IsMobile() ? 1.5 : 1; //Set Resolution as per Desktop and Mobile.
    function LoadPdfFromUrl(url,append) {
        console.log(url);
        //Read PDF from URL.
        pdfjsLib.getDocument(url).promise.then(function (pdfDoc_) {
            pdfDoc = pdfDoc_;
			
            //Reference the Container DIV.
            var pdf_container = document.getElementById("pdf_container_"+append);
            pdf_container.style.display = "block";
            //pdf_container.style.height = IsMobile() ? "1200px" : "820px";
 
            for (var i = 1; i <= pdfDoc.numPages; i++) {
				RenderPage(pdf_container, i);
            }
        });
    };
    
    function RenderPage(pdf_container, num) {
		
        pdfDoc.getPage(num).then(function (page) {
            //Create Canvas element and append to the Container DIV.

            var canvas = document.createElement('canvas');
            canvas.id = 'pdf-' + num;
            ctx = canvas.getContext('2d');
            pdf_container.appendChild(canvas);
            //Create and add empty DIV to add SPACE between pages.
            var spacer = document.createElement("div");
            spacer.style.height = "20px";
            pdf_container.appendChild(spacer);
 
            //Set the Canvas dimensions using ViewPort and Scale.
            var viewport = page.getViewport({ scale: scale });
            canvas.height = resolution * viewport.height;
            canvas.width = resolution * viewport.width;
               
            //Render the PDF page.
            var renderContext = {
                canvasContext: ctx,
                viewport: viewport,
                transform: [resolution, 0, 0, resolution, 0, 0]
            };
 
            page.render(renderContext);
        });
		$('.loaderimage').hide();
    };
 
    function IsMobile() {
        var r = new RegExp("Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini");
        return false;//r.test(navigator.userAgent);
    }
</script>
<script>
  	@php
  		$stArr = explode('.',$whole_text);
  		$store_name = $stArr[0];
  	@endphp
  	$('.main_msg').show();
  	
  	function ask_chat(voice=""){
  	    var q_id = Date.now().toString(36) + Math.random().toString(36).substr(2);
        var _token= "{{ csrf_token() }}";
        if ($(window).width() < 768) {
           var question = $("#question").val();
        } else {
           var question = $("#question1").val();
        }
        //var question = $("#question").val();
		if(question!=""){
		  var route = "{{ route('ask') }}";
		  if($("#math_genie").is(":checked") || $(".math_genie1").is(":checked")){
            route = "{{ route('math_genie_ask') }}";
          }
          var append_q = '';
		  if($(".story_mode").is(":checked") || $(".story_mode1").is(":checked")){
            append_q += " and Explain this in story mode";
          }
		  if($(".real_life_examples").is(":checked") || $(".real_life_examples1").is(":checked")){
            append_q += " and Provide real life examples";
          }
		  if($(".generate_questions").is(":checked") || $(".generate_questions1").is(":checked")){
            append_q += ". Also generate 10 questions and their respective answers based on this topic";
          }
		  if($(".practical_activity").is(":checked") || $(".practical_activity1").is(":checked")){
            append_q += ". Suggest an activity based learning exercise on this topic.";
          }
		  if($(".easy_explain").is(":checked") || $(".easy_explain1").is(":checked")){
		    append_q += ". Explain this in an easy to understand manner.";
		  }
		  if($("#validate_answer").is(":checked") || $(".validate_answer1").is(":checked")){
		    append_q += ". Am I right or wrong?";
		  }
		  if($(".lesson_plan").is(":checked") || $(".lesson_plan1").is(":checked")){
		    append_q += ". Create a detailed lesson plan on this.";
		  }
		  if($(".translate_hindi").is(":checked") || $(".translate_hindi1").is(":checked")){
		    append_q += ". Translate the answer to hindi.";
		  }
          
          //$('#scroll_chat').animate({
          //      scrollTop: $('#scroll_'+q_id).offset().top
          //  }, 1000);
		  var my_msg = "<p class='pmsg pull-right text-right'><label class='msg my_msg'>"+question+"</label></p>";
          var load_msg = "<p class='pmsg pull-left text-left' id='loader_p'><label class='msg load_msg'>Genie is typing...&nbsp;</label></p>";
          $('.genie_typing').show();
          $('.chat-part').append(my_msg);
          
          $('.chat-part').append(load_msg);
          $('.ask_button').attr('disabled',true);
          
           $('#question').attr('disabled',true);
           $('#question1').attr('disabled',true);
          
          $("#scroll_chat").animate({ scrollTop: $('#scroll_chat').prop("scrollHeight")}, 1000);
      	  
      	  $('html, body').animate({
                scrollTop: $("#scroll_chat").prop("scrollHeight")
            }, 1000);
            
          var request = $.ajax({
            url: route,
            method: "POST",
            data: { _token : _token, question: question+append_q, store_name: '{{ $store_name }}' },
            dataType: "html"
          });

          request.done(function( msg ) {
            $('.load_msg').remove();
            $('.genie_typing').hide();
            var scroll_id = "scroll_"+q_id;
            var ai_msg = "<div class='pmsg pull-left text-left' id='"+scroll_id+"'>";
            ai_msg += "<label class='msg ai_msg msg_"+q_id+"'>";
            var converter = new showdown.Converter();
            var htmlmsg      = converter.makeHtml(msg);
            ai_msg += "<span class='answer_span answer_"+q_id+"'>"+(htmlmsg)+"</span>";
            if($(".youtube").is(":checked") || $(".youtube1").is(":checked")){
                ai_msg += "<span class='video_span video_"+q_id+"'><i>Genie is fetching videos...&nbsp;</i></span>";
            }
            ai_msg += "<span class='pull-right'>";
            ai_msg += "<a class='pull-right copy_answer' onclick='copy_message(\""+q_id+"\");' title='Copy Answer'><i class='glyphicon glyphicon-copy'></i></a>&nbsp;";
            @if(auth()->user())
            
                ai_msg += "<a class='pull-right copy_answer slike_msg_btn dislike"+q_id+"' data-like='0' onclick='like_message(\""+q_id+"\",2);' title='Dislike Answer'><i class='fas fa-thumbs-down'></i></a>";
                ai_msg += "<a class='pull-right copy_answer slike_msg_btn like"+q_id+"' data-like='0' onclick='like_message(\""+q_id+"\",1);' title='Like Answer'><i class='fas fa-thumbs-up'></i></a>";
                    
                ai_msg += "<a class='pull-right copy_answer download_btn download"+q_id+"' onclick='download_message(\""+q_id+"\");' title='Download Answer'><i class='fa fa-download'></i></a>";
                
                @if(auth()->user() && count($groups)>0) 
                ai_msg += "<a data-toggle='modal' data-target='#myModalgrp' class='pull-right copy_answer share_msg_btn share"+q_id+"' data-share='0' onclick='share_modal(\""+q_id+"\");' title='Add to Group'><i class='fa fa-users'></i></a>";
                @endif
                ai_msg += "<a class='pull-right copy_answer save_msg_btn save"+q_id+"' data-save='0' onclick='save_message(\""+q_id+"\");' title='Save Answer'><i class='fas fa-bookmark'></i></a>";
                
                
                ai_msg += "<a  data-toggle='modal' data-target='#myModal2' class='pull-right copy_answer translate_msg_btn translate"+q_id+"' data-save='0' onclick='translate_message(\""+q_id+"\");' title='Message Translate'><i class='fas fa-language'></i></a>";
                
            @endif
            
            ai_msg += "<a class='pull-right copy_answer speak_btn speak"+q_id+"' onclick='speak_message(\""+q_id+"\");' title='Speak Answer'><i class='fas fa-volume-up'></i></a>";
            ai_msg += "<a class='pull-right copy_answer pause_btn d-none pause"+q_id+"' onclick='pause_speak(\""+q_id+"\");' title='Pause Answer'><i class='fas fa-pause'></i></a>";
            ai_msg += "<a class='pull-right copy_answer stop_btn d-none stop"+q_id+"' onclick='stop_speak(\""+q_id+"\");' title='Stop Answer'><i class='fas fa-pause'></i></a>";
            ai_msg += "<a class='pull-right copy_answer load_btn d-none load"+q_id+"' title='Load Answer'><i class='fa fa-spinner'></i></a>";
            
            ai_msg += "</span>";
            
            ai_msg += "</label>";
            ai_msg += "</div>";
            ai_msg = ai_msg.replace('```markdown','');
            ai_msg = ai_msg.replace('```','');
            $('.chat-part').append(ai_msg);
            $("#question").val('');
            $("#question1").val('');
            
            $("#scroll_chat").animate({ scrollTop: $('#scroll_chat').prop("scrollHeight")}, 1000);
            
            
            $('html, body').animate({
                scrollTop: $("#scroll_chat").prop("scrollHeight")
            }, 1000);
            
            console.log($('#scroll_chat').prop("scrollHeight"));
            $('.ask_button').attr('disabled',false);
      	    $('#question').attr('disabled',false);
      	    $('#question1').attr('disabled',false);
      	    
      	    
      	    
      	    if(voice=="yes"){
      	        speak_message(q_id);
      	    }
      	    if($(".youtube").is(":checked") || $(".youtube1").is(":checked")){
      	        fetch_videos(q_id,question);
      	    }
          });

          request.fail(function( jqXHR, textStatus ) {
            $('.load_msg').remove();
            $('.genie_typing').hide();
            alert( "Request failed: " + textStatus );
            $("#question").val('');
            $("#question1").val('');
            
            
            
            $('.ask_button').attr('disabled',false);
      	    $('#question').attr('disabled',false);
      	    $('#question1').attr('disabled',false);
      	    
      	    
      	    
      	    
          });
        } else {
         alert('Please enter question'); 
        }
    }
    
	function show_youtube_languages(){
	    if($(".youtube").is(":checked") || $(".youtube1").is(":checked")){
            $('#myModalGl').modal('show');
        }
	}
    function fetch_videos(id,question){ 
        
        var lang = $('input[name="gl_msg"]:checked').attr('data-language');
        question = question+' Explain in '+lang;
        var save_id = $('.answer_'+id+' md-block').attr('data-id');
        var _token= "{{ csrf_token() }}";
        var request = $.ajax({
            url: '{{ route("fetch_videos") }}',
            method: "POST",
            data: { _token : _token, q: question, save_id: save_id  },
            dataType: "html"
          });

          request.done(function( msg ) {
            $('.video_'+id).html(msg);
          });

          request.fail(function( jqXHR, textStatus ) {
            $('.video_'+id).html('Unable to fetch videos');
            
          });
    }
    function copy_message(id){
        navigator.clipboard.writeText($('.answer_'+id).text());
        alert('Answer copied to clipboard');
    }
	function showBlock(type){
      	$('.tab_btn').removeClass('active');
     	if(type==2){
          $('.pdf-screen').show();
          $('.chat-screen').hide();
          $('.doc_btn').addClass('active');
          $('.chat_doc').prop('checked',true);
        } else {
          $('.pdf-screen').hide();
          $('.chat-screen').show();
          $('.chat_btn').addClass('active');
          $('.chat_doc').prop('checked',false);
        }
    }
    function save_message(id){ 
        var prev = $('.save'+id).attr('data-save');
        if(prev=="0"){
            var saved = "1";
            $('.save'+id).html("<i class='fas fa-bookmark text-danger'></i>");
            
        } else {
            var saved = "0";
            $('.save'+id).html("<i class='fas fa-bookmark'></i>");
        }
        $('.save'+id).attr('data-save',saved);
        
        var save_id = $('.answer_'+id+' md-block').attr('data-id');
        var _token= "{{ csrf_token() }}";
        var request = $.ajax({
            url: '{{ route("save_message") }}',
            method: "POST",
            data: { _token : _token, id: save_id, saved: saved  },
            dataType: "json"
          });

          request.done(function( msg ) {
            console.log(msg.result);
          });

          request.fail(function( jqXHR, textStatus ) {
            console.log('failed to save');
            var prev = $('.save'+id).attr('data-save');
            if(prev=="0"){
                var saved = "1";
                $('.save'+id).html("<i class='fas fa-bookmark text-danger'></i>");
                
            } else {
                var saved = "0";
                $('.save'+id).html("<i class='fas fa-bookmark'></i>");
            }
          });
        
    }
    function share_modal(msg_id){
        $('#msg_id').val(msg_id);
        
    }
    function share_to_group(id){ 
        var id = $('#msg_id').val();
        var group_id = [];

        $(".share_group:checkbox:checked").map(function(){
            group_id.push($(this).val());
        });
        
        
        
        $('.share_btn').html('Sharing...');
        console.log(group_id); //return false;
        //$('.share_btn').html('<i class="fa fa-share"></i>&nbsp; Share');
        
        
        
        $('.save'+id).attr('data-save');
        var save_id = $('.answer_'+id+' md-block').attr('data-id');
        var _token= "{{ csrf_token() }}";
        var request = $.ajax({
            url: '{{ route("share_to_group") }}',
            method: "POST",
            data: { _token : _token, answer_id: save_id, group_id: group_id  },
            dataType: "json"
          });

          request.done(function( msg ) {
              $('.share_btn').html('<i class="fa fa-share"></i>&nbsp; Share');
            $('#myModalgrp').modal('hide');
            show_shackbar_message('Shared Successfully');
          });

          request.fail(function( jqXHR, textStatus ) {
            $('.share_btn').html('<i class="fa fa-share"></i>&nbsp; Share');
          });
        
    }
    
    function like_message(id, like){ 
        var liked = 0;
        if(like==2){
            var prev = $('.dislike'+id).attr('data-like');
            if(prev=="0"){
                var saved = "1";
                $('.dislike'+id).html("<i class='fas fa-thumbs-down text-danger'></i>");
                $('.like'+id).html("<i class='fas fa-thumbs-up'></i>");
                $('.like'+id).attr('data-like','0');
                liked = 2;
            } else {
                var saved = "0";
                $('.dislike'+id).html("<i class='fas fa-thumbs-down'></i>");
            }
            $('.dislike'+id).attr('data-like',saved);
        } else {
            var prev = $('.like'+id).attr('data-like');
            if(prev=="0"){
                var saved = "1";
                $('.like'+id).html("<i class='fas fa-thumbs-up text-success'></i>");
                $('.dislike'+id).html("<i class='fas fa-thumbs-down'></i>");
                $('.dislike'+id).attr('data-like','0');
                liked = 1;
            } else {
                var saved = "0";
                $('.like'+id).html("<i class='fas fa-thumbs-up'></i>");
            }
            $('.like'+id).attr('data-like',saved);
        }
        update_like(id,liked,like)
    }
    function update_like(id,liked,like){
        
        var save_id = $('.answer_'+id+' md-block').attr('data-id');
        var _token= "{{ csrf_token() }}";
        var request = $.ajax({
            url: '{{ route("like_message") }}',
            method: "POST",
            data: { _token : _token, id: save_id, liked: liked  },
            dataType: "json"
          });

          request.done(function( msg ) {
            console.log(msg.result);
          });

          request.fail(function( jqXHR, textStatus ) {
            console.log('failed to save');
            if(like==2){
                var prev = $('.dislike'+id).attr('data-like');
                if(prev=="0"){
                    var saved = "1";
                    $('.dislike'+id).html("<i class='fas fa-thumbs-down text-danger'></i>");
                    $('.like'+id).html("<i class='fas fa-thumbs-up'></i>");
                    $('.like'+id).attr('data-like','0');
                    liked = 2;
                } else {
                    var saved = "0";
                    $('.dislike'+id).html("<i class='fas fa-thumbs-down'></i>");
                }
            } else {
                var prev = $('.like'+id).attr('data-save');
                if(prev=="0"){
                    var saved = "1";
                    $('.like'+id).html("<i class='fas fa-thumbs-up text-success'></i>");
                    $('.dislike'+id).html("<i class='fas fa-thumbs-down'></i>");
                    $('.dislike'+id).attr('data-like','0');
                    liked = 1;
                } else {
                    var saved = "0";
                    $('.like'+id).html("<i class='fas fa-thumbs-up'></i>");
                }
            }
          });
        
    }
    
    function translate_message(id){
        $('.translate_msg').attr('data-id',id);
        $('.translate_result').addClass('answer_translate'+id);
        $('.translate_msg').prop('checked', false);
        
    }
	$(document).ready(function(){
	    showBlock(1);
	    setTimeout(function(){ 
	       
          	@for($i=0;$i<count($pdfs);$i++)
          	    @if($i>0)
          	        
                @else
				
          	    @endif
			@endfor
	    }, 500);
	    
		var input = document.getElementById("question");
        input.addEventListener("keypress", function(event) {
            if (event.key === "Enter") {
              event.preventDefault();
              ask_chat();
            }
        
        });
		var input = document.getElementById("question1");
        input.addEventListener("keypress", function(event) {
            if (event.key === "Enter") {
              event.preventDefault();
              ask_chat();
            }
        
        });
        
        $('.chat_doc').change(function(){
            if($(this).is(":checked")){
                showBlock(2);
            } else {
                showBlock(1);
            }
        });
        
       // var sconverter = new showdown.Converter();
        //var summary_text = "";
        //var shtmlmsg      = sconverter.makeHtml(summary_text);
        //$('.summary_text').html(shtmlmsg);
        
        //var qconverter = new showdown.Converter();
        //var question_text = "";
        //var qhtmlmsg      = qconverter.makeHtml(question_text);
        //$('.question_text').html(qhtmlmsg);
        
        $('.translate_msg').change(function(){
            $('#myModal2').modal('hide');
            //$('.translate_result').html('Genie is translating...');
            var id = $(this).attr('data-id');
            var q_id = Date.now().toString(36) + Math.random().toString(36).substr(2);
            var language = $(this).attr('data-language');
            
            $("#scroll_chat").animate({ scrollTop: $('#scroll_chat').prop("scrollHeight")}, 1000);
    		  var my_msg = "<p class='pmsg pull-right text-right'><label class='msg my_msg'>Translate this to "+language+"</label></p>";
              var load_msg = "<p class='pmsg pull-left text-left' id='loader_p'><label class='msg load_msg'>Genie is typing...&nbsp;</label></p>";
              $('.genie_typing').show();
              $('.chat-part').append(my_msg);
              $('.chat-part').append(load_msg);
              $('.ask_button').attr('disabled',true);
          	  $('#question').attr('disabled',true);
            $('#question1').attr('disabled',true);
            
      	    
            
            var query = $('.answer_'+id).text();
            var _token= "{{ csrf_token() }}";
            var request = $.ajax({
                url: '{{ route("translate_text") }}',
                method: "POST",
                data: { _token : _token, query: query, language: language, store_name: '{{$store_name}}'  },
                dataType: "html"
              });
        
              request.done(function( msg ) {
                //$('.translate_result').text(msg);
                //ai_msg  = "<p class='text-center'><a class='pull-right copy_answer speak_btn speaktranslate"+id+"' onclick='speak_message(\"translate"+id+"\");' title='Speak Answer'><i class='fas fa-volume-up'></i></a>";
                //ai_msg += "<a class='pull-right copy_answer stop_btn d-none stoptranslate"+id+"' onclick='stop_speak(\"translate"+id+"\");' title='Stop Answer'><i class='fas fa-stop'></i></a>";
                //ai_msg += "<a class='pull-right copy_answer load_btn d-none loadtranslate"+id+"' title='Load Answer'><i class='fa fa-spinner'></i></a></p>";
                //$('.translate_result').append(ai_msg);
                
                $('.load_msg').remove();
                $('.genie_typing').hide();
                var scroll_id = "scroll_"+q_id;
                var ai_msg = "<div class='pmsg pull-left text-left' id='"+scroll_id+"'>";
                ai_msg += "<label class='msg ai_msg msg_"+q_id+"'>";
                //var converter = new showdown.Converter();
                //var htmlmsg      = converter.makeHtml(msg);
                var htmlmsg = msg;
                ai_msg += "<span class='answer_span answer_"+q_id+"'>"+(htmlmsg)+"</span>";
                if($("#youtube").is(":checked")){
                    //ai_msg += "<span class='video_span video_"+q_id+"'><i>Genie is fetching videos...&nbsp;</i></span>";
                }
                ai_msg += "<span class='pull-right'>";
                ai_msg += "<a class='pull-right copy_answer' onclick='copy_message(\""+q_id+"\");' title='Copy Answer'><i class='glyphicon glyphicon-copy'></i></a>&nbsp;";
                @if(auth()->user())
                    ai_msg += "<a class='pull-right copy_answer slike_msg_btn dislike"+q_id+"' data-dislike='0' onclick='like_message(\""+q_id+"\",2);' title='Dislike Answer'><i class='fas fa-thumbs-down'></i></a>";
                    ai_msg += "<a class='pull-right copy_answer slike_msg_btn like"+q_id+"' data-like='0' onclick='like_message(\""+q_id+"\",1);' title='Like Answer'><i class='fas fa-thumbs-up'></i></a>";
                    
                    ai_msg += "<a class='pull-right copy_answer download_btn download"+q_id+"' onclick='download_message(\""+q_id+"\");' title='Download Answer'><i class='fa fa-download'></i></a>";
                    @if(auth()->user() &&  count($groups)>0) 
                    ai_msg += "<a data-toggle='modal' data-target='#myModalgrp' class='pull-right copy_answer share_msg_btn share"+q_id+"' data-share='0' onclick='share_modal(\""+q_id+"\");' title='Add to Group'><i class='fa fa-users'></i></a>";
                    @endif
                    ai_msg += "<a class='pull-right copy_answer save_msg_btn save"+q_id+"' data-save='0' onclick='save_message(\""+q_id+"\");' title='Save Answer'><i class='fas fa-bookmark'></i></a>";
                    
                    ai_msg += "<a  data-toggle='modal' data-target='#myModal2' class='pull-right copy_answer translate_msg_btn translate"+q_id+"' onclick='translate_message(\""+q_id+"\");' title='Message Translate'><i class='fas fa-language'></i></a>";
                    
                @endif
                
                ai_msg += "<a class='pull-right copy_answer speak_btn speak"+q_id+"' onclick='speak_message(\""+q_id+"\");' title='Speak Answer'><i class='fas fa-volume-up'></i></a>";
                ai_msg += "<a class='pull-right copy_answer pause_btn d-none pause"+q_id+"' onclick='pause_speak(\""+q_id+"\");' title='Pause Answer'><i class='fas fa-pause'></i></a>";
                ai_msg += "<a class='pull-right copy_answer stop_btn d-none stop"+q_id+"' onclick='stop_speak(\""+q_id+"\");' title='Stop Answer'><i class='fas fa-pause'></i></a>";
                ai_msg += "<a class='pull-right copy_answer load_btn d-none load"+q_id+"' title='Load Answer'><i class='fa fa-spinner'></i></a>";
                
                ai_msg += "</span>";
                
                ai_msg += "</label>";
                ai_msg += "</div>";
                //ai_msg = ai_msg.replace('```markdown','');
                //ai_msg = ai_msg.replace('```','');
                $('.chat-part').append(ai_msg);
                $("#question").val('');
                $("#question1").val('');
                $("#scroll_chat").animate({ scrollTop: $('#scroll_chat').prop("scrollHeight")}, 1000);
                $('.ask_button').attr('disabled',false);
          	    $('#question').attr('disabled',false);
          	    $('#question1').attr('disabled',false);
                
                
              });
        
              request.fail(function( jqXHR, textStatus ) {
                $('.load_msg').remove();
                $('.genie_typing').hide();
                alert( "Request failed: " + textStatus );
                $("#question").val('');
                $("#question1").val('');
                $('.ask_button').attr('disabled',false);
          	    $('#question').attr('disabled',false);
          	    $('#question1').attr('disabled',false);
                
              }); 
        });
        
        	
        	var wheight = window.innerHeight;
        	var sheight = screen.height;
        	var hdiff = sheight-wheight;
        	if(hdiff>1 && screen.width < 768){
        	    var extras = 190+hdiff;
        	    $('.chat-part').css('height','calc(100vh - '+extras+'px)');
        	}
        
	});    

        var xhr;
    	let audioIN = { audio: true };
        var startTime = 0;
        let mediaRecorder;
        let dataArray = [];
        let mediaStreamObjdata;
        var audioList = [];
            function speakNow() {
                startTime = Date.now();
                dataArray = [];
                $('.btnStart').addClass('speaking_btn');
                if(mediaStreamObjdata){
                    mediaStreamObjdata.getTracks().forEach( track => track.stop() );
                }
                navigator.mediaDevices.getUserMedia(audioIN).then(function (mediaStreamObj) {
                    
            	    mediaRecorder = new MediaRecorder(mediaStreamObj);
            		mediaRecorder.start();
                    $('#audio_span').html('Ask now...');
                    $('#audio_span2').html('Ask now...');
                    show_shackbar_message('Ask now...'); 
        			console.log(mediaRecorder.state);
        			mediaStreamObjdata = mediaStreamObj;
        			@if(auth()->user() && (auth()->user()->id=="3" || auth()->user()->id=="4"))
            			setTimeout(function () {
                          if(mediaStreamObjdata){
                              //$('#audio_span').html('Speaking...c');
                          } else {
                              
                              //$('#audio_span').html('Speaking...nop');
                          }
                        }, 1001);
                    @endif
                });
            }
            function sendAudio(){
                $('#audio_span').html('Asking...');
                $('#audio_span2').html('Asking...');
                show_shackbar_message('Asking...');
                mediaRecorder.stop();
    			console.log(mediaRecorder.state);
    		
    		    var end = Date.now();
                diff = (end - startTime) + 1;
                var total = diff/1000;
                if(total>1){
        			$('.delete_btn_div').show();
                    $('.speak_btn_div').hide();
                    mediaRecorder.ondataavailable = function (ev) {
                        console.log(ev.data);
            		    dataArray.push(ev.data);
            		    
            		   
                        let audioData = new Blob(dataArray,{ 'type': 'audio/webm;codecs=opus' });
                					
                		//dataArray = [];
                		console.log(audioData);
                		var form_data = new FormData();
                		var _token= "{{ csrf_token() }}";
                		form_data.append('voice', audioData);   
                		form_data.append('_token', _token);  
                		xhr = $.ajax({
                			url: "{{route('speechtotext')}}",
                			dataType: 'json', 
                			cache: false,
                			contentType: false,
                			processData: false,
                			data: form_data,                         
                			type: 'post',
                			success: function(response){
                				$('#question').val(response.text);
                				$('#question1').val(response.text);
                                $('.delete_btn_div').hide();
                                $('.speak_btn_div').show(); 
                                $('.btnStart').removeClass('speaking_btn');
                                if(response.text!=""){
                                    ask_chat("yes");
                                }
                                mediaStreamObjdata.getTracks().forEach( track => track.stop() );
                                $('#audio_span').html('Press and hold to ask');
                                $('#audio_span2').html('Press and hold to ask');
                			},
                            error: function() { 
                                $('.delete_btn_div').hide();
                                $('.speak_btn_div').show(); 
                                $('.btnStart').removeClass('speaking_btn');
                                mediaStreamObjdata.getTracks().forEach( track => track.stop() );
                                $('#audio_span').html('Press and hold to ask');
                                $('#audio_span2').html('Press and hold to ask');
                            }  
                		 });
                        
                    }
        		} else {
                    mediaStreamObjdata.getTracks().forEach( track => track.stop() );
                    $('#audio_span').html('Press and hold to ask');
                    $('#audio_span2').html('Press and hold to ask');
                    $('.delete_btn_div').hide();
                    $('.speak_btn_div').show();
                    $('.btnStart').removeClass('speaking_btn');
                }
                
            }
            function abortAudio(){
                xhr.abort();
                mediaStreamObjdata.getTracks().forEach( track => track.stop() );
                    $('#audio_span').html('Press and hold to ask');
                    $('#audio_span2').html('Press and hold to ask');
                    $('.delete_btn_div').hide();
                    $('.speak_btn_div').show();
                    $('.btnStart').removeClass('speaking_btn');
            }
            
        /*
        let start = document.getElementById('btnStart');
        
        let stop = document.getElementById('btnStop');
        
        let refresh = document.getElementById('btnRefresh');
        
        start.addEventListener('click', function (ev) {
            navigator.mediaDevices.getUserMedia(audioIN).then(function (mediaStreamObj) {
        	    let mediaRecorder = new MediaRecorder(mediaStreamObj);
        		mediaRecorder.start();
    			console.log(mediaRecorder.state);
    			start.style.display = "none";
    			stop.style.display = "block";
    			refresh.style.display = "none";
        			
        			
        			
        			
        		stop.addEventListener('click', function (ev) {
        			mediaRecorder.stop();
        			console.log(mediaRecorder.state);
        			refresh.style.display = "block";
                    stop.style.display = "none";
                    start.style.display = "none";
        		});
        		mediaRecorder.ondataavailable = function (ev) {
        		    dataArray.push(ev.data);
        		}
            		
        		let dataArray = [];
        		
        		mediaRecorder.onstop = function (ev) {
                    
                    refresh.style.display = "block";
                    stop.style.display = "none";
                    start.style.display = "none";
                    
            		let audioData = new Blob(dataArray,{ 'type': 'audio/mp3;' });
            					
            		dataArray = [];
            		
            		var form_data = new FormData();
            		var _token= "{{ csrf_token() }}";
            		form_data.append('voice', audioData);   
            		form_data.append('_token', _token);  
            		xhr = $.ajax({
            			url: "{{route('speechtotext')}}",
            			dataType: 'json', 
            			cache: false,
            			contentType: false,
            			processData: false,
            			data: form_data,                         
            			type: 'post',
            			success: function(response){
            				$('#question').val(response.text);
                            start.style.display = "block";
                            refresh.style.display = "none";
                            stop.style.display = "none";
                            if(response.text!=""){
                                ask_chat("yes");
                            }
                            mediaStreamObj.getTracks().forEach( track => track.stop() );
            			}
            		 });
            	}
            }).catch(function (err) {
        		console.log(err.name, err.message);
        		show_shackbar_message('Unable to get the voice. Please try again');
            });	
        }); */
        
    

	
	
	
</script>
</body>
</html>
