<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Theme Made By www.w3schools.com - No Copyright -->
  <title>Contact - i-Life Genie</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')


<!-- Container (Contact Section) -->
<div id="contact" class="container common_main_div">
  <h3 class="text-center">Contact</h3>
  <p class="text-center"><em>Keep in touch!</em></p>

  <div class="row">
    <div class="col-md-4">
      <p>Hello! Keep in touch.</p>
      <p><span class="glyphicon glyphicon-map-marker"></span>&nbsp;Kerala, India</p>
      <p><span class="glyphicon glyphicon-phone"></span>&nbsp;Phone: +91 8129871470</p>
      <p><span class="glyphicon glyphicon-envelope"></span>&nbsp;Email: taxinearby@authorcrafts.in</p>
    </div>
    <div class="col-md-8">
      <div class="row">
        <div class="col-sm-6 form-group">
          <input class="form-control" id="name" name="name" placeholder="Name" type="text" required>
        </div>
        <div class="col-sm-6 form-group">
          <input class="form-control" id="email" name="email" placeholder="Email" type="email" required>
        </div>
      </div>
      <textarea class="form-control" id="message" name="message" placeholder="Comment" rows="5"></textarea>
      <br>
      <div class="row">
        <div class="col-md-12 form-group">
          <button class="btn pull-right" type="button" onclick="send_mail();">Send</button>
        </div>
      </div>
      <p class="text-left mail_response"></p>
    </div>
  </div>
  <br>

</div>

<!-- Image of location/map -->
<img src="map.jpg" class="img-responsive" style="width:100%">

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
    function send_mail() {
        $('.mail_response').html('sending...');
        var name = $('#name').val();
        var email = $('#email').val();
        var message = $('#message').val();
        var _token= "{{ csrf_token() }}";
        
        if(name.trim()!="" && email.trim()!="" && message.trim()!=""){
            var _token= "{{ csrf_token() }}";
            const xhttp=new XMLHttpRequest();
            xhttp.onload = function() {
                var chatData = JSON.parse(xhttp.responseText);
                $('.mail_response').html('<div class="alert alert-success">Message sent successfullly</div>');
                $('#name').val('');
                $('#email').val('');
                $('#message').val('');
            }
            xhttp.open("POST", "{{route('send_mail')}}");
            xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            xhttp.send("_token="+_token+"&name="+name+"&email="+email+"&message="+message);
        } else {
            $('.mail_response').html('<div class="alert alert-danger">Please enter all fields</div>');
        }
    }
</script>
</body>
</html>
