<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Theme Made By www.w3schools.com - No Copyright -->
  <title>Taxi Register - Taxi Nearby</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')



<!-- Container (The Band Section) -->
<div id="band" class="container text-left">
  <h3>Taxi Sign Up</h3>
  <p><em></em></p>
    @if(Session::has( 'success' ))
     <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
    @elseif( Session::has( 'warning' ))
     <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
    @endif
  <form action="/register_driver" method="post">
    @csrf
    <div class="form-group">
    <label for="exampleInputEmail1">Name</label>
    <input type="text" name="name" class="form-control" id="name" aria-describedby="emailHelp" placeholder="Enter name">
    <span class="text-danger">{{ $errors->has('name') ? $errors->first('name') : '' }}</span>
    <small id="emailHelp" class="form-text text-muted"></small>
  </div>
    <div class="form-group">
    <label for="exampleInputEmail1">Mobile Number</label>
    <input type="text" name="mobile" class="form-control" id="mobile" aria-describedby="emailHelp" placeholder="Enter mobile">
    <span class="text-danger">{{ $errors->has('mobile') ? $errors->first('mobile') : '' }}</span>
    <small id="emailHelp" class="form-text text-muted"></small>
  </div>
    <div class="form-group">
    <label for="exampleInputEmail1">Email address</label>
    <input type="email" name="email" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Enter email">
    <span class="text-danger">{{ $errors->has('email') ? $errors->first('email') : '' }}</span>
    <small id="emailHelp" class="form-text text-muted"></small>
  </div>
  <div class="form-group">
    <label for="exampleInputPassword1">Password</label>
    <input type="password" name="password" class="form-control" id="exampleInputPassword1" placeholder="Password">
    <span class="text-danger">{{ $errors->has('password') ? $errors->first('password') : '' }}</span>
  </div>
  <input type="hidden" name="latitude" id="latitude" value="">
  <input type="hidden" name="longitude" id="longitude" value="">
  <div class="form-group">
    <label for="exampleInputEmail1">Vehicle type</label>
    <select name="vehicle_type" class="form-control" id="vehicle_type">
        <option value="">Select Type</option>
        <option value="Auto">Auto</option>
        <option value="Car">Car</option>
    <select>
    <span class="text-danger">{{ $errors->has('vehicle_type') ? $errors->first('vehicle_type') : '' }}</span>
    <small id="emailHelp" class="form-text text-muted"></small>
  </div>
  
  <div class="form-group">
    <label for="exampleInputEmail1">Vehicle Name</label>
    <input type="text" name="vehicle_name" class="form-control" id="vehicle_name" aria-describedby="emailHelp" placeholder="Enter name">
    <span class="text-danger">{{ $errors->has('vehicle_name') ? $errors->first('vehicle_name') : '' }}</span>
    <small id="emailHelp" class="form-text text-muted"></small>
  </div>
  
  <div class="form-group">
    <label for="exampleInputEmail1">Vehicle Model</label>
    <input type="text" name="vehicle_model" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Enter model">
    <span class="text-danger">{{ $errors->has('vehicle_model') ? $errors->first('vehicle_model') : '' }}</span>
    <small id="emailHelp" class="form-text text-muted"></small>
  </div>
  
  <div class="form-group">
    <label for="exampleInputEmail1">Vehicle Number</label>
    <input type="text" name="vehicle_number" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Enter  number">
    <span class="text-danger">{{ $errors->has('vehicle_number') ? $errors->first('vehicle_number') : '' }}</span>
    <small id="emailHelp" class="form-text text-muted"></small>
  </div>
  <div class="form-group form-check">
  </div>
  <button type="submit" class="btn btn-primary">Register</button>
  </form>
  
</div>


<!-- Image of location/map -->

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
<script>
getLocation();
function getLocation() {
  if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(showPosition);
  } else {
    alert("Geolocation is not supported by this browser.");
  }
}

function showPosition(position) {
    $('#latitude').val(position.coords.latitude);
    $('#latitude').val(position.coords.longitude);
}
</script>
</body>
</html>
