<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Theme Made By www.w3schools.com - No Copyright -->
  <title>Login - {{ config('app.name') }}</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 
  @include('layouts.style')
  <style>
      .pt-120 {
          padding-top:120px;
      }
      .mt-10 {
          margin-top:10px;
      }
      .pt-10 {
          padding-top:10px;
      }
      .pt-20 {
          padding-top:20px;
      }
      .left-div {
          
      }
      .right-div {
            min-height: 421px;
            margin-left: -15px;
            border: 1px solid #ccc;
      }
      #myVideo {
          position: fixed;
          right: 0;
          bottom: 0;
          min-width: 100%;
          min-height: 100%;
        }
        .login_top {
            margin: -15px;
            position: relative;
        }
        .login_body {
            margin-top: 60px;
        }
        
        .login_top h4  {
            position: absolute;
            top: 30%;
            left: 30px;
            background-color: transparent;
        }
        .right-div {
            background: url('{{ url("images/login_inside.jpg") }}');
            border-radius: 10px;
            overflow: hidden;
            background-position: right bottom;
        }
        .login-with-btn {
          transition: background-color .3s, box-shadow .3s;
            
          border: none;
          border-radius: 3px;
          box-shadow: 0 -1px 0 rgba(0, 0, 0, .04), 0 1px 1px rgba(0, 0, 0, .25);
          
          color: #757575;
          font-size: 14px;
          font-weight: 500;
          font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Ubuntu,Cantarell,"Fira Sans","Droid Sans","Helvetica Neue",sans-serif;
          
          background-color: white;
          background-repeat: no-repeat;
          background-position: 12px 11px;
        }
        .login-with-btn:hover {
            box-shadow: 0 -1px 0 rgba(0, 0, 0, .04), 0 2px 4px rgba(0, 0, 0, .25);
        }
        .login-with-google-btn {
            padding: 12px 16px 12px 42px;
            background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTgiIGhlaWdodD0iMTgiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj48cGF0aCBkPSJNMTcuNiA5LjJsLS4xLTEuOEg5djMuNGg0LjhDMTMuNiAxMiAxMyAxMyAxMiAxMy42djIuMmgzYTguOCA4LjggMCAwIDAgMi42LTYuNnoiIGZpbGw9IiM0Mjg1RjQiIGZpbGwtcnVsZT0ibm9uemVybyIvPjxwYXRoIGQ9Ik05IDE4YzIuNCAwIDQuNS0uOCA2LTIuMmwtMy0yLjJhNS40IDUuNCAwIDAgMS04LTIuOUgxVjEzYTkgOSAwIDAgMCA4IDV6IiBmaWxsPSIjMzRBODUzIiBmaWxsLXJ1bGU9Im5vbnplcm8iLz48cGF0aCBkPSJNNCAxMC43YTUuNCA1LjQgMCAwIDEgMC0zLjRWNUgxYTkgOSAwIDAgMCAwIDhsMy0yLjN6IiBmaWxsPSIjRkJCQzA1IiBmaWxsLXJ1bGU9Im5vbnplcm8iLz48cGF0aCBkPSJNOSAzLjZjMS4zIDAgMi41LjQgMy40IDEuM0wxNSAyLjNBOSA5IDAgMCAwIDEgNWwzIDIuNGE1LjQgNS40IDAgMCAxIDUtMy43eiIgZmlsbD0iI0VBNDMzNSIgZmlsbC1ydWxlPSJub256ZXJvIi8+PHBhdGggZD0iTTAgMGgxOHYxOEgweiIvPjwvZz48L3N2Zz4=);
          
        }
        .login-with-facebook-btn {
            padding: 12px 16px 12px 16px;
            position: relative;
        }
        .login-with-facebook-btn i {
            position: absolute;
        }
        
  </style>
</head>
<body id="myPage" data-spy="scroll" data-target=".navbar" data-offset="50">
@include('layouts.nav')


<video autoplay muted loop id="myVideo">
  <source src="{{ url('images/login_page_vid.mp4') }}" type="video/mp4">
</video>
<!-- Container (The Band Section) -->
<div id="band" class="container text-left common_main_div1 pt-20">
    <div class="row mt-10">
        
 <!--<div class="col-md-6 left-div">
     <img src="{{ url('images/i-life-login.jpg?v1') }}" width="100%">
 </div>-->
        <div class="col-md-4"></div>
        <div class="col-md-4 pt-10 right-div">
        <div class="login_top">
          <img src="{{ url("images/login_top.jpg") }}" width="100%">
          <h4>i-Life<br>Genie</h4>
        </div>
        <div class="login_body mt-5">
    @if(Session::has( 'success' ))
     <div class="alert alert-success">{{ Session::get( 'success' ) }}</div>
    @elseif( Session::has( 'warning' ))
     <div class="alert alert-warning">{{ Session::get( 'warning' ) }}</div>
    @endif
  <form action="{{ route('login') }}" method="post" class="">
    @csrf
    <div class="form-group">
    <label for="exampleInputEmail1" class="text-left">Email address</label>
        <input type="email" name="email" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Enter email">
        <span class="text-danger">{{ $errors->has('email') ? $errors->first('email') : '' }}</span>
        <small id="emailHelp" class="form-text text-muted"></small>
  </div>
  <div class="form-group">
        <label for="exampleInputPassword1" class="text-left">Password</label>
        <input type="password" name="password" class="form-control" id="exampleInputPassword1" placeholder="Password">
        <span class="text-danger">{{ $errors->has('password') ? $errors->first('password') : '' }}</span>
  </div>
  
  <button type="submit" class="btn genie_btn s_btn">Login</button>&nbsp;
  <a class="btn genie_btn p_btn" href="{{ route('register') }}">Sign Up</a>
  
  <p class="text-center pt-20">
  <a class="login-with-btn login-with-google-btn" href="{{ route('social_login',['provider'=>'google']) }}">Sign in / Sign up with Google</a>
  </p>
  <p class="text-center pt-20">
  <a class="login-with-btn login-with-facebook-btn" href="{{ route('social_login',['provider'=>'facebook']) }}"><i  style="color: blue;font-size: 22px;" class="fab fa-facebook"></i>
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Sign in / Sign up with Facebook</a>
  </p>
  
  <p class="text-center pt-10">Forgot Password?. <a href="{{ route('forgot_password') }}" class="link_color">Click here</a> to reset</p>
  </form>
  
</div>
</div>

<div class="col-md-4"></div>
    </div>

</div>

<!-- Image of location/map -->

<!-- Footer -->
@include('layouts.footer')
@include('layouts.script')
{{ session()->put('logged_in','')}}
</body>
</html>
